/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.testgen;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.testgen.TGInfoDialog;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class TestGenerationAction
extends MainWindowAction {
    private static final long serialVersionUID = -4911859008849602897L;
    private static final String NAME = "Generate Testcases...";
    private static final String TOOLTIP = "Generate test cases for open goals";

    public TestGenerationAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName(NAME);
        this.setTooltip(TOOLTIP);
        Icon icon = IconFactory.testGeneration((int)16);
        this.putValue("SmallIcon", icon);
        this.setMenuPath("Proof");
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        TGInfoDialog dlg = new TGInfoDialog((Window)this.mainWindow);
        dlg.setVisible(true);
    }

    public void init() {
        final KeYSelectionListener selListener = new KeYSelectionListener(){

            public void selectedNodeChanged(KeYSelectionEvent e) {
                Proof proof = TestGenerationAction.this.getMediator().getSelectedProof();
                TestGenerationAction.this.setEnabled(proof != null);
            }

            public void selectedProofChanged(KeYSelectionEvent e) {
                this.selectedNodeChanged(e);
            }
        };
        this.getMediator().addKeYSelectionListener(selListener);
        this.getMediator().getUI().getProofControl().addAutoModeListener(new AutoModeListener(){

            public void autoModeStarted(ProofEvent e) {
                TestGenerationAction.this.getMediator().removeKeYSelectionListener(selListener);
                TestGenerationAction.this.setEnabled(false);
            }

            public void autoModeStopped(ProofEvent e) {
                TestGenerationAction.this.getMediator().addKeYSelectionListener(selListener);
            }
        });
        selListener.selectedNodeChanged(new KeYSelectionEvent(this.getMediator().getSelectionModel()));
    }
}

