/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.testgen;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.TestGenerationSettings;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class TestgenOptionsPanel
extends SettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = -2170118134719823425L;
    private static final String INFO_APPLY_SYMBOLIC_EX = "Performs bounded symbolic execution on the current proof tree. More precisely, the TestGen Macro is executed which the user can also manually execute by right-clicking on the proof tree and selecting Strategy Macros->TestGen.";
    private static final String INFO_SAVE_TO = "Choose the folder where the test case files will be written.";
    private static final String INFO_MAX_PROCESSES = "Maximal number of SMT processes that are allowed to run concurrently.";
    private static final String INFO_USE_JUNIT = "Generate a JUnit 4 test suite and a test oracle from the postcondition. Disable this option when using a JML runtime checker since the generated code may be too complicated for the runtime checker or may not comply with JML requirements.";
    private static final String INFO_INVARIANT_FOR_ALL = "Includes class invariants in the test data constraints. I.e., require the class invariant of all created objects to be true in the initial state.";
    private static final String INFO_MAX_UNWINDS = "Maximal number of loop unwinds or method calls on a branch that is symbolically executed when using the Strategy Macro \"TestGen\". The Strategy Macro is available by right-click on the proof tree.";
    private static final String INFO_REMOVE_DUPLICATES = "Generate a single testcase for two or more nodes which represent the same test data constraint. Two different nodes may represent the same test data constraint, because some formulas from the nodes which cannot be translated into a test case may be filtered out from the test data constraint.";
    private static final String INFO_RFL_SELECTION = "Enables initialization of protected, private, and ghost fields with test data, as well as creation of objects from classes which have no default constructor (requires the Objenesis library).This functionality is enabled by RFL.java which is generated along the test suite. Please note, a runtime checker may not be able to handle the generated code.";
    private static final String INFO_OPEN_JML_PATH = "Set location of openjml.jar. OpenJML is a third-party runtime checker. KeYTestGen generates the shell scripts compileWithOpenJML.sh and executeWithOpenJML.sh in the test output directory to simplify compilation and execution of the tests. The user should visit the OpenJML's website for additional instructions.";
    private static final String INFO_OBJENESIS_PATH = "Set location of objenesis.jar. Objenesis is a thrid-party library allows easy object creation from classes which do not have a (public) default constructur.";
    private static final String INFO_INCLUDE_POSTCONDITION = "Includes the negated post condition in the test data constraint when generating test data. The post condition can only be included for paths (branches) where symbolic execution has finished.";
    private final JTextField saveToFilePanel;
    private final JTextField openJMLPanel;
    private final JTextField objenesisPanel;
    private final JSpinner maxProcesses;
    private final JSpinner maxUnwinds;
    private final JCheckBox symbolicEx;
    private final JCheckBox useJUnit;
    private final JCheckBox invariantForAll;
    private final JCheckBox includePostCondition;
    private final JCheckBox removeDuplicates;
    private final JCheckBox checkboxRFL;
    private transient TestGenerationSettings settings = new TestGenerationSettings(TestGenerationSettings.getInstance());

    public TestgenOptionsPanel() {
        this.setHeaderText(this.getDescription());
        this.symbolicEx = this.getSymbolicEx();
        this.maxUnwinds = this.getMaxUnwinds();
        this.invariantForAll = this.getInvariantForall();
        this.includePostCondition = this.getIncludePostCondition();
        this.maxProcesses = this.getMaxProcesses();
        this.objenesisPanel = this.getObjenesisPanel();
        this.useJUnit = this.getJUnitPanel();
        this.openJMLPanel = this.getOpenJMLPanel();
        this.saveToFilePanel = this.getSaveToFilePanel();
        this.removeDuplicates = this.getRemoveDuplicatesPanel();
        this.checkboxRFL = this.getRFLSelectionPanel();
    }

    private JSpinner getMaxProcesses() {
        return this.addNumberField("Concurrent processes:", 0, Integer.valueOf(Integer.MAX_VALUE), 1, INFO_MAX_PROCESSES, obj -> {
            this.settings.setConcurrentProcesses(obj.intValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JSpinner getMaxUnwinds() {
        return this.addNumberField("Maximal unwinds:", 0, Integer.valueOf(Integer.MAX_VALUE), 1, INFO_MAX_UNWINDS, e -> {
            this.settings.setMaxUnwinds(e.intValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JTextField getSaveToFilePanel() {
        return this.addFileChooserPanel("Store test cases to folder:", "", INFO_SAVE_TO, true, e -> {
            this.settings.setOutputPath(this.saveToFilePanel.getText());
            this.settings.fireSettingsChanged();
        });
    }

    private JTextField getOpenJMLPanel() {
        return this.addFileChooserPanel("Location of openjml:", "", INFO_OPEN_JML_PATH, false, e -> {
            this.settings.setOpenjmlPath(this.openJMLPanel.getText());
            this.settings.fireSettingsChanged();
        });
    }

    private JTextField getObjenesisPanel() {
        return this.addFileChooserPanel("Location of objenesis:", "", INFO_OBJENESIS_PATH, false, e -> {
            this.settings.setObjenesisPath(this.objenesisPanel.getText());
            this.settings.fireSettingsChanged();
        });
    }

    private JCheckBox getJUnitPanel() {
        return this.addCheckBox("Generate JUnit and test oracle", INFO_USE_JUNIT, false, val -> {
            this.settings.setUseJunit(val.booleanValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JCheckBox getRemoveDuplicatesPanel() {
        return this.addCheckBox("Remove duplicates", INFO_REMOVE_DUPLICATES, false, val -> {
            this.settings.setRemoveDuplicates(val.booleanValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JCheckBox getRFLSelectionPanel() {
        return this.addCheckBox("Use reflection framework", INFO_RFL_SELECTION, false, val -> {
            this.settings.setRFL(val.booleanValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JCheckBox getSymbolicEx() {
        return this.addCheckBox("Apply symbolic execution", INFO_APPLY_SYMBOLIC_EX, false, val -> {
            this.settings.setApplySymbolicExecution(val.booleanValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JCheckBox getInvariantForall() {
        return this.addCheckBox("Require invariant for all objects", INFO_INVARIANT_FOR_ALL, false, val -> {
            this.settings.setInvariantForAll(val.booleanValue());
            this.settings.fireSettingsChanged();
        });
    }

    private JCheckBox getIncludePostCondition() {
        return this.addCheckBox("Include post condition", INFO_INCLUDE_POSTCONDITION, false, val -> {
            this.settings.setIncludePostCondition(val.booleanValue());
            this.settings.fireSettingsChanged();
        });
    }

    public String getDescription() {
        return "TestGen";
    }

    public JComponent getPanel(MainWindow window) {
        this.settings = new TestGenerationSettings(TestGenerationSettings.getInstance());
        this.includePostCondition.setSelected(this.settings.includePostCondition());
        this.invariantForAll.setSelected(this.settings.invariantForAll());
        this.useJUnit.setSelected(this.settings.useJunit());
        this.symbolicEx.setSelected(this.settings.getApplySymbolicExecution());
        this.removeDuplicates.setSelected(this.settings.removeDuplicates());
        this.checkboxRFL.setSelected(this.settings.useRFL());
        this.objenesisPanel.setText(this.settings.getObjenesisPath());
        this.openJMLPanel.setText(this.settings.getOpenjmlPath());
        this.saveToFilePanel.setText(this.settings.getOutputFolderPath());
        return this;
    }

    public void applySettings(MainWindow window) {
        TestGenerationSettings globalSettings = TestGenerationSettings.getInstance();
        globalSettings.set(this.settings);
        globalSettings.fireSettingsChanged();
    }
}

