/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Colors;
import java.awt.Color;

public class BubbleDisplayerTransmitter
extends ColorTransmitter {
    private static final String[] KEYS = new String[]{"displayer.border.high.active", "displayer.border.high.active.mouse", "displayer.border.high.inactive", "displayer.border.high.inactive.mouse", "displayer.border.low.active", "displayer.border.low.active.mouse", "displayer.border.low.inactive", "displayer.border.low.inactive.mouse"};
    private ColorManager manager;

    public BubbleDisplayerTransmitter(ColorManager manager) {
        super(KEYS);
        this.manager = manager;
    }

    @Override
    protected Color get(Color color, String id, DockColor observer) {
        CDockable dockable = this.getDockable(observer);
        return this.get(color, id, dockable);
    }

    @Override
    protected Color get(Color color, String id, CDockable dockable) {
        if (dockable == null) {
            return color;
        }
        ColorMap map = dockable.getColors();
        Color check = null;
        if (id.contains("active") && !id.contains("inactive") && (check = map.getColor("title.background.focused")) != null) {
            check = this.convertFocused(check, id);
        }
        if (check == null && (check = map.getColor("title.background")) != null) {
            check = this.convert(check, id);
        }
        if (check != null) {
            return check;
        }
        return color;
    }

    @Override
    protected void update(CDockable dockable, String key, Color color) {
        boolean change;
        boolean bl = change = "title.background".equals(key) || "title.background.focused".equals(key);
        if (change) {
            for (String check : KEYS) {
                this.set(check, this.get((Color)this.manager.get(check), check, dockable), dockable);
            }
        }
    }

    protected Color convert(Color source, String key) {
        if (key.contains("active") && !key.contains("inactive")) {
            return this.convertFocused(Colors.diffMirror((Color)source, (double)0.2), key);
        }
        if ("displayer.border.low.inactive".equals(key)) {
            return Colors.darker((Color)source, (double)0.3);
        }
        if ("displayer.border.high.inactive".equals(key)) {
            return Colors.brighter((Color)source, (double)0.3);
        }
        if ("displayer.border.low.inactive.mouse".equals(key)) {
            return Colors.fuller((Color)Colors.darker((Color)source, (double)0.3), (double)0.3);
        }
        if ("displayer.border.high.inactive.mouse".equals(key)) {
            return Colors.fuller((Color)Colors.brighter((Color)source, (double)0.3), (double)0.3);
        }
        return source;
    }

    protected Color convertFocused(Color source, String key) {
        if ("displayer.border.low.active".equals(key)) {
            return Colors.darker((Color)source, (double)0.3);
        }
        if ("displayer.border.high.active".equals(key)) {
            return Colors.brighter((Color)source, (double)0.3);
        }
        if ("displayer.border.low.active.mouse".equals(key)) {
            return Colors.fuller((Color)Colors.darker((Color)source, (double)0.3), (double)0.3);
        }
        if ("displayer.border.high.active.mouse".equals(key)) {
            return Colors.fuller((Color)Colors.brighter((Color)source, (double)0.3), (double)0.3);
        }
        return source;
    }

    @Override
    protected CDockable getDockable(DockColor observer) {
        Dockable dockable = ((DisplayerColor)observer).getDisplayer().getDockable();
        if (dockable == null) {
            return null;
        }
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }
}

