/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.group.CGroupBehaviorCallback;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.group.StackGroupBehavior;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.facile.mode.DoubleClickLocationStrategy;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.status.DefaultExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementListener;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.layout.location.AsideRequestFactory;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import bibliothek.util.Path;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class LocationModeManager<M extends LocationMode>
extends ModeManager<Location, M> {
    public static final PropertyKey<ExtendedModeEnablementFactory> MODE_ENABLEMENT = new PropertyKey("locationmodemanager.mode_enablement", (PropertyFactory)new ConstantPropertyFactory((Object)DefaultExtendedModeEnablement.FACTORY), true);
    public static final PropertyKey<DoubleClickLocationStrategy> DOUBLE_CLICK_STRATEGY = new PropertyKey("locationmodemanager.double_click_strategy", (PropertyFactory)new ConstantPropertyFactory((Object)DoubleClickLocationStrategy.DEFAULT), true);
    private Map<Path, List<LocationModeListener>> listeners = new HashMap<Path, List<LocationModeListener>>();
    private RegisterListener registerListener = new RegisterListener();
    private HierarchyListener hierarchyListener = new HierarchyListener();
    private RelocatorListener relocatorListener = new RelocatorListener();
    private CGroupBehavior behavior = new StackGroupBehavior();
    private List<CGroupMovement> currentAction = new ArrayList<CGroupMovement>();
    private LinkedHashSet<Dockable> pendingRefreshs = new LinkedHashSet();
    private PropertyValue<ExtendedModeEnablementFactory> extendedModeFactory = new PropertyValue<ExtendedModeEnablementFactory>(MODE_ENABLEMENT){

        protected void valueChanged(ExtendedModeEnablementFactory oldValue, ExtendedModeEnablementFactory newValue) {
            LocationModeManager.this.updateEnablement();
        }
    };
    private PropertyValue<DoubleClickLocationStrategy> doubleClickStrategy = new PropertyValue<DoubleClickLocationStrategy>(DOUBLE_CLICK_STRATEGY){

        protected void valueChanged(DoubleClickLocationStrategy oldValue, DoubleClickLocationStrategy newValue) {
        }
    };
    private ExtendedModeEnablementListener enablementListener = new ExtendedModeEnablementListener(){

        @Override
        public void availabilityChanged(Dockable dockable, ExtendedMode mode, boolean available) {
            LocationModeManager.this.refresh(dockable, true);
        }
    };
    private DoubleClickListener doubleClickListener = new DoubleClickListener(){

        public DockElement getTreeLocation() {
            return null;
        }

        public boolean process(Dockable dockable, MouseEvent event) {
            if (event.isConsumed()) {
                return false;
            }
            if ((dockable = LocationModeManager.this.getDoubleClickTarget(dockable)) != null) {
                Mode current = LocationModeManager.this.getCurrentMode(dockable);
                ExtendedMode next = LocationModeManager.this.getDoubleClickStrategy().handleDoubleClick(dockable, current == null ? null : current.getExtendedMode(), LocationModeManager.this.enablement);
                if (next != null && LocationModeManager.this.isModeAvailable(dockable, next)) {
                    LocationModeManager.this.setMode(dockable, next);
                    LocationModeManager.this.ensureValidLocation(dockable);
                    return true;
                }
            }
            return false;
        }
    };
    private ExtendedModeEnablement enablement;
    private int layoutMode = 0;

    public LocationModeManager(DockController controller) {
        super(controller);
        this.registerListener.connect(controller);
        controller.getRelocator().addVetoableDockRelocatorListener((VetoableDockRelocatorListener)this.relocatorListener);
        this.updateEnablement();
        this.extendedModeFactory.setProperties(controller);
        this.addModeManagerListener(new LocationModeListenerAdapter());
        controller.getDoubleClickController().addListener(this.doubleClickListener);
    }

    @Override
    public void destroy() {
        this.registerListener.connect(null);
        DockController controller = this.getController();
        controller.getRelocator().removeVetoableDockRelocatorListener((VetoableDockRelocatorListener)this.relocatorListener);
        controller.getDoubleClickController().removeListener(this.doubleClickListener);
        for (LocationMode mode : this.modes()) {
            mode.setController(null);
        }
        super.destroy();
        this.extendedModeFactory.setProperties((DockProperties)null);
    }

    protected void updateEnablement() {
        if (this.enablement != null) {
            this.enablement.removeListener(this.enablementListener);
            this.enablement.destroy();
            this.enablement = null;
        }
        if (this.getController() != null) {
            this.enablement = ((ExtendedModeEnablementFactory)this.extendedModeFactory.getValue()).create(this);
            this.enablement.addListener(this.enablementListener);
        }
        this.rebuildAll();
    }

    public void setGroupBehavior(CGroupBehavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("the group behavior must not be null");
        }
        this.behavior = behavior;
    }

    public CGroupBehavior getGroupBehavior() {
        return this.behavior;
    }

    public void setMode(final Dockable dockable, final ExtendedMode extendedMode) {
        LocationMode mode = (LocationMode)this.getMode(extendedMode.getModeIdentifier());
        if (mode == null) {
            throw new IllegalArgumentException("No mode '" + extendedMode.getModeIdentifier() + "' available");
        }
        this.runTransaction(new Runnable(){

            @Override
            public void run() {
                CGroupMovement action = LocationModeManager.this.behavior.prepare(LocationModeManager.this, dockable, extendedMode);
                if (action == null) {
                    return;
                }
                LocationModeManager.this.apply(dockable, extendedMode, action);
            }
        });
    }

    public CGroupMovement getCurrentAction() {
        if (this.currentAction.isEmpty()) {
            return null;
        }
        return this.currentAction.get(this.currentAction.size() - 1);
    }

    public void apply(final Dockable dockable, final ExtendedMode extendedMode, final CGroupMovement action) {
        this.runTransaction(new AffectingRunnable(){

            @Override
            public void run(final AffectedSet set) {
                try {
                    LocationModeManager.this.getController().getFocusController().freezeFocus();
                    LocationModeManager.this.currentAction.add(action);
                    action.apply(new CGroupBehaviorCallback(){

                        @Override
                        public void setMode(Dockable element, ExtendedMode mode) {
                            LocationModeManager.this.apply(element, mode.getModeIdentifier(), false);
                        }

                        @Override
                        public void setLocation(Dockable element, Location location) {
                            LocationModeManager.this.apply(element, location.getMode(), location, set);
                        }

                        @Override
                        public LocationModeManager<? extends LocationMode> getManager() {
                            return LocationModeManager.this;
                        }

                        @Override
                        public Location getLocation(Dockable dockable) {
                            Mode mode = LocationModeManager.this.getCurrentMode(dockable);
                            if (mode == null) {
                                return null;
                            }
                            return (Location)mode.current(dockable);
                        }
                    });
                }
                finally {
                    LocationModeManager.this.currentAction.remove(action);
                    LocationModeManager.this.getController().getFocusController().meltFocus();
                }
                LocationMode mode = (LocationMode)LocationModeManager.this.getMode(extendedMode.getModeIdentifier());
                if (mode != null) {
                    if (mode.shouldAutoFocus()) {
                        LocationModeManager.this.getController().setFocusedDockable((FocusRequest)new DefaultFocusRequest((DockElementRepresentative)dockable, null, true, true, false));
                    } else {
                        LocationModeManager.this.getController().setFocusedDockable((FocusRequest)new DefaultFocusRequest(null, null, true));
                    }
                }
            }
        });
    }

    public ExtendedMode getMode(Dockable dockable) {
        Mode mode = this.getCurrentMode(dockable);
        if (mode == null) {
            return null;
        }
        return mode.getExtendedMode();
    }

    public Map<ExtendedMode, DockStation> getRepresentations(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        HashMap<ExtendedMode, DockStation> result = new HashMap<ExtendedMode, DockStation>();
        for (LocationMode mode : this.modes()) {
            DockStation station = mode.getRepresentation(id);
            if (station == null) continue;
            result.put(mode.getExtendedMode(), station);
        }
        return result;
    }

    @Override
    protected void applyDuringRead(String key, Path old, Path current, Dockable dockable) {
    }

    @Override
    public void apply(Dockable dockable, M mode, Location history, AffectedSet set) {
        super.apply(dockable, mode, history, set);
        if (history != null) {
            history.resetApplicationDefined();
        }
    }

    public boolean isModeAvailable(Dockable dockable, ExtendedMode mode) {
        if (this.enablement == null) {
            return false;
        }
        return this.enablement.isAvailable(dockable, mode).isAvailable();
    }

    public boolean isModeHidden(Dockable dockable, ExtendedMode mode) {
        if (this.enablement == null) {
            return false;
        }
        return this.enablement.isHidden(dockable, mode).isHidden();
    }

    public void addListener(Path identifier, LocationModeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        List<LocationModeListener> list = this.listeners.get(identifier);
        if (list == null) {
            list = new ArrayList<LocationModeListener>();
            this.listeners.put(identifier, list);
        }
        list.add(listener);
        LocationMode mode = (LocationMode)this.getMode(identifier);
        if (mode != null) {
            mode.addLocationModeListener(listener);
        }
    }

    public void removeListener(Path identifier, LocationModeListener listener) {
        LocationMode mode;
        List<LocationModeListener> list = this.listeners.get(identifier);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.listeners.remove(identifier);
        }
        if ((mode = (LocationMode)this.getMode(identifier)) != null) {
            mode.removeLocationModeListener(listener);
        }
    }

    @Override
    public M getCurrentMode(Dockable dockable) {
        while (dockable != null) {
            for (LocationMode mode : this.modes()) {
                if (!mode.isCurrentMode(dockable)) continue;
                return (M)mode;
            }
            DockStation station = dockable.getDockParent();
            dockable = station == null ? null : station.asDockable();
        }
        return null;
    }

    public DoubleClickLocationStrategy getDoubleClickStrategy() {
        return (DoubleClickLocationStrategy)this.doubleClickStrategy.getValue();
    }

    public void setDoubleClickStrategy(DoubleClickLocationStrategy strategy) {
        this.doubleClickStrategy.setValue((Object)strategy);
    }

    public boolean isLayouting() {
        return this.layoutMode > 0;
    }

    public void runLayoutTransaction(Runnable run) {
        try {
            ++this.layoutMode;
            this.runTransaction(run, true);
        }
        finally {
            --this.layoutMode;
        }
    }

    public void ensureNotHidden(final Dockable dockable) {
        if (this.isLayouting()) {
            return;
        }
        this.runTransaction(new Runnable(){

            @Override
            public void run() {
                for (LocationMode mode : LocationModeManager.this.modes()) {
                    mode.ensureNotHidden(dockable);
                }
            }
        });
    }

    public void ensureValidLocation(Dockable dockable) {
    }

    public void setLocationAside(Dockable dockable, Dockable aside) {
        Mode current = this.getCurrentMode(aside);
        List history = this.getModeHistory(aside);
        for (LocationMode mode : history) {
            AsideRequestFactory factory;
            AsideRequest request;
            Location result;
            Location location = mode == current ? (Location)mode.current(aside) : (Location)this.getHistory(aside, mode.getUniqueIdentifier());
            if (location == null || (result = mode.aside(request = (factory = (AsideRequestFactory)this.getController().getProperties().get(AsideRequest.REQUEST_FACTORY)).createAsideRequest(location.getLocation(), dockable), location)) == null) continue;
            this.addToModeHistory(dockable, mode, result);
        }
    }

    @Override
    public DockActionSource getSharedActions(DockStation station) {
        Dockable selected = station.getFrontDockable();
        if (selected == null) {
            return null;
        }
        Mode mode = this.getCurrentMode(selected);
        if (mode == null) {
            return null;
        }
        MultiDockActionSource result = new MultiDockActionSource(new DockActionSource[0]);
        for (LocationMode other : this.modes()) {
            DockActionSource source;
            if (!this.behavior.shouldForwardActions(this, station, selected, other.getExtendedMode()) || (source = other.getActionsFor(selected, mode)) == null) continue;
            result.add(source);
        }
        return result;
    }

    public void delayedRefresh(Dockable dockable) {
        if (this.getController().getRegister().isStalled()) {
            this.pendingRefreshs.add(dockable);
        } else {
            this.refresh(dockable, true);
        }
    }

    private class RegisterListener
    extends DockRegisterAdapter {
        private DockController controller;

        private RegisterListener() {
        }

        public void connect(DockController controller) {
            DockRegister register;
            if (this.controller != null) {
                register = this.controller.getRegister();
                register.removeDockRegisterListener((DockRegisterListener)this);
                for (Dockable dockable : register.listDockables()) {
                    dockable.removeDockHierarchyListener((DockHierarchyListener)LocationModeManager.this.hierarchyListener);
                    LocationModeManager.this.rebuild(dockable);
                }
            }
            this.controller = controller;
            if (controller != null) {
                register = controller.getRegister();
                register.addDockRegisterListener((DockRegisterListener)this);
                for (Dockable dockable : register.listDockables()) {
                    dockable.addDockHierarchyListener((DockHierarchyListener)LocationModeManager.this.hierarchyListener);
                }
            }
        }

        public void dockableRegistered(DockController controller, Dockable dockable) {
            dockable.addDockHierarchyListener((DockHierarchyListener)LocationModeManager.this.hierarchyListener);
            LocationModeManager.this.rebuild(dockable);
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            dockable.removeDockHierarchyListener((DockHierarchyListener)LocationModeManager.this.hierarchyListener);
        }

        public void registerUnstalled(DockController controller) {
            while (LocationModeManager.this.pendingRefreshs.size() > 0 && !controller.getRegister().isStalled()) {
                Iterator iter = LocationModeManager.this.pendingRefreshs.iterator();
                Dockable next = (Dockable)iter.next();
                iter.remove();
                LocationModeManager.this.refresh(next, true);
            }
        }
    }

    private class HierarchyListener
    implements DockHierarchyListener {
        private HierarchyListener() {
        }

        public void controllerChanged(DockHierarchyEvent event) {
        }

        public void hierarchyChanged(DockHierarchyEvent event) {
            if (!LocationModeManager.this.isOnTransaction()) {
                LocationModeManager.this.delayedRefresh(event.getDockable());
            }
        }
    }

    private class RelocatorListener
    extends VetoableDockRelocatorAdapter {
        private RelocatorListener() {
        }

        public void dragging(DockRelocatorEvent event) {
            LocationModeManager.this.store(event.getDockable());
            for (Dockable dockable : event.getImplicitDockables()) {
                LocationModeManager.this.store(dockable);
            }
        }
    }

    private class LocationModeListenerAdapter
    implements ModeManagerListener<Location, LocationMode> {
        private LocationModeListenerAdapter() {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            mode.setManager(LocationModeManager.this);
            mode.setController(LocationModeManager.this.getController());
            List<LocationModeListener> list = LocationModeManager.this.listeners.get(mode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener listener : list) {
                    mode.addLocationModeListener(listener);
                }
            }
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            mode.setManager(null);
            mode.setController(null);
            List<LocationModeListener> list = LocationModeManager.this.listeners.get(mode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener listener : list) {
                    mode.removeLocationModeListener(listener);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable, LocationMode oldMode, LocationMode newMode) {
        }
    }
}

