/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.rifl;

import de.uka.ilkd.key.util.rifl.SpecificationContainer;
import de.uka.ilkd.key.util.rifl.SpecificationEntity;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import recoder.abstraction.ClassType;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;

public class DefaultSpecificationContainer
implements SpecificationContainer {
    private final Map<SpecificationEntity.Field, String> field2domain = new HashMap<SpecificationEntity.Field, String>();
    private final Map<SpecificationEntity.Parameter, String> param2domain = new HashMap<SpecificationEntity.Parameter, String>();
    private final Map<SpecificationEntity.ReturnValue, String> return2domain = new HashMap<SpecificationEntity.ReturnValue, String>();
    private final Set<Map.Entry<String, String>> flow = new LinkedHashSet<Map.Entry<String, String>>();

    public DefaultSpecificationContainer(Map<SpecificationEntity, String> domainAssignments, Set<Map.Entry<String, String>> flow2) {
        for (Map.Entry<SpecificationEntity, String> e : domainAssignments.entrySet()) {
            if (e.getKey() instanceof SpecificationEntity.Field) {
                this.field2domain.put((SpecificationEntity.Field)e.getKey(), e.getValue());
                continue;
            }
            if (e.getKey() instanceof SpecificationEntity.Parameter) {
                this.param2domain.put((SpecificationEntity.Parameter)e.getKey(), e.getValue());
                continue;
            }
            if (!(e.getKey() instanceof SpecificationEntity.ReturnValue)) continue;
            this.return2domain.put((SpecificationEntity.ReturnValue)e.getKey(), e.getValue());
        }
        this.flow.addAll(flow2);
    }

    public String toString() {
        return "Fields: " + this.field2domain + "\nParameters: " + this.param2domain + "\nReturns: " + this.return2domain + "\nFlows: " + this.flow;
    }

    private String[] extractParamTypes(MethodDeclaration md) {
        int params = md.getParameterDeclarationCount();
        String[] paramTypes = new String[params];
        for (int i = 0; i < params; ++i) {
            ParameterDeclaration pd = md.getParameterDeclarationAt(i);
            paramTypes[i] = pd.getTypeReference().getName();
        }
        return paramTypes;
    }

    @Override
    public String field(FieldDeclaration fd, SpecificationEntity.Type type) {
        FieldSpecification fs = (FieldSpecification)fd.getVariables().get(0);
        ClassType ctype = fs.getContainingClassType();
        String inClass = ctype.getName();
        String inPackage = ctype.getPackage().getFullName();
        return this.field(inPackage, inClass, fs.getName(), type);
    }

    @Override
    public String field(String inPackage, String inClass, String name, SpecificationEntity.Type type) {
        return this.field2domain.get(new SpecificationEntity.Field(name, inPackage, inClass, type));
    }

    @Override
    public String parameter(MethodDeclaration md, int index, SpecificationEntity.Type type) {
        String[] paramTypes = this.extractParamTypes(md);
        ClassType ctype = md.getContainingClassType();
        return this.parameter(ctype.getPackage().getFullName(), ctype.getName(), md.getName(), paramTypes, index, type);
    }

    @Override
    public String parameter(String inPackage, String inClass, String methodName, String[] paramTypes, int index, SpecificationEntity.Type type) {
        return this.param2domain.get(new SpecificationEntity.Parameter(index, methodName, paramTypes, inPackage, inClass, type));
    }

    @Override
    public String returnValue(MethodDeclaration md, SpecificationEntity.Type type) {
        ClassType ctype = md.getContainingClassType();
        return this.returnValue(ctype.getPackage().getFullName(), ctype.getName(), md.getName(), this.extractParamTypes(md), type);
    }

    @Override
    public String returnValue(String inPackage, String inClass, String methodName, String[] paramTypes, SpecificationEntity.Type type) {
        return this.return2domain.get(new SpecificationEntity.ReturnValue(methodName, paramTypes, inPackage, inClass, type));
    }

    @Override
    public Set<String> flows(String domain) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<String, String> e : this.flow) {
            if (!e.getValue().equals(domain)) continue;
            result.add(e.getKey());
        }
        return result;
    }
}

