/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.rifl;

import de.uka.ilkd.key.util.LinkedHashMap;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.rifl.DefaultSpecificationContainer;
import de.uka.ilkd.key.util.rifl.SpecificationContainer;
import de.uka.ilkd.key.util.rifl.SpecificationEntity;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.key_project.util.collection.KeYCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class RIFLHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RIFLHandler.class);
    private static final String DEFAULT_CATEGORY = "Spider Pig";
    private static final String DEFAULT_DOMAIN = "low";
    private final Map<SpecificationEntity, Pair<String, String>> sources2categories = new LinkedHashMap();
    private final Map<SpecificationEntity, Pair<String, String>> sinks2categories = new LinkedHashMap();
    private final Map<Pair<String, String>, String> categories2domains = new LinkedHashMap();
    private final Map<String, String> handles2categories = new LinkedHashMap();
    private Set<String> domains = new LinkedHashSet<String>();
    private Set<Map.Entry<String, String>> flow = new LinkedHashSet<Map.Entry<String, String>>();
    private Map<SpecificationEntity, Pair<String, String>> tmpMap = null;
    private SpecificationEntity.Type type = null;
    private String tmpHandle = null;
    private String category = "Spider Pig";

    private static String printAttributes(Attributes a) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < a.getLength(); ++i) {
            sb.append(a.getValue(i));
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }

    private void assignHandle(Attributes attributes) {
        String handle = attributes.getValue("handle").intern();
        String domain = attributes.getValue("domain").intern();
        Pair p = new Pair((Object)handle, (Object)this.handles2categories.get(handle));
        this.categories2domains.put((Pair<String, String>)p, domain);
    }

    private void setAssignable(Attributes attributes) {
        assert (this.tmpHandle == null);
        this.tmpHandle = attributes.getValue("handle");
    }

    private void unsetAssignable() {
        assert (this.tmpHandle != null);
        this.tmpHandle = null;
    }

    @Override
    public void endDocument() {
    }

    public SpecificationContainer getSpecification() {
        LinkedHashMap tmp = new LinkedHashMap();
        tmp.putAll(KeYCollections.apply(this.sources2categories, this.categories2domains));
        tmp.putAll(KeYCollections.apply(this.sinks2categories, this.categories2domains));
        return new DefaultSpecificationContainer((Map<SpecificationEntity, String>)tmp, this.flow);
    }

    private void putField(Attributes attributes) {
        String field = attributes.getValue("name");
        String clazz = attributes.getValue("class");
        String packg = attributes.getValue("package");
        SpecificationEntity.Field se = new SpecificationEntity.Field(field, packg, clazz, this.type);
        this.handles2categories.put(this.tmpHandle, this.category);
        this.tmpMap.put(se, (Pair<String, String>)new Pair((Object)this.tmpHandle, (Object)this.category));
    }

    private void putParam(Attributes attributes) {
        String packg = attributes.getValue("package");
        String clazz = attributes.getValue("class");
        String method = attributes.getValue("method");
        int param = Integer.parseInt(attributes.getValue("parameter"));
        SpecificationEntity.Parameter se = new SpecificationEntity.Parameter(param, method, packg, clazz, this.type);
        this.handles2categories.put(this.tmpHandle, this.category);
        this.tmpMap.put(se, (Pair<String, String>)new Pair((Object)this.tmpHandle, (Object)this.category));
    }

    private void putReturn(Attributes attributes) {
        String packageName = attributes.getValue("package");
        String className = attributes.getValue("class");
        String methodName = attributes.getValue("method");
        SpecificationEntity.ReturnValue se = new SpecificationEntity.ReturnValue(methodName, packageName, className, this.type);
        this.handles2categories.put(this.tmpHandle, this.category);
        this.tmpMap.put(se, (Pair<String, String>)new Pair((Object)this.tmpHandle, (Object)this.category));
    }

    private void putFlow(Attributes attributes) {
        String from = attributes.getValue("from");
        String to = attributes.getValue("to");
        assert (!from.equals(to));
        AbstractMap.SimpleEntry<String, String> e = new AbstractMap.SimpleEntry<String, String>(from, to);
        this.flow.add(e);
    }

    private void putDomain(Attributes attributes) {
        String domainName = attributes.getValue("name");
        this.domains.add(domainName);
    }

    private void setCategory(Attributes attributes) {
        assert (Objects.equals(this.category, DEFAULT_CATEGORY));
        this.category = attributes.getValue("name").intern();
    }

    private void unsetCategory() {
        assert (!Objects.equals(this.category, DEFAULT_CATEGORY));
        this.category = DEFAULT_CATEGORY;
    }

    private void checkDomains() {
        assert (!this.domains.isEmpty());
        assert (this.domains.contains(DEFAULT_DOMAIN));
    }

    private void checkDomainAssignmentsWithFlows() {
    }

    private void checkFlows() {
        for (Map.Entry<Pair<String, String>, String> p : this.categories2domains.entrySet()) {
            assert (this.domains.contains(this.categories2domains.get(p.getKey())));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (localName) {
            case "sourcedompair": 
            case "source": {
                this.startSources();
                break;
            }
            case "sinkdompair": 
            case "sink": {
                this.startSinks();
                break;
            }
            case "category": {
                this.setCategory(attributes);
                break;
            }
            case "assign": {
                this.assignHandle(attributes);
                break;
            }
            case "domains": {
                this.startDomains();
                break;
            }
            case "domain": {
                this.putDomain(attributes);
                break;
            }
            case "assignable": {
                this.setAssignable(attributes);
                break;
            }
            case "field": {
                this.putField(attributes);
                break;
            }
            case "parameter": {
                this.putParam(attributes);
                break;
            }
            case "returnvalue": {
                this.putReturn(attributes);
                break;
            }
            case "flowrelation": {
                this.startFlow();
                break;
            }
            case "flow": {
                this.putFlow(attributes);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (localName) {
            case "assignable": {
                this.unsetAssignable();
                break;
            }
            case "category": {
                this.unsetCategory();
                break;
            }
            case "domains": {
                this.checkDomains();
                break;
            }
            case "domainassignment": {
                this.checkDomainAssignmentsWithFlows();
                break;
            }
            case "flowrelation": {
                this.checkFlows();
                break;
            }
        }
    }

    private void startDomains() {
        this.domains = new LinkedHashSet<String>();
    }

    private void startFlow() {
        this.flow = new LinkedHashSet<Map.Entry<String, String>>();
    }

    private void startSinks() {
        this.tmpMap = this.sinks2categories;
        this.type = SpecificationEntity.Type.SINK;
    }

    private void startSources() {
        this.tmpMap = this.sources2categories;
        this.type = SpecificationEntity.Type.SOURCE;
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            return "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            LOGGER.warn("Warning: {}", (Object)this.getParseExceptionInfo(spe));
        }
    }
}

