/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.rifl;

import de.uka.ilkd.key.java.recoderext.ProofJavaProgramFactory;
import de.uka.ilkd.key.util.Debug;
import de.uka.ilkd.key.util.DirectoryFileCollection;
import de.uka.ilkd.key.util.KeYRecoderExcHandler;
import de.uka.ilkd.key.util.rifl.RIFLHandler;
import de.uka.ilkd.key.util.rifl.SimpleRIFLExceptionHandler;
import de.uka.ilkd.key.util.rifl.SpecificationContainer;
import de.uka.ilkd.key.util.rifl.SpecificationInjector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ParserException;
import recoder.ServiceConfiguration;
import recoder.java.CompilationUnit;
import recoder.java.JavaProgramFactory;
import recoder.java.SourceVisitor;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;

public class RIFLTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RIFLTransformer.class);
    private final List<File> result = new ArrayList<File>();
    private static final JavaProgramFactory JPF = ProofJavaProgramFactory.getInstance();

    public RIFLTransformer() throws ParserConfigurationException, SAXException {
        JPF.initialize((ServiceConfiguration)new CrossReferenceServiceConfiguration());
        assert (JPF.getServiceConfiguration() != null);
    }

    public static void main(String[] args) {
        if (args.length < 2 || "--help".equals(args[0])) {
            LOGGER.info("This is the RIFL to JML* transformer.");
            LOGGER.info("Usage: <RIFL file> <Java sources>");
        } else {
            File riflFilename = new File(args[0]);
            File javaFilename = new File(args[1]);
            RIFLTransformer.transform(riflFilename, javaFilename);
        }
    }

    public static boolean transform(File riflFilename, File javaSource, File savePath, KeYRecoderExcHandler kexh) {
        if (riflFilename == null || javaSource == null || savePath == null || kexh == null) {
            throw new IllegalArgumentException("A parameter is null");
        }
        try {
            RIFLTransformer rt = new RIFLTransformer();
            rt.doTransform(riflFilename, javaSource, savePath);
            return true;
        }
        catch (IOException | ParserConfigurationException | SAXException | ParserException e) {
            kexh.reportException(e);
            return false;
        }
    }

    public static boolean transform(File riflFilename, File javaSource, KeYRecoderExcHandler kexh) {
        return RIFLTransformer.transform(riflFilename, javaSource, RIFLTransformer.getDefaultSavePath(javaSource), kexh);
    }

    public static boolean transform(File riflFilename, File javaSource) {
        return RIFLTransformer.transform(riflFilename, javaSource, SimpleRIFLExceptionHandler.INSTANCE);
    }

    public static File getDefaultSavePath(File origSourcePath) {
        origSourcePath = RIFLTransformer.getBaseDirPath(origSourcePath);
        return new File(origSourcePath.getParentFile(), origSourcePath.getName() + "_RIFL");
    }

    private static File getBaseDirPath(File origSourcePath) {
        if (origSourcePath.isFile()) {
            return origSourcePath.getParentFile();
        }
        return origSourcePath;
    }

    private Map<CompilationUnit, File> readJava(File root) throws IOException, ParserException {
        assert (root.exists()) : "source dir must exist";
        assert (root.isDirectory()) : "source must be directory";
        DirectoryFileCollection files = new DirectoryFileCollection(root);
        DirectoryFileCollection.Walker walker = files.createWalker(".java");
        ServiceConfiguration serviceConfiguration = JPF.getServiceConfiguration();
        HashMap<CompilationUnit, File> javaCUs = new HashMap<CompilationUnit, File>();
        while (walker.step()) {
            File javaFile = new File(walker.getCurrentName());
            if (Debug.ENABLE_DEBUG) {
                LOGGER.info("[RIFL] Read file: {}", (Object)javaFile);
            }
            try (BufferedReader fr = new BufferedReader(new FileReader(javaFile));){
                CompilationUnit cu = JPF.parseCompilationUnit((Reader)fr);
                File relative = this.relative(root, javaFile);
                javaCUs.put(cu, relative);
                serviceConfiguration.getChangeHistory().updateModel();
            }
        }
        return javaCUs;
    }

    private File relative(File root, File javaFile) {
        return new File(javaFile.getAbsolutePath().substring(root.getAbsolutePath().length()));
    }

    private SpecificationContainer readRIFL(File fileName) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(new RIFLHandler());
        xmlReader.setErrorHandler(new RIFLHandler.ErrorHandler());
        xmlReader.parse(fileName.toURI().toString());
        return ((RIFLHandler)xmlReader.getContentHandler()).getSpecification();
    }

    public void doTransform(File riflFilename, File source, File savePath) throws IOException, SAXException, ParserException, ParserConfigurationException {
        this.ensureTargetDirExists(savePath);
        File javaRoot = RIFLTransformer.getBaseDirPath(source);
        SpecificationContainer sc = this.readRIFL(riflFilename);
        Map<CompilationUnit, File> javaCUs = this.readJava(javaRoot);
        int counter = 0;
        for (CompilationUnit compilationUnit : javaCUs.keySet()) {
            SpecificationInjector si = new SpecificationInjector(sc, JPF.getServiceConfiguration().getSourceInfo());
            compilationUnit.accept((SourceVisitor)si);
            ClassDeclaration clazz = (ClassDeclaration)compilationUnit.getPrimaryTypeDeclaration();
            for (MethodDeclaration mdecl : si.getSpecifiedMethodDeclarations()) {
                StringBuilder sb = new StringBuilder();
                for (ParameterDeclaration p : mdecl.getParameters()) {
                    sb.append(p.getTypeReference().getName());
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                String poname = clazz.getFullName() + "[" + clazz.getFullName() + "\\\\:\\\\:" + mdecl.getName() + "(" + sb + ")].Non-interference contract.0";
                File problemFileName = new File(javaRoot.getParent(), riflFilename.getName() + "_" + counter++ + ".key");
                this.writeProblemFile(problemFileName, RIFLTransformer.getDefaultSavePath(javaRoot).getName(), poname);
                this.result.add(problemFileName);
            }
        }
        for (Map.Entry entry : javaCUs.entrySet()) {
            CompilationUnit cu = (CompilationUnit)entry.getKey();
            File relative = (File)entry.getValue();
            this.writeJavaFile(new File(savePath, relative.toString()), cu);
        }
    }

    private void writeProblemFile(File problemFileName, String newJavaFolder, String poname) {
        StringBuilder blueprint = new StringBuilder();
        InputStream stream = this.getClass().getResourceAsStream("blueprint_rifl.key");
        Objects.requireNonNull(stream);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));
             BufferedWriter fw = new BufferedWriter(new FileWriter(problemFileName));){
            String tmp;
            while ((tmp = br.readLine()) != null) {
                blueprint.append(tmp).append("\n");
            }
            fw.write(blueprint.toString().replace("%%JAVA_SOURCE%%", newJavaFolder).replace("%%PO_NAME%%", poname));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ensureTargetDirExists(File target) throws IOException {
        if (target.exists()) {
            if (!target.isDirectory() || !target.canWrite()) {
                throw new IOException("target directory " + target + " not writable");
            }
        } else {
            target.mkdirs();
        }
    }

    private void writeJavaFile(File target, CompilationUnit cu) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(target));){
            LOGGER.debug("Trying to write file {}", (Object)target);
            String source = cu.toSource();
            LOGGER.debug("[RIFL] Write the following contents to file:");
            LOGGER.debug(source);
            writer.write(source);
            writer.flush();
        }
    }

    public List<File> getProblemFiles() {
        return this.result;
    }
}

