/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.rifl;

import java.util.HashSet;
import java.util.Set;

public class SecurityLattice {
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private final SecurityDomain top;
    private final SecurityDomain bottom;
    private final Set<SecurityDomain> hash = new HashSet<SecurityDomain>();

    public SecurityLattice() {
        this.top = new SecurityDomain(TOP);
        this.bottom = new SecurityDomain(BOTTOM);
        this.top.putSubDomain(this.bottom);
        this.hash.add(this.top);
        this.hash.add(this.bottom);
    }

    SecurityDomain addDomain(String name) {
        SecurityDomain d = new SecurityDomain(name.intern());
        if (this.hash.contains(d)) {
            throw new IllegalArgumentException("Domain already in lattice (names must be unique)");
        }
        d.putSubDomain(this.bottom);
        this.top.putSubDomain(d);
        this.hash.add(d);
        return d;
    }

    void putSubDomain(SecurityDomain sup, SecurityDomain sub) {
        if (sup == this.top || sub == this.bottom) {
            return;
        }
        if (!this.hash.contains(sup)) {
            throw new IllegalArgumentException("Security domain " + sup + " must be added to the lattice first.");
        }
        if (!this.hash.contains(sub)) {
            throw new IllegalArgumentException("Security domain " + sub + " must be added to the lattice first.");
        }
        if (sup == sub || sub.isSuperDomain(sup)) {
            throw new IllegalArgumentException("Security lattice must be acyclic.");
        }
        sup.putSubDomain(sub);
    }

    public SecurityDomain top() {
        return this.top;
    }

    public SecurityDomain bottom() {
        return this.bottom;
    }

    public boolean contains(SecurityDomain d) {
        return this.hash.contains(d);
    }

    public final class SecurityDomain {
        private final String name;
        private Set<SecurityDomain> superDomains;
        private Set<SecurityDomain> subDomains;

        private SecurityDomain(String name) {
            this.name = name;
            this.superDomains = new HashSet<SecurityDomain>();
            this.subDomains = new HashSet<SecurityDomain>();
        }

        private void putSubDomain(SecurityDomain sub) {
            this.subDomains.add(sub);
            sub.superDomains.add(this);
        }

        public boolean isSuperDomain(SecurityDomain other) {
            if (other == this) {
                return false;
            }
            for (SecurityDomain sub : this.subDomains) {
                if (sub != other && !sub.isSuperDomain(other)) continue;
                return true;
            }
            return false;
        }

        public boolean isSubDomain(SecurityDomain other) {
            if (other == this) {
                return false;
            }
            for (SecurityDomain sup : this.superDomains) {
                if (sup != other && !sup.isSubDomain(other)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

