/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.rifl;

import java.util.Arrays;

public abstract class SpecificationEntity {
    public final String inPackage;
    public final String inClass;
    public final Type type;

    private SpecificationEntity(String p, String c, Type t) {
        this.inPackage = p == null ? "" : p.intern();
        this.inClass = c.intern();
        this.type = t;
    }

    public boolean equals(Object o) {
        if (o instanceof SpecificationEntity) {
            return this.inPackage.equals(((SpecificationEntity)o).inPackage) && this.inClass.equals(((SpecificationEntity)o).inClass) && this.type == ((SpecificationEntity)o).type;
        }
        return false;
    }

    public abstract int hashCode();

    public abstract String qualifiedName();

    public String toString() {
        return this.qualifiedName();
    }

    public static final class ReturnValue
    extends SpecificationEntity {
        public final String methodName;
        public final String[] paramTypes;

        ReturnValue(String m, String p, String c, Type t) {
            super(p, c, t);
            int i = m.indexOf(40);
            this.methodName = m.substring(0, i).intern();
            this.paramTypes = m.substring(i + 1, m.lastIndexOf(41)).split(",");
        }

        ReturnValue(String m, String[] pt, String p, String c, Type t) {
            super(p, c, t);
            this.methodName = m;
            this.paramTypes = pt;
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof ReturnValue) {
                return this.methodName.equals(((ReturnValue)o).methodName) && Arrays.equals(this.paramTypes, ((ReturnValue)o).paramTypes);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 3721 * (this.inPackage + this.inClass).hashCode() + 79 * this.methodName.hashCode() + 13 * this.type.hashCode() + Arrays.hashCode(this.paramTypes);
        }

        @Override
        public String qualifiedName() {
            StringBuffer sb = new StringBuffer();
            if (!"".equals(this.inPackage)) {
                sb.append(this.inPackage + ".");
            }
            sb.append(this.inClass + "#" + this.methodName + "(");
            for (String p : this.paramTypes) {
                sb.append(p);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
            return sb.toString();
        }
    }

    public static final class Parameter
    extends SpecificationEntity {
        public final String methodName;
        public final String[] paramTypes;
        public final int position;

        Parameter(int pos, String m, String p, String c, Type t) {
            super(p, c, t);
            int i = m.indexOf(40);
            this.methodName = m.substring(0, i).intern();
            this.paramTypes = m.substring(i + 1, m.lastIndexOf(41)).split(",");
            this.position = pos;
        }

        Parameter(int pos, String m, String[] pt, String p, String c, Type t) {
            super(p, c, t);
            this.position = pos;
            this.methodName = m;
            this.paramTypes = pt;
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof Parameter) {
                return this.methodName.equals(((Parameter)o).methodName) && Arrays.equals(((Parameter)o).paramTypes, this.paramTypes) && this.position == ((Parameter)o).position;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 3661 * (this.inPackage + this.inClass).hashCode() + 37 * (this.methodName.hashCode() + 13 * this.type.hashCode() + Arrays.hashCode(this.paramTypes)) + this.position;
        }

        @Override
        public String qualifiedName() {
            StringBuffer sb = new StringBuffer();
            if (!"".equals(this.inPackage)) {
                sb.append(this.inPackage + ".");
            }
            sb.append(this.inClass + "#" + this.methodName + "(");
            int i = 1;
            for (String p : this.paramTypes) {
                if (i++ == this.position) {
                    sb.append(this.position + ":");
                }
                sb.append(p);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
            return sb.toString();
        }
    }

    public static final class Field
    extends SpecificationEntity {
        public final String name;

        Field(String n, String p, String c, Type t) {
            super(p, c, t);
            this.name = n.intern();
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof Field) {
                return this.name.equals(((Field)o).name);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 3977 * (this.inPackage + this.inClass).hashCode() + 13 * this.type.hashCode() + this.name.hashCode();
        }

        @Override
        public String qualifiedName() {
            return (String)(this.inPackage == "" ? "" : this.inPackage + ".") + this.inClass + "#" + this.name;
        }
    }

    static enum Type {
        SOURCE,
        SINK;

    }
}

