/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.rifl;

import de.uka.ilkd.key.util.rifl.SpecificationContainer;
import de.uka.ilkd.key.util.rifl.SpecificationEntity;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import recoder.abstraction.ClassType;
import recoder.java.Comment;
import recoder.java.CompilationUnit;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.JavaProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;

public class SpecificationInjector
extends SourceVisitor {
    private static final String LINE_BREAK = "\n";
    private static final String DEFAULT_SPEC_COMMENT = "\n// JML* comment created by KeY RIFL Transformer.\n";
    private final SpecificationContainer sc;
    private final SourceInfo si;
    private List<MethodDeclaration> specifiedMethodDeclarations;

    public SpecificationInjector(SpecificationContainer sc, SourceInfo sourceInfo) {
        this.sc = sc;
        this.si = sourceInfo;
        this.specifiedMethodDeclarations = new LinkedList<MethodDeclaration>();
    }

    public List<MethodDeclaration> getSpecifiedMethodDeclarations() {
        return this.specifiedMethodDeclarations;
    }

    private void accessChildren(JavaNonTerminalProgramElement pe) {
        for (int i = 0; i < pe.getChildCount(); ++i) {
            pe.getChildAt(i).accept((SourceVisitor)this);
        }
    }

    private void addComment(JavaProgramElement se, String comment) {
        if (se instanceof MethodDeclaration) {
            this.specifiedMethodDeclarations.add((MethodDeclaration)se);
        }
        NonTerminalProgramElement parent = se.getASTParent();
        assert (parent != null) : "Program element " + se + " with null parent";
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (i <= 0 || parent.getChildAt(i) != se) continue;
            se = (JavaProgramElement)parent.getChildAt(i - 1);
        }
        ASTArrayList commentList = new ASTArrayList();
        ASTList oldComments = se.getComments();
        if (oldComments != null) {
            commentList.addAll((Collection)oldComments);
        }
        if (comment != null && !comment.isEmpty()) {
            commentList.add((Object)new Comment(comment));
        }
        se.setComments((ASTList)commentList);
    }

    public void visitClassDeclaration(ClassDeclaration cd) {
        cd.setProgramModelInfo((ProgramModelInfo)this.si);
        this.accessChildren((JavaNonTerminalProgramElement)cd);
        this.addComment((JavaProgramElement)cd, DEFAULT_SPEC_COMMENT);
    }

    public void visitCompilationUnit(CompilationUnit cu) {
        this.accessChildren((JavaNonTerminalProgramElement)cu);
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration id) {
        id.setProgramModelInfo((ProgramModelInfo)this.si);
        this.accessChildren((JavaNonTerminalProgramElement)id);
        this.addComment((JavaProgramElement)id, DEFAULT_SPEC_COMMENT);
    }

    public void visitMethodDeclaration(MethodDeclaration md) {
        md.setProgramModelInfo((ProgramModelInfo)this.si);
        JMLFactory factory = new JMLFactory(this.sc);
        String returnDomainSrc = this.sc.returnValue(md, SpecificationEntity.Type.SOURCE);
        factory.addResultToDetermines(returnDomainSrc, SpecificationEntity.Type.SOURCE);
        String returnDomainSnk = this.sc.returnValue(md, SpecificationEntity.Type.SINK);
        factory.addResultToDetermines(returnDomainSnk, SpecificationEntity.Type.SINK);
        for (int i = 0; i < md.getParameterDeclarationCount(); ++i) {
            ParameterDeclaration pd = md.getParameterDeclarationAt(i);
            String paraName = pd.getVariableSpecification().getName();
            String paramSrc = this.sc.parameter(md, i + 1, SpecificationEntity.Type.SOURCE);
            String paramSnk = this.sc.parameter(md, i + 1, SpecificationEntity.Type.SINK);
            factory.addToDetermines(paraName, SpecificationEntity.Type.SOURCE, paramSrc);
            factory.addToDetermines(paraName, SpecificationEntity.Type.SINK, paramSnk);
        }
        ClassType ct = md.getContainingClassType();
        String pkg = ct.getPackage().getFullName();
        String cls = ct.getName();
        for (int i = 0; i < md.getASTParent().getChildCount(); ++i) {
            JavaProgramElement fd = (JavaProgramElement)md.getASTParent().getChildAt(i);
            if (!(fd instanceof FieldDeclaration)) continue;
            String field = ((FieldSpecification)((FieldDeclaration)fd).getVariables().get(0)).getName();
            String fName = cls + "." + field;
            String fieldSrc = this.sc.field(pkg, cls, field, SpecificationEntity.Type.SOURCE);
            String fieldSnk = this.sc.field(pkg, cls, field, SpecificationEntity.Type.SINK);
            factory.addToDetermines(fName, SpecificationEntity.Type.SOURCE, fieldSrc);
            factory.addToDetermines(fName, SpecificationEntity.Type.SINK, fieldSnk);
        }
        String comment = factory.getSpecification();
        if (comment != null) {
            this.addComment((JavaProgramElement)md, factory.getSpecification());
        }
    }

    private static class JMLFactory {
        private static final String DEFAULT_INDENTATION = "  ";
        private static final String DEFAULT_KEY = "low";
        private static final String RESULT = "\\result";
        private static final String DETERMINES = "determines";
        private static final String BY = " \\by";
        private static final String JML_LINE_START = "@ ";
        private static final String JML_END = "@*/\n";
        private static final String JML_CLAUSE_END = ";";
        private static final String JML_START = "\n  /*@ ";
        private final String indentation;
        private final Map<String, Set<Map.Entry<String, SpecificationEntity.Type>>> respects = new HashMap<String, Set<Map.Entry<String, SpecificationEntity.Type>>>();
        private SpecificationContainer sc;

        JMLFactory(SpecificationContainer sc) {
            this.indentation = DEFAULT_INDENTATION;
            this.sc = sc;
        }

        JMLFactory(int indent) {
            this.indentation = " ".repeat(indent);
        }

        void addResultToDetermines(SpecificationEntity.Type t) {
            this.put(DEFAULT_KEY, t, RESULT);
        }

        void addResultToDetermines(String key, SpecificationEntity.Type t) {
            this.put(key, t, RESULT);
        }

        void addToDetermines(String name, SpecificationEntity.Type t) {
            this.put(DEFAULT_KEY, t, name);
        }

        void addToDetermines(String name, SpecificationEntity.Type t, String key) {
            this.put(key, t, name);
        }

        String getRespects(String domain, SpecificationEntity.Type t) {
            return this.getRespects(this.respects.get(domain), t);
        }

        String getRespects(Set<String> oneRespect) {
            if (oneRespect != null && !oneRespect.isEmpty()) {
                return String.join((CharSequence)", ", oneRespect);
            }
            return " \\nothing";
        }

        String getRespects(Set<Map.Entry<String, SpecificationEntity.Type>> oneRespect, SpecificationEntity.Type t) {
            String r = oneRespect.stream().filter(p -> p.getValue() == t).map(Map.Entry::getKey).collect(Collectors.joining(", "));
            if (r.isEmpty()) {
                return " \\nothing";
            }
            return r;
        }

        String getSpecification() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Set<Map.Entry<String, SpecificationEntity.Type>>> oneRespect : this.respects.entrySet()) {
                String domain = oneRespect.getKey();
                Set<String> flowsFromDomain = this.sc.flows(domain);
                LinkedHashSet<String> oneRespects = new LinkedHashSet<String>();
                for (String flowsFrom : flowsFromDomain) {
                    Set<Map.Entry<String, SpecificationEntity.Type>> es = this.respects.get(flowsFrom);
                    if (es == null) continue;
                    for (Map.Entry<String, SpecificationEntity.Type> e : es) {
                        if (e.getValue() != SpecificationEntity.Type.SOURCE) continue;
                        oneRespects.add(e.getKey());
                    }
                }
                Set<Map.Entry<String, SpecificationEntity.Type>> es = this.respects.get(domain);
                if (es != null) {
                    for (Map.Entry<String, SpecificationEntity.Type> reflFlow : es) {
                        if (reflFlow.getValue() != SpecificationEntity.Type.SOURCE) continue;
                        oneRespects.add(reflFlow.getKey());
                    }
                }
                sb.append(this.indentation);
                sb.append(DEFAULT_INDENTATION);
                sb.append(JML_LINE_START);
                sb.append(DETERMINES);
                sb.append(this.getRespects(domain, SpecificationEntity.Type.SINK));
                sb.append(BY);
                sb.append(this.getRespects(oneRespects));
                sb.append(JML_CLAUSE_END);
                sb.append(SpecificationInjector.LINE_BREAK);
            }
            if (!sb.toString().trim().isEmpty()) {
                sb.insert(0, this.indentation + "\n  /*@ \n");
                sb.append(this.indentation);
                sb.append(DEFAULT_INDENTATION);
                sb.append(JML_END);
                return sb.toString();
            }
            return null;
        }

        private void put(String key, Map.Entry<String, SpecificationEntity.Type> value) {
            if (key == null) {
                return;
            }
            Set<Map.Entry<String, SpecificationEntity.Type>> target = this.respects.get(key);
            if (target == null) {
                target = new LinkedHashSet<Map.Entry<String, SpecificationEntity.Type>>();
            }
            target.add(value);
            this.respects.put(key, target);
        }

        private void put(String key, SpecificationEntity.Type t, String value) {
            this.put(key, new AbstractMap.SimpleEntry<String, SpecificationEntity.Type>(value, t));
        }
    }
}

