/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.Preference;
import bibliothek.extension.gui.dock.preference.PreferenceListener;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.gui.DockController;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.List;

public class DefaultPreferenceModel
extends AbstractPreferenceModel {
    private List<Entry<?>> entries = new ArrayList();

    public DefaultPreferenceModel(DockController controller) {
        super(controller);
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public String getLabel(int index) {
        return this.getPreference(index).getLabel();
    }

    @Override
    public String getDescription(int index) {
        return this.getPreference(index).getDescription();
    }

    @Override
    public Object getValueInfo(int index) {
        return this.getPreference(index).getValueInfo();
    }

    @Override
    public Object getValue(int index) {
        return this.getPreference(index).getValue();
    }

    @Override
    public void setValue(int index, Object value) {
        this.getPreference(index).setValue(value);
    }

    @Override
    public Path getTypePath(int index) {
        return this.getPreference(index).getTypePath();
    }

    @Override
    public Path getPath(int index) {
        return this.getPreference(index).getPath();
    }

    @Override
    public boolean isNatural(int index) {
        return this.getPreference(index).isNatural();
    }

    @Override
    public void setValueNatural(int index) {
        this.getPreference(index).read();
    }

    @Override
    public void addPreferenceModelListener(PreferenceModelListener listener) {
        if (!this.hasListeners()) {
            for (Entry<?> entry : this.entries) {
                entry.setListener(true);
            }
        }
        super.addPreferenceModelListener(listener);
    }

    @Override
    public void removePreferenceModelListener(PreferenceModelListener listener) {
        super.removePreferenceModelListener(listener);
        if (!this.hasListeners()) {
            for (Entry<?> entry : this.entries) {
                entry.setListener(false);
            }
        }
    }

    public Preference<?> getPreference(int index) {
        return this.entries.get(index).getPreference();
    }

    public void add(Preference<?> preference) {
        this.insert(this.entries.size(), preference);
    }

    public void insert(int index, Preference<?> preference) {
        if (preference == null) {
            throw new IllegalArgumentException("preference must not be null");
        }
        if (index < 0 || index > this.entries.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Path path = preference.getPath();
        for (Entry<?> entry : this.entries) {
            if (!entry.getPreference().getPath().equals(path)) continue;
            throw new IllegalArgumentException("there is already a preference with path " + path);
        }
        Entry entry = new Entry(preference, index);
        this.entries.add(index, entry);
        int n = this.entries.size();
        for (int i = index + 1; i < n; ++i) {
            this.entries.get(i).setIndex(i);
        }
        this.firePreferenceAdded(index, index);
    }

    public void remove(int index) {
        Entry<?> entry = this.entries.remove(index);
        entry.kill();
        int n = this.entries.size();
        for (int i = index; i < n; ++i) {
            this.entries.get(i).setIndex(i);
        }
        this.firePreferenceRemoved(index, index);
    }

    public void remove(Preference<?> preference) {
        int index = this.indexOf(preference);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void removeAll() {
        int size = this.entries.size();
        if (size > 0) {
            for (Entry<?> entry : this.entries) {
                entry.kill();
            }
            this.entries.clear();
            this.firePreferenceRemoved(0, size - 1);
        }
    }

    public int indexOf(Preference<?> preference) {
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            if (this.entries.get(i).getPreference() != preference) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void read() {
        for (Entry<?> entry : this.entries) {
            entry.getPreference().read();
        }
    }

    @Override
    public void write() {
        for (Entry<?> entry : this.entries) {
            entry.getPreference().write();
        }
    }

    @Override
    public PreferenceOperation[] getOperations(int index) {
        return this.entries.get(index).getPreference().getOperations();
    }

    @Override
    public boolean isEnabled(int index, PreferenceOperation operation) {
        return this.entries.get(index).getPreference().isEnabled(operation);
    }

    @Override
    public void doOperation(int index, PreferenceOperation operation) {
        this.entries.get(index).getPreference().doOperation(operation);
    }

    private class Entry<V>
    implements PreferenceListener<V> {
        private Preference<V> preference;
        private int index;

        public Entry(Preference<V> preference, int index) {
            this.preference = preference;
            this.index = index;
            preference.setModel(DefaultPreferenceModel.this);
            if (DefaultPreferenceModel.this.hasListeners()) {
                preference.addPreferenceListener(this);
            }
        }

        @Override
        public void changed(Preference<V> preference) {
            DefaultPreferenceModel.this.firePreferenceChanged(this.index, this.index);
        }

        public void setListener(boolean listening) {
            if (listening) {
                this.preference.addPreferenceListener(this);
            } else {
                this.preference.removePreferenceListener(this);
            }
        }

        public void kill() {
            this.preference.setModel(null);
            if (DefaultPreferenceModel.this.hasListeners()) {
                this.preference.removePreferenceListener(this);
            }
        }

        public Preference<V> getPreference() {
            return this.preference;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

