/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.editor;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.preferences.choice.Choice;
import bibliothek.extension.gui.dock.preference.preferences.choice.ChoiceListener;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ChoiceEditor
extends JComboBox
implements PreferenceEditor<String> {
    public static final PreferenceEditorFactory<String> FACTORY = new PreferenceEditorFactory<String>(){

        @Override
        public PreferenceEditor<String> create() {
            return new ChoiceEditor();
        }
    };
    private Model model;
    private Choice choice;
    private boolean onChange = false;
    private PreferenceEditorCallback<String> callback;
    private ChoiceListener listener = new ChoiceListener(){

        @Override
        public void updated(Choice choice, int indexStart, int indexEnd) {
            int delta = 0;
            if (choice.isNullEntryAllowed()) {
                delta = 1;
            }
            for (int i = indexStart; i <= indexEnd; ++i) {
                Entry entry = (Entry)ChoiceEditor.this.model.getElementAt(i + delta);
                entry.text = choice.getText(i);
            }
            ChoiceEditor.this.model.fireContentsChanged(indexStart + delta, indexEnd + delta);
        }

        @Override
        public void removed(Choice choice, int indexStart, int indexEnd) {
            if (choice.isNullEntryAllowed()) {
                ++indexStart;
                ++indexEnd;
            }
            for (int i = indexEnd; i >= indexStart; --i) {
                ChoiceEditor.this.model.removeElementAt(i);
            }
        }

        @Override
        public void inserted(Choice choice, int indexStart, int indexEnd) {
            int delta = 0;
            if (choice.isNullEntryAllowed()) {
                delta = 1;
            }
            for (int i = indexStart; i <= indexEnd; ++i) {
                ChoiceEditor.this.model.insertElementAt(new Entry(choice.getId(i), choice.getText(i)), i + delta);
            }
        }
    };

    public ChoiceEditor() {
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ChoiceEditor.this.onChange && e.getStateChange() == 1) {
                    if (ChoiceEditor.this.callback != null) {
                        ChoiceEditor.this.callback.set(ChoiceEditor.this.getValue());
                    }
                    ChoiceEditor.this.checkOperations();
                }
            }
        });
    }

    @Override
    public void setValueInfo(Object information) {
        if (this.choice != null) {
            this.choice.removeChoiceListener(this.listener);
            this.choice.setController(null);
        }
        this.choice = information instanceof Choice ? (Choice)information : null;
        this.model = new Model();
        if (this.choice != null) {
            if (this.choice.isNullEntryAllowed()) {
                this.model.addElement(new Entry(null, ""));
            }
            int n = this.choice.size();
            for (int i = 0; i < n; ++i) {
                this.model.addElement(new Entry(this.choice.getId(i), this.choice.getText(i)));
            }
        }
        if (this.choice != null) {
            this.choice.addChoiceListener(this.listener);
            if (this.callback != null) {
                this.choice.setController(this.callback.getModel().getController());
            }
        }
        this.setModel(this.model);
        this.checkOperations();
    }

    @Override
    public void doOperation(PreferenceOperation operation) {
        if (operation == PreferenceOperation.DEFAULT) {
            this.setValue(this.choice.getDefaultChoice());
            if (this.callback != null) {
                this.callback.set(this.getValue());
            }
        }
        if (operation == PreferenceOperation.DELETE) {
            this.setValue(null);
            if (this.callback != null) {
                this.callback.set(null);
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getValue() {
        return ((Entry)this.model.getSelectedItem()).id;
    }

    @Override
    public void setCallback(PreferenceEditorCallback<String> callback) {
        if (this.choice != null) {
            if (callback == null) {
                this.choice.setController(null);
            } else {
                this.choice.setController(callback.getModel().getController());
            }
        }
        this.callback = callback;
        this.checkOperations();
    }

    private void checkOperations() {
        if (this.callback != null && this.choice != null) {
            String value;
            if (this.choice.isNullEntryAllowed()) {
                this.callback.setOperation(PreferenceOperation.DELETE, this.getValue() != null);
            }
            boolean enabled = (value = this.getValue()) == null && this.choice.getDefaultChoice() != null || value != null && !value.equals(this.choice.getDefaultChoice());
            this.callback.setOperation(PreferenceOperation.DEFAULT, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String value) {
        try {
            this.onChange = true;
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Entry entry = (Entry)this.model.getElementAt(i);
                if (entry.id != value && (value == null || !value.equals(entry.id))) continue;
                this.model.setSelectedItem(entry);
                break;
            }
        }
        finally {
            this.onChange = false;
            this.checkOperations();
        }
    }

    private static class Model
    extends DefaultComboBoxModel {
        private Model() {
        }

        public void fireContentsChanged(int start, int end) {
            this.fireContentsChanged(this, start, end);
        }
    }

    private static class Entry {
        public String id;
        public String text;

        public Entry(String id, String text) {
            this.id = id;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

