/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.editor;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.editor.EditorText;
import bibliothek.extension.gui.dock.preference.preferences.KeyStrokeValidator;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class KeyStrokeEditor
extends JTextField
implements PreferenceEditor<KeyStroke> {
    public static final PreferenceEditorFactory<KeyStroke> FACTORY = new PreferenceEditorFactory<KeyStroke>(){

        @Override
        public PreferenceEditor<KeyStroke> create() {
            return new KeyStrokeEditor();
        }
    };
    private KeyStroke stroke;
    private KeyStrokeValidator validator = KeyStrokeValidator.EVERYTHING;
    private PreferenceEditorCallback<KeyStroke> callback;
    private boolean focused = false;
    private EditorText text;

    public static final String toString(KeyStroke stroke, boolean complete) {
        int keyCode;
        Object result = "";
        int modifiers = stroke.getModifiers();
        if (modifiers != 0) {
            result = KeyEvent.getKeyModifiersText(modifiers);
            if (!complete) {
                result = (String)result + "+";
            }
        }
        if (!KeyStrokeEditor.isModifierKey(keyCode = stroke.getKeyCode())) {
            if (complete && modifiers != 0) {
                result = (String)result + "+";
            }
            result = keyCode != 0 ? (String)result + KeyEvent.getKeyText(keyCode) : (String)result + stroke.getKeyChar();
            if (!complete) {
                result = (String)result + "+";
            }
        }
        return result;
    }

    public static boolean isModifierKey(int keyCode) {
        switch (keyCode) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    public KeyStrokeEditor() {
        this.setEditable(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeyStrokeEditor.this.focused = true;
                KeyStrokeEditor.this.setValue(KeyStrokeEditor.this.stroke);
            }

            @Override
            public void focusLost(FocusEvent e) {
                KeyStrokeEditor.this.focused = false;
                if (KeyStrokeEditor.this.callback != null) {
                    if (KeyStrokeEditor.this.stroke == null) {
                        KeyStrokeEditor.this.setValue(KeyStrokeEditor.this.callback.get());
                    } else {
                        KeyStrokeEditor.this.callback.set(KeyStrokeEditor.this.stroke);
                    }
                } else {
                    KeyStrokeEditor.this.setValue(KeyStrokeEditor.this.stroke);
                }
            }
        });
        this.text = new EditorText("preference.keystroke.click", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                if (!KeyStrokeEditor.this.focused) {
                    KeyStrokeEditor.this.setText(newValue);
                }
            }
        };
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStrokeEditor.this.setValue(KeyStroke.getKeyStrokeForEvent(e));
                KeyStroke value = KeyStrokeEditor.this.stroke;
                KeyStrokeEditor.this.stroke = null;
                KeyStrokeEditor.this.maybeStore(value);
            }
        });
    }

    private void maybeStore(KeyStroke stroke) {
        if (stroke != null && this.callback != null && this.validator.isValid(stroke)) {
            this.callback.set(stroke);
        }
    }

    @Override
    public void setValueInfo(Object information) {
        this.validator = information instanceof KeyStrokeValidator ? (KeyStrokeValidator)information : KeyStrokeValidator.EVERYTHING;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public KeyStroke getValue() {
        return this.stroke;
    }

    @Override
    public void setCallback(PreferenceEditorCallback<KeyStroke> callback) {
        this.callback = callback;
        if (callback != null) {
            callback.setOperation(PreferenceOperation.DELETE, this.stroke != null);
            this.text.setController(callback.getModel().getController());
        } else {
            this.text.setController(null);
        }
    }

    @Override
    public void setValue(KeyStroke value) {
        this.stroke = value;
        if (value == null) {
            if (this.focused) {
                this.setText("");
            } else {
                this.setText((String)this.text.value());
            }
        } else if (this.validator.isValid(value)) {
            this.setText(KeyStrokeEditor.toString(value, true));
        } else {
            this.setText(KeyStrokeEditor.toString(value, !this.validator.isCompleteable(value)));
        }
        if (this.callback != null) {
            this.callback.setOperation(PreferenceOperation.DELETE, this.stroke != null);
        }
    }

    @Override
    public void doOperation(PreferenceOperation operation) {
        if (operation == PreferenceOperation.DELETE) {
            this.setValue(null);
            if (this.callback != null) {
                this.callback.set(null);
            }
        }
    }
}

