/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.extension.gui.dock.theme.bubble.BubbleButtonDockTitle;
import bibliothek.extension.gui.dock.theme.bubble.BubbleColorScheme;
import bibliothek.extension.gui.dock.theme.bubble.BubbleDisplayerFactory;
import bibliothek.extension.gui.dock.theme.bubble.BubbleDockTitleFactory;
import bibliothek.extension.gui.dock.theme.bubble.BubbleMovingImageFactory;
import bibliothek.extension.gui.dock.theme.bubble.BubbleSeparator;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStackDockComponent;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStationPaint;
import bibliothek.extension.gui.dock.theme.bubble.RoundButton;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonViewItem;
import bibliothek.extension.gui.dock.theme.bubble.RoundDropDownButton;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.action.DefaultDockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayout;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.NoSpanFactory;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.icon.DefaultIconScheme;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

@ThemeProperties(authors={"Ivan Seidl", "Benjamin Sigg"}, descriptionBundle="theme.bubble.description", nameBundle="theme.bubble", webpages={""})
public class BubbleTheme
extends BasicTheme {
    public static final PropertyKey<ColorScheme> BUBBLE_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.BubbleTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> key, DockProperties properties) {
            return new BubbleColorScheme();
        }
    }, true);
    public static final PropertyKey<DockActionDistributor> ACTION_DISTRIBUTOR = new PropertyKey<DefaultDockActionDistributor>("dock.bubble.DockActionDistributor", new ConstantPropertyFactory<DefaultDockActionDistributor>(new DefaultDockActionDistributor()), true);
    private List<DockController> controllers = new ArrayList<DockController>();

    public BubbleTheme() {
        this.setColorSchemeKey(BUBBLE_COLOR_SCHEME);
        this.setDisplayerFactory(new BubbleDisplayerFactory(), Priority.DEFAULT);
        this.setTitleFactory(new BubbleDockTitleFactory(), Priority.DEFAULT);
        this.setPaint(new BubbleStationPaint(), Priority.DEFAULT);
        this.setMovingImageFactory(new BubbleMovingImageFactory(), Priority.DEFAULT);
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            @Override
            public StackDockComponent create(StackDockComponentParent station) {
                return new BubbleStackDockComponent(station);
            }
        }, Priority.DEFAULT);
        this.setTabPlacement(TabPlacement.BOTTOM_OF_DOCKABLE, Priority.DEFAULT);
        this.setSpanFactory(new NoSpanFactory());
    }

    @Override
    public void install(DockController controller) {
        super.install(controller);
        this.controllers.add(controller);
        controller.getDockTitleManager().registerTheme("flap button", BubbleButtonDockTitle.FACTORY);
        controller.getProperties().set(TabPane.LAYOUT_MANAGER, new MenuLineLayout(), Priority.THEME);
        controller.getIcons().setScheme(Priority.THEME, new DefaultIconScheme("data/bibliothek/gui/dock/core/bubble/icons.ini", BubbleTheme.class.getClassLoader(), controller));
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(ActionType.BUTTON, ViewTarget.TITLE, new ButtonGenerator());
        converter.putTheme(ActionType.CHECK, ViewTarget.TITLE, new CheckGenerator());
        converter.putTheme(ActionType.RADIO, ViewTarget.TITLE, new RadioGenerator());
        converter.putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, new DropDownGenerator());
        converter.putTheme(ActionType.MENU, ViewTarget.TITLE, new MenuGenerator());
        converter.putTheme(ActionType.SEPARATOR, ViewTarget.TITLE, new SeparatorGenerator());
    }

    @Override
    public void uninstall(DockController controller) {
        super.uninstall(controller);
        this.controllers.remove(controller);
        controller.getProperties().unset(TabPane.LAYOUT_MANAGER, Priority.THEME);
        controller.getDockTitleManager().clearThemeFactories();
        controller.getIcons().setScheme(Priority.THEME, null);
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(ActionType.BUTTON, ViewTarget.TITLE, null);
        converter.putTheme(ActionType.CHECK, ViewTarget.TITLE, null);
        converter.putTheme(ActionType.RADIO, ViewTarget.TITLE, null);
        converter.putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, null);
        converter.putTheme(ActionType.MENU, ViewTarget.TITLE, null);
        converter.putTheme(ActionType.SEPARATOR, ViewTarget.TITLE, null);
    }

    private static class ButtonGenerator
    implements ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>> {
        private ButtonGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
            BasicButtonHandler handler = new BasicButtonHandler(action, dockable);
            RoundButton button = new RoundButton(handler, handler, dockable, action);
            handler.setModel(button.getModel());
            return new RoundButtonViewItem(dockable, handler, button);
        }
    }

    private static class CheckGenerator
    implements ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>> {
        private CheckGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
            BasicSelectableHandler.Check handler = new BasicSelectableHandler.Check(action, dockable);
            RoundButton button = new RoundButton(handler, handler, dockable, action);
            handler.setModel(button.getModel());
            return new RoundButtonViewItem(dockable, handler, button);
        }
    }

    private static class RadioGenerator
    implements ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>> {
        private RadioGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
            BasicSelectableHandler.Radio handler = new BasicSelectableHandler.Radio(action, dockable);
            RoundButton button = new RoundButton(handler, handler, dockable, action);
            handler.setModel(button.getModel());
            return new RoundButtonViewItem(dockable, handler, button);
        }
    }

    private static class DropDownGenerator
    implements ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>> {
        private DropDownGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
            BasicDropDownButtonHandler handler = new BasicDropDownButtonHandler(action, dockable);
            RoundDropDownButton button = new RoundDropDownButton(handler, dockable, action);
            handler.setModel(button.getModel());
            return new RoundButtonViewItem(dockable, handler, button);
        }
    }

    private static class MenuGenerator
    implements ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>> {
        private MenuGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
            BasicMenuHandler handler = new BasicMenuHandler(action, dockable);
            RoundButton button = new RoundButton(handler, handler, dockable, action);
            handler.setModel(button.getModel());
            return new RoundButtonViewItem(dockable, handler, button);
        }
    }

    private static class SeparatorGenerator
    implements ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>> {
        private SeparatorGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SeparatorAction action, Dockable dockable) {
            if (action.shouldDisplay(ViewTarget.TITLE)) {
                return new BubbleSeparator(action);
            }
            return null;
        }
    }
}

