/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.TabDecorator;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class BubbleDisplayer
extends BasicDockableDisplayer {
    private int borderSize = 2;
    private JPanel dockable;
    private BubbleColorAnimation animation;
    private DisplayerColor borderHighActive = new BubbleDisplayerColor("displayer.border.high.active", Color.WHITE);
    private DisplayerColor borderHighActiveMouse = new BubbleDisplayerColor("displayer.border.high.active.mouse", Color.WHITE);
    private DisplayerColor borderHighInactive = new BubbleDisplayerColor("displayer.border.high.inactive", Color.DARK_GRAY);
    private DisplayerColor borderHighInactiveMouse = new BubbleDisplayerColor("displayer.border.high.inactive.mouse", Color.DARK_GRAY);
    private DisplayerColor borderHighDisabled = new BubbleDisplayerColor("displayer.border.high.disabled", Color.WHITE);
    private DisplayerColor borderLowActive = new BubbleDisplayerColor("displayer.border.low.active", Color.LIGHT_GRAY);
    private DisplayerColor borderLowActiveMouse = new BubbleDisplayerColor("displayer.border.low.active.mouse", Color.LIGHT_GRAY);
    private DisplayerColor borderLowInactive = new BubbleDisplayerColor("displayer.border.low.inactive", Color.BLACK);
    private DisplayerColor borderLowInactiveMouse = new BubbleDisplayerColor("displayer.border.low.inactive.mouse", Color.BLACK);
    private DisplayerColor borderLowDisabled = new BubbleDisplayerColor("displayer.border.low.disabled", Color.LIGHT_GRAY);
    private boolean mouse = false;
    private boolean disabled = false;
    private Listener listener = new Listener();
    private BasicDockableDisplayer.DisplayerBorder openBorder;
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy oldValue, DisablingStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeDisablingStrategyListener(BubbleDisplayer.this.disablingStrategyListener);
            }
            if (newValue != null) {
                newValue.addDisablingStrategyListener(BubbleDisplayer.this.disablingStrategyListener);
                BubbleDisplayer.this.setDisabled(newValue.isDisabled(BubbleDisplayer.this.getDockable()));
            } else {
                BubbleDisplayer.this.setDisabled(false);
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        @Override
        public void changed(DockElement item) {
            if (BubbleDisplayer.this.getDockable() == item) {
                BubbleDisplayer.this.setDisabled(BubbleDisplayer.this.disablingStrategy.getValue().isDisabled(item));
            }
        }
    };

    public BubbleDisplayer(DockStation station, Dockable dockable, DockTitle title) {
        super(station, dockable, title);
        this.dockable.setOpaque(false);
        this.openBorder = new BasicDockableDisplayer.DisplayerBorder(this.dockable, "bubble");
        this.animation = new BubbleColorAnimation();
        this.animation.addTask(new Runnable(){

            @Override
            public void run() {
                BubbleDisplayer.this.pulse();
            }
        });
        this.updateAnimation();
        this.setRespectBorderHint(true);
        this.setDefaultBorderHint(true);
        this.setSingleTabShowInnerBorder(true);
        this.setSingleTabShowOuterBorder(false);
    }

    protected void setDisabled(boolean disabled) {
        if (this.disabled != disabled) {
            this.disabled = disabled;
            this.updateAnimation();
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    protected void updateAnimation() {
        if (this.animation != null) {
            DockController controller = this.getController();
            if (this.isDisabled()) {
                this.animation.putColor("high", (Color)this.borderHighDisabled.value());
                this.animation.putColor("low", (Color)this.borderLowDisabled.value());
            } else if (controller != null && controller.getFocusedDockable() == this.getDockable()) {
                if (this.mouse) {
                    this.animation.putColor("high", (Color)this.borderHighActiveMouse.value());
                    this.animation.putColor("low", (Color)this.borderLowActiveMouse.value());
                } else {
                    this.animation.putColor("high", (Color)this.borderHighActive.value());
                    this.animation.putColor("low", (Color)this.borderLowActive.value());
                }
            } else if (this.mouse) {
                this.animation.putColor("high", (Color)this.borderHighInactiveMouse.value());
                this.animation.putColor("low", (Color)this.borderLowInactiveMouse.value());
            } else {
                this.animation.putColor("high", (Color)this.borderHighInactive.value());
                this.animation.putColor("low", (Color)this.borderLowInactive.value());
            }
        }
    }

    protected void pulse() {
        this.dockable.repaint();
    }

    @Override
    public void setController(DockController controller) {
        DockController old = this.getController();
        if (old != controller) {
            if (old != null) {
                old.removeDockableFocusListener(this.listener);
            }
            if (controller != null) {
                controller.addDockableFocusListener(this.listener);
            }
            super.setController(controller);
        }
        this.disablingStrategy.setProperties(controller);
        this.openBorder.setController(controller);
        this.borderHighActive.connect(controller);
        this.borderHighActiveMouse.connect(controller);
        this.borderHighInactive.connect(controller);
        this.borderHighInactiveMouse.connect(controller);
        this.borderHighDisabled.connect(controller);
        this.borderLowActive.connect(controller);
        this.borderLowActiveMouse.connect(controller);
        this.borderLowInactive.connect(controller);
        this.borderLowInactiveMouse.connect(controller);
        this.borderLowDisabled.connect(controller);
        this.animation.kick();
    }

    @Override
    protected Component getComponent(Dockable dockable) {
        this.ensureDockable();
        return this.dockable;
    }

    @Override
    public void setTitle(DockTitle title) {
        DockTitle old = this.getTitle();
        if (old != null) {
            old.removeMouseInputListener(this.listener);
        }
        super.setTitle(title);
        if (title != null) {
            title.addMouseInputListener(this.listener);
        }
        this.mouse = false;
        this.updateAnimation();
        this.ensureDockable();
    }

    @Override
    public void setDockable(Dockable dockable) {
        super.setDockable(dockable);
        this.ensureDockable();
        this.dockable.removeAll();
        if (dockable != null) {
            this.dockable.add(dockable.getComponent());
        }
        this.ensureBorder();
    }

    private void ensureDockable() {
        if (this.dockable == null) {
            this.dockable = new JPanel(new GridLayout(1, 1));
        }
        this.ensureBorder();
    }

    private void ensureBorder() {
        if (this.dockable != null) {
            boolean station;
            Dockable dock = this.getDockable();
            boolean bl = station = dock != null && dock.asDockStation() != null;
            if (this.getTitle() == null && station) {
                this.setDefaultBorderHint(false);
            } else {
                this.setDefaultBorderHint(true);
            }
        }
    }

    @Override
    protected void updateBorder() {
        if (this.isRespectBorderHint()) {
            if (this.getHints().getShowBorderHint() || this.getTitle() != null) {
                this.openBorder.setBorder(this.getDefaultBorder());
            } else {
                this.openBorder.setBorder(null);
            }
        }
    }

    @Override
    protected Border getDefaultBorder() {
        return new OpenBorder();
    }

    @Override
    public Insets getDockableInsets() {
        Insets insets = super.getDockableInsets();
        Border border = this.dockable.getBorder();
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(this.dockable);
            insets.left += borderInsets.left;
            insets.right += borderInsets.right;
            insets.top += borderInsets.top;
            insets.bottom += borderInsets.bottom;
        }
        return insets;
    }

    @Override
    protected BasicDockableDisplayerDecorator createStackedDecorator() {
        return this.createStackedDecorator(BubbleTheme.ACTION_DISTRIBUTOR);
    }

    @Override
    protected TabDecorator createTabDecorator() {
        return new TabDecorator(this.getStation(), BubbleTheme.ACTION_DISTRIBUTOR);
    }

    private class BubbleDisplayerColor
    extends DisplayerColor {
        public BubbleDisplayerColor(String id, Color backup) {
            super(id, BubbleDisplayer.this, backup);
        }

        @Override
        protected void changed(Color oldColor, Color newColor) {
            BubbleDisplayer.this.updateAnimation();
        }
    }

    private class Listener
    extends MouseInputAdapter
    implements DockableFocusListener {
        private Listener() {
        }

        @Override
        public void dockableFocused(DockableFocusEvent event) {
            BubbleDisplayer.this.updateAnimation();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BubbleDisplayer.this.mouse = true;
            BubbleDisplayer.this.updateAnimation();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BubbleDisplayer.this.mouse = false;
            BubbleDisplayer.this.updateAnimation();
        }
    }

    public class OpenBorder
    implements Border {
        @Override
        public Insets getBorderInsets(Component c) {
            if (BubbleDisplayer.this.getTitle() == null) {
                return new Insets(BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize);
            }
            switch (BubbleDisplayer.this.getTitleLocation()) {
                case BOTTOM: {
                    return new Insets(BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, 0, BubbleDisplayer.this.borderSize);
                }
                case LEFT: {
                    return new Insets(BubbleDisplayer.this.borderSize, 0, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize);
                }
                case RIGHT: {
                    return new Insets(BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, 0);
                }
                case TOP: {
                    return new Insets(0, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize);
                }
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color high = BubbleDisplayer.this.animation.getColor("high");
            Color low = BubbleDisplayer.this.animation.getColor("low");
            boolean noTitle = BubbleDisplayer.this.getTitle() == null;
            boolean top = noTitle || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.TOP;
            boolean left = noTitle || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.LEFT;
            boolean right = noTitle || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.RIGHT;
            boolean bottom = noTitle || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.BOTTOM;
            int highSize = BubbleDisplayer.this.borderSize / 2;
            int lowSize = BubbleDisplayer.this.borderSize - highSize;
            if (top) {
                g.setColor(high);
                g.fillRect(x, y, width, highSize);
                g.setColor(low);
                g.fillRect(x, y + highSize, width, lowSize);
            }
            if (left) {
                g.setColor(high);
                g.fillRect(x, y, highSize, height);
                g.setColor(low);
                if (top) {
                    g.fillRect(x + highSize, y + highSize, lowSize, height - highSize);
                } else {
                    g.fillRect(x + highSize, y, lowSize, height);
                }
            }
            if (right) {
                g.setColor(high);
                g.fillRect(x + width - BubbleDisplayer.this.borderSize, y, highSize, height);
                g.setColor(low);
                if (top) {
                    g.fillRect(x + width - lowSize, y + highSize, lowSize, height - highSize);
                } else {
                    g.fillRect(x + width - lowSize, y, lowSize, height);
                }
            }
            if (bottom) {
                g.setColor(high);
                if (right) {
                    g.fillRect(x, y + height - BubbleDisplayer.this.borderSize, width - BubbleDisplayer.this.borderSize, highSize);
                } else {
                    g.fillRect(x, y + height - BubbleDisplayer.this.borderSize, width, highSize);
                }
                g.setColor(low);
                g.fillRect(x, y + height - lowSize, width, lowSize);
            }
        }
    }
}

