/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabStateInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabFocusTraversalPolicy;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabComponentLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneTabBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.AbstractUIValue;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.render.DockRenderingHints;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public abstract class BaseTabComponent
extends ConfiguredBackgroundPanel
implements TabComponent,
EclipseTabStateInfo {
    protected final TabColor colorStackTabBorder;
    protected final TabColor colorStackTabBorderSelected;
    protected final TabColor colorStackTabBorderSelectedFocused;
    protected final TabColor colorStackTabBorderSelectedFocusLost;
    protected final TabColor colorStackTabBorderDisabled;
    protected final TabColor colorStackTabTop;
    protected final TabColor colorStackTabTopSelected;
    protected final TabColor colorStackTabTopSelectedFocused;
    protected final TabColor colorStackTabTopSelectedFocusLost;
    protected final TabColor colorStackTabTopDisabled;
    protected final TabColor colorStackTabBottom;
    protected final TabColor colorStackTabBottomSelected;
    protected final TabColor colorStackTabBottomSelectedFocused;
    protected final TabColor colorStackTabBottomSelectedFocusLost;
    protected final TabColor colorStackTabBottomDisabled;
    protected final TabColor colorStackTabText;
    protected final TabColor colorStackTabTextSelected;
    protected final TabColor colorStackTabTextSelectedFocused;
    protected final TabColor colorStackTabTextSelectedFocusLost;
    protected final TabColor colorStackTabTextDisabled;
    protected final TabColor colorStackBorder;
    protected final TabFont fontSelected;
    protected final TabFont fontFocused;
    protected final TabFont fontUnselected;
    private TabColor[] colors;
    private TabFont[] fonts;
    private Dockable dockable;
    private boolean paintIconWhenInactive = false;
    private Icon icon;
    private ButtonPanel buttons;
    private EclipseDockActionSource actions;
    private boolean hasFocus;
    private boolean isSelected;
    private EclipseTabPane pane;
    private EclipseTab tab;
    private boolean bound;
    private Background background;
    private OrientedLabel label = new OrientedLabel();
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private boolean previousTabSelectedSet = false;
    private boolean previousTabSelected = false;
    private boolean nextTabSelectedSet = false;
    private boolean nextTabSelected = false;
    private TabComponentLayoutManager layoutManager;

    public BaseTabComponent(EclipseTabPane pane, Dockable dockable) {
        this(pane, dockable, null);
    }

    public BaseTabComponent(EclipseTabPane pane, Dockable dockable, String colorPostfix) {
        super(null, Transparency.DEFAULT);
        if (pane == null) {
            throw new IllegalArgumentException("pane must not be null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.pane = pane;
        this.dockable = dockable;
        this.add(this.label);
        DockStation station = pane.getStation();
        if (colorPostfix == null) {
            colorPostfix = "";
        }
        this.colorStackTabBorder = new BorderTabColor("stack.tab.border" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderSelected = new BorderTabColor("stack.tab.border.selected" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderSelectedFocused = new BorderTabColor("stack.tab.border.selected.focused" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderSelectedFocusLost = new BorderTabColor("stack.tab.border.selected.focuslost" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderDisabled = new BorderTabColor("stack.tab.border.disabled" + colorPostfix, station, Color.WHITE);
        this.colorStackTabTop = new BaseTabColor("stack.tab.top" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopSelected = new BaseTabColor("stack.tab.top.selected" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocused = new BaseTabColor("stack.tab.top.selected.focused" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocusLost = new BaseTabColor("stack.tab.top.selected.focuslost" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopDisabled = new BaseTabColor("stack.tab.top.disabled" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabBottom = new BaseTabColor("stack.tab.bottom" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomSelected = new BaseTabColor("stack.tab.bottom.selected" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomSelectedFocused = new BaseTabColor("stack.tab.bottom.selected.focused" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomSelectedFocusLost = new BaseTabColor("stack.tab.bottom.selected.focuslost" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomDisabled = new BaseTabColor("stack.tab.bottom.disabled" + colorPostfix, station, Color.WHITE);
        this.colorStackTabText = new BaseTabColor("stack.tab.text" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextSelected = new BaseTabColor("stack.tab.text.selected" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextSelectedFocused = new BaseTabColor("stack.tab.text.selected.focused" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextSelectedFocusLost = new BaseTabColor("stack.tab.text.selected.focuslost" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextDisabled = new BaseTabColor("stack.tab.text.disabled" + colorPostfix, station, Color.BLACK);
        this.colorStackBorder = new BaseTabColor("stack.border" + colorPostfix, station, Color.BLACK);
        this.fontFocused = new BaseTabFont("tab.focused", station);
        this.fontSelected = new BaseTabFont("tab.selected", station);
        this.fontUnselected = new BaseTabFont("tab.unselected", station);
        this.colors = new TabColor[]{this.colorStackTabBorder, this.colorStackTabBorderSelected, this.colorStackTabBorderSelectedFocused, this.colorStackTabBorderSelectedFocusLost, this.colorStackTabBorderDisabled, this.colorStackTabTop, this.colorStackTabTopSelected, this.colorStackTabTopSelectedFocused, this.colorStackTabTopSelectedFocusLost, this.colorStackTabTopDisabled, this.colorStackTabBottom, this.colorStackTabBottomSelected, this.colorStackTabBottomSelectedFocused, this.colorStackTabBottomSelectedFocusLost, this.colorStackTabBottomDisabled, this.colorStackTabText, this.colorStackTabTextSelected, this.colorStackTabTextSelectedFocused, this.colorStackTabTextSelectedFocusLost, this.colorStackTabTextDisabled, this.colorStackBorder};
        this.fonts = new TabFont[]{this.fontFocused, this.fontSelected, this.fontUnselected};
        this.buttons = new ButtonPanel(false);
        this.add(this.buttons);
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new BaseTabFocusTraversalPolicy(this.buttons), true));
        this.layoutManager = new TabComponentLayoutManager(this.label, this.buttons, pane.getConfiguration(dockable));
        this.setLayout(this.layoutManager);
    }

    @Override
    public EclipseTabStateInfo getEclipseTabStateInfo() {
        return this;
    }

    protected void addAdditionalColors(TabColor ... colors) {
        TabColor[] newColors = new TabColor[this.colors.length + colors.length];
        System.arraycopy(this.colors, 0, newColors, 0, this.colors.length);
        System.arraycopy(colors, 0, newColors, this.colors.length, colors.length);
        this.colors = newColors;
    }

    @Override
    public void setConfiguration(TabConfiguration configuration) {
        this.layoutManager.setConfiguration(configuration);
    }

    public abstract void updateBorder();

    protected void updateFont() {
        TabFont font = null;
        font = !this.isEnabled() ? this.fontUnselected : (this.isFocused() ? this.fontFocused : (this.isSelected() ? this.fontSelected : this.fontUnselected));
        this.label.setFontModifier(font.font());
    }

    protected void refreshActions() {
        if (this.actions != null) {
            this.actions.refresh();
        }
        ((EclipseTabInfo)this.pane.getInfoComponent()).refreshActions();
    }

    public abstract void updateFocus();

    protected abstract void updateSelected();

    protected abstract void updateColors();

    protected abstract void updateEnabled();

    protected void updatePaintIcon() {
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(this.icon);
        } else {
            this.label.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    protected abstract void updateOrientation();

    @Override
    public void setTab(EclipseTab tab) {
        if (this.background != null) {
            this.background.setController(null);
            this.background = null;
        }
        this.tab = tab;
        if (this.bound) {
            this.background = new Background(tab);
            this.background.setController(this.getController());
            this.buttons.setController(this.getController());
        }
        this.setBackground(this.background);
    }

    @Override
    public void bind() {
        if (this.buttons != null) {
            this.actions = new EclipseDockActionSource(this.pane.getTheme(), this.dockable.getGlobalActionOffers(), this, true);
            this.buttons.set(this.dockable, this.actions);
        }
        DockController controller = this.pane.getController();
        if (this.tab != null) {
            this.background = new Background(this.tab);
            this.background.setController(controller);
        }
        this.setBackground(this.background);
        this.buttons.setController(controller);
        for (TabColor tabColor : this.colors) {
            tabColor.connect(controller);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(controller);
        }
        this.revalidate();
        this.bound = true;
    }

    @Override
    public void unbind() {
        this.bound = false;
        if (this.buttons != null) {
            this.buttons.set(null);
        }
        if (this.background != null) {
            this.background.setController(null);
            this.background = null;
        }
        this.setBackground(this.background);
        this.buttons.setController(null);
        for (TabColor tabColor : this.colors) {
            tabColor.connect(null);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(null);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockElement getElement() {
        return this.dockable;
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.label.addMouseListener(l);
        this.buttons.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.label.removeMouseListener(l);
        this.buttons.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.label.addMouseMotionListener(l);
        this.buttons.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.label.removeMouseMotionListener(l);
        this.buttons.removeMouseMotionListener(l);
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    public DockController getController() {
        return this.pane.getController();
    }

    public DockStation getStation() {
        return this.pane.getStation();
    }

    @Override
    protected void setupRenderingHints(Graphics g) {
        DockController controller = this.getController();
        if (controller != null) {
            DockRenderingHints renderingHints = controller.getProperties().get(DockRenderingHints.RENDERING_HINTS);
            renderingHints.setupGraphics(g);
        }
    }

    public EclipseTabPane getPane() {
        return this.pane;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.hasFocus != focused) {
            this.hasFocus = focused;
            this.refreshActions();
            this.updateFocus();
        }
    }

    @Override
    public boolean isFocused() {
        return this.hasFocus;
    }

    public boolean isFocusTemporarilyLost() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        boolean focusTemporarilyLost = false;
        if (window != null) {
            focusTemporarilyLost = !window.isActive();
        }
        return focusTemporarilyLost;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            if (this.isSelected() || this.doPaintIconWhenInactive()) {
                this.label.setIcon(this.icon);
            } else {
                this.label.setIcon(null);
            }
            this.refreshActions();
            this.revalidate();
            this.updateSelected();
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    protected void setPreviousTabSelected(boolean selected) {
        this.previousTabSelected = selected;
        this.previousTabSelectedSet = true;
    }

    protected void cleanPreviousTabSelected() {
        this.previousTabSelectedSet = false;
    }

    protected boolean isPreviousTabSelected() {
        if (this.previousTabSelectedSet) {
            return this.previousTabSelected;
        }
        EclipseTabPane pane = this.getPane();
        pane.getSelectedIndex();
        int self = this.getTabIndex();
        if (self <= 0) {
            return false;
        }
        EclipseTab previous = (EclipseTab)pane.getVisibleTab(self - 1);
        return previous.getDockable() == pane.getSelectedDockable();
    }

    protected void setNextTabSelected(boolean selected) {
        this.nextTabSelected = selected;
        this.nextTabSelectedSet = true;
    }

    protected void cleanNextTabSelected() {
        this.nextTabSelectedSet = false;
    }

    protected boolean isNextTabSelected() {
        if (this.nextTabSelectedSet) {
            return this.nextTabSelected;
        }
        EclipseTabPane pane = this.getPane();
        int self = this.getTabIndex();
        if (self >= pane.getVisibleTabCount()) {
            return false;
        }
        EclipseTab next = (EclipseTab)pane.getVisibleTab(self + 1);
        if (next == null) {
            return false;
        }
        return next.getDockable() == pane.getSelectedDockable();
    }

    public int getDockableIndex() {
        EclipseTabPane pane = this.getPane();
        if (pane == null || !this.isBound()) {
            return -1;
        }
        return pane.indexOf(this.getDockable());
    }

    public int getTabIndex() {
        EclipseTabPane pane = this.getPane();
        if (pane == null || !this.isBound()) {
            return -1;
        }
        return pane.indexOfVisible(this);
    }

    public boolean doPaintIconWhenInactive() {
        return this.paintIconWhenInactive;
    }

    @Override
    public void setPaintIconWhenInactive(boolean paintIconWhenInactive) {
        if (this.paintIconWhenInactive != paintIconWhenInactive) {
            this.paintIconWhenInactive = paintIconWhenInactive;
            this.updatePaintIcon();
        }
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(icon);
            this.revalidate();
        }
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    @Override
    public void setText(String text) {
        this.label.setText(text);
        this.revalidate();
    }

    @Override
    public void setTooltip(String tooltip) {
        this.setToolTipText(tooltip);
        this.label.setToolTipText(tooltip);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setLabelInsets(Insets labelInsets) {
        this.layoutManager.setLabelInsets(labelInsets);
        this.revalidate();
    }

    public Insets getLabelInsets() {
        return this.layoutManager.getLabelInsets();
    }

    public void setButtonInsets(Insets buttonInsets) {
        this.layoutManager.setActionInsets(buttonInsets);
        this.revalidate();
    }

    public Insets getButtonInsets() {
        return this.layoutManager.getActionInsets();
    }

    protected OrientedLabel getLabel() {
        return this.label;
    }

    public ButtonPanel getButtons() {
        return this.buttons;
    }

    protected boolean containsButton(int x, int y) {
        return this.buttons.contains(x -= this.buttons.getX(), y -= this.buttons.getY());
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            this.label.setEnabled(enabled);
            this.refreshActions();
            this.updateEnabled();
        }
    }

    @Override
    public void setOrientation(TabPlacement orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.layoutManager.setOrientation(orientation);
            this.refreshActions();
            this.updateOrientation();
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    public Dimension getMinimumSize(TabComponent[] tabs) {
        this.setSelection(tabs);
        Dimension result = this.getMinimumSize();
        this.unsetSelection();
        return result;
    }

    @Override
    public Dimension getPreferredSize(TabComponent[] tabs) {
        this.setSelection(tabs);
        Dimension result = this.getPreferredSize();
        this.unsetSelection();
        return result;
    }

    private void setSelection(TabComponent[] tabs) {
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i] != this) continue;
            if (i > 0 && tabs[i - 1] instanceof BaseTabComponent) {
                this.setPreviousTabSelected(((BaseTabComponent)tabs[i - 1]).isSelected());
            }
            if (i + 1 >= tabs.length || !(tabs[i + 1] instanceof BaseTabComponent)) break;
            this.setNextTabSelected(((BaseTabComponent)tabs[i + 1]).isSelected());
            break;
        }
    }

    private void unsetSelection() {
        this.cleanNextTabSelected();
        this.cleanPreviousTabSelected();
    }

    private class BorderTabColor
    extends TabColor {
        public BorderTabColor(String id, DockStation station, Color backup) {
            super(id, station, BaseTabComponent.this.dockable, backup);
        }

        @Override
        protected void changed(Color oldColor, Color newColor) {
            BaseTabComponent.this.updateBorder();
        }
    }

    private class BaseTabColor
    extends TabColor {
        public BaseTabColor(String id, DockStation station, Color backup) {
            super(id, station, BaseTabComponent.this.dockable, backup);
        }

        @Override
        protected void changed(Color oldColor, Color newColor) {
            BaseTabComponent.this.updateColors();
        }
    }

    private class BaseTabFont
    extends TabFont {
        public BaseTabFont(String id, DockStation station) {
            super(id, station, BaseTabComponent.this.dockable);
        }

        @Override
        protected void changed(FontModifier oldValue, FontModifier newValue) {
            BaseTabComponent.this.updateFont();
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneTabBackgroundComponent {
        private EclipseTab tab;

        public Background(EclipseTab tab) {
            super(TabPaneTabBackgroundComponent.KIND, "dock.background.tabPane.child.tab");
            this.tab = tab;
        }

        @Override
        public Tab getTab() {
            return this.tab;
        }

        @Override
        public TabPaneComponent getChild() {
            return this.tab;
        }

        @Override
        public TabPane getPane() {
            return this.tab.getTabParent();
        }

        @Override
        public Component getComponent() {
            return BaseTabComponent.this.getComponent();
        }
    }
}

