/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.extension.gui.dock.theme.flat.FlatTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributorSource;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabComponentLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneTabBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.render.DockRenderingHints;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class FlatTab
extends ConfiguredBackgroundPanel
implements CombinedTab,
DockableFocusListener {
    private Dockable dockable;
    private DockController controller;
    private FlatTabPane pane;
    private OrientedLabel label = new OrientedLabel(){

        @Override
        protected void updateFonts() {
            FlatTab.this.updateFonts();
        }
    };
    private Background backgroundAlgorithm = new Background();
    private boolean focused = false;
    private TabColor borderSelectedOut;
    private TabColor borderSelectedCenter;
    private TabColor borderFocusedOut;
    private TabColor borderFocusedCenter;
    private TabColor borderOut;
    private TabColor borderCenter;
    private TabColor borderDisabledOut;
    private TabColor borderDisabledCenter;
    private TabColor border;
    private TabColor backgroundSelectedTop;
    private TabColor backgroundSelectedBottom;
    private TabColor backgroundFocusedTop;
    private TabColor backgroundFocusedBottom;
    private TabColor backgroundTop;
    private TabColor backgroundBottom;
    private TabColor backgroundDisabledTop;
    private TabColor backgroundDisabledBottom;
    private TabColor background;
    private TabColor foreground;
    private TabColor foregroundSelected;
    private TabColor foregroundFocused;
    private TabColor foregroundDisabled;
    private TabFont fontFocused;
    private TabFont fontSelected;
    private TabFont fontUnselected;
    private int zOrder;
    private TabPlacement orientation = TabPlacement.BOTTOM_OF_DOCKABLE;
    private ButtonPanel actions = new ButtonPanel(false);
    private DockActionDistributorSource actionsSource;
    private TabComponentLayoutManager layoutManager;
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();

    public FlatTab(FlatTabPane pane, Dockable dockable) {
        super(Transparency.SOLID);
        this.pane = pane;
        this.dockable = dockable;
        this.add(this.label);
        this.add(this.actions);
        this.layoutManager = new TabComponentLayoutManager(this.label, this.actions, pane.getConfiguration(dockable));
        this.layoutManager.setFreeSpaceToSideBorder(2);
        this.layoutManager.setFreeSpaceToParallelBorder(2);
        this.layoutManager.setFreeSpaceToOpenSide(2);
        this.layoutManager.setFreeSpaceBetweenLabelAndActions(2);
        this.setLayout(this.layoutManager);
        this.label.setBackground(this.backgroundAlgorithm);
        this.setBackground(this.backgroundAlgorithm);
        this.borderSelectedOut = new FlatTabColor("stack.tab.border.out.selected", dockable);
        this.borderSelectedCenter = new FlatTabColor("stack.tab.border.center.selected", dockable);
        this.borderFocusedOut = new FlatTabColor("stack.tab.border.out.focused", dockable);
        this.borderFocusedCenter = new FlatTabColor("stack.tab.border.center.focused", dockable);
        this.borderOut = new FlatTabColor("stack.tab.border.out", dockable);
        this.borderCenter = new FlatTabColor("stack.tab.border.center", dockable);
        this.borderDisabledOut = new FlatTabColor("stack.tab.border.out.disabled", dockable);
        this.borderDisabledCenter = new FlatTabColor("stack.tab.border.center.disabled", dockable);
        this.border = new FlatTabColor("stack.tab.border", dockable);
        this.backgroundSelectedTop = new FlatTabColor("stack.tab.background.top.selected", dockable);
        this.backgroundSelectedBottom = new FlatTabColor("stack.tab.background.bottom.selected", dockable);
        this.backgroundFocusedTop = new FlatTabColor("stack.tab.background.top.focused", dockable);
        this.backgroundFocusedBottom = new FlatTabColor("stack.tab.background.bottom.focused", dockable);
        this.backgroundTop = new FlatTabColor("stack.tab.background.top", dockable);
        this.backgroundBottom = new FlatTabColor("stack.tab.background.bottom", dockable);
        this.backgroundDisabledTop = new FlatTabColor("stack.tab.background.top.disabled", dockable);
        this.backgroundDisabledBottom = new FlatTabColor("stack.tab.background.bottom.disabled", dockable);
        this.background = new FlatTabColor("stack.tab.background", dockable);
        this.foreground = new FlatTabColor("stack.tab.foreground", dockable){

            @Override
            protected void changed(Color oldColor, Color newColor) {
                if (!FlatTab.this.isSelected() && FlatTab.this.isEnabled()) {
                    FlatTab.this.setForeground(newColor);
                }
            }
        };
        this.foregroundSelected = new FlatTabColor("stack.tab.foreground.selected", dockable){

            @Override
            protected void changed(Color oldColor, Color newColor) {
                if (FlatTab.this.isSelected() && !FlatTab.this.focused && FlatTab.this.isEnabled()) {
                    FlatTab.this.setForeground(newColor);
                }
            }
        };
        this.foregroundFocused = new FlatTabColor("stack.tab.foreground.focused", dockable){

            @Override
            protected void changed(Color oldColor, Color newColor) {
                if (FlatTab.this.focused && FlatTab.this.isEnabled()) {
                    FlatTab.this.setForeground(newColor);
                }
            }
        };
        this.foregroundDisabled = new FlatTabColor("stack.tab.foreground.disabled", dockable){

            @Override
            protected void changed(Color oldColor, Color newColor) {
                if (!FlatTab.this.isEnabled()) {
                    FlatTab.this.setForeground(newColor);
                }
            }
        };
        this.fontFocused = new FlatTabFont("tab.focused", dockable);
        this.fontSelected = new FlatTabFont("tab.selected", dockable);
        this.fontUnselected = new FlatTabFont("tab.unselected", dockable);
        this.setController(pane.getController());
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FlatTab.this.pane.setSelectedDockable(FlatTab.this.dockable);
            }
        });
        this.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                Graphics2D g2 = (Graphics2D)g;
                Paint oldPaint = g2.getPaint();
                Color out = null;
                Color center = null;
                if (!FlatTab.this.isEnabled()) {
                    out = (Color)FlatTab.this.borderDisabledOut.value();
                    center = (Color)FlatTab.this.borderDisabledCenter.value();
                } else if (FlatTab.this.focused) {
                    out = (Color)FlatTab.this.borderFocusedOut.value();
                    center = (Color)FlatTab.this.borderFocusedCenter.value();
                }
                if (FlatTab.this.isSelected()) {
                    if (out == null) {
                        out = (Color)FlatTab.this.borderSelectedOut.value();
                    }
                    if (center == null) {
                        center = (Color)FlatTab.this.borderSelectedCenter.value();
                    }
                }
                if (out == null) {
                    out = (Color)FlatTab.this.borderOut.value();
                }
                if (center == null) {
                    center = (Color)FlatTab.this.borderCenter.value();
                }
                if (out == null || center == null) {
                    Color background = (Color)FlatTab.this.border.value();
                    if (background == null) {
                        background = (Color)FlatTab.this.background.value();
                    }
                    if (background == null) {
                        background = FlatTab.this.getBackground();
                    }
                    if (out == null) {
                        out = background;
                    }
                    if (center == null) {
                        center = FlatTab.this.isSelected() ? background.brighter() : background.darker();
                    }
                }
                if (FlatTab.this.orientation.isHorizontal()) {
                    g2.setPaint(new GradientPaint(x, y, out, x, y + h / 2, center));
                    g.drawLine(x, y, x, y + h / 2);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h / 2);
                    g2.setPaint(new GradientPaint(x, y + h, out, x, y + h / 2, center));
                    g.drawLine(x, y + h, x, y + h / 2);
                    g.drawLine(x + w - 1, y + h, x + w - 1, y + h / 2);
                } else {
                    g2.setPaint(new GradientPaint(x, y, out, x + w / 2, y, center));
                    g.drawLine(x, y, x + w / 2, y);
                    g.drawLine(x, y + h - 1, x + w / 2, y + h - 1);
                    g2.setPaint(new GradientPaint(x + w, y, out, x + w / 2, y, center));
                    g.drawLine(x + w, y, x + w / 2, y);
                    g.drawLine(x + w, y + h - 1, x + w / 2, y + h - 1);
                }
                g2.setPaint(oldPaint);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 1, 0, 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
    }

    @Override
    public void setConfiguration(TabConfiguration configuration) {
        this.layoutManager.setConfiguration(configuration);
    }

    public void updateForeground() {
        if (!this.isEnabled()) {
            this.setForeground((Color)this.foregroundDisabled.value());
        } else if (this.focused) {
            this.setForeground((Color)this.foregroundFocused.value());
        } else if (this.isSelected()) {
            this.setForeground((Color)this.foregroundSelected.value());
        } else {
            this.setForeground((Color)this.foreground.value());
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public void updateFonts() {
        if (this.focused) {
            this.setFontModifier(this.fontFocused.font());
        } else if (this.isSelected()) {
            this.setFontModifier(this.fontSelected.font());
        } else {
            this.setFontModifier(this.fontUnselected.font());
        }
    }

    public void setFontModifier(FontModifier modifier) {
        this.label.setFontModifier(modifier);
    }

    public FontModifier getFontModifier() {
        return this.label.getFontModifier();
    }

    @Override
    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    @Override
    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this);
        }
        this.controller = controller;
        this.actions.setController(controller);
        if (controller == null) {
            if (this.actionsSource != null) {
                this.actions.set(null);
                this.actionsSource.setDockable(null);
                this.actionsSource = null;
            }
        } else {
            controller.addDockableFocusListener(this);
            boolean bl = this.focused = controller.getFocusedDockable() == this.dockable;
            if (this.actionsSource == null) {
                this.actionsSource = new DockActionDistributorSource(DockActionDistributor.Target.TAB, FlatTheme.ACTION_DISTRIBUTOR);
                this.actionsSource.setDockable(this.getDockable());
                this.actions.set(this.getDockable(), this.actionsSource);
            }
        }
        this.borderSelectedOut.connect(controller);
        this.borderSelectedCenter.connect(controller);
        this.borderFocusedOut.connect(controller);
        this.borderFocusedCenter.connect(controller);
        this.borderOut.connect(controller);
        this.borderCenter.connect(controller);
        this.borderDisabledOut.connect(controller);
        this.borderDisabledCenter.connect(controller);
        this.border.connect(controller);
        this.backgroundSelectedTop.connect(controller);
        this.backgroundSelectedBottom.connect(controller);
        this.backgroundFocusedTop.connect(controller);
        this.backgroundFocusedBottom.connect(controller);
        this.backgroundTop.connect(controller);
        this.backgroundBottom.connect(controller);
        this.backgroundDisabledTop.connect(controller);
        this.backgroundDisabledBottom.connect(controller);
        this.background.connect(controller);
        this.foregroundSelected.connect(controller);
        this.foregroundFocused.connect(controller);
        this.foregroundDisabled.connect(controller);
        this.foreground.connect(controller);
        this.fontFocused.connect(controller);
        this.fontSelected.connect(controller);
        this.fontUnselected.connect(controller);
        this.backgroundAlgorithm.setController(controller);
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    @Override
    public void dockableFocused(DockableFocusEvent event) {
        this.focused = this.dockable == event.getNewFocusOwner();
        this.updateForeground();
        this.updateFonts();
        this.repaint();
    }

    @Override
    public TabPane getTabParent() {
        return this.pane;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public DockElement getElement() {
        return this.dockable;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.label.setEnabled(enabled);
            super.setEnabled(enabled);
            if (enabled) {
                for (MouseInputListener listener : this.mouseInputListeners) {
                    this.doAddMouseInputListener(listener);
                }
            } else {
                for (MouseInputListener listener : this.mouseInputListeners) {
                    this.doRemoveMouseInputListener(listener);
                }
            }
            this.updateFonts();
            this.updateForeground();
            this.repaint();
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.mouseInputListeners.add(listener);
        if (this.isEnabled()) {
            this.doAddMouseInputListener(listener);
        }
    }

    private void doAddMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.label.addMouseListener(listener);
        this.label.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.mouseInputListeners.remove(listener);
        if (this.isEnabled()) {
            this.doRemoveMouseInputListener(listener);
        }
    }

    private void doRemoveMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
        this.label.removeMouseListener(listener);
        this.label.removeMouseMotionListener(listener);
    }

    @Override
    public Dimension getPreferredSize(Tab[] tabs) {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = super.getPreferredSize();
        if (preferred.width < 10 || preferred.height < 10) {
            preferred = new Dimension(preferred);
            preferred.width = Math.max(preferred.width, 10);
            preferred.height = Math.max(preferred.height, 10);
        }
        return preferred;
    }

    @Override
    public Dimension getMinimumSize(Tab[] tabs) {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension min = super.getMinimumSize();
        if (min.width < 10 || min.height < 10) {
            min = new Dimension(min);
            min.width = Math.max(min.width, 10);
            min.height = Math.max(min.height, 10);
        }
        return min;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.setToolTipText(tooltip);
    }

    @Override
    public void setPaneVisible(boolean visible) {
        this.pane.getTabHandler().setVisible(this, visible);
    }

    @Override
    public boolean isPaneVisible() {
        return this.pane.getTabHandler().isVisible(this);
    }

    public boolean isSelected() {
        return this.pane.getSelectedDockable() == this.dockable;
    }

    @Override
    public void setZOrder(int order) {
        this.zOrder = order;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public Insets getOverlap(TabPaneComponent other) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void setOrientation(TabPlacement orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.layoutManager.setOrientation(orientation);
            this.revalidate();
            this.repaint();
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    protected void setupRenderingHints(Graphics g) {
        if (this.controller != null) {
            DockRenderingHints renderingHints = this.controller.getProperties().get(DockRenderingHints.RENDERING_HINTS);
            renderingHints.setupGraphics(g);
        }
    }

    @Override
    public void paintBackground(Graphics g) {
        if (this.getTransparency() != Transparency.TRANSPARENT) {
            super.paintBackground(g);
            Graphics2D g2 = (Graphics2D)g;
            Paint oldPaint = g2.getPaint();
            int w = this.getWidth();
            int h = this.getHeight();
            Color top = null;
            Color bottom = null;
            if (!this.isEnabled()) {
                top = (Color)this.backgroundDisabledTop.value();
                bottom = (Color)this.backgroundFocusedBottom.value();
            } else if (this.focused) {
                top = (Color)this.backgroundFocusedTop.value();
                bottom = (Color)this.backgroundFocusedBottom.value();
            }
            if (this.isSelected()) {
                if (top == null) {
                    top = (Color)this.backgroundSelectedTop.value();
                }
                if (bottom == null) {
                    bottom = (Color)this.backgroundSelectedBottom.value();
                }
            }
            if (top == null) {
                top = (Color)this.backgroundTop.value();
            }
            if (bottom == null) {
                bottom = (Color)this.backgroundBottom.value();
            }
            if (top == null || bottom == null) {
                Color background = (Color)this.background.value();
                if (background == null) {
                    background = this.getBackground();
                }
                if (bottom == null) {
                    bottom = background;
                }
                if (top == null) {
                    top = this.isSelected() ? background.brighter() : background;
                }
            }
            if (top.equals(bottom)) {
                g.setColor(top);
            } else if (this.orientation.isHorizontal()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, 0.0f, h, bottom));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, w, 0.0f, bottom));
            }
            g.fillRect(0, 0, w, h);
            g2.setPaint(oldPaint);
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneTabBackgroundComponent {
        public Background() {
            super(TabPaneTabBackgroundComponent.KIND, "dock.background.tabPane.child.tab");
        }

        @Override
        public Tab getTab() {
            return FlatTab.this;
        }

        @Override
        public TabPaneComponent getChild() {
            return FlatTab.this;
        }

        @Override
        public TabPane getPane() {
            return FlatTab.this.getTabParent();
        }

        @Override
        public Component getComponent() {
            return FlatTab.this;
        }
    }

    private class FlatTabColor
    extends TabColor {
        public FlatTabColor(String id, Dockable dockable) {
            super(id, FlatTab.this.pane.getStation(), dockable, null);
        }

        @Override
        protected void changed(Color oldColor, Color newColor) {
            FlatTab.this.repaint();
        }
    }

    private class FlatTabFont
    extends TabFont {
        public FlatTabFont(String id, Dockable dockable) {
            super(id, FlatTab.this.pane.getStation(), dockable);
        }

        @Override
        protected void changed(FontModifier oldValue, FontModifier newValue) {
            FlatTab.this.updateFonts();
        }
    }
}

