/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicStationTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;
import java.awt.Color;

public class SmoothDefaultStationTitle
extends BasicStationTitle {
    private final int ACTIVE_STATE = 0;
    private final int INACTIVE_STATE = 1;
    private final int DISABLED_STATE = 2;
    private int[] current = null;
    private SmoothChanger changer = new SmoothChanger(3){

        @Override
        protected int destination() {
            if (SmoothDefaultStationTitle.this.isDisabled()) {
                return 2;
            }
            if (SmoothDefaultStationTitle.this.isActive()) {
                return 0;
            }
            return 1;
        }

        @Override
        protected void repaint(int[] current) {
            SmoothDefaultStationTitle.this.current = current;
            SmoothDefaultStationTitle.this.updateColors();
        }
    };

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    @Override
    protected void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    public SmoothDefaultStationTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
    }

    public int getDuration() {
        return this.changer.getDuration();
    }

    public void setDuration(int duration) {
        this.changer.setDuration(duration);
    }

    @Override
    protected void updateColors() {
        if (this.changer != null && this.changer.isRunning() && this.current != null) {
            this.setForeground(this.get(this.getActiveTextColor(), this.getInactiveTextColor(), this.getInactiveTextColor()));
            this.setBackground(this.get(this.getActiveColor(), this.getInactiveColor(), this.getDisabledColor()));
            this.repaint();
        } else {
            super.updateColors();
        }
    }

    private Color get(Color active, Color inactive, Color disabled) {
        return Colors.between(active, this.current[0], inactive, this.current[1], disabled, this.current[2]);
    }
}

