/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.DefaultFlapLayoutManager;
import bibliothek.gui.dock.station.flap.DefaultFlapWindowFactory;
import bibliothek.gui.dock.station.flap.FlapDockHoldToggle;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.flap.FlapDockStationSource;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapLayoutManagerListener;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindowFactory;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentFilter;
import bibliothek.gui.dock.station.flap.button.DefaultButtonContentFilter;
import bibliothek.gui.dock.station.flap.layer.FlapOverrideDropLayer;
import bibliothek.gui.dock.station.flap.layer.FlapSideDropLayer;
import bibliothek.gui.dock.station.flap.layer.WindowDropLayer;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerSourceWrapper;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.gui.dock.themes.basic.BasicButtonTitleFactory;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class FlapDockStation
extends AbstractDockableStation {
    public static final String WINDOW_TITLE_ID = "flap window";
    public static final String BUTTON_TITLE_ID = "flap button";
    public static final String DISPLAYER_ID = "flap";
    public static final PropertyKey<FlapLayoutManager> LAYOUT_MANAGER = new PropertyKey<FlapLayoutManager>("flap dock station layout manager", new DynamicPropertyFactory<FlapLayoutManager>(){

        @Override
        public FlapLayoutManager getDefault(PropertyKey<FlapLayoutManager> key, DockProperties properties) {
            return new DefaultFlapLayoutManager();
        }
    }, true);
    public static final PropertyKey<ButtonContent> BUTTON_CONTENT = new PropertyKey<ButtonContent>("flap dock station button content", new ConstantPropertyFactory<ButtonContent>(ButtonContent.THEME_DEPENDENT), true);
    public static final PropertyKey<ButtonContentFilter> BUTTON_CONTENT_FILTER = new PropertyKey<DefaultButtonContentFilter>("flap dock station button content connector", new ConstantPropertyFactory<DefaultButtonContentFilter>(new DefaultButtonContentFilter()), true);
    public static final PropertyKey<Dimension> MINIMUM_SIZE = new PropertyKey<Dimension>("flap dock station empty size", new ConstantPropertyFactory<Dimension>(new Dimension(0, 0)), true);
    public static final PropertyKey<FlapWindowFactory> WINDOW_FACTORY = new PropertyKey<DefaultFlapWindowFactory>("flap dock station window factory", new ConstantPropertyFactory<DefaultFlapWindowFactory>(new DefaultFlapWindowFactory()), true);
    private FlapLayoutManagerListener layoutManagerListener = new FlapLayoutManagerListener(){

        @Override
        public void holdSwitchableChanged(FlapLayoutManager manager, FlapDockStation station, Dockable dockable) {
            if (station == null || station == FlapDockStation.this) {
                FlapDockStation.this.updateIsHoldSwitchable(dockable);
            }
        }
    };
    private PropertyValue<FlapLayoutManager> layoutManager = new PropertyValue<FlapLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(FlapLayoutManager oldValue, FlapLayoutManager newValue) {
            if (oldValue != null) {
                oldValue.removeListener(FlapDockStation.this.layoutManagerListener);
                oldValue.uninstall(FlapDockStation.this);
            }
            if (newValue != null) {
                newValue.addListener(FlapDockStation.this.layoutManagerListener);
                newValue.install(FlapDockStation.this);
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            FlapDockStation.this.handles.setStrategy(newValue);
        }
    };
    private PropertyValue<ButtonContent> buttonContent = new PropertyValue<ButtonContent>(BUTTON_CONTENT){

        @Override
        protected void valueChanged(ButtonContent oldValue, ButtonContent newValue) {
            if (oldValue != newValue) {
                FlapDockStation.this.recreateTitles();
            }
        }
    };
    private PropertyValue<Dimension> minimumSize = new PropertyValue<Dimension>(MINIMUM_SIZE){

        @Override
        protected void valueChanged(Dimension oldValue, Dimension newValue) {
            FlapDockStation.this.buttonPane.revalidate();
        }
    };
    private PropertyValue<FlapWindowFactory> windowFactory = new PropertyValue<FlapWindowFactory>(WINDOW_FACTORY){

        @Override
        protected void valueChanged(FlapWindowFactory oldValue, FlapWindowFactory newValue) {
            if (oldValue != null) {
                oldValue.uninstall(FlapDockStation.this);
            }
            if (newValue != null) {
                newValue.install(FlapDockStation.this);
            }
            FlapDockStation.this.updateWindow(FlapDockStation.this.getFrontDockable(), true);
        }
    };
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy oldValue, DisablingStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeDisablingStrategyListener(FlapDockStation.this.disablingStrategyListener);
            }
            if (newValue != null) {
                newValue.addDisablingStrategyListener(FlapDockStation.this.disablingStrategyListener);
                if (newValue.isDisabled(FlapDockStation.this)) {
                    FlapDockStation.this.setFrontDockable(null);
                }
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        @Override
        public void changed(DockElement item) {
            if (item == FlapDockStation.this && FlapDockStation.this.disablingStrategy.getValue().isDisabled(item)) {
                FlapDockStation.this.setFrontDockable(null);
            }
        }
    };
    private Direction direction = Direction.SOUTH;
    private boolean autoDirection = true;
    private FlapWindow window;
    private int windowBorder = 3;
    private int windowMinSize = 25;
    private int defaultWindowSize = 400;
    private Dockable oldFrontDockable;
    private DockablePlaceholderList<DockableHandle> handles = new DockablePlaceholderList();
    private Listener dockableListener = new Listener();
    private ButtonPane buttonPane;
    private DockTitleVersion buttonVersion;
    private DockTitleVersion titleVersion;
    private DefaultStationPaintValue paint;
    private StationCombinerValue combiner;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private FlapDropInfo dropInfo;
    private StationDragOperation dragInfo;
    private ControllerListener controllerListener = new ControllerListener();
    private boolean smallButtons = true;
    private ListeningDockAction holdAction;
    private VisibleListener visibleListener = new VisibleListener();
    private boolean lastShowing = false;
    private List<FlapDockListener> flapDockListeners = new ArrayList<FlapDockListener>();
    private DockableShowingManager showingManager;
    private Background background = new Background();
    private int borderSideSnapSize = 15;

    public FlapDockStation() {
        this.init();
    }

    protected FlapDockStation(boolean init) {
        if (init) {
            this.init();
        }
    }

    protected void init() {
        this.showingManager = new DockableShowingManager(this.listeners);
        this.buttonPane = this.createButtonPane();
        this.buttonPane.setBackground(this.background);
        this.buttonPane.setController(this.getController());
        this.setDirection(Direction.SOUTH);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.flap", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, DISPLAYER_ID);
        this.paint = new DefaultStationPaintValue("dock.paint.flap", this);
        this.combiner = new StationCombinerValue("dock.combiner.flap", this);
        this.buttonPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.buttonPane.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.buttonPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (FlapDockStation.this.getDockParent() == null) {
                        FlapDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    FlapDockStation.this.checkShowing();
                }
            }
        });
        this.holdAction = this.createHoldAction();
    }

    protected ButtonPane createButtonPane() {
        return new ButtonPane(this);
    }

    protected ListeningDockAction createHoldAction() {
        return new FlapDockHoldToggle(this);
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                if (FlapDockStation.this.buttonPane.getBasePane() == component) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE_CHILDREN;
                }
                if (FlapDockStation.this.displayers.isDisplayerComponent(component)) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    @Override
    public void setDockParent(DockStation station) {
        if (this.getDockParent() != null) {
            this.getDockParent().removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(station);
        if (station != null) {
            station.addDockStationListener(this.visibleListener);
        }
    }

    @Override
    public void setController(DockController controller) {
        if (this.getController() != controller) {
            boolean remove;
            boolean bl = remove = this.getController() != null;
            if (remove) {
                this.handles.unbind();
                this.getController().removeDockableFocusListener(this.controllerListener);
                this.getController().getFocusController().removeVetoListener(this.controllerListener);
                this.oldFrontDockable = this.getFrontDockable();
                this.setFrontDockable(null);
                for (DockableHandle dockable : this.handles.dockables()) {
                    if (dockable == null) continue;
                    dockable.setTitle(null);
                }
                if (this.window != null) {
                    this.window.setDockTitle(null);
                }
                this.titleVersion = null;
                this.buttonVersion = null;
            }
            super.setController(controller);
            this.placeholderStrategy.setProperties(controller);
            this.displayers.setController(controller);
            this.paint.setController(controller);
            this.displayerFactory.setController(controller);
            this.combiner.setController(controller);
            this.background.setController(controller);
            if (this.window != null) {
                this.window.setController(controller);
            }
            this.disablingStrategy.setProperties(controller);
            this.buttonPane.setController(controller);
            FlapLayoutManager oldLayoutManager = this.layoutManager.getValue();
            this.layoutManager.setProperties(controller);
            FlapLayoutManager newLayoutManager = this.layoutManager.getValue();
            if (oldLayoutManager == newLayoutManager) {
                if (controller == null) {
                    if (oldLayoutManager != null) {
                        oldLayoutManager.uninstall(this);
                    }
                } else if (newLayoutManager != null) {
                    newLayoutManager.install(this);
                }
            }
            this.buttonContent.setProperties(controller);
            this.minimumSize.setProperties(controller);
            if (this.holdAction != null) {
                this.holdAction.setController(controller);
            }
            if (controller != null) {
                this.handles.bind();
                this.titleVersion = controller.getDockTitleManager().getVersion(WINDOW_TITLE_ID, ControllerTitleFactory.INSTANCE);
                this.buttonVersion = controller.getDockTitleManager().getVersion(BUTTON_TITLE_ID, BasicButtonTitleFactory.FACTORY);
                for (DockableHandle dockable : this.handles.dockables()) {
                    if (dockable == null) continue;
                    dockable.setTitle(this.buttonVersion);
                }
                if (this.window != null) {
                    this.window.setDockTitle(this.titleVersion);
                }
                controller.addDockableFocusListener(this.controllerListener);
                controller.getFocusController().addVetoListener(this.controllerListener);
                if (this.isStationShowing()) {
                    this.setFrontDockable(this.oldFrontDockable);
                }
            }
            this.windowFactory.setProperties(controller);
            this.buttonPane.setProperties(controller);
            this.buttonPane.resetTitles();
            this.showingManager.fire();
        }
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new FlapDockStationFactory());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this.direction = direction;
        DockTitle.Orientation orientation = this.orientation(direction);
        for (DockableHandle dockable : this.handles.dockables()) {
            DockTitle title = dockable.getTitle();
            if (title == null) continue;
            title.setOrientation(orientation);
        }
        this.buttonPane.resetTitles();
        this.updateWindowBounds();
        this.buttonPane.revalidate();
    }

    protected DockTitle.Orientation orientation(Direction direction) {
        switch (direction) {
            case NORTH: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case SOUTH: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case EAST: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case WEST: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    protected void updateWindowBounds() {
        if (this.window != null) {
            this.window.updateBounds();
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize.getValue();
    }

    public void setMinimumSize(Dimension size) {
        this.minimumSize.setValue(size);
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public StationCombinerValue getCombiner() {
        return this.combiner;
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public Rectangle getExpansionBounds() {
        Component component = this.getComponent();
        return new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public boolean isAutoDirection() {
        return this.autoDirection;
    }

    public void setAutoDirection(boolean autoDirection) {
        this.autoDirection = autoDirection;
        if (autoDirection) {
            this.selfSetDirection();
        }
    }

    public void selfSetDirection() {
        Component c = this.getComponent();
        Point center = new Point(c.getWidth() / 2, c.getHeight() / 2);
        SwingUtilities.convertPointToScreen(center, c);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Direction direction = c.getWidth() > c.getHeight() ? (center.y < size.height / 2 ? Direction.SOUTH : Direction.NORTH) : (center.x < size.width / 2 ? Direction.EAST : Direction.WEST);
        if (direction != this.direction) {
            this.setDirection(direction);
        } else {
            this.updateWindowBounds();
        }
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.window == null) {
            return null;
        }
        return this.window.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        boolean active;
        DockTitle[] titles;
        Dockable oldFrontDockable = this.getFrontDockable();
        if (oldFrontDockable == dockable) {
            return;
        }
        this.updateWindow(dockable, false);
        if (this.getController() != null && oldFrontDockable != null) {
            titles = oldFrontDockable.listBoundTitles();
            active = this.getController().isFocused(oldFrontDockable);
            for (DockTitle title : titles) {
                this.changed(oldFrontDockable, title, active);
            }
        }
        if (this.window != null) {
            if (this.window.getDockable() == null) {
                this.window.setWindowVisible(false);
            } else {
                this.window.repaint();
            }
        }
        if (this.getController() != null && dockable != null) {
            titles = dockable.listBoundTitles();
            active = this.getController().isFocused(dockable);
            for (DockTitle title : titles) {
                this.changed(dockable, title, active);
            }
        }
        this.showingManager.fire();
        this.listeners.fireDockableSelected(oldFrontDockable, dockable);
    }

    private void updateWindow(Dockable dockable, boolean forceReplace) {
        if (dockable == null) {
            if (this.window != null) {
                this.window.setDockable(null);
                if (forceReplace) {
                    this.setFlapWindow(null);
                }
            }
        } else {
            Window owner = SwingUtilities.getWindowAncestor(this.getComponent());
            if (this.window == null || forceReplace || !this.windowFactory.getValue().isValid(this.window, this)) {
                FlapWindow window;
                if (this.window != null) {
                    this.window.setDockable(null);
                }
                if ((window = this.createFlapWindow(this.buttonPane)) != null) {
                    this.setFlapWindow(window);
                }
            }
            if (this.window != null && owner != null) {
                this.window.setDockable(dockable);
                if (owner.isVisible()) {
                    this.window.setWindowVisible(true);
                }
                this.updateWindowBounds();
            }
        }
    }

    protected FlapWindow createFlapWindow(ButtonPane buttonPane) {
        FlapWindow window = this.windowFactory.getValue().create(this, buttonPane);
        if (window != null) {
            window.setDockTitle(this.titleVersion);
        }
        return window;
    }

    public boolean isHold(Dockable dockable) {
        FlapLayoutManager manager = this.layoutManager.getValue();
        if (manager == null) {
            return false;
        }
        return manager.isHold(this, dockable);
    }

    public void setHold(Dockable dockable, boolean hold) {
        FlapLayoutManager manager = this.layoutManager.getValue();
        if (manager != null) {
            boolean old = manager.isHold(this, dockable);
            manager.setHold(this, dockable, hold);
            hold = manager.isHold(this, dockable);
            if (old != hold) {
                this.updateHold(dockable);
            }
        }
    }

    public void updateHold(Dockable dockable) {
        FlapLayoutManager manager = this.layoutManager.getValue();
        if (manager != null) {
            boolean hold = manager.isHold(this, dockable);
            this.fireHoldChanged(dockable, hold);
            if (!hold && this.getController() != null && this.getFrontDockable() == dockable && !this.getController().isFocused(dockable)) {
                this.setFrontDockable(null);
            }
        }
    }

    public boolean isSmallButtons() {
        return this.smallButtons;
    }

    public void setSmallButtons(boolean smallButtons) {
        this.smallButtons = smallButtons;
    }

    public DockTitleVersion getTitleVersion() {
        return this.titleVersion;
    }

    public DockTitleVersion getButtonVersion() {
        return this.buttonVersion;
    }

    public int getWindowBorder() {
        return this.windowBorder;
    }

    public void setWindowBorder(int windowBorder) {
        if (windowBorder < 0) {
            throw new IllegalArgumentException("Border must not be less than 0");
        }
        this.windowBorder = windowBorder;
        this.updateWindowBounds();
    }

    public int getWindowMinSize() {
        return this.windowMinSize;
    }

    public void setWindowMinSize(int windowMinSize) {
        if (windowMinSize < 0) {
            throw new IllegalArgumentException("Min size must not be smaller than 0");
        }
        this.windowMinSize = windowMinSize;
        this.updateWindowBounds();
    }

    public int getWindowSize(Dockable dockable) {
        FlapLayoutManager manager = this.layoutManager.getValue();
        if (manager == null) {
            return 0;
        }
        return manager.getSize(this, dockable);
    }

    public void setWindowSize(Dockable dockable, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must at least be 0");
        }
        FlapLayoutManager manager = this.layoutManager.getValue();
        if (manager != null) {
            manager.setSize(this, dockable, size);
            this.updateWindowSize(dockable);
        }
    }

    public void updateWindowSize(Dockable dockable) {
        if (this.getFrontDockable() == dockable) {
            this.updateWindowBounds();
        }
    }

    public void setDefaultWindowSize(int defaultWindowSize) {
        this.defaultWindowSize = defaultWindowSize;
    }

    public int getDefaultWindowSize() {
        return this.defaultWindowSize;
    }

    public void setFlapLayoutManager(FlapLayoutManager manager) {
        this.layoutManager.setValue(manager);
    }

    public FlapLayoutManager getFlapLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public FlapLayoutManager getCurrentFlapLayoutManager() {
        return this.layoutManager.getValue();
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategy.setValue(strategy);
    }

    public void addFlapDockStationListener(FlapDockListener listener) {
        this.flapDockListeners.add(listener);
    }

    public void removeFlapDockStationListener(FlapDockListener listener) {
        this.flapDockListeners.remove(listener);
    }

    protected void fireHoldChanged(Dockable dockable, boolean value) {
        for (FlapDockListener listener : this.flapDockListeners.toArray(new FlapDockListener[this.flapDockListeners.size()])) {
            listener.holdChanged(this, dockable, value);
        }
    }

    @Override
    public DockActionSource getDirectActionOffers(Dockable dockable) {
        int index = this.indexOf(dockable);
        if (index < 0) {
            return null;
        }
        DockableHandle handle = (DockableHandle)this.handles.dockables().get(index);
        return handle.getActions();
    }

    private void updateIsHoldSwitchable(Dockable dockable) {
        if (dockable == null) {
            for (DockableHandle handle : this.handles.dockables()) {
                handle.getActions().updateHoldSwitchable();
            }
        } else {
            int index = this.indexOf(dockable);
            if (index >= 0) {
                DockableHandle handle = (DockableHandle)this.handles.dockables().get(index);
                handle.getActions().updateHoldSwitchable();
            }
        }
    }

    @Override
    public void changed(Dockable dockable, DockTitle title, boolean active) {
        ActivityDockTitleEvent event = new ActivityDockTitleEvent(this, dockable, active);
        event.setPreferred(dockable == this.getFrontDockable());
        title.changed(event);
    }

    private void setDropInfo(FlapDropInfo info) {
        this.dropInfo = info;
        if (this.window != null) {
            this.window.setDropInfo(info);
        }
        if (this.buttonPane != null) {
            this.buttonPane.setDropInfo(info);
        }
    }

    private void setFlapWindow(FlapWindow window) {
        if (this.window != null) {
            this.getRootHandler().removeRoot(window.getComponent());
            this.window.setController(null);
            this.window.destroy();
        }
        this.window = window;
        if (window != null) {
            window.setController(this.getController());
            window.setDropInfo(this.dropInfo);
            this.getRootHandler().removeRoot(window.getComponent());
        }
    }

    public boolean isFlapWindow(FlapWindow window) {
        return this.window == window;
    }

    public FlapWindow getFlapWindow() {
        return this.window;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.handles.toMap();
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.handles){

            @Override
            public DockableProperty getLocationAt(Path placeholder) {
                int index = FlapDockStation.this.handles.getDockableIndex(placeholder);
                return new FlapDockProperty(index, false, -1, placeholder);
            }
        };
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("only allowed if there are not children present");
        }
        try {
            DockablePlaceholderList next = new DockablePlaceholderList(placeholders);
            if (this.getController() != null) {
                this.handles.setStrategy(null);
                this.handles.unbind();
                this.handles = next;
                this.handles.bind();
                this.handles.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.handles = next;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> children) {
        final PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        return this.handles.toMap(new PlaceholderListItemAdapter<Dockable, DockableHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int index, DockableHandle dockable) {
                Path placeholder;
                Integer id = (Integer)children.get(dockable.getDockable());
                if (id == null) {
                    return null;
                }
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("id", id);
                item.putInt("index", index);
                item.putBoolean("hold", FlapDockStation.this.isHold(dockable.getDockable()));
                item.putInt("size", FlapDockStation.this.getWindowSize(dockable.getDockable()));
                if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable.getDockable())) != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap map, final Map<Integer, Dockable> children) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        DockController controller = this.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
                this.handles.setStrategy(null);
                this.handles.unbind();
            }
            this.handles = new DockablePlaceholderList();
            this.handles.read(map, new PlaceholderListItemAdapter<Dockable, DockableHandle>(){
                private DockHierarchyLock.Token token;

                @Override
                public DockableHandle convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    Dockable dockable = (Dockable)children.get(id);
                    if (dockable != null) {
                        DockUtilities.ensureTreeValidity(FlapDockStation.this, dockable);
                        this.token = DockHierarchyLock.acquireLinking(FlapDockStation.this, dockable);
                        boolean hold = item.getBoolean("hold");
                        int size = item.getInt("size");
                        FlapDockStation.this.listeners.fireDockableAdding(dockable);
                        DockableHandle handle = FlapDockStation.this.link(dockable);
                        FlapDockStation.this.setHold(dockable, hold);
                        FlapDockStation.this.setWindowSize(dockable, size);
                        return handle;
                    }
                    return null;
                }

                @Override
                public void added(DockableHandle dockable) {
                    try {
                        dockable.getDockable().setDockParent(FlapDockStation.this);
                        FlapDockStation.this.listeners.fireDockableAdded(dockable.getDockable());
                    }
                    finally {
                        this.token.releaseNoCheck();
                    }
                }
            });
            if (this.getController() != null) {
                this.handles.bind();
                this.handles.setStrategy(this.getPlaceholderStrategy());
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
        this.buttonPane.resetTitles();
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        Component component = this.getComponent();
        if (component.getWidth() <= 0 || component.getHeight() <= 0) {
            return new DockStationDropLayer[0];
        }
        if (this.getDockableCount() == 0) {
            return new DockStationDropLayer[]{new DefaultDropLayer(this), new FlapOverrideDropLayer(this), new WindowDropLayer(this), new FlapSideDropLayer(this)};
        }
        return new DockStationDropLayer[]{new DefaultDropLayer(this), new FlapOverrideDropLayer(this), new WindowDropLayer(this)};
    }

    public void setBorderSideSnapSize(int borderSideSnapSize) {
        this.borderSideSnapSize = borderSideSnapSize;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        if (this.dragInfo != null) {
            this.dragInfo.canceled();
        }
        if (this.window != null && this.window.getDockable() == dockable) {
            this.window.setRemoval(true);
            this.dragInfo = new StationDragOperation(){

                @Override
                public void succeeded() {
                    FlapDockStation.this.window.setRemoval(false);
                    FlapDockStation.this.dragInfo = null;
                }

                @Override
                public void canceled() {
                    FlapDockStation.this.window.setRemoval(false);
                    FlapDockStation.this.dragInfo = null;
                }
            };
        }
        return this.dragInfo;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem item) {
        DockTitle title;
        boolean move;
        int mouseX = item.getMouseX();
        int mouseY = item.getMouseY();
        Dockable dockable = item.getDockable();
        boolean bl = move = dockable.getDockParent() == this;
        if (SwingUtilities.isDescendingFrom(this.getComponent(), dockable.getComponent())) {
            return null;
        }
        Point mouse = new Point(mouseX, mouseY);
        SwingUtilities.convertPointFromScreen(mouse, this.buttonPane);
        FlapDropInfo dropInfo = null;
        MultiDockAcceptance acceptance = this.getController().getAcceptance();
        if (this.window != null && this.window.isWindowVisible() && (title = this.window.getDockTitle()) != null) {
            boolean combine;
            Component c = title.getComponent();
            Point point = new Point(mouseX, mouseY);
            SwingUtilities.convertPointFromScreen(point, c);
            Dockable child = this.window.getDockable();
            boolean bl2 = combine = c.contains(point) && this.acceptable(child, dockable);
            if (combine) {
                dropInfo = this.prepareCombine(dockable, this.window, new Point(mouseX, mouseY), combine, Enforcement.HARD);
            }
        }
        if (this.window != null && this.window.isWindowVisible() && dropInfo == null) {
            boolean combine;
            Point point = new Point(mouseX, mouseY);
            Dockable child = this.window.getDockable();
            boolean bl3 = combine = this.window.containsScreenPoint(point) && this.acceptable(child, dockable);
            if (combine) {
                dropInfo = this.prepareCombine(dockable, this.window, point, false, Enforcement.HARD);
            }
        }
        if (dropInfo != null && dockable == this.getFrontDockable()) {
            return null;
        }
        if (dropInfo == null && dockable.accept(this) && this.accept(dockable) && acceptance.accept(this, dockable)) {
            dropInfo = new FlapDropInfo(this, dockable){

                @Override
                public Point getMousePosition() {
                    return null;
                }

                @Override
                public Dockable getOld() {
                    return null;
                }

                @Override
                public DockableDisplayer getOldDisplayer() {
                    return null;
                }

                @Override
                public PlaceholderMap getPlaceholders() {
                    return null;
                }

                @Override
                public Dimension getSize() {
                    return null;
                }

                @Override
                public boolean isMouseOverTitle() {
                    return false;
                }
            };
            dropInfo.setIndex(this.buttonPane.indexAt(mouse.x, mouse.y));
        }
        if (dropInfo == null) {
            return null;
        }
        return new FlapDropOperation(dropInfo, move);
    }

    private FlapDropInfo prepareCombine(Dockable dockable, FlapWindow window, final Point mouseOnScreen, final boolean mouseOverTitle, Enforcement force) {
        DockableDisplayer displayer;
        final Dockable child = window.getDockable();
        FlapDropInfo info = new FlapDropInfo(this, dockable, displayer = window.getDisplayer()){
            final /* synthetic */ DockableDisplayer val$displayer;
            {
                this.val$displayer = dockableDisplayer;
                super(station, dockable);
            }

            @Override
            public boolean isMouseOverTitle() {
                return mouseOverTitle;
            }

            @Override
            public Dimension getSize() {
                return child.getComponent().getSize();
            }

            @Override
            public PlaceholderMap getPlaceholders() {
                for (PlaceholderList.Item item : FlapDockStation.this.handles.list()) {
                    DockableHandle handle = (DockableHandle)item.getDockable();
                    if (handle == null || handle.getDockable() != child) continue;
                    return item.getPlaceholderMap();
                }
                return null;
            }

            @Override
            public Point getMousePosition() {
                Point mouse = new Point(mouseOnScreen);
                SwingUtilities.convertPointFromScreen(mouse, this.getOld().getComponent());
                return mouse;
            }

            @Override
            public Dockable getOld() {
                return child;
            }

            @Override
            public DockableDisplayer getOldDisplayer() {
                return this.val$displayer;
            }
        };
        CombinerTarget target = this.combiner.prepare(info, force);
        if (target == null) {
            return null;
        }
        info.setCombineTarget(target);
        return info;
    }

    @Override
    public void drop(Dockable dockable) {
        this.add(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof FlapDockProperty) {
            return this.drop(dockable, (FlapDockProperty)property);
        }
        return false;
    }

    public boolean drop(Dockable dockable, FlapDockProperty property) {
        DockableHandle current;
        DockUtilities.checkLayoutLocked();
        boolean result = false;
        Path placeholder = property.getPlaceholder();
        DockableProperty successor = property.getSuccessor();
        int index = property.getIndex();
        boolean acceptable = this.acceptable(dockable);
        if (placeholder != null && successor != null && (current = (DockableHandle)this.handles.getDockableAt(placeholder)) != null) {
            Dockable oldDockable = current.getDockable();
            DockStation station = oldDockable.asDockStation();
            if (station != null) {
                if (station.drop(dockable, successor)) {
                    result = true;
                    this.handles.removeAll(placeholder);
                }
            } else {
                result = this.combine(current.getDockable(), dockable, successor);
            }
        }
        if (placeholder != null && !result) {
            int listIndex = this.handles.getListIndex(placeholder);
            if (listIndex >= 0) {
                this.add(dockable, property.getIndex(), listIndex);
                this.setHold(dockable, property.isHolding());
                int size = property.getSize();
                if (size >= this.getWindowMinSize()) {
                    this.setWindowSize(dockable, size);
                }
                result = true;
            } else {
                index = this.handles.getDockableIndex(placeholder);
                if (index == -1) {
                    index = property.getIndex();
                }
            }
        }
        if (!result && index >= this.getDockableCount() && acceptable) {
            this.add(dockable);
            this.setHold(dockable, property.isHolding());
            int size = property.getSize();
            if (size >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, size);
            }
            result = true;
        }
        if (!result && successor != null) {
            DockStation previous = this.getDockable(index).asDockStation();
            if (previous != null) {
                if (previous.drop(dockable, successor)) {
                    result = true;
                }
            } else {
                result = this.combine(this.getDockable(index), dockable, successor);
            }
        }
        if (!result && acceptable) {
            this.add(dockable, index);
            this.setHold(dockable, property.isHolding());
            int size = property.getSize();
            if (size >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, size);
            }
            result = true;
        }
        return result;
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable target) {
        int index = this.indexOf(dockable);
        boolean holding = this.isHold(dockable);
        int size = this.getWindowSize(dockable);
        PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        Path placeholder = null;
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(target == null ? dockable : target)) != null) {
            this.handles.dockables().addPlaceholder(index, placeholder);
        }
        return new FlapDockProperty(index, holding, size, placeholder);
    }

    @Override
    public void aside(AsideRequest request) {
        DockableProperty location = request.getLocation();
        if (location instanceof FlapDockProperty) {
            FlapDockProperty flapLocation = (FlapDockProperty)location;
            PlaceholderList.Item item = this.getItem(flapLocation);
            if (item != null) {
                this.delegate().combine(item, this.getCombiner(), request);
            }
            FlapDockProperty copy = flapLocation.copy();
            copy.setSuccessor(null);
            copy.setPlaceholder(request.getPlaceholder());
            request.answer(copy);
        }
    }

    private PlaceholderList.Item getItem(FlapDockProperty property) {
        PlaceholderList.Item item;
        Path oldPlaceholder = property.getPlaceholder();
        if (oldPlaceholder != null && (item = this.handles.getItem(oldPlaceholder)) != null) {
            return item;
        }
        if (property.getIndex() >= 0 && property.getIndex() < this.handles.dockables().size()) {
            int index = this.handles.levelToBase(property.getIndex(), PlaceholderList.Level.DOCKABLE);
            return this.handles.list().get(index);
        }
        return null;
    }

    @Override
    public void move(Dockable dockable, DockableProperty property) {
        DockUtilities.checkLayoutLocked();
        if (property instanceof FlapDockProperty) {
            int index = this.indexOf(dockable);
            if (index < 0) {
                throw new IllegalArgumentException("dockable is not child of this station");
            }
            int destination = ((FlapDockProperty)property).getIndex();
            destination = Math.min(destination, this.handles.dockables().size() - 1);
            if ((destination = Math.max(0, destination)) != index) {
                this.handles.dockables().move(index, destination);
                this.buttonPane.resetTitles();
                this.fireDockablesRepositioned(Math.min(index, destination), Math.max(index, destination));
            }
        }
    }

    public boolean isOverButtons(int x, int y) {
        Point mouse = new Point(x, y);
        SwingUtilities.convertPointFromScreen(mouse, this.buttonPane);
        return this.buttonPane.contains(mouse);
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.remove(dockable);
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public Component getComponent() {
        return this.buttonPane;
    }

    @Override
    public int getDockableCount() {
        return this.handles.dockables().size();
    }

    @Override
    public Dockable getDockable(int index) {
        return ((DockableHandle)this.handles.dockables().get(index)).getDockable();
    }

    public DockTitle getButton(int index) {
        return ((DockableHandle)this.handles.dockables().get(index)).getTitle();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationShowing() && this.getFrontDockable() == dockable;
    }

    protected void recreateTitles() {
        for (DockableHandle handle : this.handles.dockables()) {
            handle.setTitle(this.buttonVersion);
        }
    }

    public void remove(Dockable dockable) {
        int index = this.indexOf(dockable);
        if (index >= 0) {
            this.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        DockUtilities.checkLayoutLocked();
        Dockable dockable = this.getDockable(index);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        if (this.oldFrontDockable == dockable) {
            this.oldFrontDockable = null;
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            DockableHandle handle = (DockableHandle)this.handles.dockables().get(index);
            this.handles.remove(index);
            handle.setTitle(null);
            dockable.removeDockableListener(this.dockableListener);
            this.buttonPane.resetTitles();
            this.listeners.fireDockableRemoved(dockable);
        }
        finally {
            token.release();
        }
        this.fireDockablesRepositioned(index);
    }

    public void add(Dockable dockable) {
        this.add(dockable, this.getDockableCount());
    }

    public void add(Dockable dockable, int index) {
        this.add(dockable, index, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Dockable dockable, int index, int listIndex) {
        DockUtilities.checkLayoutLocked();
        DockUtilities.ensureTreeValidity(this, dockable);
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            DockableHandle handle = this.link(dockable);
            if (listIndex == -1 || this.handles.list().get(listIndex).getDockable() != null) {
                this.handles.dockables().add(index, handle);
            } else if (this.handles.list().get(listIndex).getDockable() == null) {
                this.handles.list().get(listIndex).setDockable(handle);
            }
            dockable.setDockParent(this);
            this.buttonPane.resetTitles();
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(index + 1);
            if (this.getController().isFocused(dockable)) {
                this.setFrontDockable(dockable);
            }
        }
        finally {
            token.release();
        }
    }

    private DockableHandle link(Dockable dockable) {
        DockableHandle handle = this.createHandle(dockable);
        handle.setTitle(this.buttonVersion);
        dockable.addDockableListener(this.dockableListener);
        return handle;
    }

    protected DockableHandle createHandle(Dockable dockable) {
        return new DockableHandle(dockable);
    }

    protected DockableHandle getHandle(Dockable dockable) {
        int index = this.indexOf(dockable);
        if (index < 0) {
            return null;
        }
        return (DockableHandle)this.handles.dockables().get(index);
    }

    public boolean combine(Dockable child, Dockable append) {
        return this.combine(child, append, null);
    }

    public boolean combine(final Dockable child, Dockable append, DockableProperty property) {
        DockUtilities.checkLayoutLocked();
        int index = this.indexOf(child);
        if (index < 0) {
            throw new IllegalArgumentException("Child must be a child of this station");
        }
        int listIndex = this.handles.levelToBase(index, PlaceholderList.Level.DOCKABLE);
        PlaceholderList.Item oldItem = this.handles.list().get(listIndex);
        final PlaceholderMap placeholders = oldItem.getPlaceholderMap();
        FlapDropInfo info = new FlapDropInfo(this, append){

            @Override
            public boolean isMouseOverTitle() {
                return true;
            }

            @Override
            public Dimension getSize() {
                return null;
            }

            @Override
            public PlaceholderMap getPlaceholders() {
                return placeholders;
            }

            @Override
            public Dockable getOld() {
                return child;
            }

            @Override
            public DockableDisplayer getOldDisplayer() {
                return null;
            }

            @Override
            public Point getMousePosition() {
                return null;
            }
        };
        CombinerTarget target = this.combiner.prepare(info, Enforcement.HARD);
        return this.combine(info, target, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean combine(CombinerSource source, CombinerTarget target, DockableProperty property) {
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        Dockable child = source.getOld();
        Dockable append = source.getNew();
        DockUtilities.ensureTreeValidity(this, append);
        try {
            DockStation combined;
            int index;
            if (controller != null) {
                controller.freezeLayout();
            }
            if ((index = this.indexOf(child)) < 0) {
                throw new IllegalArgumentException("old dockable must be a child of this station");
            }
            if (append.getDockParent() != null) {
                append.getDockParent().drag(append);
            }
            boolean hold = this.isHold(child);
            int listIndex = this.handles.levelToBase(index, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item oldItem = this.handles.list().get(listIndex);
            final PlaceholderMap placeholders = oldItem.getPlaceholderMap();
            oldItem.setPlaceholderMap(null);
            this.remove(index);
            int other = this.indexOf(append);
            if (other >= 0) {
                this.remove(other);
                if (other < index) {
                    --index;
                }
            }
            index = Math.min(index, this.getDockableCount());
            Dockable combination = this.combiner.combine(new CombinerSourceWrapper(source){

                @Override
                public PlaceholderMap getPlaceholders() {
                    return placeholders;
                }
            }, target);
            if (property != null && (combined = combination.asDockStation()) != null && append.getDockParent() == combined) {
                combined.move(append, property);
            }
            this.add(combination, index);
            listIndex = this.handles.levelToBase(index, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item newItem = this.handles.list().get(listIndex);
            newItem.setPlaceholderSet(newItem.getPlaceholderSet());
            this.setHold(combination, hold);
            boolean bl = true;
            return bl;
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    @Override
    public boolean canReplace(Dockable old, Dockable next) {
        return true;
    }

    @Override
    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next, true);
    }

    @Override
    public void replace(Dockable child, Dockable append) {
        this.replace(child, append, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(Dockable child, Dockable append, boolean station) {
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        try {
            int index;
            if (controller != null) {
                controller.freezeLayout();
            }
            if ((index = this.indexOf(child)) < 0) {
                throw new IllegalArgumentException("Child must be a child of this station");
            }
            boolean hold = this.isHold(child);
            boolean open = this.getFrontDockable() == child;
            int listIndex = this.handles.levelToBase(index, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item oldItem = this.handles.list().get(listIndex);
            this.remove(index);
            this.handles.list().remove(oldItem);
            this.add(append, index);
            PlaceholderList.Item newItem = this.handles.list().get(listIndex);
            if (station) {
                newItem.setPlaceholderMap(child.asDockStation().getPlaceholders());
            } else {
                newItem.setPlaceholderMap(oldItem.getPlaceholderMap());
            }
            newItem.setPlaceholderSet(oldItem.getPlaceholderSet());
            this.setHold(append, hold);
            if (open) {
                this.setFrontDockable(append);
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    public int indexOf(Dockable dockable) {
        PlaceholderList.Filter list = this.handles.dockables();
        int index = 0;
        for (DockableHandle handle : list) {
            if (handle.getDockable() == dockable) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void checkShowing() {
        boolean showing = this.isDockableShowing();
        if (showing != this.lastShowing) {
            this.lastShowing = showing;
            if (showing) {
                if (this.oldFrontDockable != null) {
                    this.setFrontDockable(this.oldFrontDockable);
                }
            } else {
                this.oldFrontDockable = this.getFrontDockable();
                this.setFrontDockable(null);
                if (!this.isHold(this.oldFrontDockable)) {
                    this.oldFrontDockable = null;
                }
            }
            this.showingManager.fire();
        }
    }

    public static enum Direction {
        NORTH,
        WEST,
        SOUTH,
        EAST;

    }

    private class Listener
    extends DockableAdapter {
        private Listener() {
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle title) {
            int index = FlapDockStation.this.indexOf(dockable);
            if (index < 0) {
                return;
            }
            DockableHandle handle = (DockableHandle)FlapDockStation.this.handles.dockables().get(index);
            if (handle.getTitle() == title) {
                handle.setTitle(FlapDockStation.this.buttonVersion);
            }
        }
    }

    private class ControllerListener
    implements FocusVetoListener,
    DockableFocusListener {
        private ControllerListener() {
        }

        @Override
        public FocusVetoListener.FocusVeto vetoFocus(FocusController controller, Dockable dockable) {
            return FocusVetoListener.FocusVeto.NONE;
        }

        @Override
        public FocusVetoListener.FocusVeto vetoFocus(FocusController controller, DockTitle title) {
            for (DockableHandle handle : FlapDockStation.this.handles.dockables()) {
                if (handle.getTitle() != title) continue;
                return FocusVetoListener.FocusVeto.VETO_NO_CONSUME;
            }
            return FocusVetoListener.FocusVeto.NONE;
        }

        @Override
        public void dockableFocused(DockableFocusEvent event) {
            Dockable front = FlapDockStation.this.getFrontDockable();
            if (FlapDockStation.this.isStationShowing()) {
                if (front == null || front != null && FlapDockStation.this.isHold(front)) {
                    return;
                }
                DockController controller = event.getController();
                Dockable dockable = event.getNewFocusOwner();
                if (controller.isFocused(FlapDockStation.this)) {
                    return;
                }
                if (dockable == null || !DockUtilities.isAncestor(FlapDockStation.this, dockable)) {
                    FlapDockStation.this.setFrontDockable(null);
                }
            }
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
            if (dockable == FlapDockStation.this) {
                FlapDockStation.this.checkShowing();
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.flap");
        }

        @Override
        public DockStation getStation() {
            return FlapDockStation.this;
        }

        @Override
        public Component getComponent() {
            return FlapDockStation.this.getComponent();
        }
    }

    protected class DockableHandle
    implements PlaceholderListItem<Dockable> {
        private Dockable dockable;
        private DockTitleRequest title;
        private ButtonListener buttonListener;
        private FlapDockStationSource actions;

        public DockableHandle(Dockable dockable) {
            this(dockable, false);
        }

        public DockableHandle(Dockable dockable, boolean forceActionSourceCreation) {
            this.dockable = dockable;
            this.buttonListener = new ButtonListener(dockable);
            if (FlapDockStation.this.holdAction != null || forceActionSourceCreation) {
                this.actions = new FlapDockStationSource(FlapDockStation.this, dockable, (DockAction)FlapDockStation.this.holdAction);
                this.actions.updateHoldSwitchable();
            }
        }

        public FlapDockStationSource getActions() {
            return this.actions;
        }

        public void resetHoldAction() {
            if (this.actions != null) {
                this.actions.setHoldAction(FlapDockStation.this.holdAction);
            }
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        @Override
        public Dockable asDockable() {
            return this.getDockable();
        }

        public DockTitle getTitle() {
            if (this.title == null) {
                return null;
            }
            return (DockTitle)this.title.getAnswer();
        }

        public void setTitle(DockTitleVersion version) {
            if (this.title != null) {
                DockTitle answer = (DockTitle)this.title.getAnswer();
                if (answer != null) {
                    answer.removeMouseInputListener(this.buttonListener);
                    this.dockable.unbind(answer);
                    FlapDockStation.this.buttonPane.resetTitles();
                }
                this.title.uninstall();
                this.title = null;
            }
            if (version != null) {
                this.title = new DockTitleRequest(FlapDockStation.this, this.dockable, version){

                    @Override
                    protected void answer(DockTitle previous, DockTitle title) {
                        if (previous != null) {
                            previous.removeMouseInputListener(DockableHandle.this.buttonListener);
                            DockableHandle.this.dockable.unbind(previous);
                        }
                        if (title != null) {
                            title.addMouseInputListener(DockableHandle.this.buttonListener);
                            title.setOrientation(FlapDockStation.this.orientation(FlapDockStation.this.direction));
                            DockableHandle.this.dockable.bind(title);
                        }
                        FlapDockStation.this.buttonPane.resetTitles();
                    }
                };
                this.title.install();
                this.title.request();
            }
        }
    }

    protected class FlapDropOperation
    implements StationDropOperation {
        private FlapDropInfo dropInfo;
        private boolean move;

        public FlapDropOperation(FlapDropInfo dropInfo, boolean move) {
            if (dropInfo == null) {
                throw new IllegalArgumentException("dropInfo must not be null");
            }
            this.dropInfo = dropInfo;
            this.move = move;
        }

        @Override
        public boolean isMove() {
            return this.move;
        }

        @Override
        public void draw() {
            FlapDockStation.this.setDropInfo(this.dropInfo);
        }

        @Override
        public void destroy(StationDropOperation next) {
            if (!(FlapDockStation.this.dropInfo != this.dropInfo || next != null && next instanceof FlapDropOperation && next.getTarget() == this.getTarget())) {
                FlapDockStation.this.setDropInfo(null);
            }
        }

        @Override
        public Dockable getItem() {
            return this.dropInfo.getDockable();
        }

        @Override
        public DockStation getTarget() {
            return FlapDockStation.this;
        }

        @Override
        public CombinerTarget getCombination() {
            return this.dropInfo.getCombineTarget();
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            CombinerTarget target = this.getCombination();
            if (target == null) {
                return null;
            }
            return target.getDisplayerCombination();
        }

        @Override
        public void execute() {
            if (this.isMove()) {
                this.move();
            } else {
                this.drop();
            }
        }

        public void move() {
            if (this.dropInfo.getCombineTarget() != null) {
                FlapDockStation.this.remove(this.dropInfo.getDockable());
                FlapDockStation.this.combine(this.dropInfo, this.dropInfo.getCombineTarget(), null);
            } else {
                int index = FlapDockStation.this.indexOf(this.dropInfo.getDockable());
                if (index < this.dropInfo.getIndex()) {
                    this.dropInfo.setIndex(this.dropInfo.getIndex() - 1);
                }
                FlapDockStation.this.handles.dockables().move(index, this.dropInfo.getIndex());
                FlapDockStation.this.buttonPane.resetTitles();
                FlapDockStation.this.fireDockablesRepositioned(Math.min(index, this.dropInfo.getIndex()), Math.max(index, this.dropInfo.getIndex()));
            }
        }

        public void drop() {
            if (this.dropInfo.getCombineTarget() != null) {
                FlapDockStation.this.combine(this.dropInfo, this.dropInfo.getCombineTarget(), null);
            } else {
                FlapDockStation.this.add(this.dropInfo.getDockable(), this.dropInfo.getIndex());
            }
        }
    }

    private class ButtonListener
    extends MouseInputAdapter {
        private Dockable dockable;

        public ButtonListener(Dockable dockable) {
            this.dockable = dockable;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dockable.getDockParent() == FlapDockStation.this) {
                boolean enabled;
                int MASK = 7168;
                DisablingStrategy strategy = FlapDockStation.this.disablingStrategy.getValue();
                boolean bl = enabled = strategy == null || !strategy.isDisabled(this.dockable) && !strategy.isDisabled(FlapDockStation.this);
                if (enabled && e.getButton() == 1 && (e.getModifiersEx() & 0x1C00) == 0) {
                    int index = FlapDockStation.this.indexOf(this.dockable);
                    if (index < 0) {
                        return;
                    }
                    DockableHandle handle = (DockableHandle)FlapDockStation.this.handles.dockables().get(index);
                    DockTitle title = handle.getTitle();
                    if (FlapDockStation.this.getFrontDockable() == this.dockable && title.isActive()) {
                        FlapDockStation.this.getController().setFocusedDockable(new DefaultFocusRequest(FlapDockStation.this, null, true));
                        FlapDockStation.this.setFrontDockable(null);
                    } else {
                        FlapDockStation.this.getController().setFocusedDockable(new DefaultFocusRequest(this.dockable, null, true));
                    }
                }
            }
        }
    }
}

