/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.AbstractDockStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.DefaultScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.FullscreenActionSource;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenFilter;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationExtension;
import bibliothek.gui.dock.station.screen.ScreenDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowConfiguration;
import bibliothek.gui.dock.station.screen.ScreenDockWindowFactory;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.station.screen.ScreenDropSizeStrategy;
import bibliothek.gui.dock.station.screen.ScreenFullscreenAction;
import bibliothek.gui.dock.station.screen.layer.ScreenLayer;
import bibliothek.gui.dock.station.screen.layer.ScreenWindowLayer;
import bibliothek.gui.dock.station.screen.magnet.AttractorStrategy;
import bibliothek.gui.dock.station.screen.magnet.DefaultMagnetStrategy;
import bibliothek.gui.dock.station.screen.magnet.MagnetController;
import bibliothek.gui.dock.station.screen.magnet.MagnetStrategy;
import bibliothek.gui.dock.station.screen.magnet.MultiAttractorStrategy;
import bibliothek.gui.dock.station.screen.window.DefaultScreenDockWindowConfiguration;
import bibliothek.gui.dock.station.screen.window.DefaultScreenDockWindowFactory;
import bibliothek.gui.dock.station.screen.window.ScreenDockWindowClosingStrategy;
import bibliothek.gui.dock.station.screen.window.ScreenDockWindowHandle;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerSourceWrapper;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderMetaMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ScreenDockStation
extends AbstractDockStation {
    public static final String TITLE_ID = "screen dock";
    public static final String DISPLAYER_ID = "screen";
    public static final Path ATTRACTOR_STRATEGY_EXTENSION = new Path("dock.AttractorStrategy");
    public static final Path STATION_EXTENSION = new Path("dock.ScreenDockStation");
    public static final String EXTENSION_PARAM = "station";
    public static final PropertyKey<BoundaryRestriction> BOUNDARY_RESTRICTION = new PropertyKey<BoundaryRestriction>("ScreenDockStation.boundary_restriction", new ConstantPropertyFactory<BoundaryRestriction>(BoundaryRestriction.MEDIUM), true);
    public static final PropertyKey<ScreenDockWindowFactory> WINDOW_FACTORY = new PropertyKey<DefaultScreenDockWindowFactory>("ScreenDockStation.window_factory", new ConstantPropertyFactory<DefaultScreenDockWindowFactory>(new DefaultScreenDockWindowFactory()), true);
    public static final PropertyKey<ScreenDockWindowClosingStrategy> WINDOW_CLOSING_STRATEGY = new PropertyKey("ScreenDockStation.window_closing");
    public static final PropertyKey<ScreenDockWindowConfiguration> WINDOW_CONFIGURATION = new PropertyKey<ScreenDockWindowConfiguration>("ScreenDockStation.window_configuration", new PropertyFactory<ScreenDockWindowConfiguration>(){

        @Override
        public ScreenDockWindowConfiguration getDefault(PropertyKey<ScreenDockWindowConfiguration> key, DockProperties properties) {
            return new DefaultScreenDockWindowConfiguration(properties.getController());
        }

        @Override
        public ScreenDockWindowConfiguration getDefault(PropertyKey<ScreenDockWindowConfiguration> key) {
            return new DefaultScreenDockWindowConfiguration(null);
        }
    }, true);
    public static final PropertyKey<ScreenDockFullscreenStrategy> FULL_SCREEN_STRATEGY = new PropertyKey<ScreenDockFullscreenStrategy>("ScreenDockStation.full_screen_strategy", new PropertyFactory<ScreenDockFullscreenStrategy>(){

        @Override
        public ScreenDockFullscreenStrategy getDefault(PropertyKey<ScreenDockFullscreenStrategy> key, DockProperties properties) {
            return new DefaultScreenDockFullscreenStrategy();
        }

        @Override
        public ScreenDockFullscreenStrategy getDefault(PropertyKey<ScreenDockFullscreenStrategy> key) {
            return new DefaultScreenDockFullscreenStrategy();
        }
    }, true);
    public static final PropertyKey<Boolean> EXPAND_ON_DOUBLE_CLICK = new PropertyKey<Boolean>("ScreenDockStation.double_click_fullscreen", new ConstantPropertyFactory<Boolean>(true), true);
    public static final PropertyKey<Integer> PREVENT_FOCUS_STEALING_DELAY = new PropertyKey<Integer>("ScreenDockStation.prevent_focus_stealing_delay", new ConstantPropertyFactory<Integer>(500), false);
    public static final PropertyKey<MagnetStrategy> MAGNET_STRATEGY = new PropertyKey<MagnetStrategy>("ScreenDockStation.magnet_strategy", new ConstantPropertyFactory<MagnetStrategy>((MagnetStrategy)new DefaultMagnetStrategy()){

        @Override
        public MagnetStrategy getDefault(PropertyKey<MagnetStrategy> key) {
            return null;
        }
    }, true);
    public static final PropertyKey<AttractorStrategy> ATTRACTOR_STRATEGY = new PropertyKey<AttractorStrategy>("ScreenDockStation.attractor_strategy", new DynamicPropertyFactory<AttractorStrategy>(){

        @Override
        public AttractorStrategy getDefault(PropertyKey<AttractorStrategy> key, DockProperties properties) {
            ExtensionName<AttractorStrategy> name = new ExtensionName<AttractorStrategy>(ATTRACTOR_STRATEGY_EXTENSION, AttractorStrategy.class, null);
            List<AttractorStrategy> extensions = properties.getController().getExtensions().load(name);
            MultiAttractorStrategy strategy = new MultiAttractorStrategy();
            for (AttractorStrategy extension : extensions) {
                strategy.add(extension);
            }
            return strategy;
        }
    }, true);
    public static final PropertyKey<ScreenDropSizeStrategy> DROP_SIZE_STRATEGY = new PropertyKey<ScreenDropSizeStrategy>("ScreendockStation.drop_size_strategy", new ConstantPropertyFactory<ScreenDropSizeStrategy>(ScreenDropSizeStrategy.CURRENT_SIZE), true);
    private boolean showing = false;
    private DockablePlaceholderList<ScreenDockWindowHandle> dockables = new DockablePlaceholderList();
    private List<ScreenDockStationListener> screenDockStationListeners = new ArrayList<ScreenDockStationListener>();
    private DockTitleVersion version;
    private ScreenDockStationExtension[] extensions;
    private StationCombinerValue combiner;
    private DropInfo dropInfo;
    private StationDragOperation dragInfo;
    private WindowProvider owner;
    private DefaultStationPaintValue stationPaint;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private ScreenDockWindow frontWindow;
    private DockableShowingManager visibility;
    private ListeningDockAction fullscreenAction;
    private double dropOverRatio = 0.75;
    private MagnetController magnet;
    private PropertyValue<BoundaryRestriction> restriction = new PropertyValue<BoundaryRestriction>(BOUNDARY_RESTRICTION){

        @Override
        protected void valueChanged(BoundaryRestriction oldValue, BoundaryRestriction newValue) {
            ScreenDockStation.this.checkWindowBoundaries();
        }
    };
    private PropertyValue<ScreenDockWindowFactory> windowFactory = new PropertyValue<ScreenDockWindowFactory>(WINDOW_FACTORY){

        @Override
        protected void valueChanged(ScreenDockWindowFactory oldValue, ScreenDockWindowFactory newValue) {
            ScreenDockStation.this.updateWindows(true);
        }
    };
    private PropertyValue<ScreenDockWindowConfiguration> windowConfiguration = new PropertyValue<ScreenDockWindowConfiguration>(WINDOW_CONFIGURATION){

        @Override
        protected void valueChanged(ScreenDockWindowConfiguration oldValue, ScreenDockWindowConfiguration newValue) {
            ScreenDockStation.this.updateWindows(true);
        }
    };
    private PropertyValue<ScreenDockFullscreenStrategy> fullscreenStrategy = new PropertyValue<ScreenDockFullscreenStrategy>(FULL_SCREEN_STRATEGY){

        @Override
        protected void valueChanged(ScreenDockFullscreenStrategy oldValue, ScreenDockFullscreenStrategy newValue) {
            ArrayList<ScreenDockWindow> fullscreenWindows = new ArrayList<ScreenDockWindow>();
            for (ScreenDockWindowHandle screenDockWindowHandle : ScreenDockStation.this.dockables.dockables()) {
                ScreenDockWindow window = screenDockWindowHandle.getWindow();
                if (!window.isFullscreen()) continue;
                fullscreenWindows.add(window);
                window.setFullscreen(false);
            }
            if (oldValue != null) {
                oldValue.uninstall(ScreenDockStation.this);
            }
            if (newValue != null) {
                newValue.install(ScreenDockStation.this);
            }
            for (ScreenDockWindowHandle screenDockWindowHandle : ScreenDockStation.this.dockables.dockables()) {
                screenDockWindowHandle.getWindow().setFullscreenStrategy(newValue);
            }
            for (ScreenDockWindow screenDockWindow : fullscreenWindows) {
                screenDockWindow.setFullscreen(true);
            }
        }
    };
    private PropertyValue<Boolean> expandOnDoubleClick = new PropertyValue<Boolean>(EXPAND_ON_DOUBLE_CLICK){

        @Override
        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            DockController controller;
            if (oldValue.booleanValue() != newValue.booleanValue() && (controller = ScreenDockStation.this.getController()) != null) {
                if (newValue.booleanValue()) {
                    controller.getDoubleClickController().addListener(ScreenDockStation.this.doubleClickListener);
                } else {
                    controller.getDoubleClickController().removeListener(ScreenDockStation.this.doubleClickListener);
                }
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            ScreenDockStation.this.dockables.setStrategy(newValue);
        }
    };
    private DoubleClickListener doubleClickListener = new DoubleClickListener(){

        @Override
        public DockElement getTreeLocation() {
            return ScreenDockStation.this;
        }

        @Override
        public boolean process(Dockable dockable, MouseEvent event) {
            DockStation parent = dockable.getDockParent();
            while (parent != null && parent != ScreenDockStation.this) {
                dockable = parent.asDockable();
                parent = dockable == null ? null : dockable.getDockParent();
            }
            if (parent == ScreenDockStation.this) {
                for (ScreenDockFullscreenFilter filter : ScreenDockStation.this.filters) {
                    if (filter.isFullscreenEnabled(dockable)) continue;
                    return false;
                }
                boolean state = ScreenDockStation.this.isFullscreen(dockable);
                ScreenDockStation.this.setFullscreen(dockable, !state);
                return true;
            }
            return false;
        }
    };
    private PropertyValue<ScreenDropSizeStrategy> dropSizeStrategy = new PropertyValue<ScreenDropSizeStrategy>(DROP_SIZE_STRATEGY){

        @Override
        protected void valueChanged(ScreenDropSizeStrategy oldValue, ScreenDropSizeStrategy newValue) {
            if (oldValue != null) {
                oldValue.uninstall(ScreenDockStation.this);
            }
            if (newValue != null) {
                newValue.install(ScreenDockStation.this);
            }
        }
    };
    private List<ScreenDockFullscreenFilter> filters = new ArrayList<ScreenDockFullscreenFilter>();
    private List<FullscreenActionSource> filterSources = new LinkedList<FullscreenActionSource>();

    public ScreenDockStation(Window owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.init(new DirectWindowProvider(owner));
    }

    public ScreenDockStation(WindowProvider owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.init(owner);
    }

    private void init(WindowProvider owner) {
        this.visibility = new DockableShowingManager(this.listeners);
        this.owner = owner;
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.screen", this);
        this.combiner = new StationCombinerValue("dock.combiner.screen", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, DISPLAYER_ID);
        this.fullscreenAction = this.createFullscreenAction();
        this.stationPaint = new DefaultStationPaintValue("dock.paint.screen", this);
        this.magnet = new MagnetController(this);
        this.addScreenDockStationListener(new ScreenWindowListener());
        owner.addWindowProviderListener(new WindowProviderListener(){

            @Override
            public void visibilityChanged(WindowProvider provider, boolean showing) {
            }

            @Override
            public void windowChanged(WindowProvider provider, Window window) {
                ScreenDockStation.this.updateWindows();
            }
        });
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    protected ListeningDockAction createFullscreenAction() {
        return new ScreenFullscreenAction(this);
    }

    public void addScreenDockStationListener(ScreenDockStationListener listener) {
        this.screenDockStationListeners.add(listener);
    }

    public void removeScreenDockStationListener(ScreenDockStationListener listener) {
        this.screenDockStationListeners.remove(listener);
    }

    protected ScreenDockStationListener[] screenDockStationListeners() {
        return this.screenDockStationListeners.toArray(new ScreenDockStationListener[this.screenDockStationListeners.size()]);
    }

    public void setFullscreenAction(ListeningDockAction fullScreenAction) {
        if (this.fullscreenAction != null) {
            throw new IllegalStateException("The fullScreenAction can only be set once");
        }
        this.fullscreenAction = fullScreenAction;
    }

    @Override
    public DockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.fullscreenAction == null) {
            return null;
        }
        return this.createFullscreenSource(dockable, new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.VERY_RIGHT));
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        if (this.fullscreenAction == null) {
            return null;
        }
        DockStation parent = dockable.getDockParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof ScreenDockStation) {
            return null;
        }
        dockable = parent.asDockable();
        if (dockable == null) {
            return null;
        }
        parent = dockable.getDockParent();
        if (parent != this) {
            return null;
        }
        return this.createFullscreenSource(dockable, new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.VERY_RIGHT));
    }

    private DockActionSource createFullscreenSource(final Dockable dockable, LocationHint hint) {
        return new FullscreenActionSource(this.fullscreenAction, hint){
            private boolean listening;

            @Override
            protected boolean isFullscreenEnabled() {
                for (ScreenDockFullscreenFilter filter : ScreenDockStation.this.filters) {
                    if (filter.isFullscreenEnabled(dockable)) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected void listen(boolean listening) {
                if (this.listening != listening) {
                    this.listening = listening;
                    if (listening) {
                        ScreenDockStation.this.filterSources.add(this);
                    } else {
                        ScreenDockStation.this.filterSources.remove(this);
                    }
                }
            }
        };
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public StationCombinerValue getCombiner() {
        return this.combiner;
    }

    public DefaultStationPaintValue getPaint() {
        return this.stationPaint;
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new ScreenDockStationFactory(this.owner));
    }

    @Override
    public void setController(DockController controller) {
        DockController old = this.getController();
        if (old != null) {
            if (this.expandOnDoubleClick.getValue().booleanValue()) {
                old.getDoubleClickController().removeListener(this.doubleClickListener);
            }
            this.dockables.unbind();
        }
        this.version = null;
        super.setController(controller);
        this.displayers.setController(controller);
        if (controller != null) {
            this.version = controller.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE);
            if (this.expandOnDoubleClick.getValue().booleanValue()) {
                controller.getDoubleClickController().addListener(this.doubleClickListener);
            }
            this.dockables.bind();
            List<ScreenDockStationExtension> list = controller.getExtensions().load(new ExtensionName<ScreenDockStationExtension>(STATION_EXTENSION, ScreenDockStationExtension.class, EXTENSION_PARAM, this));
            this.extensions = list.toArray(new ScreenDockStationExtension[list.size()]);
        } else {
            this.extensions = null;
        }
        this.stationPaint.setController(controller);
        this.combiner.setController(controller);
        this.displayerFactory.setController(controller);
        this.restriction.setProperties(controller);
        this.windowFactory.setProperties(controller);
        this.windowConfiguration.setProperties(controller);
        this.fullscreenStrategy.setProperties(controller);
        this.placeholderStrategy.setProperties(controller);
        this.magnet.setController(controller);
        this.dropSizeStrategy.setProperties(controller);
        if (this.fullscreenAction != null) {
            this.fullscreenAction.setController(controller);
        }
        for (ScreenDockWindowHandle window : this.dockables.dockables()) {
            window.getWindow().setController(controller);
        }
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int index) {
        return ((ScreenDockWindowHandle)this.dockables.dockables().get(index)).asDockable();
    }

    public int indexOf(Dockable dockable) {
        PlaceholderList.Filter handles = this.dockables.dockables();
        int n = handles.size();
        for (int i = 0; i < n; ++i) {
            ScreenDockWindowHandle window = (ScreenDockWindowHandle)handles.get(i);
            if (window.asDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            @Override
            public DockableProperty getLocationAt(Path placeholder) {
                PlaceholderList.Item item = ScreenDockStation.this.dockables.getItem(placeholder);
                if (item == null) {
                    return null;
                }
                ScreenDockWindowHandle handle = (ScreenDockWindowHandle)item.getDockable();
                if (handle != null) {
                    Dockable dockable = handle.asDockable();
                    ScreenDockProperty property = ScreenDockStation.this.getLocation(dockable, dockable);
                    property.setPlaceholder(placeholder);
                    return property;
                }
                if (item.contains("x", "y", "width", "height")) {
                    int x = item.getInt("x");
                    int y = item.getInt("y");
                    int width = item.getInt("width");
                    int height = item.getInt("height");
                    return new ScreenDockProperty(x, y, width, height, placeholder);
                }
                return null;
            }
        };
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> children) {
        final PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        return this.dockables.toMap(new PlaceholderListItemAdapter<Dockable, ScreenDockWindowHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int index, ScreenDockWindowHandle dockable) {
                Path placeholder;
                Integer id = (Integer)children.get(dockable.asDockable());
                if (id == null) {
                    return null;
                }
                ScreenDockStation.this.saveLocation(index);
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                Rectangle bounds = dockable.getBounds();
                item.putInt("id", id);
                item.putInt("x", bounds.x);
                item.putInt("y", bounds.y);
                item.putInt("width", bounds.width);
                item.putInt("height", bounds.height);
                item.putBoolean("fullscreen", dockable.getWindow().isFullscreen());
                if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable.asDockable())) != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        try {
            DockablePlaceholderList next = new DockablePlaceholderList(placeholders);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = next;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = next;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap map, final Map<Integer, Dockable> children) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        DockController controller = this.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            DockablePlaceholderList<ScreenDockWindowHandle> next = new DockablePlaceholderList<ScreenDockWindowHandle>();
            if (controller != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = next;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = next;
            }
            next.read(map, new PlaceholderListItemAdapter<Dockable, ScreenDockWindowHandle>(){
                private DockHierarchyLock.Token token;

                @Override
                public ScreenDockWindowHandle convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    Dockable dockable = (Dockable)children.get(id);
                    if (dockable != null) {
                        DockUtilities.ensureTreeValidity(ScreenDockStation.this, dockable);
                        this.token = DockHierarchyLock.acquireLinking(ScreenDockStation.this, dockable);
                        int x = item.getInt("x");
                        int y = item.getInt("y");
                        int width = item.getInt("width");
                        int height = item.getInt("height");
                        boolean fullscreen = item.getBoolean("fullscreen");
                        ScreenDockStation.this.listeners.fireDockableAdding(dockable);
                        WindowConfiguration configuration = ScreenDockStation.this.getConfiguration(dockable);
                        ScreenDockWindow window = ScreenDockStation.this.createWindow(configuration);
                        ScreenDockWindowHandle handle = new ScreenDockWindowHandle(dockable, window, configuration);
                        window.setController(ScreenDockStation.this.getController());
                        window.setFullscreenStrategy(ScreenDockStation.this.getFullscreenStrategy());
                        window.setDockable(dockable);
                        window.setWindowBounds(new Rectangle(x, y, width, height));
                        window.setVisible(ScreenDockStation.this.isShowing());
                        window.validate();
                        window.setFullscreen(fullscreen);
                        return handle;
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void added(ScreenDockWindowHandle dockable) {
                    try {
                        dockable.asDockable().setDockParent(ScreenDockStation.this);
                        for (ScreenDockStationListener listener : ScreenDockStation.this.screenDockStationListeners()) {
                            listener.windowRegistering(ScreenDockStation.this, dockable.asDockable(), dockable.getWindow());
                        }
                        ScreenDockStation.this.listeners.fireDockableAdded(dockable.asDockable());
                    }
                    finally {
                        this.token.release();
                    }
                }
            });
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategy.setValue(strategy);
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.frontWindow == null) {
            return null;
        }
        return this.frontWindow.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable newSelected;
        Dockable oldSelected = this.getFrontDockable();
        this.frontWindow = this.getWindow(dockable);
        if (this.frontWindow != null) {
            this.frontWindow.toFront();
        }
        if (oldSelected != (newSelected = this.getFrontDockable())) {
            this.listeners.fireDockableSelected(oldSelected, newSelected);
        }
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        DockStationDropLayer[] result = new DockStationDropLayer[this.getDockableCount() + 1];
        result[0] = new ScreenLayer(this);
        for (int i = 1; i < result.length; ++i) {
            result[i] = new ScreenWindowLayer(this, this.getWindow(i - 1));
        }
        return result;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem item) {
        return this.prepare(item, item.getDockable().getDockParent() != this);
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        final ScreenDockWindow window = this.getWindow(dockable);
        if (this.dragInfo != null) {
            this.dragInfo.canceled();
        }
        if (window != null) {
            window.setPaintRemoval(true);
            this.dragInfo = new StationDragOperation(){

                @Override
                public void succeeded() {
                    window.setPaintRemoval(false);
                    ScreenDockStation.this.dragInfo = null;
                }

                @Override
                public void canceled() {
                    window.setPaintRemoval(false);
                    ScreenDockStation.this.dragInfo = null;
                }
            };
        }
        return this.dragInfo;
    }

    public StationDropOperation prepare(StationDropItem item, boolean drop) {
        DropInfo dropInfo = new DropInfo();
        dropInfo.x = item.getMouseX();
        dropInfo.y = item.getMouseY();
        dropInfo.titleX = item.getTitleX();
        dropInfo.titleY = item.getTitleY();
        dropInfo.dockable = item.getDockable();
        dropInfo.move = !drop;
        Enforcement force = Enforcement.HARD;
        dropInfo.combine = this.searchCombineDockable(dropInfo.x, dropInfo.y, dropInfo.dockable, true);
        if (dropInfo.combine == null) {
            force = Enforcement.EXPECTED;
            dropInfo.combine = this.searchCombineDockable(dropInfo.x, dropInfo.y, dropInfo.dockable, false);
        }
        if (dropInfo.combine != null && dropInfo.combine.getDockable() == dropInfo.dockable) {
            dropInfo.combine = null;
        }
        if (dropInfo.combine != null) {
            dropInfo.combiner = this.combiner.prepare(dropInfo, force);
            if (dropInfo.combiner == null) {
                dropInfo.combine = null;
            }
        }
        if (!this.checkDropInfo(dropInfo)) {
            dropInfo = null;
        }
        return dropInfo;
    }

    private boolean checkDropInfo(DropInfo dropInfo) {
        return !(dropInfo.combine != null ? !this.accept(dropInfo.dockable) || !dropInfo.dockable.accept(this, dropInfo.combine.getDockable()) || !dropInfo.combine.getDockable().accept(this, dropInfo.dockable) || !this.getController().getAcceptance().accept(this, dropInfo.combine.getDockable(), dropInfo.dockable) : !this.accept(dropInfo.dockable) || !dropInfo.dockable.accept(this) || !this.getController().getAcceptance().accept(this, dropInfo.dockable));
    }

    protected ScreenDockWindow searchCombineDockable(int x, int y, Dockable drop, boolean combineArea) {
        for (ScreenDockWindowHandle handle : this.dockables.dockables()) {
            Dockable child;
            ScreenDockWindow window = handle.getWindow();
            boolean candidate = combineArea ? window.inCombineArea(x, y) : window.contains(x, y);
            if (!candidate || !DockUtilities.acceptable(this, child = window.getDockable(), drop)) continue;
            return window;
        }
        return null;
    }

    @Override
    public void drop(Dockable dockable) {
        int height;
        Window owner = this.getOwner();
        int x = 30;
        int y = 30;
        if (owner != null) {
            x += owner.getX();
            y += owner.getY();
        }
        Dimension preferred = this.dropSizeStrategy.getValue().getAddSize(this, dockable);
        int width = Math.max(preferred.width, 100);
        if (!this.drop(dockable, new ScreenDockProperty(x, y, width, height = Math.max(preferred.height, 100)))) {
            this.addDockable(dockable, new Rectangle(x, y, width, height));
        }
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable target) {
        return this.getLocation(dockable, target);
    }

    public ScreenDockProperty getLocation(Dockable dockable, Dockable target) {
        int index = this.indexOf(dockable);
        ScreenDockWindow window = this.getWindow(index);
        if (window == null) {
            throw new IllegalArgumentException("dockable not child of this station");
        }
        Rectangle bounds = null;
        boolean fullscreen = window.isFullscreen();
        if (fullscreen) {
            bounds = window.getNormalBounds();
        }
        if (bounds == null) {
            bounds = window.getWindowBounds();
        }
        PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        Path placeholder = null;
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(target == null ? dockable : target)) != null) {
            this.dockables.dockables().addPlaceholder(index, placeholder);
        }
        return new ScreenDockProperty(bounds.x, bounds.y, bounds.width, bounds.height, placeholder, fullscreen);
    }

    @Override
    public void aside(AsideRequest request) {
        DockableProperty location = request.getLocation();
        if (location instanceof ScreenDockProperty) {
            ScreenDockProperty screenLocation = (ScreenDockProperty)location;
            PlaceholderList.Item item = this.getItem(screenLocation);
            if (item != null) {
                this.delegate().combine(item, this.getCombiner(), request);
            }
            ScreenDockProperty copy = screenLocation.copy();
            copy.setSuccessor(null);
            copy.setPlaceholder(request.getPlaceholder());
            request.answer(copy);
        }
    }

    private PlaceholderList.Item getItem(ScreenDockProperty property) {
        PlaceholderList.Item item;
        Path oldPlaceholder = property.getPlaceholder();
        if (oldPlaceholder != null && (item = this.dockables.getItem(oldPlaceholder)) != null) {
            return item;
        }
        ScreenDockStationExtension.DropArguments args = new ScreenDockStationExtension.DropArguments();
        args.setProperty(property);
        args.setBoundsIncludeWindow(true);
        this.windowAt(args);
        ScreenDockWindow window = args.getWindow();
        if (window != null) {
            return this.dockables.getItem(window.getDockable());
        }
        return null;
    }

    public ScreenDockWindow getWindow(Dockable dockable) {
        int index = this.indexOf(dockable);
        if (index < 0) {
            return null;
        }
        return this.getWindow(index);
    }

    public ScreenDockWindow getWindow(int index) {
        return this.getWindowHandle(index).getWindow();
    }

    private ScreenDockWindowHandle getWindowHandle(int index) {
        return (ScreenDockWindowHandle)this.dockables.dockables().get(index);
    }

    public Dockable[] getFullscreenChildren() {
        ArrayList<Dockable> result = new ArrayList<Dockable>();
        for (ScreenDockWindowHandle handle : this.dockables.dockables()) {
            ScreenDockWindow window = handle.getWindow();
            if (!window.isFullscreen()) continue;
            result.add(window.getDockable());
        }
        return result.toArray(new Dockable[result.size()]);
    }

    public boolean isFullscreen(Dockable dockable) {
        ScreenDockWindow window = this.getWindow(dockable);
        if (window == null) {
            throw new IllegalArgumentException("dockable is not known to this station");
        }
        return window.isFullscreen();
    }

    public void setFullscreen(Dockable dockable, boolean fullscreen) {
        ScreenDockWindow window = this.getWindow(dockable);
        if (window == null) {
            throw new IllegalArgumentException("dockable is not known to this station");
        }
        window.setFullscreen(fullscreen);
    }

    public void addFullscreenFilter(ScreenDockFullscreenFilter filter) {
        this.filters.add(filter);
        this.filterChanged();
    }

    public void removeFullscreenFilter(ScreenDockFullscreenFilter filter) {
        this.filters.remove(filter);
        this.filterChanged();
    }

    private void filterChanged() {
        for (FullscreenActionSource source : this.filterSources) {
            source.update();
        }
    }

    public void setExpandOnDoubleClick(boolean expand) {
        this.expandOnDoubleClick.setValue(expand);
    }

    public void clearExpandOnDoubleClick() {
        this.expandOnDoubleClick.setValue(null);
    }

    public boolean isExpandOnDoubleClick() {
        return this.expandOnDoubleClick.getValue();
    }

    @Override
    public void move(Dockable dockable, DockableProperty property) {
        DockUtilities.checkLayoutLocked();
        if (property instanceof ScreenDockProperty) {
            ScreenDockWindow window = this.getWindow(dockable);
            if (window == null) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            ScreenDockProperty bounds = (ScreenDockProperty)property;
            window.setWindowBounds(new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight()));
        }
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.removeDockable(dockable);
    }

    public void addDockable(Dockable dockable, Rectangle bounds) {
        this.addDockable(dockable, bounds, true);
    }

    public void addDockable(Dockable dockable, Rectangle bounds, boolean boundsIncludeWindow) {
        this.addDockable(dockable, bounds, null, boundsIncludeWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDockable(Dockable dockable, Rectangle bounds, Path placeholder, boolean boundsIncludeWindow) {
        DockUtilities.checkLayoutLocked();
        DockUtilities.ensureTreeValidity(this, dockable);
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            if (bounds == null) {
                throw new IllegalArgumentException("Bounds must not be null");
            }
            this.listeners.fireDockableAdding(dockable);
            WindowConfiguration configuration = this.getConfiguration(dockable);
            ScreenDockWindow window = this.createWindow(configuration);
            this.register(dockable, placeholder, window, configuration);
            window.setDockable(dockable);
            bounds = new Rectangle(bounds);
            if (!boundsIncludeWindow) {
                window.validate();
                Insets estimate = window.getDockableInsets();
                if (estimate != null) {
                    bounds.x -= estimate.left;
                    bounds.y -= estimate.top;
                    bounds.width += estimate.left + estimate.right;
                    bounds.height += estimate.top + estimate.bottom;
                }
            }
            window.setWindowBounds(bounds);
            window.validate();
            if (!boundsIncludeWindow) {
                window.validate();
                Point offset = window.getOffsetDrop();
                if (offset != null) {
                    Rectangle windowBounds = window.getWindowBounds();
                    windowBounds = new Rectangle(windowBounds.x + offset.x, windowBounds.y + offset.y, windowBounds.width, windowBounds.height);
                    window.setWindowBounds(windowBounds);
                }
            }
            if (this.isShowing()) {
                window.setVisible(true);
            }
            dockable.setDockParent(this);
            this.listeners.fireDockableAdded(dockable);
        }
        finally {
            token.release();
        }
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof ScreenDockProperty) {
            return this.drop(dockable, (ScreenDockProperty)property);
        }
        return false;
    }

    public boolean drop(Dockable dockable, ScreenDockProperty property) {
        return this.drop(dockable, property, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, ScreenDockProperty property, boolean boundsIncludeWindow) {
        ScreenDockStationExtension.DropArguments args = new ScreenDockStationExtension.DropArguments();
        args.setDockable(dockable);
        args.setProperty(property);
        args.setBoundsIncludeWindow(boundsIncludeWindow);
        this.windowAt(args);
        if (this.extensions != null) {
            DockController controller = this.getController();
            if (controller != null) {
                controller.freezeLayout();
            }
            try {
                for (ScreenDockStationExtension extension : this.extensions) {
                    extension.drop(this, args);
                }
                boolean result = this.executeDrop(args);
                for (ScreenDockStationExtension extension : this.extensions) {
                    extension.dropped(this, args, result);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                if (controller != null) {
                    controller.meltLayout();
                }
            }
        }
        return this.executeDrop(args);
    }

    private void windowAt(ScreenDockStationExtension.DropArguments args) {
        ScreenDockWindow best = null;
        double bestRatio = 0.0;
        ScreenDockProperty property = args.getProperty();
        int x = property.getX();
        int y = property.getY();
        int width = property.getWidth();
        int height = property.getHeight();
        Path placeholder = property.getPlaceholder();
        if (placeholder != null) {
            ScreenDockWindowHandle handle = (ScreenDockWindowHandle)this.dockables.getDockableAt(placeholder);
            if (handle != null) {
                bestRatio = 1.0;
                best = handle.getWindow();
            } else {
                PlaceholderMetaMap meta = this.dockables.getMetaMap(placeholder);
                if (meta != null) {
                    if (meta.contains("x")) {
                        x = meta.getInt("x");
                    }
                    if (meta.contains("y")) {
                        y = meta.getInt("y");
                    }
                    if (meta.contains("width")) {
                        width = meta.getInt("width");
                    }
                    if (meta.contains("height")) {
                        height = meta.getInt("height");
                    }
                    ScreenDockProperty replacement = new ScreenDockProperty(x, y, width, height, placeholder, property.isFullscreen());
                    replacement.setSuccessor(property.getSuccessor());
                    args.setProperty(replacement);
                    args.setBoundsIncludeWindow(true);
                } else {
                    placeholder = null;
                }
            }
        }
        if (bestRatio == 0.0) {
            double propertySize = width * height;
            for (ScreenDockWindowHandle handle : this.dockables.dockables()) {
                double max;
                double size;
                double ratio;
                ScreenDockWindow window = handle.getWindow();
                if (window.isFullscreen()) continue;
                Rectangle bounds = window.getWindowBounds();
                double windowSize = bounds.width * bounds.height;
                bounds = SwingUtilities.computeIntersection(x, y, width, height, bounds);
                if (bounds.width == 0 || bounds.height == 0 || !((ratio = (size = (double)(bounds.width * bounds.height)) / (max = Math.max(propertySize, windowSize))) > bestRatio)) continue;
                bestRatio = ratio;
                best = window;
            }
        }
        if (bestRatio >= this.dropOverRatio) {
            args.setWindow(best);
        }
    }

    private boolean executeDrop(ScreenDockStationExtension.DropArguments args) {
        DockUtilities.checkLayoutLocked();
        DockUtilities.ensureTreeValidity(this, args.getDockable());
        DockController controller = this.getController();
        MultiDockAcceptance acceptance = controller == null ? null : controller.getAcceptance();
        ScreenDockWindow best = args.getWindow();
        boolean done = false;
        Dockable dockable = args.getDockable();
        ScreenDockProperty property = args.getProperty();
        if (best != null && best.getDockable() != null) {
            Dockable old;
            DockStation station;
            DockableProperty successor = property.getSuccessor();
            Dockable dock = best.getDockable();
            if (successor != null && (station = dock.asDockStation()) != null) {
                done = station.drop(dockable, successor);
            }
            if (!done && (old = best.getDockable()).accept(this, dockable) && dockable.accept(this, old) && (acceptance == null || acceptance.accept(this, old, dockable))) {
                this.combine(old, dockable, property.getSuccessor());
                done = true;
            }
        }
        if (!done) {
            boolean accept;
            boolean bl = accept = this.accept(dockable) && dockable.accept(this) && (acceptance == null || acceptance.accept(this, dockable));
            if (accept) {
                this.addDockable(dockable, new Rectangle(property.getX(), property.getY(), property.getWidth(), property.getHeight()), property.getPlaceholder(), args.isBoundsIncludeWindow());
                done = true;
            }
        }
        if (done && property.isFullscreen()) {
            DockStation parent = dockable.getDockParent();
            while (parent != null && parent != this) {
                dockable = parent.asDockable();
                parent = dockable == null ? null : dockable.getDockParent();
            }
            if (dockable != null) {
                this.setFullscreen(dockable, true);
            }
        }
        return done;
    }

    public boolean drop(Dockable dockable, Dockable location) {
        boolean accept;
        boolean bl = accept = this.accept(dockable) && dockable.accept(this);
        if (!accept) {
            return false;
        }
        ScreenDockWindow window = this.getWindow(location);
        if (window == null) {
            throw new IllegalArgumentException("location is now known to this station");
        }
        Rectangle bounds = null;
        if (window.isFullscreen()) {
            bounds = window.getNormalBounds();
        }
        if (bounds == null) {
            bounds = window.getWindowBounds();
        }
        this.addDockable(dockable, bounds, true);
        return true;
    }

    public void combine(Dockable lower, Dockable upper) {
        this.combine(lower, upper, null);
    }

    public void combine(Dockable lower, Dockable upper, DockableProperty property) {
        DropInfo info = new DropInfo();
        info.dockable = upper;
        info.combine = this.getWindow(lower);
        if (info.combine == null) {
            throw new IllegalArgumentException("lower is not a child of this station");
        }
        Component component = lower.getComponent();
        Point middle = new Point(component.getWidth() / 2, component.getHeight() / 2);
        SwingUtilities.convertPointToScreen(middle, component);
        info.x = middle.x;
        info.y = middle.y;
        info.titleX = info.x;
        info.titleY = info.y;
        info.combiner = this.combiner.prepare(info, Enforcement.HARD);
        this.combine(info, info.combiner, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combine(CombinerSource source, CombinerTarget target, DockableProperty property) {
        DockStation combined;
        DockUtilities.checkLayoutLocked();
        Dockable lower = source.getOld();
        Dockable upper = source.getNew();
        int index = this.indexOf(lower);
        if (index < 0) {
            throw new IllegalArgumentException("old is not child of this station");
        }
        ScreenDockWindowHandle window = this.getWindowHandle(index);
        this.removeDockable(upper);
        index = this.indexOf(lower);
        final Dockable old = window.getWindow().getDockable();
        int listIndex = this.dockables.levelToBase(index, PlaceholderList.Level.DOCKABLE);
        PlaceholderList.Item item = this.dockables.list().get(listIndex);
        final PlaceholderMap map = item.getPlaceholderMap();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, lower);
        try {
            this.listeners.fireDockableRemoving(lower);
            item.setPlaceholderMap(null);
            window.setDockable(null);
            lower.setDockParent(null);
        }
        finally {
            token.release();
        }
        this.listeners.fireDockableRemoved(lower);
        Dockable valid = this.combiner.combine(new CombinerSourceWrapper(source){

            @Override
            public PlaceholderMap getPlaceholders() {
                return map;
            }

            @Override
            public Dockable getOld() {
                return old;
            }
        }, target);
        if (property != null && (combined = valid.asDockStation()) != null && upper.getDockParent() == combined) {
            combined.move(upper, property);
        }
        token = DockHierarchyLock.acquireLinking(this, valid);
        try {
            this.listeners.fireDockableAdding(valid);
            window.setDockable(valid);
            valid.setDockParent(this);
            this.listeners.fireDockableAdded(valid);
        }
        finally {
            token.release();
        }
    }

    @Override
    public boolean canReplace(Dockable old, Dockable next) {
        if (this.extensions != null) {
            for (ScreenDockStationExtension extension : this.extensions) {
                if (extension.canReplace(this, old, next)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next, true);
    }

    @Override
    public void replace(Dockable current, Dockable other) {
        this.replace(current, other, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Dockable current, Dockable other, boolean station) {
        DockUtilities.checkLayoutLocked();
        int index = this.indexOf(current);
        if (index < 0) {
            throw new IllegalArgumentException("current not known to this station");
        }
        DockUtilities.ensureTreeValidity(this, other);
        ScreenDockWindowHandle window = this.getWindowHandle(index);
        if (station) {
            int listIndex = this.dockables.levelToBase(index, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.dockables.list().get(listIndex);
            item.setPlaceholderMap(current.asDockStation().getPlaceholders());
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, current);
        try {
            this.listeners.fireDockableRemoving(current);
            window.setDockable(null);
            current.setDockParent(null);
            this.listeners.fireDockableRemoved(current);
        }
        finally {
            token.release();
        }
        token = DockHierarchyLock.acquireLinking(this, other);
        try {
            this.listeners.fireDockableAdding(other);
            window.setDockable(other);
            other.setDockParent(this);
            this.listeners.fireDockableAdded(other);
        }
        finally {
            token.release();
        }
    }

    public void removeDockable(Dockable dockable) {
        int index = this.indexOf(dockable);
        if (index >= 0) {
            this.removeDockable(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDockable(int index) {
        DockUtilities.checkLayoutLocked();
        ScreenDockWindowHandle handle = this.getWindowHandle(index);
        ScreenDockWindow window = handle.getWindow();
        Dockable dockable = window.getDockable();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            window.setVisible(false);
            this.deregister(dockable, window);
            handle.setDockable(null);
            dockable.setDockParent(null);
            this.listeners.fireDockableRemoved(dockable);
        }
        finally {
            token.release();
        }
    }

    protected ScreenDockWindowHandle register(Dockable dockable, Path placeholder, ScreenDockWindow window, WindowConfiguration configuration) {
        ScreenDockWindowHandle handle = new ScreenDockWindowHandle(dockable, window, configuration);
        if (placeholder != null) {
            if (this.dockables.getDockableAt(placeholder) != null) {
                throw new IllegalStateException("there is already a window in the group " + placeholder + ", add the element directly to that window or do not use a placeholder");
            }
            if (this.dockables.put(placeholder, handle) == -1) {
                this.dockables.dockables().add(handle);
            }
        } else {
            this.dockables.dockables().add(handle);
        }
        window.setController(this.getController());
        window.setFullscreenStrategy(this.getFullscreenStrategy());
        this.getRootHandler().addRoot(window.getComponent());
        for (ScreenDockStationListener listener : this.screenDockStationListeners()) {
            listener.windowRegistering(this, dockable, window);
        }
        return handle;
    }

    protected void deregister(Dockable dockable, ScreenDockWindow window) {
        if (this.frontWindow == window) {
            this.frontWindow = null;
        }
        int index = this.indexOf(window.getDockable());
        this.saveLocation(index);
        this.dockables.remove(index);
        this.getRootHandler().removeRoot(window.getComponent());
        window.setDockable(null);
        window.setPaintCombining(null);
        window.setController(null);
        window.setFullscreenStrategy(null);
        for (ScreenDockStationListener listener : this.screenDockStationListeners()) {
            listener.windowDeregistering(this, dockable, window);
        }
        window.destroy();
    }

    private void saveLocation(int index) {
        ScreenDockWindow window = ((ScreenDockWindowHandle)this.dockables.dockables().get(index)).getWindow();
        PlaceholderMetaMap map = this.dockables.dockables().getMetaMap(index);
        Rectangle bounds = null;
        if (window.isFullscreen()) {
            bounds = window.getNormalBounds();
        }
        if (bounds == null) {
            bounds = window.getWindowBounds();
        }
        map.putInt("x", bounds.x);
        map.putInt("y", bounds.y);
        map.putInt("width", bounds.width);
        map.putInt("height", bounds.height);
    }

    protected WindowConfiguration getConfiguration(Dockable dockable) {
        WindowConfiguration result = this.windowConfiguration.getValue().getConfiguration(this, dockable);
        if (result == null) {
            result = new WindowConfiguration();
        }
        return result;
    }

    protected ScreenDockWindow createWindow(WindowConfiguration configuration) {
        return this.getWindowFactory().createWindow(this, configuration);
    }

    protected void updateWindows() {
        this.updateWindows(false);
    }

    protected void updateWindows(boolean force) {
        ScreenDockWindowFactory factory = this.getWindowFactory();
        Integer delay = PREVENT_FOCUS_STEALING_DELAY.getDefault(null);
        DockController controller = this.getController();
        if (controller != null) {
            delay = controller.getProperties().get(PREVENT_FOCUS_STEALING_DELAY);
        }
        for (ScreenDockWindowHandle handle : this.dockables.dockables()) {
            ScreenDockWindow newWindow;
            WindowConfiguration configuration;
            ScreenDockWindow oldWindow = handle.getWindow();
            if (force) {
                configuration = this.getConfiguration(oldWindow.getDockable());
                newWindow = this.createWindow(configuration);
            } else {
                configuration = handle.getConfiguration();
                newWindow = factory.updateWindow(oldWindow, configuration, this);
            }
            if (newWindow == null || newWindow == oldWindow) continue;
            Dockable dockable = oldWindow.getDockable();
            Rectangle bounds = oldWindow.getNormalBounds();
            if (bounds == null) {
                bounds = oldWindow.getWindowBounds();
            }
            boolean fullscreen = oldWindow.isFullscreen();
            boolean visible = oldWindow.isVisible();
            oldWindow.setDockable(null);
            oldWindow.setPaintCombining(null);
            oldWindow.setController(null);
            oldWindow.setFullscreenStrategy(null);
            for (ScreenDockStationListener listener : this.screenDockStationListeners()) {
                listener.windowDeregistering(this, dockable, oldWindow);
            }
            oldWindow.destroy();
            handle.setWindow(newWindow, configuration);
            newWindow.setController(this.getController());
            newWindow.setFullscreenStrategy(this.getFullscreenStrategy());
            newWindow.setWindowBounds(bounds);
            newWindow.setFullscreen(fullscreen);
            for (ScreenDockStationListener listener : this.screenDockStationListeners()) {
                listener.windowRegistering(this, dockable, newWindow);
            }
            if (!visible || !this.isShowing()) continue;
            if (delay == null || delay <= 0) {
                newWindow.setVisible(true);
                continue;
            }
            newWindow.setPreventFocusStealing(true);
            newWindow.setVisible(true);
            Timer timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    newWindow.setPreventFocusStealing(false);
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    public Window getOwner() {
        return this.owner.searchWindow();
    }

    public WindowProvider getProvider() {
        return this.owner;
    }

    public ScreenDockWindowFactory getWindowFactory() {
        return this.windowFactory.getValue();
    }

    protected PropertyValue<ScreenDockWindowFactory> getWindowFactoryProperty() {
        return this.windowFactory;
    }

    public void setWindowFactory(ScreenDockWindowFactory factory) {
        this.windowFactory.setValue(factory);
    }

    public ScreenDockWindowConfiguration getWindowConfiguration() {
        return this.windowConfiguration.getValue();
    }

    protected PropertyValue<ScreenDockWindowConfiguration> getWindowConfigurationProperty() {
        return this.windowConfiguration;
    }

    public void setWindowConfiguration(ScreenDockWindowConfiguration configuration) {
        this.windowConfiguration.setValue(configuration);
    }

    public ScreenDockFullscreenStrategy getFullscreenStrategy() {
        return this.fullscreenStrategy.getValue();
    }

    public void setFullscreenStrategy(ScreenDockFullscreenStrategy strategy) {
        this.fullscreenStrategy.setValue(strategy);
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean showing) {
        if (this.showing != showing) {
            this.showing = showing;
            for (ScreenDockWindowHandle window : this.dockables.dockables()) {
                window.getWindow().setVisible(showing);
            }
            this.visibility.fire();
        }
    }

    @Override
    public boolean isStationShowing() {
        return this.isShowing();
    }

    @Override
    @Deprecated
    public boolean isStationVisible() {
        return this.isShowing();
    }

    @Override
    public boolean isChildShowing(Dockable dockable) {
        return this.isVisible(dockable);
    }

    @Override
    @Deprecated
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible();
    }

    public Rectangle getStationBounds() {
        return null;
    }

    @Override
    public Dockable asDockable() {
        return null;
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return TITLE_ID;
    }

    public DockTitleVersion getTitleVersion() {
        return this.version;
    }

    public BoundaryRestriction getBoundaryRestriction() {
        return this.restriction.getValue();
    }

    public void setBoundaryRestriction(BoundaryRestriction restriction) {
        this.restriction.setValue(restriction);
    }

    public void checkWindowBoundaries() {
        for (ScreenDockWindowHandle window : this.dockables.dockables()) {
            window.getWindow().checkWindowBounds();
        }
    }

    public MagnetController getMagnetController() {
        return this.magnet;
    }

    public double getDropOverRatio() {
        return this.dropOverRatio;
    }

    public void setDropOverRatio(double dropOverRatio) {
        if (dropOverRatio < 0.0 || dropOverRatio > 1.0) {
            throw new IllegalArgumentException("dropOverRatio must be between 0 and 1");
        }
        this.dropOverRatio = dropOverRatio;
    }

    private ScreenDockWindowClosingStrategy getWindowClosingStrategy() {
        DockController controller = this.getController();
        if (controller == null) {
            return null;
        }
        return controller.getProperties().get(WINDOW_CLOSING_STRATEGY);
    }

    private class ScreenWindowListener
    implements ScreenDockStationListener,
    ScreenDockWindowListener {
        private ScreenWindowListener() {
        }

        @Override
        public void fullscreenChanged(ScreenDockStation station, Dockable dockable) {
            ScreenDockStation.this.listeners.fireDockablesRepositioned(dockable);
        }

        @Override
        public void windowDeregistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
            window.removeScreenDockWindowListener(this);
        }

        @Override
        public void windowRegistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
            window.addScreenDockWindowListener(this);
        }

        @Override
        public void fullscreenStateChanged(ScreenDockWindow window) {
            Dockable dockable = window.getDockable();
            if (dockable != null) {
                for (ScreenDockStationListener listener : ScreenDockStation.this.screenDockStationListeners()) {
                    listener.fullscreenChanged(ScreenDockStation.this, dockable);
                }
            }
        }

        @Override
        public void shapeChanged(ScreenDockWindow window) {
            Dockable dockable = window.getDockable();
            if (dockable != null) {
                ScreenDockStation.this.listeners.fireDockablesRepositioned(dockable);
            }
        }

        @Override
        public void visibilityChanged(ScreenDockWindow window) {
        }

        @Override
        public void windowClosing(ScreenDockWindow window) {
            ScreenDockWindowClosingStrategy strategy = ScreenDockStation.this.getWindowClosingStrategy();
            if (strategy != null) {
                strategy.closing(window);
            }
        }
    }

    private class DropInfo
    implements CombinerSource,
    StationDropOperation {
        public Dockable dockable;
        public int x;
        public int y;
        public int titleX;
        public int titleY;
        public ScreenDockWindow combine;
        public CombinerTarget combiner;
        public boolean move;

        private DropInfo() {
        }

        @Override
        public Point getMousePosition() {
            Point point = new Point(this.x, this.y);
            SwingUtilities.convertPointFromScreen(point, this.combine.getDockable().getComponent());
            return point;
        }

        @Override
        public void draw() {
            ScreenDockStation.this.dropInfo = this;
            if (this.combine != null) {
                this.combine.setPaintCombining(ScreenDockStation.this.dropInfo.combiner);
            }
        }

        @Override
        public void destroy(StationDropOperation next) {
            if (this.combine != null) {
                this.combine.setPaintCombining(null);
            }
            if (ScreenDockStation.this.dropInfo == this) {
                ScreenDockStation.this.dropInfo = null;
            }
        }

        @Override
        public DockStation getTarget() {
            return ScreenDockStation.this;
        }

        @Override
        public Dockable getItem() {
            return this.dockable;
        }

        @Override
        public CombinerTarget getCombination() {
            return this.combiner;
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            CombinerTarget target = this.getCombination();
            if (target == null) {
                return null;
            }
            return target.getDisplayerCombination();
        }

        @Override
        public Dimension getSize() {
            return this.combine.getDockable().getComponent().getSize();
        }

        @Override
        public boolean isMouseOverTitle() {
            return this.combine.inTitleArea(this.x, this.y);
        }

        @Override
        public Dockable getNew() {
            return this.dockable;
        }

        @Override
        public Dockable getOld() {
            return this.combine.getDockable();
        }

        @Override
        public DockableDisplayer getOldDisplayer() {
            return this.combine.getDockableDisplayer();
        }

        @Override
        public DockStation getParent() {
            return ScreenDockStation.this;
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            for (PlaceholderList.Item item : ScreenDockStation.this.dockables.list()) {
                ScreenDockWindowHandle handle = (ScreenDockWindowHandle)item.getDockable();
                if (handle == null || handle.getWindow() != this.combine) continue;
                return item.getPlaceholderMap();
            }
            return null;
        }

        @Override
        public boolean isMove() {
            return this.move;
        }

        @Override
        public void execute() {
            if (this.isMove()) {
                this.move();
            } else {
                this.drop();
            }
        }

        private void move() {
            DockUtilities.checkLayoutLocked();
            if (this.combine != null) {
                ScreenDockStation.this.combine(ScreenDockStation.this.dropInfo, this.combiner, null);
            } else {
                ScreenDockWindow window = ScreenDockStation.this.getWindow(this.dockable);
                Point zero = window.getOffsetMove();
                if (zero == null) {
                    zero = new Point(0, 0);
                }
                Rectangle bounds = window.getWindowBounds();
                bounds = new Rectangle(this.titleX - zero.x, this.titleY - zero.y, bounds.width, bounds.height);
                window.setWindowBounds(bounds);
            }
        }

        private void drop() {
            if (this.combine != null) {
                ScreenDockStation.this.combine(ScreenDockStation.this.dropInfo, this.combiner, null);
            } else {
                Dimension size = ScreenDockStation.this.dropSizeStrategy.getValue().getDropSize(ScreenDockStation.this, this.dockable);
                ScreenDockProperty property = new ScreenDockProperty(this.titleX, this.titleY, size.width, size.height);
                ScreenDockStation.this.drop(this.dockable, property, false);
            }
        }
    }
}

