/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.stack.DefaultStackDockComponent;
import bibliothek.gui.dock.station.stack.DndAutoSelectStrategy;
import bibliothek.gui.dock.station.stack.StackDnDAutoSelectSupport;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.TabDropLayer;
import bibliothek.gui.dock.station.stack.tab.TabConfigurations;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ComponentDragOperation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class StackDockStation
extends AbstractDockableStation
implements StackDockComponentParent {
    public static final String TITLE_ID = "stack";
    public static final String DISPLAYER_ID = "stack";
    public static final PropertyKey<StackDockComponentFactory> COMPONENT_FACTORY = new PropertyKey("stack dock component factory");
    public static final PropertyKey<TabPlacement> TAB_PLACEMENT = new PropertyKey<TabPlacement>("stack dock station tab side", new ConstantPropertyFactory<TabPlacement>(TabPlacement.TOP_OF_DOCKABLE), true);
    public static final PropertyKey<TabContentFilter> TAB_CONTENT_FILTER = new PropertyKey("stack dock tab content filter");
    public static final PropertyKey<Boolean> IMMUTABLE_SELECTION_INDEX = new PropertyKey<Boolean>("stack dock immutable selection index", new ConstantPropertyFactory<Boolean>(false), true);
    public static final PropertyKey<TabConfigurations> TAB_CONFIGURATIONS = new PropertyKey<TabConfigurations>("stack dock tab configurations", new ConstantPropertyFactory<TabConfigurations>(TabConfigurations.DEFAULT), true);
    public static final PropertyKey<StackDnDAutoSelectSupport> DND_AUTO_SELECT_SUPPORT = new PropertyKey("stack dock auto select");
    public static final PropertyKey<DndAutoSelectStrategy> DND_AUTO_SELECT_STRATEGY = new PropertyKey<DndAutoSelectStrategy>("stack dock auto select strategy", new ConstantPropertyFactory<DndAutoSelectStrategy>(DndAutoSelectStrategy.DEFAULT), true);
    private DockablePlaceholderList<StationChildHandle> dockables = new DockablePlaceholderList();
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private DockableShowingManager visibility;
    private DefaultStationPaintValue paint;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private Insert insert;
    private ComponentDragOperation dragOperation;
    private Background background;
    private JComponent panel;
    private PanelBackground panelBackground = new PanelBackground();
    private StackDockComponent stackComponent;
    private StackDockComponentRepresentative stackComponentRepresentative;
    private PropertyValue<StackDockComponentFactory> stackComponentFactory;
    private PropertyValue<TabPlacement> tabPlacement;
    private DockTitleVersion title;
    private Listener listener = new Listener();
    private boolean smallMinimumSize = true;
    private boolean updatingTheme = false;
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            StackDockStation.this.dockables.setStrategy(newValue);
        }
    };
    private PropertyValue<TabContentFilter> tabContentFilter = new PropertyValue<TabContentFilter>(TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter oldValue, TabContentFilter newValue) {
            if (oldValue != newValue) {
                if (oldValue != null) {
                    oldValue.removeListener(StackDockStation.this.tabContentFilterListener);
                    oldValue.uninstall(StackDockStation.this);
                }
                if (newValue != null) {
                    newValue.install(StackDockStation.this);
                    newValue.addListener(StackDockStation.this.tabContentFilterListener);
                }
                StackDockStation.this.tabContentFilterListener.contentChanged();
            }
        }
    };
    private TabContentFilterListener tabContentFilterListener = new TabContentFilterListener(){

        @Override
        public void contentChanged() {
            int count = StackDockStation.this.getDockableCount();
            for (int i = 0; i < count; ++i) {
                StackDockStation.this.updateContent(i);
            }
        }

        @Override
        public void contentChanged(StackDockComponent component) {
        }

        @Override
        public void contentChanged(StackDockStation station) {
            if (StackDockStation.this == station) {
                this.contentChanged();
            }
        }

        @Override
        public void contentChanged(Dockable dockable) {
            int index;
            if (dockable.getDockParent() == StackDockStation.this && (index = StackDockStation.this.indexOf(dockable)) >= 0) {
                StackDockStation.this.updateContent(index);
            }
        }
    };
    private PropertyValue<StackDnDAutoSelectSupport> autoSelectSupport = new PropertyValue<StackDnDAutoSelectSupport>(DND_AUTO_SELECT_SUPPORT){

        @Override
        protected void valueChanged(StackDnDAutoSelectSupport oldValue, StackDnDAutoSelectSupport newValue) {
            StackDockComponent component = StackDockStation.this.getStackComponent();
            if (component != null) {
                if (oldValue != null) {
                    oldValue.uninstall(component);
                }
                if (newValue != null) {
                    newValue.install(StackDockStation.this, component);
                }
            }
        }
    };
    private VisibleListener visibleListener;
    private Dockable lastSelectedDockable = null;

    public StackDockStation() {
        this(null);
    }

    public StackDockStation(DockTheme theme) {
        super(theme);
        this.init();
    }

    protected StackDockStation(DockTheme theme, boolean init) {
        super(theme);
        if (init) {
            this.init();
        }
    }

    protected void init() {
        this.paint = new DefaultStationPaintValue("dock.paint.stack", this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.stack", this);
        this.visibleListener = new VisibleListener();
        this.visibility = new DockableShowingManager(this.listeners);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, "stack");
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer displayer) {
                StackDockStation.this.discard(displayer);
            }

            @Override
            public void moveableElementChanged(DockableDisplayer displayer) {
            }
        });
        this.background = this.createBackground();
        this.background.setController(this.getController());
        this.panel = this.background.getContentPane();
        this.stackComponentFactory = new PropertyValue<StackDockComponentFactory>(COMPONENT_FACTORY){

            @Override
            protected void valueChanged(StackDockComponentFactory oldValue, StackDockComponentFactory newValue) {
                if (newValue == null) {
                    StackDockStation.this.setStackComponent(StackDockStation.this.createStackDockComponent());
                } else {
                    StackDockStation.this.setStackComponent(newValue.create(StackDockStation.this));
                }
            }
        };
        this.tabPlacement = new PropertyValue<TabPlacement>(TAB_PLACEMENT){

            @Override
            protected void valueChanged(TabPlacement oldValue, TabPlacement newValue) {
                if (StackDockStation.this.stackComponent != null) {
                    StackDockStation.this.stackComponent.setDockTabPlacement(newValue);
                }
            }
        };
        this.stackComponent = this.createStackDockComponent();
        this.stackComponent.addStackDockComponentListener(this.visibleListener);
        this.stackComponentRepresentative = new StackDockComponentRepresentative();
        this.stackComponentRepresentative.setComponent(this.stackComponent);
        this.stackComponentRepresentative.setTarget(this);
        this.addDockStationListener(new DockStationAdapter(){

            @Override
            public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
                StackDockStation.this.lastSelectedDockable = newSelection;
            }
        });
        this.panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (StackDockStation.this.getDockParent() == null) {
                        StackDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    StackDockStation.this.visibility.fire();
                }
            }
        });
    }

    protected Background createBackground() {
        return new Background();
    }

    protected StackDockComponent createStackDockComponent() {
        return new DefaultStackDockComponent();
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    @Override
    public DockStation getStackDockParent() {
        return this;
    }

    public void setTabPlacement(TabPlacement placement) {
        this.tabPlacement.setValue(placement);
    }

    public TabPlacement getTabPlacement() {
        return this.tabPlacement.getValue();
    }

    public void setTabContentFilter(TabContentFilter filter) {
        this.tabContentFilter.setValue(filter);
    }

    public TabContentFilter getTabContentFilter() {
        return this.tabContentFilter.getValue();
    }

    protected boolean singleTabStackDockComponent() {
        StackDockComponent component = this.getStackComponent();
        if (component == null) {
            return false;
        }
        return component.isSingleTabComponent();
    }

    public void setStackComponent(StackDockComponent stackComponent) {
        if (stackComponent == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        if (stackComponent != this.stackComponent) {
            Object component;
            int selected = -1;
            StackDnDAutoSelectSupport autoSelectSupport = this.autoSelectSupport.getValue();
            if (this.stackComponent != null) {
                this.stackComponent.setController(null);
                component = this.stackComponent.getComponent();
                for (MouseInputListener listener : this.mouseInputListeners) {
                    ((Component)component).removeMouseListener(listener);
                    ((Component)component).removeMouseMotionListener(listener);
                }
                selected = this.stackComponent.getSelectedIndex();
                this.stackComponent.removeStackDockComponentListener(this.visibleListener);
                this.stackComponent.removeAll();
                if (autoSelectSupport != null) {
                    autoSelectSupport.uninstall(this.stackComponent);
                }
            }
            this.stackComponent = stackComponent;
            stackComponent.setDockTabPlacement(this.tabPlacement.getValue());
            this.stackComponentRepresentative.setComponent(stackComponent);
            if (this.getDockableCount() < 2 && !this.singleTabStackDockComponent()) {
                stackComponent.addStackDockComponentListener(this.visibleListener);
            } else {
                this.panel.removeAll();
                for (StationChildHandle handle : this.dockables.dockables()) {
                    DockableDisplayer displayer = handle.getDisplayer();
                    int index = stackComponent.getTabCount();
                    this.insertTab(displayer, index);
                }
                this.panel.add(stackComponent.getComponent());
                if (selected >= 0 && selected < stackComponent.getTabCount()) {
                    stackComponent.setSelectedIndex(selected);
                }
                stackComponent.addStackDockComponentListener(this.visibleListener);
            }
            component = stackComponent.getComponent();
            stackComponent.setController(this.getController());
            for (MouseInputListener listener : this.mouseInputListeners) {
                ((Component)component).addMouseListener(listener);
                ((Component)component).addMouseMotionListener(listener);
            }
            if (autoSelectSupport != null) {
                autoSelectSupport.install(this, this.stackComponent);
            }
            this.updateConfigurableDisplayerHints();
        }
    }

    public StackDockComponent getStackComponent() {
        return this.stackComponent;
    }

    public void setStackComponentFactory(StackDockComponentFactory factory) {
        this.stackComponentFactory.setValue(factory);
    }

    public StackDockComponentFactory getStackComponentFactory() {
        return this.stackComponentFactory.getOwnValue();
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        try {
            this.updatingTheme = true;
            DockUI.updateTheme(this, new StackDockStationFactory());
        }
        finally {
            this.updatingTheme = false;
        }
    }

    @Override
    public void setDockParent(DockStation station) {
        DockStation old = this.getDockParent();
        if (old != null) {
            old.removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(station);
        if (station != null) {
            station.addDockStationListener(this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController controller) {
        if (this.getController() != controller) {
            boolean isNull;
            for (StationChildHandle handle : this.dockables.dockables()) {
                handle.setTitleRequest(null);
            }
            boolean wasNull = this.getController() == null;
            this.background.setController(controller);
            this.stackComponentFactory.setProperties(controller);
            super.setController(controller);
            this.stackComponent.setController(controller);
            this.tabPlacement.setProperties(controller);
            this.placeholderStrategy.setProperties(controller);
            this.tabContentFilter.setProperties(controller);
            this.stackComponentRepresentative.setController(controller);
            this.paint.setController(controller);
            this.displayerFactory.setController(controller);
            this.panelBackground.setController(controller);
            this.autoSelectSupport.setProperties(controller);
            this.title = controller != null ? controller.getDockTitleManager().getVersion("stack", ControllerTitleFactory.INSTANCE) : null;
            this.displayers.setController(controller);
            boolean bl = isNull = controller == null;
            if (wasNull != isNull) {
                if (wasNull) {
                    this.dockables.bind();
                } else {
                    this.dockables.unbind();
                }
            }
            for (StationChildHandle handle : this.dockables.dockables()) {
                handle.setTitleRequest(this.title, true);
            }
            this.visibility.fire();
        }
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    @Override
    public boolean isStationVisible() {
        DockStation parent = this.getDockParent();
        if (parent != null) {
            return parent.isChildShowing(this);
        }
        return this.panel.isDisplayable();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (this.dockables.dockables().size() == 1 || this.indexOf(dockable) == this.stackComponent.getSelectedIndex());
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int index) {
        return ((StationChildHandle)this.dockables.dockables().get(index)).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable target) {
        int index = this.indexOf(dockable);
        PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        Path placeholder = null;
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(target == null ? dockable : target)) != null) {
            this.dockables.dockables().addPlaceholder(index, placeholder);
        }
        return new StackDockProperty(index, placeholder);
    }

    @Override
    public void aside(AsideRequest request) {
        int index;
        DockableProperty location = request.getLocation();
        Path newPlaceholder = request.getPlaceholder();
        if (location instanceof StackDockProperty) {
            StackDockProperty stackLocation = (StackDockProperty)location;
            index = this.dockables.getNextListIndex(stackLocation.getIndex(), stackLocation.getPlaceholder());
            if (newPlaceholder != null) {
                this.dockables.list().insertPlaceholder(index, newPlaceholder);
            }
        } else {
            index = this.dockables.dockables().size();
            if (newPlaceholder != null) {
                this.dockables.dockables().insertPlaceholder(index, newPlaceholder);
            }
        }
        request.answer(new StackDockProperty(index, newPlaceholder));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.dockables.dockables().size() == 0) {
            return null;
        }
        if (this.dockables.dockables().size() == 1) {
            return ((StationChildHandle)this.dockables.dockables().get(0)).getDockable();
        }
        int index = this.stackComponent.getSelectedIndex();
        if (index >= 0) {
            return ((StationChildHandle)this.dockables.dockables().get(index)).getDockable();
        }
        return null;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        if (this.dockables.dockables().size() > 1 && dockable != null) {
            this.stackComponent.setSelectedIndex(this.indexOf(dockable));
        }
        this.fireDockableSelected();
    }

    protected void fireDockableSelected() {
        Dockable selection = this.getFrontDockable();
        if (this.lastSelectedDockable != selection) {
            this.listeners.fireDockableSelected(this.lastSelectedDockable, selection);
        }
    }

    @Override
    public int indexOf(Dockable dockable) {
        int index = 0;
        for (StationChildHandle check : this.dockables.dockables()) {
            if (check.getDockable() == dockable) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            @Override
            public DockableProperty getLocationAt(Path placeholder) {
                int index = StackDockStation.this.dockables.getDockableIndex(placeholder);
                return new StackDockProperty(index, placeholder);
            }
        };
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        try {
            DockablePlaceholderList next = new DockablePlaceholderList(placeholders);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = next;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = next;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> children) {
        this.dockables.insertAllPlaceholders();
        final PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        return this.dockables.toMap(new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int index, StationChildHandle dockable) {
                Path placeholder;
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                Integer id = (Integer)children.get(dockable.getDockable());
                if (id == null) {
                    return null;
                }
                item.putInt("id", id);
                item.putInt("index", index);
                if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable.getDockable())) != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }

            @Override
            public StationChildHandle convert(ConvertedPlaceholderListItem item) {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap placeholders, final Map<Integer, Dockable> children) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        DockController controller = this.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            this.dockables.setStrategy(null);
            this.dockables.unbind();
            DockablePlaceholderList<StationChildHandle> next = new DockablePlaceholderList<StationChildHandle>();
            this.dockables = next;
            next.read(placeholders, new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){
                private DockHierarchyLock.Token token;
                private int size = 0;

                @Override
                public StationChildHandle convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    Dockable dockable = (Dockable)children.get(id);
                    if (dockable == null) {
                        return null;
                    }
                    DockUtilities.ensureTreeValidity(StackDockStation.this, dockable);
                    this.token = DockHierarchyLock.acquireLinking(StackDockStation.this, dockable);
                    StackDockStation.this.listeners.fireDockableAdding(dockable);
                    dockable.addDockableListener(StackDockStation.this.listener);
                    StationChildHandle handle = new StationChildHandle(StackDockStation.this, StackDockStation.this.getDisplayers(), dockable, StackDockStation.this.title);
                    return handle;
                }

                @Override
                public void added(StationChildHandle handle) {
                    try {
                        Dockable dockable = handle.getDockable();
                        dockable.setDockParent(StackDockStation.this);
                        handle.updateDisplayer();
                        StackDockStation.this.addToPanel(handle, this.size, this.size);
                        ++this.size;
                        StackDockStation.this.listeners.fireDockableAdded(dockable);
                    }
                    finally {
                        this.token.release();
                    }
                }
            });
            if (controller != null) {
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategy.setValue(strategy);
    }

    public void setSmallMinimumSize(boolean smallMinimumSize) {
        this.smallMinimumSize = smallMinimumSize;
        this.getComponent().invalidate();
    }

    public boolean isSmallMinimumSize() {
        return this.smallMinimumSize;
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        Component component = this.getComponent();
        if (component.getWidth() <= 0 || component.getHeight() <= 0) {
            return new DockStationDropLayer[0];
        }
        return new DockStationDropLayer[]{new DefaultDropLayer(this), new TabDropLayer(this)};
    }

    public boolean isOverTabs(int x, int y) {
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, this.panel);
        return this.exactTabIndexAt(point.x, point.y) != null;
    }

    public boolean isOverTitle(int x, int y) {
        DockTitle title;
        if (this.dockables.dockables().size() == 1 && (title = ((StationChildHandle)this.dockables.dockables().get(0)).getDisplayer().getTitle()) != null) {
            Component component = title.getComponent();
            Point p = new Point(x, y);
            SwingUtilities.convertPointFromScreen(p, component);
            return component.getBounds().contains(p);
        }
        return false;
    }

    public StationDropOperation prepareMove(StationDropItem item) {
        Point point = new Point(item.getMouseX(), item.getMouseY());
        SwingUtilities.convertPointFromScreen(point, this.panel);
        Insert insert = this.tabIndexAt(point.x, point.y);
        if (this.validate(insert, item.getDockable())) {
            return new StackDropOperation(item.getDockable(), insert, true);
        }
        return null;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem item) {
        if (item.getDockable().getDockParent() == this) {
            return this.prepareMove(item);
        }
        if (SwingUtilities.isDescendingFrom(this.getComponent(), item.getDockable().getComponent())) {
            return null;
        }
        Point point = new Point(item.getMouseX(), item.getMouseY());
        SwingUtilities.convertPointFromScreen(point, this.panel);
        Insert insert = this.tabIndexAt(point.x, point.y);
        if (this.validate(insert, item.getDockable())) {
            return new StackDropOperation(item.getDockable(), insert, false);
        }
        return null;
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        this.dragOperation = new ComponentDragOperation(dockable, this.getComponent()){

            @Override
            protected void destroy() {
                StackDockStation.this.dragOperation = null;
            }
        };
        return this.dragOperation;
    }

    @Override
    public void drop(Dockable dockable) {
        this.drop(dockable, true);
    }

    public void drop(Dockable dockable, boolean autoPlaceholder) {
        Path placeholder = null;
        if (autoPlaceholder) {
            PlaceholderStrategy strategy = this.getPlaceholderStrategy();
            placeholder = strategy == null ? null : strategy.getPlaceholderFor(dockable);
        }
        boolean done = false;
        if (placeholder != null) {
            done = this.drop(dockable, new StackDockProperty(this.dockables.dockables().size(), placeholder));
        }
        if (!done) {
            this.add(dockable, this.dockables.dockables().size(), null);
        }
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof StackDockProperty) {
            return this.drop(dockable, (StackDockProperty)property);
        }
        return false;
    }

    public boolean drop(Dockable dockable, StackDockProperty property) {
        DockUtilities.checkLayoutLocked();
        int index = property.getIndex();
        Path placeholder = property.getPlaceholder();
        boolean acceptable = this.acceptable(dockable);
        DockableProperty successor = property.getSuccessor();
        boolean result = false;
        if (placeholder != null && successor != null) {
            DockStation station;
            StationChildHandle preset = (StationChildHandle)this.dockables.getDockableAt(placeholder);
            if (preset != null && (station = preset.getDockable().asDockStation()) != null && station.drop(dockable, successor)) {
                result = true;
                this.dockables.removeAll(placeholder);
            }
        } else if (placeholder != null && acceptable && this.dockables.hasPlaceholder(placeholder)) {
            this.add(dockable, 0, placeholder);
            result = true;
        }
        if (!result && this.dockables.dockables().size() == 0 && acceptable) {
            this.drop(dockable, false);
            result = true;
        }
        if (!result) {
            DockStation station;
            if ((index = Math.min(index, this.dockables.dockables().size())) < this.dockables.dockables().size() && successor != null && (station = ((StationChildHandle)this.dockables.dockables().get(index)).getDockable().asDockStation()) != null && station.drop(dockable, successor)) {
                result = true;
            }
            if (!result && acceptable) {
                this.add(dockable, index);
                result = true;
            }
        }
        return result;
    }

    private boolean validate(Insert insert, Dockable child) {
        return insert != null && this.accept(child) && child.accept(this) && this.getController().getAcceptance().accept(this, child);
    }

    public Insert getInsert() {
        return this.insert;
    }

    @Override
    public void move(Dockable dockable, DockableProperty property) {
        if (property instanceof StackDockProperty) {
            DockUtilities.checkLayoutLocked();
            int index = this.indexOf(dockable);
            if (index < 0) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            int destination = ((StackDockProperty)property).getIndex();
            destination = Math.min(destination, this.getDockableCount() - 1);
            destination = Math.max(0, destination);
            this.move(index, destination);
        }
    }

    private void move(int source, int destination) {
        if (source != destination) {
            DockUtilities.checkLayoutLocked();
            this.dockables.dockables().move(source, destination);
            this.stackComponent.moveTab(source, destination);
            this.fireDockablesRepositioned(Math.min(source, destination), Math.max(source, destination));
        }
    }

    protected Insert tabIndexAt(int x, int y) {
        if (this.dockables.dockables().size() == 0) {
            return new Insert(0, false);
        }
        if (this.dockables.dockables().size() == 1) {
            return new Insert(1, false);
        }
        Insert insert = this.exactTabIndexAt(x, y);
        if (insert == null) {
            insert = new Insert(this.dockables.dockables().size() - 1, true);
        }
        return insert;
    }

    protected Insert exactTabIndexAt(int x, int y) {
        Point point = SwingUtilities.convertPoint(this.panel, x, y, this.stackComponent.getComponent());
        int size = this.dockables.dockables().size();
        if (size > 1 || this.singleTabStackDockComponent()) {
            for (int i = 0; i < size; ++i) {
                Rectangle bounds = this.stackComponent.getBoundsAt(i);
                if (bounds == null || !bounds.contains(point)) continue;
                if (this.tabPlacement.getValue().isHorizontal()) {
                    return new Insert(i, bounds.x + bounds.width / 2 < point.x);
                }
                return new Insert(i, bounds.y + bounds.height / 2 < point.y);
            }
        }
        return null;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        int index = this.indexOf(dockable);
        if (index < 0) {
            throw new IllegalArgumentException("The dockable is not part of this station.");
        }
        this.remove(index);
    }

    @Override
    public boolean canReplace(Dockable old, Dockable next) {
        return true;
    }

    @Override
    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next, true);
    }

    @Override
    public void replace(Dockable old, Dockable next) {
        this.replace(old, next, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Dockable old, Dockable next, boolean station) {
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            int index = this.indexOf(old);
            int listIndex = this.dockables.levelToBase(index, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item oldItem = this.dockables.list().get(listIndex);
            this.remove(index);
            this.add(next, index);
            PlaceholderList.Item newItem = this.dockables.list().get(listIndex);
            if (station) {
                newItem.setPlaceholderMap(old.asDockStation().getPlaceholders());
            } else {
                newItem.setPlaceholderMap(oldItem.getPlaceholderMap());
            }
            newItem.setPlaceholderSet(oldItem.getPlaceholderSet());
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    public void add(Dockable dockable, int index) {
        this.add(dockable, index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Dockable dockable, int index, Path placeholder) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockUtilities.checkLayoutLocked();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            StationChildHandle handle = new StationChildHandle(this, this.getDisplayers(), dockable, this.title);
            handle.updateDisplayer();
            int inserted = -1;
            if (placeholder != null && this.dockables.getDockableAt(placeholder) == null) {
                inserted = this.dockables.put(placeholder, handle);
            } else if (placeholder != null) {
                index = this.dockables.getDockableIndex(placeholder);
            }
            if (inserted == -1) {
                this.dockables.dockables().add(index, handle);
            } else {
                index = inserted;
            }
            this.addToPanel(handle, index, this.dockables.dockables().size() - 1);
            dockable.setDockParent(this);
            dockable.addDockableListener(this.listener);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(index + 1);
            this.fireDockableSelected();
        }
        finally {
            token.release();
        }
    }

    protected void addToPanel(StationChildHandle handle, int index, int size) {
        if (size == 0 && !this.singleTabStackDockComponent()) {
            DockableDisplayer displayer = handle.getDisplayer();
            this.panel.add(displayer.getComponent());
        } else {
            int selectionIndex = index;
            int oldSelectionIndex = 0;
            if (size == 1 && !this.singleTabStackDockComponent()) {
                this.panel.removeAll();
                PlaceholderList.Filter list = this.dockables.dockables();
                if (list.get(0) == handle) {
                    if (list.size() != 2) {
                        throw new IllegalStateException("handle is stored, size is 1, but number of known dockables is not 2");
                    }
                    handle = (StationChildHandle)list.get(1);
                    index = 1;
                }
                DockableDisplayer child = ((StationChildHandle)list.get(0)).getDisplayer();
                this.insertTab(child, 0);
                this.panel.add(this.stackComponent.getComponent());
            } else {
                oldSelectionIndex = this.stackComponent.getSelectedIndex();
                if (index <= oldSelectionIndex) {
                    ++oldSelectionIndex;
                }
            }
            DockableDisplayer displayer = handle.getDisplayer();
            this.insertTab(displayer, index);
            if (this.isImmutableSelectedIndex()) {
                this.stackComponent.setSelectedIndex(oldSelectionIndex);
            } else {
                this.stackComponent.setSelectedIndex(selectionIndex);
            }
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private boolean isImmutableSelectedIndex() {
        DockController controller = this.getController();
        if (controller == null) {
            return IMMUTABLE_SELECTION_INDEX.getDefault(null);
        }
        return controller.getProperties().get(IMMUTABLE_SELECTION_INDEX);
    }

    private void insertTab(DockableDisplayer displayer, int index) {
        Dockable dockable = displayer.getDockable();
        String title = dockable.getTitleText();
        String tooltip = dockable.getTitleToolTip();
        Icon icon = dockable.getTitleIcon();
        TabContentFilter filter = this.getTabContentFilter();
        if (filter != null) {
            TabContent content = new TabContent(icon, title, tooltip);
            if ((content = filter.filter(content, this, dockable)) == null) {
                title = null;
                tooltip = null;
                icon = null;
            } else {
                title = content.getTitle();
                tooltip = content.getTooltip();
                icon = content.getIcon();
            }
        }
        this.stackComponent.insertTab(title, icon, displayer.getComponent(), dockable, index);
        this.stackComponent.setTooltipAt(index, tooltip);
    }

    protected void discard(DockableDisplayer displayer) {
        Dockable dockable = displayer.getDockable();
        int index = this.indexOf(dockable);
        if (index < 0) {
            throw new IllegalArgumentException("displayer is not a child of this station: " + displayer);
        }
        StationChildHandle handle = (StationChildHandle)this.dockables.dockables().get(index);
        handle.updateDisplayer();
        displayer = handle.getDisplayer();
        if (this.dockables.dockables().size() == 1 && this.singleTabStackDockComponent()) {
            this.panel.removeAll();
            this.panel.add(displayer.getComponent());
        } else {
            this.stackComponent.setComponentAt(index, displayer.getComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        if (index < 0 || index >= this.dockables.dockables().size()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        DockUtilities.checkLayoutLocked();
        StationChildHandle handle = (StationChildHandle)this.dockables.dockables().get(index);
        Dockable dockable = handle.getDockable();
        boolean removingSelection = false;
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.removeDockableListener(this.listener);
            this.visibleListener.ignoreSelectionChanges = true;
            if (this.dockables.dockables().size() == 1) {
                if (this.singleTabStackDockComponent()) {
                    this.stackComponent.remove(0);
                } else {
                    this.panel.remove(((StationChildHandle)this.dockables.dockables().get(0)).getDisplayer().getComponent());
                }
                this.dockables.remove(0);
                this.panel.repaint();
            } else if (this.dockables.dockables().size() == 2 && !this.singleTabStackDockComponent()) {
                this.panel.remove(this.stackComponent.getComponent());
                this.dockables.remove(index);
                this.stackComponent.removeAll();
                this.panel.add(((StationChildHandle)this.dockables.dockables().get(0)).getDisplayer().getComponent());
            } else {
                removingSelection = index == this.stackComponent.getSelectedIndex();
                this.dockables.remove(index);
                this.stackComponent.remove(index);
            }
            handle.destroy();
            dockable.setDockParent(null);
            this.visibleListener.ignoreSelectionChanges = false;
            this.focusAfterRemoving(removingSelection);
            this.panel.revalidate();
            this.listeners.fireDockableRemoved(dockable);
        }
        finally {
            this.visibleListener.ignoreSelectionChanges = false;
            token.release();
        }
        this.fireDockablesRepositioned(index);
        this.fireDockableSelected();
    }

    private void focusAfterRemoving(boolean removedSelectedDockable) {
        Dockable next;
        DockController controller;
        if (removedSelectedDockable && (controller = this.getController()) != null && this.dockables.dockables().size() > 1 && (next = controller.getFocusHistory().getNewestOn(this)) != null && next.getDockParent() == this) {
            this.stackComponent.setSelectedIndex(this.indexOf(next));
            return;
        }
        this.visibleListener.selectionChanged(this.stackComponent);
    }

    @Override
    public Component getComponent() {
        return this.background;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints hints) {
        super.configureDisplayerHints(hints);
        this.updateConfigurableDisplayerHints();
    }

    protected void updateConfigurableDisplayerHints() {
        DockableDisplayerHints hints = this.getConfigurableDisplayerHints();
        if (hints != null) {
            hints.setShowBorderHint(!this.getStackComponent().hasBorder());
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.panel.addMouseListener(listener);
        this.panel.addMouseMotionListener(listener);
        this.mouseInputListeners.add(listener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().addMouseListener(listener);
            this.stackComponent.getComponent().addMouseMotionListener(listener);
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.panel.removeMouseListener(listener);
        this.panel.removeMouseMotionListener(listener);
        this.mouseInputListeners.remove(listener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().removeMouseListener(listener);
            this.stackComponent.getComponent().removeMouseMotionListener(listener);
        }
    }

    @Override
    public String getFactoryID() {
        return "StackDockStationFactory";
    }

    private void updateContent(int index) {
        if (index >= 0 && (this.getDockableCount() > 1 || this.singleTabStackDockComponent())) {
            Dockable dockable = this.getDockable(index);
            TabContentFilter filter = this.getTabContentFilter();
            TabContent content = new TabContent(dockable.getTitleIcon(), dockable.getTitleText(), dockable.getTitleToolTip());
            if (filter != null) {
                content = filter.filter(content, this, dockable);
            }
            if (content == null) {
                this.stackComponent.setTitleAt(index, null);
                this.stackComponent.setIconAt(index, null);
                this.stackComponent.setTooltipAt(index, null);
            } else {
                this.stackComponent.setTitleAt(index, content.getTitle());
                this.stackComponent.setIconAt(index, content.getIcon());
                this.stackComponent.setTooltipAt(index, content.getTooltip());
            }
        }
    }

    protected void insertionLine(Rectangle left, Rectangle right, Point a, Point b, boolean leftImportant) {
        if (this.tabPlacement.getValue().isHorizontal()) {
            if (left != null && right != null) {
                int dif;
                int top = Math.max(left.y, right.y);
                int bottom = Math.min(left.y + left.height, right.y + right.height);
                if (bottom > top && (double)(dif = bottom - top) >= 0.8 * (double)left.height && (double)dif >= 0.8 * (double)right.height) {
                    a.x = (left.x + left.width + right.x) / 2;
                    a.y = top;
                    b.x = a.x;
                    b.y = bottom;
                    return;
                }
            }
            if (leftImportant) {
                a.x = left.x + left.width;
                a.y = left.y;
                b.x = a.x;
                b.y = a.y + left.height;
            } else {
                a.x = right.x;
                a.y = right.y;
                b.x = a.x;
                b.y = a.y + right.height;
            }
        } else {
            if (left != null && right != null) {
                int dif;
                int top = Math.max(left.x, right.x);
                int bottom = Math.min(left.x + left.width, right.x + right.width);
                if (bottom > top && (double)(dif = bottom - top) >= 0.8 * (double)left.width && (double)dif >= 0.8 * (double)right.width) {
                    a.y = (left.y + left.height + right.y) / 2;
                    a.x = top;
                    b.y = a.y;
                    b.x = bottom;
                    return;
                }
            }
            if (leftImportant) {
                a.y = left.y + left.height;
                a.x = left.x;
                b.y = a.y;
                b.x = a.x + left.width;
            } else {
                a.y = right.y;
                a.x = right.x;
                b.y = a.y;
                b.x = a.x + right.width;
            }
        }
    }

    private class PanelBackground
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public PanelBackground() {
            super(StationBackgroundComponent.KIND, "dock.background.station.stack");
        }

        @Override
        public Component getComponent() {
            return StackDockStation.this.getComponent();
        }

        @Override
        public DockStation getStation() {
            return StackDockStation.this;
        }
    }

    private class Listener
    implements DockableListener {
        private Listener() {
        }

        @Override
        public void titleBound(Dockable dockable, DockTitle title) {
        }

        @Override
        public void titleUnbound(Dockable dockable, DockTitle title) {
        }

        @Override
        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            int index = StackDockStation.this.indexOf(dockable);
            if (index >= 0) {
                StackDockStation.this.updateContent(index);
            }
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String oldTooltip, String newTooltip) {
            int index = StackDockStation.this.indexOf(dockable);
            if (index >= 0) {
                StackDockStation.this.updateContent(index);
            }
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            int index = StackDockStation.this.indexOf(dockable);
            if (index >= 0) {
                StackDockStation.this.updateContent(index);
            }
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle title) {
        }
    }

    private class VisibleListener
    extends DockStationAdapter
    implements StackDockComponentListener {
        private boolean ignoreSelectionChanges = false;

        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
            StackDockStation.this.visibility.fire();
        }

        @Override
        public void selectionChanged(StackDockComponent stack) {
            if (!this.ignoreSelectionChanges) {
                DockController controller = StackDockStation.this.getController();
                if (controller != null && !StackDockStation.this.updatingTheme) {
                    Dockable selection = StackDockStation.this.getFrontDockable();
                    if (selection != null && !controller.getRelocator().isOnPut()) {
                        controller.setFocusedDockable(new DefaultFocusRequest(selection, null, false));
                    }
                    StackDockStation.this.fireDockableSelected();
                }
                StackDockStation.this.visibility.fire();
            }
        }

        @Override
        public void tabChanged(StackDockComponent stack, Dockable dockable) {
        }
    }

    protected class Background
    extends SecureContainer {
        private BackgroundPanel content;

        public Background() {
            this.content = new ConfiguredBackgroundPanel(Transparency.SOLID){

                @Override
                public void setTransparency(Transparency transparency) {
                    super.setTransparency(transparency);
                    Background.this.setSolid(transparency == Transparency.SOLID);
                }
            };
            this.content.setBackground(StackDockStation.this.panelBackground);
            this.setBasePane(this.content);
            this.content.setLayout(new GridLayout(1, 1));
        }

        @Override
        public Dimension getMinimumSize() {
            if (StackDockStation.this.isSmallMinimumSize()) {
                return new Dimension(5, 5);
            }
            return super.getMinimumSize();
        }

        @Override
        protected void paintOverlay(Graphics g) {
            Rectangle bounds;
            DefaultStationPaintValue paint = StackDockStation.this.getPaint();
            if (StackDockStation.this.insert != null && StackDockStation.this.dockables.dockables().size() > 1) {
                bounds = null;
                if (StackDockStation.this.insert.tab >= 0 && StackDockStation.this.insert.tab < StackDockStation.this.stackComponent.getTabCount()) {
                    bounds = StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab);
                }
                if (bounds != null) {
                    Point a = new Point();
                    Point b = new Point();
                    if (StackDockStation.this.insert.right) {
                        StackDockStation.this.insertionLine(bounds, StackDockStation.this.insert.tab + 1 < StackDockStation.this.stackComponent.getTabCount() ? StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab + 1) : null, a, b, true);
                    } else {
                        StackDockStation.this.insertionLine(StackDockStation.this.insert.tab > 0 ? StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab - 1) : null, bounds, a, b, false);
                    }
                    paint.drawInsertionLine(g, a.x, a.y, b.x, b.y);
                }
            }
            if (StackDockStation.this.insert != null || StackDockStation.this.dragOperation != null && StackDockStation.this.dragOperation.getDockable() != null) {
                bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                Rectangle frontBounds = null;
                if (StackDockStation.this.getDockableCount() < 2) {
                    frontBounds = bounds;
                } else {
                    int index = StackDockStation.this.stackComponent.getSelectedIndex();
                    if (index >= 0) {
                        Component front = ((StationChildHandle)StackDockStation.this.dockables.dockables().get(index)).getDisplayer().getComponent();
                        Point location = new Point(0, 0);
                        location = SwingUtilities.convertPoint(front, location, this);
                        frontBounds = new Rectangle(location.x, location.y, front.getWidth(), front.getHeight());
                    }
                }
                if (frontBounds != null) {
                    if (StackDockStation.this.insert != null) {
                        paint.drawInsertion(g, bounds, frontBounds);
                    } else if (StackDockStation.this.dragOperation != null && StackDockStation.this.dragOperation.getDockable() != null) {
                        paint.drawRemoval(g, bounds, frontBounds);
                    }
                }
            }
        }
    }

    public static class Insert {
        private final int tab;
        private final boolean right;

        public Insert(int tab, boolean right) {
            this.tab = tab;
            this.right = right;
        }

        public int getTab() {
            return this.tab;
        }

        public boolean isRight() {
            return this.right;
        }
    }

    protected class StackDropOperation
    implements StationDropOperation {
        private Insert insert;
        private Dockable dropping;
        private boolean move;

        public StackDropOperation(Dockable dropping, Insert insert, boolean move) {
            this.dropping = dropping;
            this.insert = insert;
            this.move = move;
        }

        @Override
        public boolean isMove() {
            return this.move;
        }

        @Override
        public void draw() {
            StackDockStation.this.insert = this.insert;
            StackDockStation.this.panel.repaint();
        }

        @Override
        public void destroy(StationDropOperation next) {
            if (StackDockStation.this.insert == this.insert) {
                StackDockStation.this.insert = null;
                StackDockStation.this.panel.repaint();
            }
            this.insert = null;
            this.dropping = null;
        }

        @Override
        public DockStation getTarget() {
            return StackDockStation.this;
        }

        @Override
        public Dockable getItem() {
            return this.dropping;
        }

        @Override
        public void execute() {
            if (this.isMove()) {
                this.move();
            } else {
                this.drop();
            }
        }

        public void move() {
            int index = StackDockStation.this.indexOf(this.dropping);
            if (index >= 0) {
                int drop = this.insert.tab + (this.insert.right ? 1 : 0);
                if (drop > index) {
                    --drop;
                }
                StackDockStation.this.move(index, drop);
            }
        }

        public void drop() {
            StackDockStation.this.add(this.dropping, this.insert.tab + (this.insert.right ? 1 : 0), null);
        }

        @Override
        public CombinerTarget getCombination() {
            return null;
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            return null;
        }
    }
}

