/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultDockActionSource
extends AbstractDockActionSource {
    private List<DockAction> actions = new ArrayList<DockAction>();
    private LocationHint hint;

    public DefaultDockActionSource(DockAction ... actions) {
        this(LocationHint.UNKNOWN, actions);
    }

    public DefaultDockActionSource(LocationHint hint, DockAction ... actions) {
        for (DockAction action : actions) {
            this.actions.add(action);
        }
        this.setHint(hint);
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private int current = -1;
            private boolean removed = true;

            @Override
            public boolean hasNext() {
                return this.current + 1 < DefaultDockActionSource.this.actions.size();
            }

            @Override
            public DockAction next() {
                ++this.current;
                this.removed = false;
                return DefaultDockActionSource.this.actions.get(this.current);
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("Next not yet called or remove already called");
                }
                this.removed = true;
                DefaultDockActionSource.this.remove(this.current--);
            }
        };
    }

    public void setHint(LocationHint hint) {
        if (hint == null) {
            throw new IllegalArgumentException("Hint must not be null");
        }
        this.hint = hint;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public int getDockActionCount() {
        return this.actions.size();
    }

    @Override
    public DockAction getDockAction(int index) {
        return this.actions.get(index);
    }

    public void addSeparator(int position) {
        this.add(position, SeparatorAction.SEPARATOR);
    }

    public void addSeparator() {
        this.add(SeparatorAction.SEPARATOR);
    }

    public void add(DockAction ... action) {
        this.add(this.getDockActionCount(), action);
    }

    public void add(int index, DockAction ... actions) {
        int firstIndex = index;
        for (DockAction action : actions) {
            this.actions.add(index++, action);
        }
        this.fireAdded(firstIndex, index - 1);
    }

    @Override
    public int indexOf(DockAction action) {
        return this.actions.indexOf(action);
    }

    public void remove(DockAction action) {
        int index = this.indexOf(action);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        this.remove(index, 1);
    }

    public void removeAll() {
        this.remove(0, this.getDockActionCount());
    }

    public void remove(int index, int length) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (index + length > this.getDockActionCount()) {
            throw new IllegalArgumentException("index + length too great");
        }
        if (length > 0) {
            for (int i = length - 1; i >= 0; --i) {
                this.actions.remove(index + i);
            }
            this.fireRemoved(index, index + length - 1);
        }
    }
}

