/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class FilteredDockActionSource
extends AbstractDockActionSource {
    private DockActionSource source;
    private List<Boolean> actions = null;
    private Listener listener = new Listener();

    public FilteredDockActionSource(DockActionSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = source;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockAction> iterator;
            private DockAction next;
            {
                this.iterator = FilteredDockActionSource.this.source.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DockAction next() {
                DockAction result = this.next;
                this.advance();
                return result;
            }

            private void advance() {
                while (this.iterator.hasNext()) {
                    DockAction check = this.iterator.next();
                    if (!FilteredDockActionSource.this.include(check)) continue;
                    this.next = check;
                    return;
                }
                this.next = null;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        if (this.listeners.isEmpty()) {
            this.source.addDockActionSourceListener(this.listener);
            this.actions = new ArrayList<Boolean>();
            for (DockAction action : this.source) {
                this.actions.add(this.include(action));
            }
        }
        super.addDockActionSourceListener(listener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (this.listeners.isEmpty()) {
            this.source.removeDockActionSourceListener(this.listener);
            this.actions = null;
        }
    }

    @Override
    public DockAction getDockAction(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index out of bounds: " + index);
        }
        int count = -1;
        if (this.actions == null) {
            for (DockAction action : this.source) {
                if (!this.include(action) || index != ++count) continue;
                return action;
            }
        } else {
            int n = this.source.getDockActionCount();
            for (int i = 0; i < n; ++i) {
                if (!this.actions.get(i).booleanValue() || index != ++count) continue;
                return this.source.getDockAction(i);
            }
        }
        throw new IllegalArgumentException("Index out of bounds: " + index);
    }

    @Override
    public int getDockActionCount() {
        int count = 0;
        if (this.actions == null) {
            for (DockAction action : this.source) {
                if (!this.include(action)) continue;
                ++count;
            }
        } else {
            int n = this.source.getDockActionCount();
            for (int i = 0; i < n; ++i) {
                if (!this.actions.get(i).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.source.getLocationHint();
    }

    public void refresh() {
        if (this.actions != null) {
            int index = 0;
            int n = this.source.getDockActionCount();
            for (int i = 0; i < n; ++i) {
                boolean include = this.include(this.source.getDockAction(i));
                if (include != this.actions.get(i)) {
                    this.actions.set(i, include);
                    if (include) {
                        this.fireAdded(index, index);
                    } else {
                        this.fireRemoved(index, index);
                    }
                }
                if (!include) continue;
                ++index;
            }
        }
    }

    protected abstract boolean include(DockAction var1);

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            int insert = 0;
            for (int i = 0; i < firstIndex; ++i) {
                if (!FilteredDockActionSource.this.actions.get(i).booleanValue()) continue;
                ++insert;
            }
            int count = 0;
            for (int i = firstIndex; i <= lastIndex; ++i) {
                DockAction action = source.getDockAction(i);
                boolean include = FilteredDockActionSource.this.include(action);
                FilteredDockActionSource.this.actions.add(i, include);
                if (!include) continue;
                ++count;
            }
            if (count > 0) {
                FilteredDockActionSource.this.fireAdded(insert, insert + count - 1);
            }
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            int remove = 0;
            for (int i = 0; i < firstIndex; ++i) {
                if (!FilteredDockActionSource.this.actions.get(i).booleanValue()) continue;
                ++remove;
            }
            int count = 0;
            for (int i = lastIndex; i >= firstIndex; --i) {
                if (!FilteredDockActionSource.this.actions.remove(i).booleanValue()) continue;
                ++count;
            }
            if (count > 0) {
                FilteredDockActionSource.this.fireRemoved(remove, remove + count - 1);
            }
        }
    }
}

