/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.util.container.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class StationChildrenActionSource
extends AbstractDockActionSource {
    private LocationHint hint;
    private Dockable dockable;
    private Listener listener;
    private boolean onUpdateList = false;
    private List<Tuple<Dockable, DockAction>> actions = new ArrayList<Tuple<Dockable, DockAction>>();

    public StationChildrenActionSource(Dockable dockable, LocationHint hint) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
        if (hint == null) {
            hint = LocationHint.UNKNOWN;
        }
        this.hint = hint;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public DockAction getDockAction(int index) {
        this.updateActionList(false);
        return this.actions.get(index).getB();
    }

    @Override
    public int getDockActionCount() {
        this.updateActionList(false);
        return this.actions.size();
    }

    @Override
    public Iterator<DockAction> iterator() {
        this.updateActionList(false);
        return new Iterator<DockAction>(){
            private Iterator<Tuple<Dockable, DockAction>> iterator;
            {
                this.iterator = StationChildrenActionSource.this.actions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DockAction next() {
                return this.iterator.next().getB();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        if (this.listener == null) {
            this.updateActionList(false);
        }
        super.addDockActionSourceListener(listener);
        if (this.listener == null) {
            this.listener = new Listener();
            this.listener.add(this.dockable);
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (this.listeners.size() == 0 && this.listener != null) {
            this.listener.remove(this.dockable);
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionList(boolean force) {
        if (this.onUpdateList) {
            return;
        }
        try {
            this.onUpdateList = true;
            if (this.listener != null && !force) {
                return;
            }
            ArrayList<Dockable> list = new ArrayList<Dockable>();
            this.fill(this.dockable, list);
            this.sort(list);
            int i = 0;
            int n = list.size();
            int j = 0;
            int m = this.actions.size();
            HashSet<Dockable> pendingActions = new HashSet<Dockable>();
            for (Tuple<Dockable, DockAction> item : this.actions) {
                pendingActions.add((Dockable)item.getA());
            }
            while (i < n && j < m) {
                Dockable dockable = (Dockable)list.get(i);
                if (this.actions.get(j).getA() == dockable) {
                    ++i;
                    ++j;
                } else if (pendingActions.contains(dockable)) {
                    this.actions.remove(j);
                    --m;
                    this.fireRemoved(j, j);
                } else {
                    this.actions.add(j, new Tuple<Dockable, DockAction>(dockable, this.createActionFor(dockable)));
                    ++m;
                    this.fireAdded(j, j);
                    ++i;
                    ++j;
                }
                pendingActions.remove(dockable);
            }
            if (j < m) {
                int length = m;
                while (j < m) {
                    this.actions.remove(--m);
                }
                this.fireRemoved(j, length - 1);
            }
            if (i < n) {
                int index = i;
                while (i < n) {
                    Dockable dockable = (Dockable)list.get(i++);
                    this.actions.add(new Tuple<Dockable, DockAction>(dockable, this.createActionFor(dockable)));
                }
                this.fireAdded(index, this.actions.size() - 1);
            }
        }
        finally {
            this.onUpdateList = false;
        }
    }

    private void fill(Dockable dockable, List<Dockable> list) {
        DockStation station;
        if (this.shouldShow(dockable)) {
            list.add(dockable);
        }
        if ((station = dockable.asDockStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.fill(station.getDockable(i), list);
            }
        }
    }

    protected DockAction createActionFor(Dockable dockable) {
        return new FocusAction(dockable);
    }

    protected void sort(List<Dockable> dockables) {
    }

    protected boolean shouldShow(Dockable dockable) {
        if (dockable.getDockParent() == this.getDockable().asDockStation()) {
            return true;
        }
        return dockable == this.getDockable() && dockable.asDockStation() == null;
    }

    private class Listener
    extends DockStationAdapter {
        private Listener() {
        }

        @Override
        public void dockableAdded(DockStation station, Dockable dockable) {
            this.add(dockable);
            StationChildrenActionSource.this.updateActionList(true);
        }

        @Override
        public void dockableRemoving(DockStation station, Dockable dockable) {
            this.remove(dockable);
        }

        @Override
        public void dockableRemoved(DockStation station, Dockable dockable) {
            StationChildrenActionSource.this.updateActionList(true);
        }

        @Override
        public void dockablesRepositioned(DockStation station, Dockable[] dockables) {
            StationChildrenActionSource.this.updateActionList(true);
        }

        public void add(Dockable dockable) {
            DockStation station = dockable.asDockStation();
            if (station != null) {
                station.addDockStationListener(this);
                int n = station.getDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.add(station.getDockable(i));
                }
            }
        }

        public void remove(Dockable dockable) {
            DockStation station = dockable.asDockStation();
            if (station != null) {
                station.removeDockStationListener(this);
                int n = station.getDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.remove(station.getDockable(i));
                }
            }
        }
    }

    protected class FocusAction
    extends SimpleSelectableAction.Check
    implements DockableListener {
        private Dockable dockable;
        private DockStation parent;
        private boolean onChange = false;
        private int bound = 0;
        private DockStationAdapter adapter = new DockStationAdapter(){

            @Override
            public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
                FocusAction.this.checkState();
            }

            @Override
            public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
                FocusAction.this.checkState();
            }
        };
        private DockHierarchyListener hierarchy = new DockHierarchyListener(){

            @Override
            public void hierarchyChanged(DockHierarchyEvent event) {
                if (FocusAction.this.bound > 0) {
                    if (FocusAction.this.parent != null) {
                        FocusAction.this.parent.removeDockStationListener(FocusAction.this.adapter);
                    }
                    FocusAction.this.parent = FocusAction.this.dockable.getDockParent();
                    if (FocusAction.this.parent != null) {
                        FocusAction.this.parent.addDockStationListener(FocusAction.this.adapter);
                    }
                    FocusAction.this.checkState();
                }
            }

            @Override
            public void controllerChanged(DockHierarchyEvent event) {
            }
        };

        public FocusAction(Dockable dockable) {
            this.dockable = dockable;
            this.setDockableRepresentation(dockable);
            this.addSelectableListener(new SelectableDockActionListener(){

                @Override
                public void selectedChanged(SelectableDockAction action, Set<Dockable> dockables) {
                    FocusAction.this.checkDockable();
                }
            });
        }

        @Override
        public void bind(Dockable dockable) {
            ++this.bound;
            if (this.bound == 1) {
                this.dockable.addDockHierarchyListener(this.hierarchy);
                this.parent = this.dockable.getDockParent();
                if (this.parent != null) {
                    this.parent.addDockStationListener(this.adapter);
                }
                this.checkState();
            }
            super.bind(dockable);
        }

        @Override
        public void unbind(Dockable dockable) {
            super.unbind(dockable);
            --this.bound;
            if (this.bound == 0) {
                if (this.parent != null) {
                    this.parent.removeDockStationListener(this.adapter);
                }
                this.dockable.removeDockHierarchyListener(this.hierarchy);
                this.parent = null;
            }
        }

        private void checkState() {
            if (!this.onChange) {
                try {
                    this.onChange = true;
                    DockStation parent = this.dockable.getDockParent();
                    boolean select = false;
                    if (parent != null) {
                        select = parent.isChildShowing(this.dockable) && parent.getFrontDockable() == this.dockable;
                    }
                    this.setSelected(select);
                }
                finally {
                    this.onChange = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDockable() {
            if (!this.onChange) {
                try {
                    this.onChange = true;
                    if (this.isSelected()) {
                        DockController controller = this.dockable.getController();
                        if (controller != null) {
                            controller.setFocusedDockable(new DefaultFocusRequest(this.dockable, null, true, true, true));
                        }
                    } else {
                        DockStation parent = this.parent;
                        Dockable dockable = this.dockable;
                        DockStation finalParent = StationChildrenActionSource.this.dockable.getDockParent();
                        while (parent != null) {
                            if (parent.getFrontDockable() == dockable) {
                                parent.setFrontDockable(null);
                            }
                            if (parent == finalParent) {
                                parent = null;
                                continue;
                            }
                            dockable = parent.asDockable();
                            if (dockable != null) {
                                parent = dockable.getDockParent();
                                continue;
                            }
                            parent = null;
                        }
                    }
                }
                finally {
                    this.onChange = false;
                }
            }
        }

        @Override
        protected void bound(Dockable dockable) {
            this.dockable.addDockableListener(this);
            this.setIcon(this.dockable.getTitleIcon());
            this.setText(this.dockable.getTitleText());
            this.setTooltip(this.dockable.getTitleToolTip());
        }

        @Override
        protected void unbound(Dockable dockable) {
            this.dockable.removeDockableListener(this);
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            this.setIcon(newIcon);
        }

        @Override
        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            this.setText(newTitle);
            String tooltip = dockable.getTitleToolTip();
            if (tooltip == null || tooltip.length() == 0) {
                this.setTooltip(newTitle);
            }
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String oldToolTip, String newToolTip) {
            this.setTooltip(newToolTip);
            if (newToolTip == null || newToolTip.length() == 0) {
                this.setTooltip(dockable.getTitleText());
            }
        }

        @Override
        public void titleBound(Dockable dockable, DockTitle title) {
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle title) {
        }

        @Override
        public void titleUnbound(Dockable dockable, DockTitle title) {
        }
    }
}

