/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.dropdown.AbstractDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import java.util.HashSet;
import javax.swing.Icon;

public class DefaultDropDownFilter
extends AbstractDropDownFilter {
    public static final DropDownFilterFactory FACTORY = new DropDownFilterFactory(){

        @Override
        public DropDownFilter createView(DropDownAction action, Dockable dockable, DropDownView view) {
            return new DefaultDropDownFilter(action, dockable, view);
        }
    };

    public DefaultDropDownFilter(DropDownAction action, Dockable dockable, DropDownView view) {
        super(action, dockable, view);
    }

    @Override
    public void update(DropDownViewItem selection) {
        this.updateEnabled(selection);
        this.updateSelected(selection);
        this.updateIcon(selection);
        this.updateText(selection);
        this.updateTooltip(selection);
        this.updateRepresentative(selection);
    }

    protected void updateEnabled(DropDownViewItem selection) {
        this.getView().setEnabled(this.enabled);
    }

    protected void updateRepresentative(DropDownViewItem selection) {
        this.getView().setDockableRepresentation(this.representative);
    }

    protected void updateSelected(DropDownViewItem selection) {
        this.getView().setSelected(this.selected);
    }

    @Override
    public ActionContentModifier[] getIconContexts() {
        return this.getView().getIconContexts();
    }

    protected void updateIcon(DropDownViewItem selection) {
        HashSet<Object> modifiers = new HashSet<Object>();
        modifiers.addAll(this.icons.keySet());
        for (ActionContentModifier modifier : this.getView().getIconContexts()) {
            modifiers.add(modifier);
        }
        for (ActionContentModifier modifier : this.getAction().getIconContexts(this.getDockable())) {
            modifiers.add(modifier);
        }
        for (ActionContentModifier actionContentModifier : modifiers) {
            Icon icon = (Icon)this.icons.get(actionContentModifier);
            if (icon == null) {
                this.getView().setIcon(actionContentModifier, this.getAction().getIcon(this.getDockable(), actionContentModifier));
                continue;
            }
            this.getView().setIcon(actionContentModifier, icon);
        }
    }

    protected void updateText(DropDownViewItem selection) {
        if (this.text == null) {
            this.getView().setText(this.getAction().getText(this.getDockable()));
        } else {
            this.getView().setText(this.text);
        }
    }

    protected void updateTooltip(DropDownViewItem selection) {
        if (selection == null || !selection.isTriggerable(true)) {
            String tooltip = this.getAction().getTooltipText(this.getDockable());
            if (tooltip == null) {
                tooltip = this.tooltip;
            }
            if (tooltip == null) {
                tooltip = this.getAction().getText(this.getDockable());
            }
            if (tooltip == null) {
                tooltip = this.text;
            }
            this.getView().setTooltip(tooltip);
        } else {
            String tooltip = this.tooltip;
            if (tooltip == null) {
                tooltip = this.getAction().getTooltipText(this.getDockable());
            }
            if (tooltip == null) {
                tooltip = this.text;
            }
            if (tooltip == null) {
                tooltip = this.getAction().getText(this.getDockable());
            }
            this.getView().setTooltip(tooltip);
        }
    }
}

