/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.LocatedListenerList;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.MouseInputAdapter;

public class DoubleClickController {
    private LocatedListenerList<DoubleClickListener> observers = new LocatedListenerList();
    private Map<DockElementRepresentative, GlobalDoubleClickListener> listeners = new HashMap<DockElementRepresentative, GlobalDoubleClickListener>();

    public DoubleClickController(ControllerSetupCollection setup) {
        setup.add(new ControllerSetupListener(){

            @Override
            public void done(DockController controller) {
                controller.addRepresentativeListener(new DockControllerRepresentativeListener(){

                    @Override
                    public void representativeAdded(DockController controller, DockElementRepresentative representative) {
                        Dockable dockable = representative.getElement().asDockable();
                        if (dockable != null) {
                            GlobalDoubleClickListener listener = new GlobalDoubleClickListener(dockable);
                            representative.addMouseInputListener(listener);
                            DoubleClickController.this.listeners.put(representative, listener);
                        }
                    }

                    @Override
                    public void representativeRemoved(DockController controller, DockElementRepresentative representative) {
                        GlobalDoubleClickListener listener;
                        Dockable dockable = representative.getElement().asDockable();
                        if (dockable != null && (listener = DoubleClickController.this.listeners.remove(representative)) != null) {
                            representative.removeMouseInputListener(listener);
                        }
                    }
                });
            }
        });
    }

    public void addListener(DoubleClickListener listener) {
        this.observers.addListener(listener);
    }

    public void removeListener(DoubleClickListener listener) {
        this.observers.removeListener(listener);
    }

    public void send(Dockable dockable, MouseEvent event) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (event == null) {
            throw new NullPointerException("event must not be null");
        }
        if (event.getClickCount() != 2) {
            throw new IllegalArgumentException("click count must be equal to 2");
        }
        List<DoubleClickListener> list = this.observers.affected(dockable);
        for (DoubleClickListener observer : list) {
            if (!observer.process(dockable, event)) continue;
            event.consume();
            break;
        }
    }

    protected class GlobalDoubleClickListener
    extends MouseInputAdapter {
        private Dockable dockable;

        public GlobalDoubleClickListener(Dockable dockable) {
            this.dockable = dockable;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!event.isConsumed() && event.getClickCount() == 2) {
                DoubleClickController.this.send(this.dockable, event);
            }
        }
    }
}

