/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.dockable.DockableStateListenerManager;
import bibliothek.gui.dock.dockable.IconHandling;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

public abstract class AbstractDockable
implements Dockable {
    private DockStation parent;
    private DockController controller;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockHierarchyObserver hierarchyObserver;
    private DockableStateListenerManager dockableStateListeners;
    private List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private KeyboardListener keyboardListener;
    private PropertyValue<String> titleText;
    private DockIcon titleIcon;
    private Icon currentTitleIcon;
    private IconHandling titleIconHandling = IconHandling.KEEP_NULL_ICON;
    private PropertyValue<String> titleToolTip;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private DockableDisplayerHints hints;
    private DockComponentRootHandler rootHandler;
    private DockActionSource source;
    private HierarchyDockActionSource globalSource;

    protected AbstractDockable(PropertyKey<String> titleText, PropertyKey<String> titleTooltip) {
        this.titleText = new PropertyValue<String>(titleText){

            @Override
            protected void valueChanged(String oldValue, String newValue) {
                if (oldValue == null) {
                    oldValue = "";
                }
                if (newValue == null) {
                    newValue = "";
                }
                AbstractDockable.this.fireTitleTextChanged(oldValue, newValue);
            }
        };
        this.titleToolTip = new PropertyValue<String>(titleTooltip){

            @Override
            protected void valueChanged(String oldValue, String newValue) {
                AbstractDockable.this.fireTitleTooltipChanged(oldValue, newValue);
            }
        };
        this.dockableStateListeners = new DockableStateListenerManager(this);
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
    }

    protected DockComponentRootHandler getRootHandler() {
        if (this.rootHandler == null) {
            this.rootHandler = this.createRootHandler();
            this.rootHandler.addRoot(this.getComponent());
        }
        return this.rootHandler;
    }

    protected abstract DockComponentRootHandler createRootHandler();

    protected abstract DockIcon createTitleIcon();

    private DockIcon titleIcon() {
        if (this.titleIcon == null) {
            this.titleIcon = this.createTitleIcon();
            this.titleIcon.setController(this.getController());
        }
        return this.titleIcon;
    }

    @Override
    public void setDockParent(DockStation station) {
        if (this.parent != station) {
            this.parent = station;
            this.hierarchyObserver.update();
        }
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    @Override
    public void setController(DockController controller) {
        this.getRootHandler().setController(null);
        if (this.controller != null && this.keyboardListener != null) {
            this.controller.getKeyboardController().removeListener(this.keyboardListener);
            this.keyboardListener = null;
        }
        this.controller = controller;
        this.titleIcon().setController(controller);
        this.titleText.setProperties(controller);
        this.hierarchyObserver.controllerChanged(controller);
        if (!this.keyListeners.isEmpty()) {
            this.registerKeyboardListener();
        }
        this.getRootHandler().setController(controller);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration configuration) {
        this.getRootHandler().setConfiguration(configuration);
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.getRootHandler().getConfiguration();
    }

    @Override
    public boolean isDockableShowing() {
        return this.isDockableVisible();
    }

    @Override
    @Deprecated
    public boolean isDockableVisible() {
        DockController controller = this.getController();
        if (controller == null) {
            return false;
        }
        DockStation parent = this.getDockParent();
        if (parent != null) {
            return parent.isVisible(this);
        }
        return false;
    }

    @Override
    public void addDockableListener(DockableListener listener) {
        this.dockableListeners.add(listener);
    }

    @Override
    public void removeDockableListener(DockableListener listener) {
        this.dockableListeners.remove(listener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyObserver.addDockHierarchyListener(listener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyObserver.removeDockHierarchyListener(listener);
    }

    @Override
    public void addDockableStateListener(DockableStateListener listener) {
        this.dockableStateListeners.addListener(listener);
    }

    @Override
    public void removeDockableStateListener(DockableStateListener listener) {
        this.dockableStateListeners.removeListener(listener);
    }

    protected DockableStateListenerManager getDockableStateListeners() {
        return this.dockableStateListeners;
    }

    protected DockableStateListenerManager getDockElementObserver() {
        return this.dockableStateListeners;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.getComponent().addMouseListener(listener);
        this.getComponent().addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.getComponent().removeMouseListener(listener);
        this.getComponent().removeMouseMotionListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListeners.add(listener);
        this.registerKeyboardListener();
    }

    public void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
        if (this.keyboardListener != null && this.controller != null) {
            this.controller.getKeyboardController().removeListener(this.keyboardListener);
            this.keyboardListener = null;
        }
    }

    private KeyListener[] getKeyListeners() {
        return this.keyListeners.toArray(new KeyListener[this.keyListeners.size()]);
    }

    private void registerKeyboardListener() {
        if (this.keyboardListener == null && this.controller != null) {
            this.keyboardListener = new KeyboardListener(){

                @Override
                public DockElement getTreeLocation() {
                    return AbstractDockable.this;
                }

                @Override
                public boolean keyTyped(DockElement element, KeyEvent event) {
                    if (element == AbstractDockable.this) {
                        for (KeyListener listener : AbstractDockable.this.getKeyListeners()) {
                            listener.keyTyped(event);
                        }
                        return event.isConsumed();
                    }
                    return false;
                }

                @Override
                public boolean keyReleased(DockElement element, KeyEvent event) {
                    if (element == AbstractDockable.this) {
                        for (KeyListener listener : AbstractDockable.this.getKeyListeners()) {
                            listener.keyReleased(event);
                        }
                        return event.isConsumed();
                    }
                    return false;
                }

                @Override
                public boolean keyPressed(DockElement element, KeyEvent event) {
                    if (element == AbstractDockable.this) {
                        for (KeyListener listener : AbstractDockable.this.getKeyListeners()) {
                            listener.keyPressed(event);
                        }
                        return event.isConsumed();
                    }
                    return false;
                }
            };
            this.controller.getKeyboardController().addListener(this.keyboardListener);
        }
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return false;
    }

    @Override
    public boolean accept(DockStation station) {
        return true;
    }

    @Override
    public boolean accept(DockStation base, Dockable neighbour) {
        return true;
    }

    @Override
    public String getTitleText() {
        String text = this.titleText.getValue();
        if (text == null) {
            return "";
        }
        return text;
    }

    public void setTitleText(String titleText) {
        this.titleText.setValue(titleText);
    }

    @Override
    public Icon getTitleIcon() {
        return this.currentTitleIcon;
    }

    public void setTitleToolTip(String titleToolTip) {
        this.titleToolTip.setValue(titleToolTip);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    public void setTitleIconHandling(IconHandling titleIconHandling) {
        if (titleIconHandling == null) {
            throw new IllegalArgumentException("titleIconHandling must not be null");
        }
        this.titleIconHandling = titleIconHandling;
    }

    public IconHandling getTitleIconHandling() {
        return this.titleIconHandling;
    }

    public void setTitleIcon(Icon titleIcon) {
        switch (this.getTitleIconHandling()) {
            case KEEP_NULL_ICON: {
                this.titleIcon().setValue(titleIcon, true);
                break;
            }
            case REPLACE_NULL_ICON: {
                this.titleIcon().setValue(titleIcon, false);
                break;
            }
            default: {
                throw new IllegalStateException("unknown behavior: " + this.titleIconHandling);
            }
        }
    }

    public void resetTitleIcon() {
        this.titleIcon().setValue(null);
    }

    @Override
    public void requestDockTitle(DockTitleRequest request) {
    }

    @Override
    public void requestDisplayer(DisplayerRequest request) {
    }

    @Override
    public void bind(DockTitle title) {
        if (this.titles.contains(title)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(title);
        this.fireTitleBound(title);
    }

    @Override
    public void unbind(DockTitle title) {
        if (!this.titles.contains(title)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(title);
        this.fireTitleUnbound(title);
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return this.source;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    public void setActionOffers(DockActionSource source) {
        this.source = source;
        this.globalSource.update();
    }

    protected void fireTitleTextChanged(String oldTitle, String newTitle) {
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleTextChanged(this, oldTitle, newTitle);
        }
    }

    protected void fireTitleTooltipChanged(String oldTooltip, String newTooltip) {
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleToolTipChanged(this, oldTooltip, newTooltip);
        }
    }

    protected void fireTitleIconChanged(Icon oldIcon, Icon newIcon) {
        this.currentTitleIcon = newIcon;
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleIconChanged(this, oldIcon, newIcon);
        }
    }

    protected void fireTitleBound(DockTitle title) {
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleBound(this, title);
        }
    }

    protected void fireTitleUnbound(DockTitle title) {
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleUnbound(this, title);
        }
    }

    protected void fireTitleExchanged(DockTitle title) {
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleExchanged(this, title);
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] bound;
        for (DockTitle title : bound = this.listBoundTitles()) {
            this.fireTitleExchanged(title);
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints hints) {
        this.hints = hints;
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }
}

