/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedPerspective;

public class DefaultDockFrontendPerspective
implements DockFrontendPerspective {
    private DockFrontend frontend;
    private PredefinedPerspective perspective;
    private boolean entry;

    public DefaultDockFrontendPerspective(DockFrontend frontend, PredefinedPerspective perspective, boolean entry) {
        if (perspective == null) {
            throw new IllegalArgumentException("perspective must not be null");
        }
        this.frontend = frontend;
        this.perspective = perspective;
    }

    @Override
    public PropertyTransformer getPropertyTransformer() {
        return this.frontend.createPropertyTransformer();
    }

    @Override
    public PredefinedPerspective getPerspective() {
        return this.perspective;
    }

    @Override
    public PerspectiveStation getRoot(String root) {
        PerspectiveElement result = this.perspective.get("root" + root);
        if (result == null) {
            return null;
        }
        return result.asStation();
    }

    @Override
    public void apply() {
        this.frontend.setSetting(this.createSetting(), this.entry);
    }

    @Override
    public void store(String name) {
        this.frontend.setSetting(name, this.createSetting());
    }

    private Setting createSetting() {
        Setting setting = this.frontend.getSetting(this.entry);
        for (String key : this.frontend.getRootNames()) {
            setting.putRoot(key, this.perspective.convert(this.getRoot(key)));
        }
        return setting;
    }
}

