/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.VetoableDockFrontendEvent;
import bibliothek.gui.dock.event.VetoableDockFrontendListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VetoManager {
    private DockFrontend frontend;
    private Set<Dockable> expectedToShow = new HashSet<Dockable>();
    private Set<Dockable> expectedToHide = new HashSet<Dockable>();
    private Set<Dockable> dockables = new HashSet<Dockable>();
    private List<VetoableDockFrontendListener> vetoableListeners = new ArrayList<VetoableDockFrontendListener>();

    public VetoManager(DockFrontend frontend) {
        if (frontend == null) {
            throw new IllegalArgumentException("Frontend must not be null");
        }
        this.frontend = frontend;
        frontend.addFrontendListener(new DockFrontendAdapter(){

            @Override
            public void shown(DockFrontend frontend, Dockable dockable) {
                boolean expected = VetoManager.this.expectedToShow.remove(dockable);
                if (VetoManager.this.dockables.add(dockable)) {
                    VetoManager.this.fireShown(dockable, expected);
                }
            }

            @Override
            public void hidden(DockFrontend fronend, Dockable dockable) {
                boolean expected = VetoManager.this.expectedToHide.remove(dockable);
                if (VetoManager.this.dockables.remove(dockable)) {
                    VetoManager.this.fireHidden(dockable, expected);
                }
            }
        });
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public boolean expectToHide(Dockable dockable, boolean cancelable) {
        return this.expectToHide(DockUtilities.listDockables(dockable, true), cancelable);
    }

    public boolean expectToHide(Collection<Dockable> dockables, boolean cancelable) {
        boolean cancel = this.fireAllHiding(dockables, cancelable);
        if (cancel) {
            return false;
        }
        this.expectedToHide.addAll(dockables);
        return true;
    }

    public boolean expectToShow(Dockable dockable, boolean cancelable) {
        return this.expectToShow(DockUtilities.listDockables(dockable, true), cancelable);
    }

    public boolean expectToShow(Collection<Dockable> dockables, boolean cancelable) {
        boolean cancel = this.fireAllShowing(dockables, cancelable);
        if (cancel) {
            return false;
        }
        this.expectedToShow.addAll(dockables);
        return true;
    }

    public void addVetoableListener(VetoableDockFrontendListener listener) {
        this.vetoableListeners.add(listener);
    }

    public void removeVetoableListener(VetoableDockFrontendListener listener) {
        this.vetoableListeners.remove(listener);
    }

    protected VetoableDockFrontendListener[] vetoableListeners() {
        return this.vetoableListeners.toArray(new VetoableDockFrontendListener[this.vetoableListeners.size()]);
    }

    protected boolean fireAllHiding(Dockable dockable, boolean cancelable) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        List<Dockable> list = DockUtilities.listDockables(dockable, true);
        return this.fireAllHiding(list, cancelable);
    }

    protected boolean fireAllHiding(Collection<Dockable> dockables, boolean cancelable) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        if (dockables.isEmpty()) {
            return false;
        }
        VetoableDockFrontendEvent event = new VetoableDockFrontendEvent(this.frontend, cancelable, true, dockables.toArray(new Dockable[dockables.size()]));
        for (VetoableDockFrontendListener listener : this.vetoableListeners()) {
            listener.hiding(event);
        }
        return event.isCanceled();
    }

    protected void fireAllHidden(Collection<Dockable> dockables, boolean expected) {
        if (!dockables.isEmpty()) {
            VetoableDockFrontendEvent event = new VetoableDockFrontendEvent(this.frontend, false, expected, dockables.toArray(new Dockable[dockables.size()]));
            for (VetoableDockFrontendListener listener : this.vetoableListeners()) {
                listener.hidden(event);
            }
        }
    }

    protected void fireHidden(Dockable dockable, boolean expected) {
        VetoableDockFrontendEvent event = new VetoableDockFrontendEvent(this.frontend, false, expected, dockable);
        for (VetoableDockFrontendListener listener : this.vetoableListeners()) {
            listener.hidden(event);
        }
    }

    protected void fireAllHidden(Dockable dockable, boolean expected) {
        this.fireAllHidden(DockUtilities.listDockables(dockable, true), expected);
    }

    protected boolean fireAllShowing(Dockable dockable, boolean cancelable) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        return this.fireAllShowing(DockUtilities.listDockables(dockable, true), cancelable);
    }

    protected boolean fireAllShowing(Collection<Dockable> dockables, boolean cancelable) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        if (dockables.isEmpty()) {
            return false;
        }
        VetoableDockFrontendEvent event = new VetoableDockFrontendEvent(this.frontend, cancelable, true, dockables.toArray(new Dockable[dockables.size()]));
        for (VetoableDockFrontendListener listener : this.vetoableListeners()) {
            listener.showing(event);
        }
        return event.isCanceled();
    }

    protected void fireAllShown(Dockable dockable, boolean expected) {
        if (this.vetoableListeners.size() == 0) {
            return;
        }
        List<Dockable> list = DockUtilities.listDockables(dockable, true);
        this.fireAllShown(list, expected);
    }

    protected void fireAllShown(Collection<Dockable> dockables, boolean expected) {
        if (this.vetoableListeners.size() == 0) {
            return;
        }
        if (!dockables.isEmpty()) {
            VetoableDockFrontendEvent event = new VetoableDockFrontendEvent(this.frontend, false, expected, dockables.toArray(new Dockable[dockables.size()]));
            for (VetoableDockFrontendListener listener : this.vetoableListeners()) {
                listener.shown(event);
            }
        }
    }

    protected void fireShown(Dockable dockable, boolean expected) {
        VetoableDockFrontendEvent event = new VetoableDockFrontendEvent(this.frontend, false, expected, dockable);
        for (VetoableDockFrontendListener listener : this.vetoableListeners()) {
            listener.shown(event);
        }
    }
}

