/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindowBackgroundComponent;
import bibliothek.gui.dock.station.flap.FlapWindowBorder;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DefaultFlapWindow
implements FlapWindow,
MouseListener,
MouseMotionListener {
    private StationChildHandle dockable;
    private DockableDisplayerListener displayerListener = new DockableDisplayerListener(){

        @Override
        public void discard(DockableDisplayer displayer) {
            DefaultFlapWindow.this.discardDisplayer();
        }

        @Override
        public void moveableElementChanged(DockableDisplayer displayer) {
        }
    };
    private BorderForwarder contentBorder;
    private boolean pressed;
    private FlapDockStation station;
    private ButtonPane buttonPane;
    private FlapDropInfo dropInfo;
    private boolean removal;
    private JComponent contentPane;
    private Parent window;
    private SecureContainer contentContainer;
    private Background background = new Background();

    public DefaultFlapWindow(FlapDockStation station, ButtonPane buttonPane, Parent window) {
        this.station = station;
        this.buttonPane = buttonPane;
        this.window = window;
        this.init();
    }

    private void init() {
        this.contentContainer = new SecureContainer(){

            @Override
            protected void paintOverlay(Graphics g) {
                if (DefaultFlapWindow.this.removal || DefaultFlapWindow.this.dropInfo != null && DefaultFlapWindow.this.dropInfo.getCombineTarget() != null) {
                    Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    StationPaint paint = (StationPaint)DefaultFlapWindow.this.station.getPaint().get();
                    if (paint != null) {
                        if (DefaultFlapWindow.this.dropInfo != null && DefaultFlapWindow.this.dropInfo.getCombineTarget() != null) {
                            DefaultFlapWindow.this.dropInfo.getCombineTarget().paint(g, DefaultFlapWindow.this.contentContainer, paint, bounds, bounds);
                        } else if (DefaultFlapWindow.this.removal) {
                            paint.drawRemoval(g, DefaultFlapWindow.this.getStation(), bounds, bounds);
                        }
                    }
                }
            }
        };
        BackgroundPanel content = new BackgroundPanel(Transparency.SOLID){

            @Override
            protected void configure(Transparency transparency) {
            }

            @Override
            protected void setupRenderingHints(Graphics g) {
            }
        };
        content.setBackground(this.background);
        this.contentContainer.getBasePane().setLayout(new BorderLayout());
        this.contentContainer.getBasePane().add((Component)content, "Center");
        this.contentContainer.setContentPane(content);
        this.window.setContentPane(this.contentContainer);
        this.contentPane = this.contentContainer.getContentPane();
        this.contentPane.setOpaque(false);
        this.contentBorder = new WindowBorder(this.contentPane);
        this.contentBorder.setBorder(BorderFactory.createBevelBorder(0));
        this.contentPane.addMouseListener(this);
        this.contentPane.addMouseMotionListener(this);
        this.contentPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                DockableDisplayer displayer = DefaultFlapWindow.this.getDisplayer();
                if (displayer == null) {
                    return new Dimension(100, 100);
                }
                return displayer.getComponent().getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                DockableDisplayer displayer = DefaultFlapWindow.this.getDisplayer();
                if (displayer == null) {
                    return new Dimension(100, 100);
                }
                return displayer.getComponent().getMinimumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                DockableDisplayer displayer = DefaultFlapWindow.this.getDisplayer();
                if (displayer != null) {
                    Insets insets = parent.getInsets();
                    insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
                    if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                        insets.bottom += DefaultFlapWindow.this.station.getWindowBorder();
                    } else if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.NORTH) {
                        insets.top += DefaultFlapWindow.this.station.getWindowBorder();
                    } else if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.EAST) {
                        insets.right += DefaultFlapWindow.this.station.getWindowBorder();
                    } else {
                        insets.left += DefaultFlapWindow.this.station.getWindowBorder();
                    }
                    displayer.getComponent().setBounds(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
                }
            }
        });
        this.window.asComponent().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (!DefaultFlapWindow.this.station.isFlapWindow(DefaultFlapWindow.this) || DefaultFlapWindow.this.getDockable() == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultFlapWindow.this.destroy();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setWindowVisible(boolean flag) {
        if (flag) {
            this.updateBounds();
        }
        this.window.setVisible(flag);
    }

    @Override
    public boolean isWindowVisible() {
        return this.window != null && this.window.isVisible();
    }

    @Override
    public Rectangle getWindowBounds() {
        return this.window.asComponent().getBounds();
    }

    @Override
    public void destroy() {
        if (this.window != null) {
            this.setController(null);
            this.setDockable(null);
            this.window.destroy();
            this.window = null;
        }
    }

    @Override
    public void repaint() {
        if (this.window != null) {
            this.window.asComponent().repaint();
        }
    }

    @Override
    public Component getComponent() {
        if (this.window == null) {
            return null;
        }
        return this.window.asComponent();
    }

    public boolean isWindowValid() {
        return this.window != null && this.window.isParentValid();
    }

    @Override
    public boolean containsScreenPoint(Point point) {
        point = new Point(point);
        Component parent = this.window.asComponent();
        SwingUtilities.convertPointFromScreen(point, parent);
        return parent.contains(point);
    }

    public FlapDockStation getStation() {
        return this.station;
    }

    @Override
    public void setDropInfo(FlapDropInfo dropInfo) {
        this.dropInfo = dropInfo;
        this.repaint();
    }

    @Override
    public void setRemoval(boolean removal) {
        this.removal = removal;
        this.repaint();
    }

    @Override
    public void setDockTitle(DockTitleVersion title) {
        if (this.dockable != null) {
            this.dockable.setTitleRequest(title);
        }
    }

    @Override
    public DockTitle getDockTitle() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getTitle();
    }

    @Override
    public Dockable getDockable() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getDockable();
    }

    @Override
    public DockableDisplayer getDisplayer() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getDisplayer();
    }

    @Override
    public void setDockable(Dockable dockable) {
        DockableDisplayer displayer;
        Container content = this.getDisplayerParent();
        if (this.dockable != null) {
            displayer = this.getDisplayer();
            displayer.removeDockableDisplayerListener(this.displayerListener);
            content.remove(displayer.getComponent());
            this.dockable.destroy();
            this.dockable = null;
        }
        if (dockable != null) {
            this.dockable = new StationChildHandle(this.station, this.station.getDisplayers(), dockable, this.station.getTitleVersion());
            this.dockable.updateDisplayer();
            displayer = this.getDisplayer();
            displayer.addDockableDisplayerListener(this.displayerListener);
            content.add(displayer.getComponent());
        }
    }

    protected void discardDisplayer() {
        if (this.dockable != null) {
            DockableDisplayer displayer = this.dockable.getDisplayer();
            displayer.removeDockableDisplayerListener(this.displayerListener);
            this.contentPane.remove(displayer.getComponent());
            this.dockable.updateDisplayer();
            displayer = this.dockable.getDisplayer();
            displayer.addDockableDisplayerListener(this.displayerListener);
            this.contentPane.add(displayer.getComponent());
            this.updateBounds();
        }
    }

    protected Container getDisplayerParent() {
        return this.contentPane;
    }

    @Override
    public void setController(DockController controller) {
        this.background.setController(controller);
        this.contentContainer.setController(controller);
        this.contentBorder.setController(controller);
    }

    @Override
    public Insets getDockableInsets() {
        DockableDisplayer displayer = this.dockable.getDisplayer();
        Insets insets = displayer.getDockableInsets();
        displayer.getComponent().getBounds();
        Component parent = this.window.asComponent();
        Point zero = new Point(0, 0);
        zero = SwingUtilities.convertPoint(displayer.getComponent(), zero, parent);
        int deltaX = zero.x;
        int deltaY = zero.y;
        int deltaW = parent.getWidth() - displayer.getComponent().getWidth();
        int deltaH = parent.getHeight() - displayer.getComponent().getHeight();
        insets.left += deltaX;
        insets.top += deltaY;
        insets.right += deltaW - deltaX;
        insets.bottom += deltaH - deltaY;
        return insets;
    }

    @Override
    public void updateBounds() {
        Dockable dockable;
        DockableDisplayer displayer = this.getDisplayer();
        Dockable dockable2 = dockable = displayer == null ? null : displayer.getDockable();
        if (dockable != null) {
            Dimension size;
            Point location;
            this.window.asComponent().validate();
            FlapDockStation.Direction direction = this.station.getDirection();
            int windowSize = this.station.getWindowSize(dockable);
            Rectangle bounds = this.station.getExpansionBounds();
            Insets insets = this.getDockableInsets();
            if (direction == FlapDockStation.Direction.SOUTH) {
                location = new Point(bounds.x, bounds.height);
                size = new Dimension(bounds.width, windowSize += insets.top + insets.bottom);
            } else if (direction == FlapDockStation.Direction.NORTH) {
                location = new Point(bounds.x, -(windowSize += insets.top + insets.bottom));
                size = new Dimension(bounds.width, windowSize);
            } else if (direction == FlapDockStation.Direction.WEST) {
                location = new Point(-(windowSize += insets.left + insets.right), bounds.y);
                size = new Dimension(windowSize, bounds.height);
            } else {
                location = new Point(bounds.width, bounds.y);
                size = new Dimension(windowSize += insets.left + insets.right, bounds.height);
            }
            SwingUtilities.convertPointToScreen(location, this.buttonPane);
            this.window.setParentLocation(location);
            this.window.setSize(size);
            this.window.asComponent().validate();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.pressed) {
            this.window.asComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.station.getDirection() == FlapDockStation.Direction.EAST) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pressed) {
            Dockable dockable;
            DockableDisplayer displayer = this.getDisplayer();
            Dockable dockable2 = dockable = displayer == null ? null : displayer.getDockable();
            if (dockable != null) {
                Point mouse = new Point(e.getX(), e.getY());
                SwingUtilities.convertPointToScreen(mouse, e.getComponent());
                Component flap = this.station.getComponent();
                Point zero = new Point(0, 0);
                SwingUtilities.convertPointToScreen(zero, flap);
                int size = 0;
                size = this.station.getDirection() == FlapDockStation.Direction.SOUTH ? mouse.y - zero.y - flap.getHeight() : (this.station.getDirection() == FlapDockStation.Direction.NORTH ? zero.y - mouse.y : (this.station.getDirection() == FlapDockStation.Direction.EAST ? mouse.x - zero.x - flap.getWidth() : zero.x - mouse.x));
                size = Math.max(size, this.station.getWindowMinSize());
                Insets insets = this.getDockableInsets();
                size = this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH ? (size -= insets.top + insets.bottom) : (size -= insets.left + insets.right);
                if (size > 0) {
                    this.station.setWindowSize(dockable, size);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private class Background
    extends BackgroundAlgorithm
    implements FlapWindowBackgroundComponent {
        public Background() {
            super(FlapWindowBackgroundComponent.KIND, "dock.background.station.flap.window");
        }

        @Override
        public FlapWindow getWindow() {
            return DefaultFlapWindow.this;
        }

        @Override
        public DockStation getStation() {
            return DefaultFlapWindow.this.station;
        }

        @Override
        public Component getComponent() {
            return DefaultFlapWindow.this.window.asComponent();
        }
    }

    public static interface Parent {
        public boolean isParentValid();

        public Component asComponent();

        public void setParentLocation(Point var1);

        public void setSize(Dimension var1);

        public boolean isVisible();

        public void setVisible(boolean var1);

        public void setContentPane(Container var1);

        public Container getContentPane();

        public void destroy();
    }

    private class WindowBorder
    extends BorderForwarder
    implements FlapWindowBorder {
        public WindowBorder(JComponent target) {
            super(FlapWindowBorder.KIND, "dock.border.flap.window", target);
        }

        @Override
        public FlapWindow getWindow() {
            return DefaultFlapWindow.this;
        }

        @Override
        public FlapDockStation getStation() {
            return DefaultFlapWindow.this.getStation();
        }
    }

    public static class DialogParent
    extends JDialog
    implements Parent {
        private FlapDockStation station;

        public DialogParent(Frame owner, FlapDockStation station) {
            super(owner, false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.station = station;
        }

        public DialogParent(Dialog owner, FlapDockStation station) {
            super(owner, false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.station = station;
        }

        @Override
        public Component asComponent() {
            return this;
        }

        @Override
        public boolean isParentValid() {
            Window owner = SwingUtilities.getWindowAncestor(this.station.getComponent());
            return this.getOwner() == owner;
        }

        @Override
        public void setParentLocation(Point location) {
            this.setLocation(location);
        }

        @Override
        public void destroy() {
            this.dispose();
        }
    }
}

