/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.magnet;

import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.magnet.AttractorStrategy;
import bibliothek.gui.dock.station.screen.magnet.MagnetController;
import bibliothek.gui.dock.station.screen.magnet.MagnetRequest;
import bibliothek.gui.dock.station.screen.magnet.StickMagnetGraphConstraint;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class StickMagnetGraph {
    private MagnetController controller;
    private MagnetRequest request;
    private DefaultNode root;
    private List<DefaultNode> nodes = new ArrayList<DefaultNode>();
    private List<DefaultEdge> edges = new ArrayList<DefaultEdge>();

    public StickMagnetGraph(MagnetController controller, MagnetRequest request) {
        this.controller = controller;
        this.request = request;
    }

    public Node getRoot() {
        if (this.root == null) {
            ScreenDockWindow[] windows = this.controller.getWindows();
            DefaultNode[] nodes = new DefaultNode[windows.length];
            int index = 0;
            ScreenDockWindow window = this.request.getWindow();
            while (windows[index] != window) {
                ++index;
            }
            this.expand(index, nodes, windows);
            this.root = nodes[index];
        }
        return this.root;
    }

    public MagnetController getController() {
        return this.controller;
    }

    public MagnetRequest getRequest() {
        return this.request;
    }

    public String toString() {
        if (this.root == null) {
            return this.getClass().getSimpleName() + "[root=null]";
        }
        final StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[\nroot: ");
        this.getRoot().visit(new Visitor(){
            private int depth = 0;

            @Override
            public boolean beginVisit(Node node, boolean revisit) {
                builder.append(node.hashCode()).append(" '").append(node.getWindow().getDockable().getTitleText()).append("' ");
                builder.append(node.getConstraints()).append("\n");
                ++this.depth;
                return !revisit;
            }

            @Override
            public void endVisit(Edge edge) {
                --this.depth;
            }

            @Override
            public void endVisit(Node node) {
                --this.depth;
            }

            @Override
            public boolean beginVisit(Edge edge) {
                for (int i = 0; i < this.depth; ++i) {
                    builder.append("  ");
                }
                ++this.depth;
                builder.append("-> ").append(edge.getSide().name().toLowerCase());
                builder.append(" ");
                return true;
            }
        });
        builder.append("]");
        return builder.toString();
    }

    public void unmark() {
        for (DefaultNode node : this.nodes) {
            node.unmark();
        }
    }

    protected void expand(int index, DefaultNode[] nodes, ScreenDockWindow[] windows) {
        if (nodes[index] == null) {
            nodes[index] = new DefaultNode(index, windows[index]);
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(index);
        while (!queue.isEmpty()) {
            index = (Integer)queue.poll();
            int n = nodes.length;
            for (int i = 0; i < n; ++i) {
                MagnetRequest.Side relation;
                if (i == index || (relation = this.relation(windows[index], windows[i])) == null) continue;
                if (nodes[i] == null) {
                    nodes[i] = new DefaultNode(i, windows[i]);
                }
                nodes[index].add(relation, nodes[i]);
            }
            for (DefaultEdge edge : nodes[index].getEdges()) {
                if (edge.getTarget() == nodes[index]) continue;
                queue.offer(edge.getTarget().getIndex());
            }
        }
    }

    protected MagnetRequest.Side relation(ScreenDockWindow moved, ScreenDockWindow fixed) {
        AttractorStrategy.Attraction attraction = this.getController().getStickiness(moved.getDockable(), fixed.getDockable());
        if (attraction == AttractorStrategy.Attraction.ATTRACTED || attraction == AttractorStrategy.Attraction.STRONGLY_ATTRACTED) {
            MagnetController controller = this.getController();
            if (controller.intersectHorizontally(moved, fixed, true)) {
                if (controller.distance(moved, MagnetRequest.Side.EAST, fixed, MagnetRequest.Side.WEST, true) == 1) {
                    return MagnetRequest.Side.EAST;
                }
                if (controller.distance(moved, MagnetRequest.Side.WEST, fixed, MagnetRequest.Side.EAST, true) == 1) {
                    return MagnetRequest.Side.WEST;
                }
            }
            if (controller.intersectVertically(moved, fixed, true)) {
                if (controller.distance(moved, MagnetRequest.Side.NORTH, fixed, MagnetRequest.Side.SOUTH, true) == 1) {
                    return MagnetRequest.Side.NORTH;
                }
                if (controller.distance(moved, MagnetRequest.Side.SOUTH, fixed, MagnetRequest.Side.NORTH, true) == 1) {
                    return MagnetRequest.Side.SOUTH;
                }
            }
        }
        return null;
    }

    public void moveNeighbors() {
        Rectangle initial = this.request.getInitialBounds(this.request.getWindow());
        Rectangle current = this.request.getResultBounds();
        final int dx = current.x - initial.x;
        final int dy = current.y - initial.y;
        this.getRoot().visit(new Visitor(){

            @Override
            public boolean beginVisit(Edge edge) {
                return true;
            }

            @Override
            public void endVisit(Edge edge) {
            }

            @Override
            public boolean beginVisit(Node node, boolean revisit) {
                if (revisit) {
                    return false;
                }
                ScreenDockWindow window = node.getWindow();
                if (window != StickMagnetGraph.this.request.getWindow()) {
                    Rectangle bounds = StickMagnetGraph.this.request.getInitialBounds(window);
                    bounds.x += dx;
                    bounds.y += dy;
                    window.setWindowBounds(bounds);
                }
                return true;
            }

            @Override
            public void endVisit(Node node) {
            }
        });
    }

    public void moveAndResizeNeighbors() {
        Rectangle initial = this.request.getInitialBounds(this.request.getWindow());
        Rectangle current = this.request.getResultBounds();
        StickMagnetGraphConstraint constraint = this.getRoot().getConstraints();
        constraint.set(MagnetRequest.Side.NORTH, current.y - initial.y, true, true);
        constraint.set(MagnetRequest.Side.WEST, current.x - initial.x, true, true);
        constraint.set(MagnetRequest.Side.EAST, current.x + current.width - (initial.x + initial.width), true, true);
        constraint.set(MagnetRequest.Side.SOUTH, current.y + current.height - (initial.y + initial.height), true, true);
        for (MagnetRequest.Side side : MagnetRequest.Side.values()) {
            this.hardPush(side);
        }
        this.validateHardConstraints();
        this.buildConstraints();
        this.validateConstraints();
        this.executeConstraints();
    }

    protected DefaultEdge[] getEdgesByDistance() {
        DefaultEdge[] edges = this.edges.toArray(new DefaultEdge[this.edges.size()]);
        Arrays.sort(edges, new Comparator<DefaultEdge>(){

            @Override
            public int compare(DefaultEdge o1, DefaultEdge o2) {
                return o2.getTarget().getRootDistance() - o1.getTarget().getRootDistance();
            }
        });
        return edges;
    }

    protected void buildConstraints() {
        MagnetRequest.Side side;
        DefaultEdge[] edges;
        for (DefaultEdge edge : edges = this.getEdgesByDistance()) {
            DefaultNode target = edge.getTarget();
            StickMagnetGraphConstraint constraint = target.getConstraints();
            side = edge.getSide();
            StickMagnetGraphConstraint partner = edge.getSource().getConstraints();
            if (!partner.isSet(side)) continue;
            int delta = partner.get(side);
            constraint.set(side.opposite(), delta);
            if (partner.isDirect(side)) {
                constraint.setDirect(side.opposite(), true);
            }
            if (constraint.isDirect(side) && constraint.isSet(side)) continue;
            constraint.set(side, delta);
        }
        for (DefaultEdge edge : edges) {
            StickMagnetGraphConstraint source = edge.getSource().getConstraints();
            StickMagnetGraphConstraint target = edge.getTarget().getConstraints();
            side = edge.getSide();
            if (source.isSet(side) && !target.isDirect(side.opposite())) {
                target.set(side.opposite(), source.get(side));
            } else if (target.isSet(side.opposite()) && !source.isDirect(side)) {
                source.set(side, target.get(side.opposite()));
            }
            if (!source.isSet(side)) {
                source.set(side, 0);
            }
            if (target.isSet(side.opposite())) continue;
            target.set(side.opposite(), 0);
        }
    }

    protected void hardPush(final MagnetRequest.Side side) {
        this.getRoot().visit(new Visitor(){
            private Edge edge;

            @Override
            public boolean beginVisit(Edge edge) {
                int target;
                this.edge = edge;
                if (edge.getSide() == side) {
                    return true;
                }
                if (edge.getSide() == side.opposite()) {
                    return false;
                }
                int source = StickMagnetGraph.this.controller.getValue(edge.getSource().getWindow(), side, true);
                return source == (target = StickMagnetGraph.this.controller.getValue(edge.getTarget().getWindow(), side, true));
            }

            @Override
            public void endVisit(Edge edge) {
            }

            @Override
            public boolean beginVisit(Node node, boolean revisit) {
                if (revisit) {
                    return false;
                }
                StickMagnetGraphConstraint constraint = node.getConstraints();
                if (this.edge != null) {
                    if (this.edge.getSide() == side) {
                        constraint.setHard(side, true);
                        constraint.setHard(side.opposite(), true);
                    } else {
                        constraint.setHard(side, true);
                    }
                }
                return true;
            }

            @Override
            public void endVisit(Node node) {
            }
        });
    }

    protected void validateHardConstraints() {
        this.getRoot().visit(new Visitor(){

            @Override
            public boolean beginVisit(Edge edge) {
                if (edge.getSource().getConstraints().isHard(edge.getSide())) {
                    edge.getTarget().getConstraints().setHard(edge.getSide().opposite(), true);
                }
                return true;
            }

            @Override
            public void endVisit(Edge edge) {
            }

            @Override
            public boolean beginVisit(Node node, boolean revisit) {
                return !revisit;
            }

            @Override
            public void endVisit(Node node) {
            }
        });
    }

    protected void validateConstraints() {
        final ArrayList resizedVertically = new ArrayList();
        final ArrayList resizedHorizontally = new ArrayList();
        this.getRoot().visit(new Visitor(){

            @Override
            public void endVisit(Edge edge) {
            }

            @Override
            public void endVisit(Node node) {
            }

            @Override
            public boolean beginVisit(Edge edge) {
                return true;
            }

            @Override
            public boolean beginVisit(Node node, boolean revisit) {
                if (revisit) {
                    return false;
                }
                StickMagnetGraphConstraint constraints = node.getConstraints();
                if (constraints.isSet(MagnetRequest.Side.SOUTH) && constraints.isSet(MagnetRequest.Side.NORTH) && (!constraints.isHard(MagnetRequest.Side.SOUTH) || !constraints.isHard(MagnetRequest.Side.NORTH)) && constraints.get(MagnetRequest.Side.SOUTH) != constraints.get(MagnetRequest.Side.NORTH)) {
                    resizedVertically.add(node);
                }
                if (constraints.isSet(MagnetRequest.Side.EAST) && constraints.isSet(MagnetRequest.Side.WEST) && (!constraints.isHard(MagnetRequest.Side.EAST) || !constraints.isHard(MagnetRequest.Side.WEST)) && constraints.get(MagnetRequest.Side.EAST) != constraints.get(MagnetRequest.Side.WEST)) {
                    resizedHorizontally.add(node);
                }
                return true;
            }
        });
        for (Node node : resizedHorizontally) {
            this.resizeRipple(node, MagnetRequest.Side.WEST);
        }
        for (Node node : resizedVertically) {
            this.resizeRipple(node, MagnetRequest.Side.NORTH);
        }
    }

    protected void resizeRipple(Node node, MagnetRequest.Side topleft) {
        int leftInitial = this.rippleBorder(node, topleft, true);
        this.unmark();
        int rightInitial = this.rippleBorder(node, topleft.opposite(), true);
        this.unmark();
        int leftAfter = this.rippleBorder(node, topleft, false);
        this.unmark();
        int rightAfter = this.rippleBorder(node, topleft.opposite(), false);
        this.unmark();
        if (leftInitial == rightInitial || leftAfter == rightAfter) {
            return;
        }
        this.rippleSide(node, topleft, leftInitial, leftAfter, rightInitial, rightAfter);
        this.unmark();
        this.rippleSide(node, topleft.opposite(), leftInitial, leftAfter, rightInitial, rightAfter);
        this.unmark();
    }

    private int rippleBorder(Node start, MagnetRequest.Side direction, boolean initial) {
        start.mark();
        int result = this.controller.getValue(start.getWindow(), direction, true);
        if (!initial && start.getConstraints().isSet(direction)) {
            result += start.getConstraints().get(direction);
        }
        if (start.getConstraints().isHard(direction)) {
            return result;
        }
        if (direction == MagnetRequest.Side.NORTH || direction == MagnetRequest.Side.WEST) {
            for (Edge edge : start.getEdges()) {
                if (edge.getSource() == start && edge.getSide() == direction && !edge.getTarget().isMarked()) {
                    result = Math.min(result, this.rippleBorder(edge.getTarget(), direction, initial));
                    continue;
                }
                if (edge.getTarget() != start || edge.getSide() != direction.opposite() || edge.getSource().isMarked()) continue;
                result = Math.min(result, this.rippleBorder(edge.getSource(), direction, initial));
            }
        } else {
            for (Edge edge : start.getEdges()) {
                if (edge.getSource() == start && edge.getSide() == direction && !edge.getTarget().isMarked()) {
                    result = Math.max(result, this.rippleBorder(edge.getTarget(), direction, initial));
                    continue;
                }
                if (edge.getTarget() != start || edge.getSide() != direction.opposite() || edge.getSource().isMarked()) continue;
                result = Math.max(result, this.rippleBorder(edge.getSource(), direction, initial));
            }
        }
        return result;
    }

    private void rippleSide(Node start, MagnetRequest.Side direction, int leftInitial, int leftAfter, int rightInitial, int rightAfter) {
        StickMagnetGraphConstraint constraint = start.getConstraints();
        start.mark();
        if (constraint.isHard(direction)) {
            return;
        }
        for (Edge edge : start.getEdges()) {
            StickMagnetGraphConstraint next;
            Node target = null;
            if (edge.getSource() == start && edge.getSide() == direction) {
                target = edge.getTarget();
            } else if (edge.getTarget() == start && edge.getSide() == direction.opposite()) {
                target = edge.getSource();
            }
            if (target == null || target.isMarked() || !(next = target.getConstraints()).isHard(direction.opposite())) continue;
            return;
        }
        int value = this.controller.getValue(start.getWindow(), direction, true);
        if (value <= leftInitial || value >= rightInitial) {
            return;
        }
        double point = (double)(value - leftInitial) / (double)(rightInitial - leftInitial);
        int actual = (int)((double)leftAfter + point * (double)(rightAfter - leftAfter) + 0.5);
        int delta = actual - value;
        constraint.set(direction, delta, true, true);
        for (Edge edge : start.getEdges()) {
            Node target = null;
            if (edge.getSource() == start && edge.getSide() == direction) {
                target = edge.getTarget();
            } else if (edge.getTarget() == start && edge.getSide() == direction.opposite()) {
                target = edge.getSource();
            }
            if (target == null || target.isMarked()) continue;
            StickMagnetGraphConstraint next = target.getConstraints();
            next.set(direction.opposite(), delta, true, true);
            this.rippleSide(target, direction, leftInitial, leftAfter, rightInitial, rightAfter);
        }
    }

    protected void executeConstraints() {
        this.getRoot().visit(new Visitor(){

            @Override
            public boolean beginVisit(Edge edge) {
                return true;
            }

            @Override
            public void endVisit(Edge edge) {
            }

            @Override
            public boolean beginVisit(Node node, boolean revisit) {
                StickMagnetGraphConstraint constraint;
                if (revisit) {
                    return false;
                }
                if (node != StickMagnetGraph.this.getRoot() && (constraint = node.getConstraints()) != null) {
                    Rectangle initial = StickMagnetGraph.this.request.getInitialBounds(node.getWindow());
                    if (constraint.isSet(MagnetRequest.Side.NORTH)) {
                        initial.y += constraint.get(MagnetRequest.Side.NORTH);
                        if (constraint.isSet(MagnetRequest.Side.SOUTH)) {
                            initial.height -= constraint.get(MagnetRequest.Side.NORTH);
                            initial.height += constraint.get(MagnetRequest.Side.SOUTH);
                        }
                    } else if (constraint.isSet(MagnetRequest.Side.SOUTH)) {
                        initial.y += constraint.get(MagnetRequest.Side.SOUTH);
                    }
                    if (constraint.isSet(MagnetRequest.Side.WEST)) {
                        initial.x += constraint.get(MagnetRequest.Side.WEST);
                        if (constraint.isSet(MagnetRequest.Side.EAST)) {
                            initial.width -= constraint.get(MagnetRequest.Side.WEST);
                            initial.width += constraint.get(MagnetRequest.Side.EAST);
                        }
                    } else if (constraint.isSet(MagnetRequest.Side.EAST)) {
                        initial.x += constraint.get(MagnetRequest.Side.EAST);
                    }
                    node.getWindow().setWindowBounds(initial);
                }
                node.getConstraints().reset();
                return true;
            }

            @Override
            public void endVisit(Node node) {
            }
        });
    }

    public boolean depends(ScreenDockWindow window, MagnetRequest.Side side) {
        return this.depends(this.getRoot(), window, side);
    }

    private boolean depends(Node node, ScreenDockWindow window, MagnetRequest.Side side) {
        if (node.isMarked()) {
            return false;
        }
        if (node.getWindow() == window) {
            return true;
        }
        node.mark();
        for (Edge edge : node.getEdges()) {
            if (edge.getSide() != side && edge.getSide() != side.opposite()) continue;
            if (edge.getSource() == node) {
                if (!this.depends(edge.getTarget(), window, side)) continue;
                node.unmark();
                return true;
            }
            if (!this.depends(edge.getSource(), window, side)) continue;
            node.unmark();
            return true;
        }
        node.unmark();
        return false;
    }

    protected class DefaultNode
    implements Node {
        private ScreenDockWindow window;
        private int index;
        private List<DefaultEdge> edges;
        private boolean mark = false;
        private StickMagnetGraphConstraint constraints = new StickMagnetGraphConstraint();
        private int rootDistance = -1;

        public DefaultNode(int index, ScreenDockWindow window) {
            this.index = index;
            this.window = window;
            StickMagnetGraph.this.nodes.add(this);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                this.doVisit(visitor);
            }
            finally {
                StickMagnetGraph.this.unmark();
            }
        }

        @Override
        public StickMagnetGraphConstraint getConstraints() {
            return this.constraints;
        }

        public int getRootDistance() {
            if (this.rootDistance == -1) {
                int min = -1;
                for (DefaultEdge edge : this.edges) {
                    if (edge.getTarget() != this) continue;
                    int distance = edge.getSource().getRootDistance() + 1;
                    if (min == -1) {
                        min = distance;
                        continue;
                    }
                    min = Math.min(distance, min);
                }
                if (min == -1) {
                    min = 0;
                }
                this.rootDistance = min;
            }
            return this.rootDistance;
        }

        public void doVisit(Visitor visitor) {
            if (visitor.beginVisit(this, this.mark)) {
                this.mark = true;
                if (this.edges != null) {
                    for (DefaultEdge edge : this.edges) {
                        if (edge.getSource() != this || !visitor.beginVisit(edge)) continue;
                        edge.getTarget().doVisit(visitor);
                        visitor.endVisit(edge);
                    }
                }
            }
            visitor.endVisit(this);
        }

        @Override
        public void mark() {
            this.mark = true;
        }

        @Override
        public boolean isMarked() {
            return this.mark;
        }

        @Override
        public void unmark() {
            this.mark = false;
        }

        @Override
        public ScreenDockWindow getWindow() {
            return this.window;
        }

        public int getIndex() {
            return this.index;
        }

        public void add(MagnetRequest.Side side, DefaultNode depending) {
            if (!depending.contains(this) && !this.contains(depending)) {
                DefaultEdge edge = new DefaultEdge(this, depending, side);
                this.add(edge);
                depending.add(edge);
            }
        }

        public void add(DefaultEdge edge) {
            if (this.edges == null) {
                this.edges = new ArrayList<DefaultEdge>();
            }
            this.edges.add(edge);
            this.rootDistance = -1;
        }

        public boolean contains(DefaultNode node) {
            if (this.edges != null) {
                for (Edge edge : this.edges) {
                    if (edge.getTarget() != node) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public MagnetRequest.Side getNeighbor(ScreenDockWindow window) {
            if (this.edges != null && this.getWindow() != window) {
                for (Edge edge : this.edges) {
                    if (edge.getTarget().getWindow() != window) continue;
                    return edge.getSide();
                }
            }
            return null;
        }

        public DefaultEdge[] getEdges() {
            if (this.edges == null) {
                return new DefaultEdge[0];
            }
            return this.edges.toArray(new DefaultEdge[this.edges.size()]);
        }
    }

    public static interface Node {
        public ScreenDockWindow getWindow();

        public MagnetRequest.Side getNeighbor(ScreenDockWindow var1);

        public Edge[] getEdges();

        public void visit(Visitor var1);

        public StickMagnetGraphConstraint getConstraints();

        public void mark();

        public void unmark();

        public boolean isMarked();
    }

    public static interface Visitor {
        public boolean beginVisit(Node var1, boolean var2);

        public void endVisit(Node var1);

        public boolean beginVisit(Edge var1);

        public void endVisit(Edge var1);
    }

    protected class DefaultEdge
    implements Edge {
        private DefaultNode source;
        private DefaultNode target;
        private MagnetRequest.Side side;

        public DefaultEdge(DefaultNode source, DefaultNode target, MagnetRequest.Side side) {
            this.source = source;
            this.target = target;
            this.side = side;
            StickMagnetGraph.this.edges.add(this);
        }

        @Override
        public DefaultNode getSource() {
            return this.source;
        }

        @Override
        public DefaultNode getTarget() {
            return this.target;
        }

        @Override
        public MagnetRequest.Side getSide() {
            return this.side;
        }
    }

    public static interface Edge {
        public Node getSource();

        public Node getTarget();

        public MagnetRequest.Side getSide();
    }
}

