/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.magnet.MagnetizedOperation;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class WindowMover {
    private ScreenDockWindow window;
    private boolean allowDragAndDrop;
    private boolean resetOnDropable;
    private DockElementRepresentative element;
    private MouseInputAdapter listener = new Listener();
    private DragAcceptance acceptance;
    private VetoListener veto;
    private boolean onMouseEvent = false;

    public WindowMover(ScreenDockWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        this.window = window;
    }

    public void setElement(DockElementRepresentative element) {
        if (this.element != null) {
            this.element.removeMouseInputListener(this.listener);
        }
        this.element = element;
        this.uninstallDragAcceptance();
        this.uninstallVeto();
        if (this.element != null) {
            this.element.addMouseInputListener(this.listener);
        }
    }

    private void installDragAcceptance() {
        this.uninstallDragAcceptance();
        this.acceptance = new DragAcceptance(this.window.getStation().getController());
    }

    private void uninstallDragAcceptance() {
        if (this.acceptance != null) {
            this.acceptance.destroy();
            this.acceptance = null;
        }
    }

    private void installVeto() {
        this.uninstallVeto();
        this.veto = new VetoListener(this.window.getStation().getController());
    }

    private void uninstallVeto() {
        if (this.veto != null) {
            this.veto.destroy();
            this.veto = null;
        }
    }

    public void setAllowDragAndDrop(boolean allowDragAndDrop) {
        this.allowDragAndDrop = allowDragAndDrop;
    }

    public boolean isAllowDragAndDrop() {
        return this.allowDragAndDrop;
    }

    public void setResetOnDropable(boolean resetOnDropable) {
        this.resetOnDropable = resetOnDropable;
    }

    public boolean isResetOnDropable() {
        return this.resetOnDropable;
    }

    protected void convertPointToScreen(Point point, Component component) {
        SwingUtilities.convertPointToScreen(point, component);
    }

    private class Listener
    extends MouseInputAdapter {
        private Rectangle startBoundaries;
        private Point startPoint;
        private MagnetizedOperation magnet;
        private RemoteRelocator relocator;

        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                WindowMover.this.onMouseEvent = true;
                this.handleMousePressed(e);
            }
            finally {
                WindowMover.this.onMouseEvent = false;
            }
        }

        private void handleMousePressed(MouseEvent e) {
            if (!e.isConsumed() && !WindowMover.this.window.isFullscreen()) {
                DockController controller;
                int buttons = 7168;
                if (Integer.bitCount(buttons &= e.getModifiersEx()) == 1 && e.getButton() == 1) {
                    e.consume();
                    this.startBoundaries = WindowMover.this.window.getWindowBounds();
                    this.startPoint = e.getPoint();
                    WindowMover.this.convertPointToScreen(this.startPoint, e.getComponent());
                    this.magnet = WindowMover.this.window.getStation().getMagnetController().start(WindowMover.this.window);
                }
                WindowMover.this.installVeto();
                if (WindowMover.this.allowDragAndDrop && (controller = WindowMover.this.window.getStation().getController()) != null) {
                    this.relocator = controller.getRelocator().createRemote(WindowMover.this.window.getDockable());
                    this.relocator.setShowImageWindow(false);
                    DockableDisplayer displayer = WindowMover.this.window.getDockableDisplayer();
                    if (displayer != null) {
                        this.relocator.setTitle(displayer.getTitle());
                    }
                    RemoteRelocator.Reaction reaction = this.relocator.init(this.startPoint.x, this.startPoint.y, 0, 0, e.getModifiersEx());
                    switch (reaction) {
                        case BREAK: 
                        case BREAK_CONSUMED: {
                            this.relocator = null;
                            break;
                        }
                        case CONTINUE: 
                        case CONTINUE_CONSUMED: {
                            WindowMover.this.installDragAcceptance();
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                WindowMover.this.onMouseEvent = true;
                this.handleMouseDragged(e);
            }
            finally {
                WindowMover.this.onMouseEvent = false;
            }
        }

        private void handleMouseDragged(MouseEvent e) {
            if (!e.isConsumed()) {
                Point current = e.getPoint();
                WindowMover.this.convertPointToScreen(current, e.getComponent());
                if (this.relocator != null) {
                    RemoteRelocator.Reaction reaction = this.relocator.drag(current.x, current.y, e.getModifiersEx());
                    switch (reaction) {
                        case BREAK: {
                            this.relocator = null;
                            break;
                        }
                        case BREAK_CONSUMED: {
                            this.relocator = null;
                            e.consume();
                            break;
                        }
                        case CONTINUE_CONSUMED: {
                            e.consume();
                        }
                    }
                }
                if (this.startPoint != null) {
                    DockController controller;
                    e.consume();
                    int dx = current.x - this.startPoint.x;
                    int dy = current.y - this.startPoint.y;
                    Rectangle bounds = null;
                    if (this.relocator != null && WindowMover.this.resetOnDropable && (controller = WindowMover.this.window.getStation().getController()) != null && controller.getRelocator().hasTarget()) {
                        bounds = this.startBoundaries;
                    }
                    if (bounds == null) {
                        bounds = new Rectangle(this.startBoundaries.x + dx, this.startBoundaries.y + dy, this.startBoundaries.width, this.startBoundaries.height);
                    }
                    bounds = this.magnet.attract(bounds);
                    WindowMover.this.window.setWindowBounds(bounds);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                WindowMover.this.onMouseEvent = true;
                this.handleMouseReleased(e);
            }
            finally {
                WindowMover.this.onMouseEvent = false;
            }
        }

        private void handleMouseReleased(MouseEvent e) {
            Point current = e.getPoint();
            WindowMover.this.convertPointToScreen(current, e.getComponent());
            if (this.relocator != null) {
                RemoteRelocator.Reaction reaction = this.relocator.drop(current.x, current.y, e.getModifiersEx());
                switch (reaction) {
                    case BREAK: {
                        this.relocator = null;
                        WindowMover.this.uninstallDragAcceptance();
                        WindowMover.this.uninstallVeto();
                        break;
                    }
                    case BREAK_CONSUMED: {
                        this.relocator = null;
                        WindowMover.this.uninstallDragAcceptance();
                        WindowMover.this.uninstallVeto();
                        e.consume();
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        e.consume();
                    }
                }
            }
            if (e.getButton() == 1) {
                if (this.magnet != null) {
                    this.magnet.stop();
                }
                this.startPoint = null;
                this.startBoundaries = null;
                WindowMover.this.uninstallDragAcceptance();
                WindowMover.this.uninstallVeto();
            }
        }
    }

    private class DragAcceptance
    implements DockAcceptance {
        private DockController controller;

        public DragAcceptance(DockController controller) {
            this.controller = controller;
            controller.addAcceptance(this);
        }

        @Override
        public boolean accept(DockStation parent, Dockable child) {
            return parent != WindowMover.this.window.getStation();
        }

        @Override
        public boolean accept(DockStation parent, Dockable child, Dockable next) {
            return true;
        }

        public void destroy() {
            this.controller.removeAcceptance(this);
        }
    }

    private class VetoListener
    extends VetoableDockRelocatorAdapter {
        private DockRelocator relocator;

        public VetoListener(DockController controller) {
            this.relocator = controller.getRelocator();
            this.relocator.addVetoableDockRelocatorListener(this);
        }

        public void destroy() {
            this.relocator.removeVetoableDockRelocatorListener(this);
        }

        @Override
        public void grabbing(DockRelocatorEvent event) {
            if (!WindowMover.this.onMouseEvent) {
                event.ignore();
            }
        }

        @Override
        public void dragged(DockRelocatorEvent event) {
            if (!WindowMover.this.onMouseEvent) {
                event.ignore();
            }
        }

        @Override
        public void canceled(DockRelocatorEvent event) {
            if (!WindowMover.this.onMouseEvent) {
                event.ignore();
            }
        }
    }
}

