/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class DefaultSplitLayoutManager
implements SplitLayoutManager {
    @Override
    public void install(SplitDockStation station) {
    }

    @Override
    public void uninstall(SplitDockStation station) {
    }

    @Override
    public Dockable willMakeFullscreen(SplitDockStation station, Dockable dockable) {
        return dockable;
    }

    @Override
    public PutInfo prepareDrop(SplitDockStation station, StationDropItem item) {
        if (station.isFullScreen()) {
            return null;
        }
        if (station.getDockableCount() == 0) {
            PutInfo putInfo = new PutInfo(null, PutInfo.Put.CENTER, item.getDockable(), true);
            putInfo = this.validatePutInfo(station, putInfo);
            return putInfo;
        }
        Point point = new Point(item.getMouseX(), item.getMouseY());
        SwingUtilities.convertPointFromScreen(point, station);
        PutInfo putInfo = station.getRoot().getPut(point.x, point.y, item.getDockable());
        if (putInfo == null && station.isAllowSideSnap()) {
            putInfo = this.calculateSideSnap(station, point.x, point.y, null, item.getDockable());
            putInfo = this.validatePutInfo(station, putInfo);
        }
        if (putInfo != null) {
            putInfo.setDockable(item.getDockable());
            this.calculateDivider(station, putInfo, null, item);
        }
        return putInfo;
    }

    @Override
    public PutInfo prepareMove(SplitDockStation station, StationDropItem item) {
        if (station.isFullScreen()) {
            return null;
        }
        Point point = new Point(item.getMouseX(), item.getMouseY());
        SwingUtilities.convertPointFromScreen(point, station);
        Root root = station.getRoot();
        PutInfo putInfo = root.getPut(point.x, point.y, item.getDockable());
        Leaf leaf = root.getLeaf(item.getDockable());
        if (putInfo == null && station.isAllowSideSnap()) {
            putInfo = this.calculateSideSnap(station, point.x, point.y, leaf, item.getDockable());
            if ((putInfo = this.validatePutInfo(station, putInfo)) != null) {
                leaf = null;
            }
        }
        if (putInfo != null && putInfo.getNode() instanceof Leaf && ((Leaf)putInfo.getNode()).getDockable() == item.getDockable()) {
            putInfo.setNode(null);
        }
        if (putInfo != null) {
            putInfo.setDockable(item.getDockable());
            this.calculateDivider(station, putInfo, leaf, item);
        }
        return putInfo;
    }

    protected PutInfo calculateSideSnap(SplitDockStation station, int x, int y, Leaf leaf, Dockable drop) {
        Node node;
        if (station.getDockableCount() == 0) {
            return null;
        }
        if (station.getDockableCount() == 1 && station.getDockable(0) == drop) {
            return null;
        }
        PutInfo info = SplitNode.above(0.0, 0.0, station.getWidth(), station.getHeight(), x, y) ? (SplitNode.above(0.0, station.getHeight(), station.getWidth(), 0.0, x, y) ? new PutInfo(station.getRoot().getChild(), PutInfo.Put.TOP, drop, false) : new PutInfo(station.getRoot().getChild(), PutInfo.Put.RIGHT, drop, false)) : (SplitNode.above(0.0, station.getHeight(), station.getWidth(), 0.0, x, y) ? new PutInfo(station.getRoot().getChild(), PutInfo.Put.LEFT, drop, false) : new PutInfo(station.getRoot().getChild(), PutInfo.Put.BOTTOM, drop, false));
        if (leaf != null && station.getRoot().getChild() instanceof Node && (node = (Node)station.getRoot().getChild()).getLeft().isVisible() && node.getRight().isVisible()) {
            if (info.getPut() == PutInfo.Put.TOP && node.getOrientation() == SplitDockStation.Orientation.VERTICAL && node.getLeft() == leaf) {
                return null;
            }
            if (info.getPut() == PutInfo.Put.BOTTOM && node.getOrientation() == SplitDockStation.Orientation.VERTICAL && node.getRight() == leaf) {
                return null;
            }
            if (info.getPut() == PutInfo.Put.LEFT && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL && node.getLeft() == leaf) {
                return null;
            }
            if (info.getPut() == PutInfo.Put.RIGHT && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL && node.getRight() == leaf) {
                return null;
            }
        }
        return info;
    }

    @Override
    public void calculateDivider(SplitDockStation station, PutInfo putInfo, Leaf origin, StationDropItem item) {
        Dimension oldSize;
        double MINIMUM_ORIGINAL_SIZE = 0.25;
        SplitNode other = putInfo.getNode();
        if (other == null) {
            return;
        }
        Dimension dimension = oldSize = origin == null ? item.getOriginalSize() : origin.getSize();
        if (other.getParent() instanceof Root) {
            other = other.getParent();
        }
        Dimension nodeSize = other.getSize();
        int size = Math.min(oldSize.width, oldSize.height);
        if (origin != null) {
            if (origin.getParent() instanceof Node) {
                Node originParent = (Node)origin.getParent();
                if ((putInfo.getPut() == PutInfo.Put.LEFT || putInfo.getPut() == PutInfo.Put.RIGHT) && originParent.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    size = oldSize.width;
                } else if ((putInfo.getPut() == PutInfo.Put.TOP || putInfo.getPut() == PutInfo.Put.BOTTOM) && originParent.getOrientation() == SplitDockStation.Orientation.VERTICAL) {
                    size = oldSize.height;
                }
            }
        } else if (putInfo.getOldSize() != 0) {
            size = putInfo.getOldSize();
        }
        double divider = 0.5;
        int dividerSize = station.getDividerSize();
        if (putInfo.getPut() == PutInfo.Put.TOP) {
            if (size != 0) {
                divider = ((double)size + (double)dividerSize / 2.0) / (double)nodeSize.height;
            }
            if ((divider = this.validateDivider(station, divider, item.getMinimumSize(), other.getMinimumSize(), SplitDockStation.Orientation.VERTICAL, other.getWidth(), other.getHeight())) > 0.75) {
                divider = 0.75;
            }
        } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
            if (size != 0) {
                divider = 1.0 - ((double)size + (double)dividerSize / 2.0) / (double)nodeSize.height;
            }
            if ((divider = this.validateDivider(station, divider, other.getMinimumSize(), item.getMinimumSize(), SplitDockStation.Orientation.VERTICAL, other.getWidth(), other.getHeight())) < 0.25) {
                divider = 0.25;
            }
        } else if (putInfo.getPut() == PutInfo.Put.LEFT) {
            if (size != 0) {
                divider = ((double)size + (double)dividerSize / 2.0) / (double)nodeSize.width;
            }
            if ((divider = this.validateDivider(station, divider, item.getMinimumSize(), other.getMinimumSize(), SplitDockStation.Orientation.HORIZONTAL, other.getWidth(), other.getHeight())) > 0.75) {
                divider = 0.75;
            }
        } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
            if (size != 0) {
                divider = 1.0 - ((double)size + (double)dividerSize / 2.0) / (double)nodeSize.width;
            }
            if ((divider = this.validateDivider(station, divider, other.getMinimumSize(), item.getMinimumSize(), SplitDockStation.Orientation.HORIZONTAL, other.getWidth(), other.getHeight())) < 0.25) {
                divider = 0.25;
            }
        }
        putInfo.setDivider(divider);
        putInfo.setOldSize(size);
    }

    @Override
    public double validateDivider(SplitDockStation station, double divider, Node node) {
        divider = Math.min(1.0, Math.max(0.0, divider));
        SplitNode left = node.getLeft();
        SplitNode right = node.getRight();
        Dimension leftMin = null;
        Dimension rightMin = null;
        if (left != null) {
            leftMin = left.getMinimumSize();
        }
        if (right != null) {
            rightMin = right.getMinimumSize();
        }
        if (leftMin == null) {
            leftMin = new Dimension();
        }
        if (rightMin == null) {
            rightMin = new Dimension();
        }
        return this.validateDivider(station, divider, leftMin, rightMin, node.getOrientation(), node.getWidth(), node.getHeight());
    }

    protected double validateDivider(SplitDockStation station, double divider, Dimension minimumLeft, Dimension minimumRight, SplitDockStation.Orientation orientation, double width, double height) {
        int right;
        int left;
        double size;
        double factor;
        if (orientation == SplitDockStation.Orientation.HORIZONTAL) {
            factor = station.getRoot().getWidthFactor();
            size = width;
            left = minimumLeft.width;
            right = minimumRight.width;
        } else {
            factor = station.getRoot().getHeightFactor();
            size = height;
            left = minimumLeft.height;
            right = minimumRight.height;
        }
        if (factor <= 0.0 || Double.isNaN(factor)) {
            return divider;
        }
        double leftNeed = (double)left / factor;
        double rightNeed = (double)right / factor;
        double dividerNeed = (double)station.getDividerSize() / factor;
        if (leftNeed + rightNeed + dividerNeed >= size) {
            divider = (leftNeed + dividerNeed / 2.0) / (leftNeed + rightNeed + dividerNeed);
        } else if (divider * size < leftNeed + dividerNeed / 2.0) {
            divider = (leftNeed + dividerNeed / 2.0) / size;
        } else if (divider * size > size - rightNeed - dividerNeed / 2.0) {
            divider = (size - rightNeed - dividerNeed / 2.0) / size;
        }
        return divider;
    }

    @Override
    public PutInfo validatePutInfo(SplitDockStation station, PutInfo putInfo) {
        if (putInfo != null) {
            if (!station.accept(putInfo.getDockable())) {
                return null;
            }
            if (putInfo.getNode() != null && (putInfo.getPut() == PutInfo.Put.CENTER || putInfo.getPut() == PutInfo.Put.TITLE) ? !putInfo.getDockable().accept(station, ((Leaf)putInfo.getNode()).getDockable()) || !((Leaf)putInfo.getNode()).getDockable().accept(station, putInfo.getDockable()) || !station.getController().getAcceptance().accept(station, ((Leaf)putInfo.getNode()).getDockable(), putInfo.getDockable()) : !putInfo.getDockable().accept(station) || !station.getController().getAcceptance().accept(station, putInfo.getDockable())) {
                return null;
            }
        }
        return putInfo;
    }

    @Override
    public void updateBounds(Root root, double x, double y, double factorW, double factorH) {
        root.updateBounds(x, y, 1.0, 1.0, factorW, factorH, true);
    }
}

