/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.util.Map;

public class Placeholder
extends SplitNode {
    public Placeholder(SplitDockAccess access, long id) {
        super(access, id);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean checkValidity, Map<Leaf, Dockable> linksToSet) {
        this.setPlaceholders(key.getTree().getPlaceholders(key));
    }

    @Override
    public int getChildLocation(SplitNode child) {
        return -1;
    }

    @Override
    public Node getDividerNode(int x, int y) {
        return null;
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    @Override
    public PutInfo getPut(int x, int y, double factorW, double factorH, Dockable drop) {
        return null;
    }

    @Override
    public boolean aside(AsideRequest request) {
        if (request.getPlaceholder() != null) {
            this.addPlaceholder(request.getPlaceholder());
            AsideAnswer answer = request.forward(this.getStation().getCombiner(), this.getPlaceholderMap());
            if (answer.isCanceled()) {
                return false;
            }
            this.setPlaceholderMap(answer.getLayout());
        }
        return true;
    }

    @Override
    public boolean aside(SplitDockPathProperty property, int index, AsideRequest request) {
        if (request.getPlaceholder() != null) {
            if (index < property.size()) {
                Placeholder placeholder = this.createPlaceholder(property.getLeafId());
                this.split(property, index, placeholder);
                placeholder.aside(request);
            } else {
                this.aside(request);
            }
        }
        return true;
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty property, Dockable dockable) {
        Path placeholder = property.getPlaceholder();
        if (this.hasPlaceholder(placeholder)) {
            return this.replace(placeholder, dockable);
        }
        return false;
    }

    @Override
    public boolean insert(SplitDockPathProperty property, int depth, Dockable dockable) {
        if (property.getLeafId() == this.getId()) {
            return this.replace(null, dockable);
        }
        if (depth < property.size()) {
            Leaf leaf = this.create(dockable, property.getLeafId());
            if (leaf == null) {
                return false;
            }
            this.split(property, depth, leaf);
            leaf.setDockable(dockable, null);
            return true;
        }
        return false;
    }

    private boolean replace(Path placeholder, Dockable dockable) {
        Leaf leaf = this.create(dockable, this.getId());
        if (leaf == null) {
            return false;
        }
        this.ensureOnlyOnThisNode(placeholder);
        this.ensureOnlyOnThisNode(this.getAccess().getOwner().getPlaceholderStrategy().getPlaceholderFor(dockable));
        leaf.setPlaceholders(this.getPlaceholders());
        this.replace(leaf);
        leaf.setPlaceholderMap(this.getPlaceholderMap());
        leaf.setDockable(dockable, null);
        return true;
    }

    private void ensureOnlyOnThisNode(Path placeholder) {
        if (placeholder != null) {
            this.getAccess().getPlaceholderSet().set((SplitNode)this, placeholder, this);
        }
    }

    @Override
    public boolean isInOverrideZone(int x, int y, double factorW, double factorH) {
        return false;
    }

    @Override
    public void setChild(SplitNode child, int location) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getMaxChildrenCount() {
        return 0;
    }

    @Override
    public SplitNode getChild(int location) {
        return null;
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> factory) {
        return factory.placeholder(this.getId(), this.getPlaceholders(), this.getPlaceholderMap());
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public SplitNode getVisible() {
        return null;
    }

    @Override
    public boolean isOfUse() {
        if (!this.getAccess().isTreeAutoCleanupEnabled()) {
            return true;
        }
        return this.hasPlaceholders();
    }

    @Override
    public void visit(SplitNodeVisitor visitor) {
        visitor.handlePlaceholder(this);
    }

    @Override
    public void toString(int tabs, StringBuilder out) {
        out.append("Placeholder: ");
        boolean first = true;
        for (Path key : this.getPlaceholders()) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(key);
        }
    }
}

