/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeAdapter;
import bibliothek.util.Path;
import java.util.ArrayList;

public class SplitDockPlaceholderMapping
implements PlaceholderMapping {
    private SplitDockStation station;

    public SplitDockPlaceholderMapping(SplitDockStation station) {
        this.station = station;
    }

    @Override
    public SplitDockStation getStation() {
        return this.station;
    }

    @Override
    public void addPlaceholder(Dockable dockable, Path placeholder) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (placeholder == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        Leaf leaf = this.station.getRoot().getLeaf(dockable);
        if (leaf == null) {
            throw new IllegalArgumentException("unable to find location of dockable");
        }
        this.removePlaceholder(leaf, placeholder);
        leaf.addPlaceholder(placeholder);
    }

    @Override
    public void removePlaceholder(Path placeholder) {
        this.removePlaceholder(null, placeholder);
    }

    private void removePlaceholder(final Leaf ignore, final Path placeholder) {
        final ArrayList nodesToRemove = new ArrayList();
        this.station.getRoot().visit(new SplitNodeAdapter(){

            @Override
            public void handlePlaceholder(Placeholder node) {
                node.removePlaceholder(placeholder);
                if (!node.isOfUse()) {
                    nodesToRemove.add(node);
                }
            }

            @Override
            protected void handle(SplitNode node) {
                if (node != ignore) {
                    node.removePlaceholder(placeholder);
                }
            }
        });
        for (Placeholder node : nodesToRemove) {
            node.delete(true);
        }
    }

    @Override
    public Dockable getDockableAt(Path placeholder) {
        FindDockable finder = new FindDockable(placeholder);
        this.station.getRoot().visit(finder);
        return finder.getResult();
    }

    @Override
    public DockableProperty getLocationAt(Path placeholder) {
        SplitDockPathProperty path = this.station.getDockablePathProperty(placeholder);
        return new SplitDockPlaceholderProperty(placeholder, path);
    }

    @Override
    public boolean hasPlaceholder(Path placeholder) {
        HasPlaceholderFinder finder = new HasPlaceholderFinder(placeholder);
        this.station.getRoot().visit(finder);
        return finder.isFound();
    }

    private static class FindDockable
    extends SplitNodeAdapter {
        private Path placeholder;
        private Dockable result;

        public FindDockable(Path placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public void handleLeaf(Leaf leaf) {
            if (leaf.hasPlaceholder(this.placeholder)) {
                this.result = leaf.getDockable();
            }
        }

        public Dockable getResult() {
            return this.result;
        }
    }

    private static class HasPlaceholderFinder
    extends SplitNodeAdapter {
        private Path placeholder;
        private boolean found;

        public HasPlaceholderFinder(Path placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        protected void handle(SplitNode node) {
            if (node.hasPlaceholder(this.placeholder)) {
                this.found = true;
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }
}

