/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;

public class SplitDockStationLayout {
    private Entry root;
    private int fullscreen;
    private boolean hasFullscreenAction;

    @Deprecated
    public SplitDockStationLayout(Entry root, int fullscreen) {
        this(root, fullscreen, true);
    }

    public SplitDockStationLayout(Entry root, int fullscreen, boolean hasFullscreenAction) {
        this.root = root;
        this.fullscreen = fullscreen;
        this.hasFullscreenAction = hasFullscreenAction;
    }

    public Entry getRoot() {
        return this.root;
    }

    public int getFullscreen() {
        return this.fullscreen;
    }

    public boolean hasFullscreenAction() {
        return this.hasFullscreenAction;
    }

    public static abstract class Entry {
        private Node parent;
        private long id;
        private Path[] placeholders;
        private PlaceholderMap placeholderMap;

        public Entry(Path[] placeholders, PlaceholderMap placeholderMap, long id) {
            this.placeholders = placeholders;
            this.placeholderMap = placeholderMap;
            this.id = id;
        }

        protected void setParent(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public long getNodeId() {
            return this.id;
        }

        public Leaf asLeaf() {
            return null;
        }

        public Node asNode() {
            return null;
        }

        public abstract boolean isVisible();

        public SplitDockPathProperty createPathProperty() {
            SplitDockPathProperty path = null;
            path = this.parent != null ? this.parent.createPathProperty(this) : new SplitDockPathProperty();
            path.setLeafId(this.getNodeId());
            return path;
        }

        public Path[] getPlaceholders() {
            return this.placeholders;
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }
    }

    public static class Node
    extends Entry {
        private SplitDockStation.Orientation orientation;
        private double divider;
        private Entry childA;
        private Entry childB;

        public Node(SplitDockStation.Orientation orientation, double divider, Entry childA, Entry childB, Path[] placeholders, PlaceholderMap placeholderMap, long id) {
            super(placeholders, placeholderMap, id);
            this.orientation = orientation;
            this.divider = divider;
            this.childA = childA;
            this.childB = childB;
            if (childA != null) {
                childA.setParent(this);
            }
            if (childB != null) {
                childB.setParent(this);
            }
        }

        @Override
        public Node asNode() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.childA.isVisible() && this.childB.isVisible();
        }

        public SplitDockPathProperty createPathProperty(Entry child) {
            boolean childAvisible = this.childA.isVisible();
            boolean childBvisible = this.childB.isVisible();
            if (childAvisible && childBvisible) {
                SplitDockPathProperty property = this.createPathProperty();
                if (child == this.childA) {
                    if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                        property.add(SplitDockPathProperty.Location.LEFT, this.divider, child.getNodeId());
                    } else {
                        property.add(SplitDockPathProperty.Location.TOP, this.divider, child.getNodeId());
                    }
                } else if (child == this.childB) {
                    if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                        property.add(SplitDockPathProperty.Location.RIGHT, 1.0 - this.divider, child.getNodeId());
                    } else {
                        property.add(SplitDockPathProperty.Location.BOTTOM, 1.0 - this.divider, child.getNodeId());
                    }
                }
                return property;
            }
            Node parent = this.getParent();
            if (parent != null) {
                return parent.createPathProperty(this);
            }
            return new SplitDockPathProperty();
        }

        public SplitDockStation.Orientation getOrientation() {
            return this.orientation;
        }

        public double getDivider() {
            return this.divider;
        }

        public Entry getChildA() {
            return this.childA;
        }

        public Entry getChildB() {
            return this.childB;
        }
    }

    public static class Leaf
    extends Entry {
        private int id;

        public Leaf(int id, Path[] placeholders, PlaceholderMap placeholderMap, long nodeId) {
            super(placeholders, placeholderMap, nodeId);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public Leaf asLeaf() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.id != -1;
        }
    }
}

