/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Set;

public abstract class SplitDockTree<D> {
    private Key root;
    private Set<D> dockables = new HashSet<D>();

    public abstract D[] array(int var1);

    public D[] array(D dockable) {
        boolean[] array = this.array(true);
        array[0] = dockable;
        return array;
    }

    public Key root(D dockable) {
        this.root = this.put(this.array(dockable));
        return this.root;
    }

    public Key unroot() {
        Key key = this.root;
        this.root = null;
        return key;
    }

    public SplitDockTree<D> root(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (key.getTree() != this) {
            throw new IllegalArgumentException("Key is not created by this tree");
        }
        if (key.parent != null) {
            throw new IllegalArgumentException("Key has a parent, and can't be the root");
        }
        this.root = key;
        return this;
    }

    public Key put(D dockable, long nodeId) {
        boolean[] array = this.array(true);
        array[0] = dockable;
        return this.put((D[])array, (D)null, nodeId);
    }

    public Key put(D ... dockables) {
        return this.put(dockables, (D)null);
    }

    public Key put(D[] dockables, D selected) {
        return this.put(dockables, selected, -1L);
    }

    public Key put(D[] dockables, D selected, long nodeId) {
        return this.put(dockables, selected, null, null, nodeId);
    }

    public Key put(Path[] placeholders, PlaceholderMap placeholderMap) {
        return this.put(placeholders, placeholderMap, -1L);
    }

    public Key put(Path[] placeholders, PlaceholderMap placeholderMap, long nodeId) {
        return this.put((D[])null, (D)null, placeholders, placeholderMap, nodeId);
    }

    public Key put(D[] dockables, D selected, Path[] placeholders, PlaceholderMap placeholderMap, long nodeId) {
        if (placeholders == null || placeholders.length == 0) {
            if (dockables == null) {
                throw new IllegalArgumentException("Dockables must not be null");
            }
            if (dockables.length == 0) {
                throw new IllegalArgumentException("At least one Dockable is required");
            }
        }
        if (dockables != null) {
            for (D dockable : dockables) {
                if (dockable == null) {
                    throw new IllegalArgumentException("Entries of array must not be null");
                }
                if (this.dockables.add(dockable)) continue;
                throw new IllegalArgumentException("Dockable already known");
            }
        }
        return new Leaf(dockables, selected, placeholders, placeholderMap, nodeId);
    }

    public Key horizontal(D left, D right) {
        return this.horizontal(this.put(this.array(left)), this.put(this.array(right)));
    }

    public Key horizontal(D left, D right, double divider) {
        return this.horizontal(this.put(this.array(left)), this.put(this.array(right)), divider);
    }

    public Key horizontal(Key left, Key right) {
        return this.horizontal(left, right, 0.5);
    }

    public Key horizontal(Key left, Key right, double divider) {
        return this.horizontal(left, right, divider, -1L);
    }

    public Key horizontal(Key left, Key right, double divider, long nodeId) {
        return this.horizontal(left, right, divider, null, null, nodeId);
    }

    public Key horizontal(Key left, Key right, double divider, Path[] placeholders, PlaceholderMap placeholderMap, long nodeId) {
        return new Node(left, right, divider, true, placeholders, placeholderMap, nodeId);
    }

    public Key vertical(D top, D bottom) {
        return this.vertical(this.put(this.array(top)), this.put(this.array(bottom)));
    }

    public Key vertical(D top, D bottom, double divider) {
        return this.vertical(this.put(this.array(top)), this.put(this.array(bottom)), divider);
    }

    public Key vertical(Key top, Key bottom) {
        return this.vertical(top, bottom, 0.5);
    }

    public Key vertical(Key top, Key bottom, double divider) {
        return this.vertical(top, bottom, divider, -1L);
    }

    public Key vertical(Key top, Key bottom, double divider, long nodeId) {
        return this.vertical(top, bottom, divider, null, null, nodeId);
    }

    public Key vertical(Key top, Key bottom, double divider, Path[] placeholders, PlaceholderMap placeholderMap, long nodeId) {
        return new Node(top, bottom, divider, false, placeholders, placeholderMap, nodeId);
    }

    public Key getRoot() {
        return this.root;
    }

    public boolean isDockable(Key key) {
        return key.asLeaf() != null;
    }

    public boolean isNode(Key key) {
        return key.asNode() != null;
    }

    public boolean isPlaceholder(Key key) {
        return key.placeholders != null && key.placeholders.length > 0;
    }

    public Path[] getPlaceholders(Key key) {
        return key.placeholders;
    }

    public PlaceholderMap getPlaceholderMap(Key key) {
        return key.placeholderMap;
    }

    public D[] getDockables() {
        return this.dockables.toArray(this.array((D)this.dockables.size()));
    }

    public D[] getDockables(Key key) {
        if (!this.isDockable(key)) {
            throw new IllegalArgumentException("Not a Dockable");
        }
        return key.asLeaf().dockables;
    }

    public D getSelected(Key key) {
        if (!this.isDockable(key)) {
            throw new IllegalArgumentException("Not a Dockable");
        }
        return key.asLeaf().selected;
    }

    public boolean isHorizontal(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().horizontal;
    }

    public Key getLeft(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyA;
    }

    public Key getRight(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyB;
    }

    public Key getTop(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyA;
    }

    public Key getBottom(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyB;
    }

    public double getDivider(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().divider;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName() + "[root=\n");
        if (this.root == null) {
            builder.append("null");
        } else {
            this.root.toString(builder, 1);
        }
        builder.append("\n]");
        return builder.toString();
    }

    public abstract class Key {
        private Key parent;
        private long id;
        private Path[] placeholders;
        private PlaceholderMap placeholderMap;

        public Key(Path[] placeholders, PlaceholderMap placeholderMap, long id) {
            this.id = id;
            if (placeholders != null) {
                this.placeholders = (Path[])placeholders.clone();
            }
            if (placeholderMap != null) {
                this.placeholderMap = placeholderMap.copy();
            }
        }

        protected abstract void toString(StringBuilder var1, int var2);

        public SplitDockTree<D> getTree() {
            return SplitDockTree.this;
        }

        public Key getParent() {
            return this.parent;
        }

        private void setParent(Key parent) {
            this.parent = parent;
        }

        public void setNodeId(long id) {
            this.id = id;
        }

        public long getNodeId() {
            return this.id;
        }

        protected Leaf asLeaf() {
            return null;
        }

        protected Node asNode() {
            return null;
        }
    }

    private class Leaf
    extends Key {
        public D[] dockables;
        public D selected;

        public Leaf(D[] dockables, D selected, Path[] placeholders, PlaceholderMap placeholderMap, long id) {
            super(placeholders, placeholderMap, id);
            if (dockables != null) {
                this.dockables = (Object[])dockables.clone();
            }
            this.selected = selected;
        }

        @Override
        public Leaf asLeaf() {
            return this;
        }

        @Override
        protected void toString(StringBuilder builder, int depth) {
            for (int i = 0; i < depth; ++i) {
                builder.append("\t");
            }
            builder.append("Leaf[dockables: ").append(this.dockables == null ? 0 : this.dockables.length);
            Path[] placeholders = SplitDockTree.this.getPlaceholders(this);
            if (placeholders != null) {
                builder.append(", placeholders: ");
                for (Path placeholder : placeholders) {
                    builder.append(placeholder);
                }
            }
            builder.append("]");
        }
    }

    private class Node
    extends Key {
        public Key keyA;
        public Key keyB;
        public double divider;
        public boolean horizontal;

        public Node(Key keyA, Key keyB, double divider, boolean horizontal, Path[] placeholders, PlaceholderMap placeholderMap, long id) {
            super(placeholders, placeholderMap, id);
            if (keyA.getTree() != this.getTree()) {
                throw new IllegalArgumentException("Key of first argument belongs not to this tree");
            }
            if (keyB.getTree() != this.getTree()) {
                throw new IllegalArgumentException("Key of second argument belongs not to this tree");
            }
            if (divider < 0.0 || divider > 1.0) {
                throw new IllegalArgumentException("Divider out of bounds, must be between 0 and 1");
            }
            if (keyA.getParent() != null) {
                throw new IllegalArgumentException("First key already has a parent");
            }
            if (keyB.getParent() != null) {
                throw new IllegalArgumentException("Second key already has a parent");
            }
            if (keyA == keyB) {
                throw new IllegalArgumentException("The arguments must not be the same object");
            }
            if (keyA == SplitDockTree.this.root) {
                throw new IllegalArgumentException("First argument is the root, can't be a child of any other node");
            }
            if (keyB == SplitDockTree.this.root) {
                throw new IllegalArgumentException("Second argument is the root, can't be a child of any other node");
            }
            keyA.setParent(this);
            keyB.setParent(this);
            this.keyA = keyA;
            this.keyB = keyB;
            this.divider = divider;
            this.horizontal = horizontal;
        }

        @Override
        protected Node asNode() {
            return this;
        }

        @Override
        protected void toString(StringBuilder builder, int depth) {
            for (int i = 0; i < depth; ++i) {
                builder.append("\t");
            }
            builder.append("Node[divider: ").append(this.divider);
            Path[] placeholders = SplitDockTree.this.getPlaceholders(this);
            if (placeholders != null) {
                builder.append(", placeholders: ");
                for (Path placeholder : placeholders) {
                    builder.append(placeholder);
                }
            }
            builder.append("]\n");
            this.keyA.toString(builder, depth + 1);
            builder.append("\n");
            this.keyB.toString(builder, depth + 1);
        }
    }
}

