/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SpanSplitNode;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import java.awt.Rectangle;

public class SplitSpanStrategy {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int TOP = 2;
    private static final int BOTTOM = 3;
    private SplitDockStation station;
    private StationSpanFactoryValue factory;
    private PutInfo lastPut;

    public SplitSpanStrategy(SplitDockStation station) {
        this.station = station;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.split", station){

            @Override
            protected void changed() {
                SplitSpanStrategy.this.reset();
            }
        };
    }

    public void setPut(PutInfo info) {
        Span[] spans;
        PutInfo.Put put;
        if (info != null && (put = info.getPut()) != PutInfo.Put.LEFT && put != PutInfo.Put.RIGHT && put != PutInfo.Put.TOP && put != PutInfo.Put.BOTTOM) {
            info = null;
        }
        if (info != null && info.willHaveNoEffect()) {
            return;
        }
        if (info != null && this.lastPut != null && info.getPut() == this.lastPut.getPut() && info.getNode() == this.lastPut.getNode()) {
            return;
        }
        if (this.lastPut != null && (spans = this.getSpans(this.lastPut)) != null) {
            spans[this.putToPosition(this.lastPut.getPut())].mutate(SpanMode.OFF);
        }
        this.lastPut = info;
        if (info != null) {
            put = info.getPut();
            Span[] spans2 = this.getSpans(info);
            if (spans2 != null) {
                int position = this.putToPosition(put);
                double divider = info.getDivider();
                int size = 100;
                SplitNode node = info.getNode();
                if (node.getParent() == this.station.getRoot()) {
                    node = node.getParent();
                }
                switch (put) {
                    case LEFT: {
                        size = (int)((double)node.getSize().width * divider);
                        break;
                    }
                    case RIGHT: {
                        size = (int)((double)node.getSize().width * (1.0 - divider));
                        break;
                    }
                    case TOP: {
                        size = (int)((double)node.getSize().height * divider);
                        break;
                    }
                    case BOTTOM: {
                        size = (int)((double)node.getSize().height * (1.0 - divider));
                    }
                }
                spans2[position].configureSize(SpanMode.OPEN, size);
                spans2[position].mutate(SpanMode.OPEN);
            }
        }
    }

    public int putToPosition(PutInfo.Put put) {
        switch (put) {
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return 1;
            }
            case TOP: {
                return 2;
            }
            case BOTTOM: {
                return 3;
            }
        }
        throw new IllegalArgumentException("not a side: " + put);
    }

    public Span[] getSpans(PutInfo put) {
        SplitNode node = put.getNode();
        if (node instanceof Leaf) {
            return ((Leaf)node).getSpans();
        }
        if (node instanceof Root) {
            return ((Root)node).getSpans();
        }
        if (node.getParent() instanceof Root) {
            return ((Root)node.getParent()).getSpans();
        }
        return null;
    }

    public void unsetPut() {
        if (this.lastPut != null) {
            Span[] spans = this.getSpans(this.lastPut);
            this.lastPut = null;
            if (spans != null) {
                for (int i = 0; i < 4; ++i) {
                    spans[i].set(SpanMode.OFF);
                }
            }
        }
    }

    private void reset() {
        this.station.getRoot().visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
                root.createSpans();
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
            }

            @Override
            public void handleNode(Node node) {
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                leaf.createSpans();
            }
        });
    }

    public StationSpanFactoryValue getFactory() {
        return this.factory;
    }

    public void setController(DockController controller) {
        this.factory.setController(controller);
    }

    public Span[] createSpans(SpanSplitNode node) {
        if (this.factory.get() == null) {
            return null;
        }
        Span[] result = new Span[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = this.createSpan(i, node);
        }
        return result;
    }

    private Span createSpan(final int position, final SpanSplitNode node) {
        return ((SpanFactory)this.factory.get()).create(new SpanCallback(){

            @Override
            public void resized() {
                node.onSpanResize();
            }

            @Override
            public boolean isVertical() {
                return position == 2 || position == 3;
            }

            @Override
            public boolean isHorizontal() {
                return position == 0 || position == 1;
            }

            @Override
            public DockStation getStation() {
                return SplitSpanStrategy.this.station;
            }

            @Override
            public SpanUsage getUsage() {
                return SpanUsage.INSERTING;
            }
        });
    }

    public Rectangle modifyBounds(Rectangle bounds, SpanSplitNode node) {
        Span[] spans = node.getSpans();
        if (spans == null) {
            return bounds;
        }
        Rectangle copy = new Rectangle(bounds);
        int left = spans[0].getSize();
        int right = spans[1].getSize();
        int top = spans[2].getSize();
        int bottom = spans[3].getSize();
        copy.x += left;
        copy.width -= left + right;
        copy.y += top;
        copy.height -= top + bottom;
        return copy;
    }
}

