/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.disable.TabDisablingStrategyObserver;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.util.SimpleDockElementRepresentative;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class DefaultStackDockComponent
extends JTabbedPane
implements StackDockComponent {
    private List<Tab> dockables = new ArrayList<Tab>();
    private DockController controller;
    private Tab mouseTarget;
    private List<StackDockComponentListener> listeners = new ArrayList<StackDockComponentListener>();
    private TabDisablingStrategyObserver tabDisabling = new TabDisablingStrategyObserver(){

        @Override
        public void setDisabled(Dockable dockable, boolean disabled) {
            int index = DefaultStackDockComponent.this.indexOf(dockable);
            if (index >= 0) {
                DefaultStackDockComponent.this.setEnabledAt(index, !disabled);
            }
        }
    };

    public DefaultStackDockComponent() {
        super(3);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addChangeListener(listener);
        this.setOpaque(false);
    }

    @Override
    public void addStackDockComponentListener(StackDockComponentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeStackDockComponentListener(StackDockComponentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setDockTabPlacement(TabPlacement tabSide) {
        switch (tabSide) {
            case BOTTOM_OF_DOCKABLE: {
                this.setTabPlacement(3);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.setTabPlacement(2);
                break;
            }
            case TOP_OF_DOCKABLE: {
                this.setTabPlacement(1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.setTabPlacement(4);
            }
        }
    }

    @Override
    public TabPlacement getDockTabPlacement() {
        switch (this.getTabPlacement()) {
            case 3: {
                return TabPlacement.BOTTOM_OF_DOCKABLE;
            }
            case 2: {
                return TabPlacement.LEFT_OF_DOCKABLE;
            }
            case 4: {
                return TabPlacement.RIGHT_OF_DOCKABLE;
            }
            case 1: {
                return TabPlacement.TOP_OF_DOCKABLE;
            }
        }
        throw new IllegalStateException("unknown position: " + this.getTabPlacement());
    }

    @Override
    public void insertTab(String title, Icon icon, Component comp, Dockable dockable, int index) {
        this.insertTab(title, icon, comp, (String)null, index);
        Tab tab = this.createTab(dockable);
        this.dockables.add(index, tab);
        tab.setController(this.controller);
        this.tabDisabling.add(dockable);
    }

    protected Tab createTab(Dockable dockable) {
        return new Tab(dockable);
    }

    @Override
    public void addTab(String title, Icon icon, Component comp, Dockable dockable) {
        this.addTab(title, icon, comp);
        Tab tab = this.createTab(dockable);
        this.dockables.add(tab);
        tab.setController(this.controller);
        this.tabDisabling.add(dockable);
    }

    @Override
    public Dockable getDockableAt(int index) {
        return this.dockables.get(index).getDockable();
    }

    @Override
    public DockElementRepresentative getTabAt(int index) {
        return null;
    }

    @Override
    public void moveTab(int source, int destination) {
        if (source == destination) {
            return;
        }
        if (destination < 0 || destination >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int selected = this.getSelectedIndex();
        String title = this.getTitleAt(source);
        String tooltip = this.getToolTipTextAt(source);
        Icon icon = this.getIconAt(source);
        Component comp = this.getComponentAt(source);
        Dockable dockable = this.dockables.get(source).getDockable();
        this.remove(source);
        this.insertTab(title, icon, comp, dockable, destination);
        this.setTooltipAt(destination, tooltip);
        if (selected == source) {
            selected = destination;
        } else if (selected > source && selected <= destination) {
            ++selected;
        }
        this.setSelectedIndex(selected);
    }

    @Override
    public void removeAll() {
        for (Tab tab : this.dockables) {
            tab.setController(null);
            this.tabDisabling.remove(tab.getDockable());
        }
        super.removeAll();
        this.dockables.clear();
    }

    @Override
    public void remove(int index) {
        Tab tab = this.dockables.remove(index);
        tab.setController(null);
        this.tabDisabling.remove(tab.getDockable());
        super.remove(index);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title == null ? "" : title);
    }

    @Override
    public void setTooltipAt(int index, String newTooltip) {
        this.setToolTipTextAt(index, newTooltip);
    }

    @Override
    public void setController(DockController controller) {
        if (this.controller != controller) {
            if (this.mouseTarget != null) {
                if (this.mouseTarget.relocator != null) {
                    this.mouseTarget.relocator.cancel();
                }
                this.mouseTarget = null;
            }
            this.controller = controller;
            this.tabDisabling.setController(controller);
            for (Tab tab : this.dockables) {
                tab.setController(controller);
            }
        }
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    @Override
    public boolean isSingleTabComponent() {
        return false;
    }

    @Override
    public DockElementRepresentative createDefaultRepresentation(DockElement target) {
        return new SimpleDockElementRepresentative(target, this);
    }

    @Override
    public int getIndexOfTabAt(Point mouseLocation) {
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle tab = this.getBoundsAt(i);
            if (tab == null || !tab.contains(mouseLocation)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Dockable dockable) {
        int index = 0;
        for (Tab tab : this.dockables) {
            if (tab.getDockable() == dockable) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension result = new Dimension(1, 1);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Dimension size = this.getComponentAt(i).getMinimumSize();
            result.width = Math.max(result.width, size.width);
            result.height = Math.max(result.height, size.height);
        }
        return result;
    }

    private class Listener
    extends MouseInputAdapter
    implements ChangeListener {
        private Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (StackDockComponentListener listener : DefaultStackDockComponent.this.listeners.toArray(new StackDockComponentListener[DefaultStackDockComponent.this.listeners.size()])) {
                listener.selectionChanged(DefaultStackDockComponent.this);
            }
        }

        private void updateRelocator(int x, int y, boolean searchDockable, boolean forceSearch) {
            boolean allowed;
            boolean bl = allowed = DefaultStackDockComponent.this.controller == null || !DefaultStackDockComponent.this.controller.getRelocator().isDragOnlyTitle();
            if (DefaultStackDockComponent.this.mouseTarget != null) {
                if (!allowed) {
                    DefaultStackDockComponent.this.mouseTarget.relocator.cancel();
                    if (!forceSearch) {
                        DefaultStackDockComponent.this.mouseTarget = null;
                    }
                }
                return;
            }
            if (!allowed && !forceSearch) {
                return;
            }
            if (searchDockable) {
                int n = DefaultStackDockComponent.this.getTabCount();
                for (int i = 0; i < n; ++i) {
                    Rectangle bounds = DefaultStackDockComponent.this.getBoundsAt(i);
                    if (bounds == null || !bounds.contains(x, y)) continue;
                    DefaultStackDockComponent.this.mouseTarget = DefaultStackDockComponent.this.dockables.get(i);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.updateRelocator(e.getX(), e.getY(), true, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                DefaultStackDockComponent.this.mouseTarget.popup(e);
                if (e.isConsumed()) {
                    return;
                }
                Point mouse = e.getPoint();
                SwingUtilities.convertPointToScreen(mouse, e.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.init(mouse.x, mouse.y, 0, 0, e.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        e.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE: 
                    case CONTINUE_CONSUMED: {
                        e.consume();
                    }
                }
            } else {
                this.updateRelocator(e.getX(), e.getY(), true, true);
                if (DefaultStackDockComponent.this.mouseTarget != null) {
                    DefaultStackDockComponent.this.mouseTarget.popup(e);
                    DefaultStackDockComponent.this.mouseTarget = null;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.updateRelocator(e.getX(), e.getY(), false, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                Point mouse = e.getPoint();
                SwingUtilities.convertPointToScreen(mouse, e.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.drop(mouse.x, mouse.y, e.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        e.consume();
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget.popup(e);
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        e.consume();
                    }
                }
            } else {
                this.updateRelocator(e.getX(), e.getY(), true, true);
                if (DefaultStackDockComponent.this.mouseTarget != null) {
                    DefaultStackDockComponent.this.mouseTarget.popup(e);
                    DefaultStackDockComponent.this.mouseTarget = null;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.updateRelocator(e.getX(), e.getY(), false, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                Point mouse = e.getPoint();
                SwingUtilities.convertPointToScreen(mouse, e.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.drag(mouse.x, mouse.y, e.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        e.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        e.consume();
                    }
                }
            }
        }
    }

    public class Tab
    extends ActionPopup {
        protected Dockable dockable;
        private RemoteRelocator relocator;

        public Tab(Dockable dockable) {
            super(true);
            this.dockable = dockable;
        }

        @Override
        public Dockable getDockable() {
            return this.dockable;
        }

        public void setController(DockController controller) {
            this.relocator = controller == null ? null : controller.getRelocator().createRemote(this.dockable);
        }

        @Override
        public void popup(MouseEvent event) {
            if (!event.isConsumed() && event.isPopupTrigger()) {
                super.popup(event);
            }
        }

        @Override
        protected DockActionSource getActions() {
            return this.dockable.getGlobalActionOffers();
        }

        @Override
        protected Object getSource() {
            return this;
        }

        @Override
        protected boolean isEnabled() {
            return true;
        }
    }
}

