/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import java.awt.Component;
import java.awt.Dimension;

public abstract class DockActionCombinedInfoComponent
extends AbstractTabPaneComponent
implements CombinedInfoComponent,
LayoutBlock {
    private CombinedStackDockComponent<?, ?, ?> pane;
    private ButtonPanel buttons;
    private Dockable dockable;
    private TabPaneListener listener = new TabPaneListener(){

        @Override
        public void selectionChanged(TabPane pane) {
            DockActionCombinedInfoComponent.this.setSelection(pane.getSelectedDockable());
        }

        @Override
        public void removed(TabPane pane, Dockable dockable) {
        }

        @Override
        public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
        }

        @Override
        public void added(TabPane pane, Dockable dockable) {
        }

        @Override
        public void controllerChanged(TabPane pane, DockController controller) {
            DockActionCombinedInfoComponent.this.setController(controller);
        }
    };

    public DockActionCombinedInfoComponent(CombinedStackDockComponent<?, ?, ?> pane) {
        super(pane);
        this.pane = pane;
        this.buttons = new ButtonPanel(true);
        pane.addTabPaneListener(this.listener);
        this.setController(pane.getController());
    }

    public void destroy() {
        this.pane.removeTabPaneListener(this.listener);
        this.setController(null);
    }

    public void setSelection(Dockable dockable) {
        this.dockable = dockable;
        this.updateContent();
    }

    public Dockable getSelection() {
        return this.dockable;
    }

    public void setController(DockController controller) {
        this.buttons.setController(controller);
    }

    protected void updateContent() {
        if (this.dockable == null) {
            this.buttons.set(null, null);
        } else {
            this.buttons.set(this.dockable, this.createActionSource(this.dockable));
        }
    }

    protected abstract DockActionSource createActionSource(Dockable var1);

    @Override
    public Component getComponent() {
        return this.buttons;
    }

    @Override
    public boolean isPaneVisible() {
        return this.pane.getInfoHandler().isVisible(this);
    }

    @Override
    public void setPaneVisible(boolean visible) {
        this.pane.getInfoHandler().setVisible(this, visible);
    }

    @Override
    public int getZOrder() {
        return this.pane.getInfoHandler().getZOrder(this);
    }

    @Override
    public void setZOrder(int order) {
        this.pane.getInfoHandler().setZOrder(this, order);
    }

    @Override
    public LayoutBlock toLayoutBlock() {
        return this;
    }

    @Override
    public void setOrientation(TabPlacement orientation) {
        super.setOrientation(orientation);
        this.buttons.setOrientation(orientation.toOrientation());
    }

    @Override
    public Size[] getSizes() {
        Dimension[] sizes = this.buttons.getPreferredSizes();
        Size[] result = new Size[sizes.length];
        for (int i = 0; i < sizes.length; ++i) {
            Size.Type type = i + 1 == sizes.length ? Size.Type.PREFERRED : Size.Type.MINIMUM;
            result[i] = new CountingSize(type, sizes[i], i, (double)(i + 1) / (double)sizes.length);
        }
        return result;
    }

    @Override
    public void setLayout(Size size) {
        if (!(size instanceof CountingSize)) {
            throw new IllegalArgumentException("size not created by this component");
        }
        this.buttons.setVisibleActions(((CountingSize)size).getCount());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.buttons.setBounds(x, y, width, height);
    }

    private static class CountingSize
    extends Size {
        private int count;

        public CountingSize(Size.Type type, Dimension size, int count, double score) {
            super(type, size, score);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

