/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;

public class DefaultAxisConversion
implements AxisConversion {
    private TabPlacement side;
    private Rectangle space;

    public DefaultAxisConversion(Rectangle space, TabPlacement side) {
        if (space == null) {
            throw new IllegalArgumentException("space must not be null");
        }
        if (side == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        this.side = side;
        this.space = space;
    }

    @Override
    public Dimension modelToView(Dimension size) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                return new Dimension(size);
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                return new Dimension(size.height, size.width);
            }
        }
        throw new IllegalStateException("unknown side: " + this.side);
    }

    @Override
    public Rectangle modelToView(Rectangle bounds) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: {
                return new Rectangle(this.space.x + bounds.x, this.space.y + bounds.y, bounds.width, bounds.height);
            }
            case BOTTOM_OF_DOCKABLE: {
                return new Rectangle(this.space.x + bounds.x, this.space.y + this.space.height - bounds.height - bounds.y, bounds.width, bounds.height);
            }
            case LEFT_OF_DOCKABLE: {
                return new Rectangle(this.space.x + bounds.y, this.space.y + bounds.x, bounds.height, bounds.width);
            }
            case RIGHT_OF_DOCKABLE: {
                return new Rectangle(this.space.x + this.space.width - bounds.y - bounds.height, this.space.y + bounds.x, bounds.height, bounds.width);
            }
        }
        throw new IllegalStateException("unknown side: " + this.side);
    }

    @Override
    public Dimension viewToModel(Dimension size) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                return new Dimension(size);
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                return new Dimension(size.height, size.width);
            }
        }
        throw new IllegalStateException("unknown side: " + this.side);
    }

    @Override
    public Rectangle viewToModel(Rectangle bounds) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: {
                return new Rectangle(bounds.x - this.space.x, bounds.y - this.space.y, bounds.width, bounds.height);
            }
            case BOTTOM_OF_DOCKABLE: {
                return new Rectangle(bounds.x - this.space.x, bounds.y + bounds.height - this.space.y - this.space.height, bounds.width, bounds.height);
            }
            case LEFT_OF_DOCKABLE: {
                return new Rectangle(this.space.x - bounds.y, bounds.x - this.space.y, bounds.height, bounds.width);
            }
            case RIGHT_OF_DOCKABLE: {
                return new Rectangle(this.space.y - bounds.y, this.space.x + this.space.width - bounds.width - bounds.x, bounds.height, bounds.width);
            }
        }
        throw new IllegalStateException("unknown side: " + this.side);
    }
}

