/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import java.util.Iterator;

public class MenuLineLayoutOrder
implements Iterable<Item> {
    private ItemConstraints[] order;

    public MenuLineLayoutOrder(Item first, Item second, Item third) {
        if (first == null) {
            throw new IllegalArgumentException("first must not be null");
        }
        if (second == null) {
            throw new IllegalArgumentException("second must not be null");
        }
        if (third == null) {
            throw new IllegalArgumentException("third must not be null");
        }
        if (first == second) {
            throw new IllegalArgumentException("first and second are the same: " + first);
        }
        if (first == third) {
            throw new IllegalArgumentException("first and third are the same: " + first);
        }
        if (second == third) {
            throw new IllegalArgumentException("second and third are the same: " + second);
        }
        this.order = new ItemConstraints[]{new ItemConstraints(first), new ItemConstraints(second), new ItemConstraints(third)};
    }

    @Override
    public Iterator<Item> iterator() {
        return new Iterator<Item>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < MenuLineLayoutOrder.this.order.length;
            }

            @Override
            public Item next() {
                return MenuLineLayoutOrder.this.order[this.index++].item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Item getFirst() {
        return this.order[0].item;
    }

    public Item getSecond() {
        return this.order[1].item;
    }

    public Item getThird() {
        return this.order[2].item;
    }

    private ItemConstraints get(Item item) {
        for (ItemConstraints constraint : this.order) {
            if (constraint.item != item) continue;
            return constraint;
        }
        throw new IllegalArgumentException("unknown item: " + item);
    }

    public void setConstraints(Item item, float weight, float alignment, float fill) {
        this.setAlignment(item, alignment);
        this.setWeight(item, weight);
        this.setFill(item, fill);
    }

    public void setAlignment(Item item, float alignment) {
        if (alignment < 0.0f || alignment > 1.0f) {
            throw new IllegalArgumentException("Alignment must be between 0 and 1: " + alignment);
        }
        this.get((Item)item).alignment = alignment;
    }

    public float getAlignment(Item item) {
        return this.get((Item)item).alignment;
    }

    public void setWeight(Item item, float weight) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Weight must be at least 0: " + weight);
        }
        this.get((Item)item).weight = weight;
    }

    public float getWeight(Item item) {
        return this.get((Item)item).weight;
    }

    public void setFill(Item item, float fill) {
        if (fill < 0.0f || fill > 1.0f) {
            throw new IllegalArgumentException("Fill must be between 0 and 1: " + fill);
        }
        this.get((Item)item).fill = fill;
    }

    public float getFill(Item item) {
        return this.get((Item)item).fill;
    }

    public static enum Item {
        MENU,
        TABS,
        INFO;

    }

    private static class ItemConstraints {
        private Item item;
        private float alignment;
        private float weight;
        private float fill;

        public ItemConstraints(Item item) {
            this.item = item;
            this.alignment = 0.0f;
            this.weight = 1.0f;
            this.fill = 0.0f;
        }
    }
}

