/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerBackgroundComponent;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.displayer.DisplayerFocusTraversalPolicy;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.SingleTabDeciderListener;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributorSource;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecoratorListener;
import bibliothek.gui.dock.themes.basic.DisplayerContentPane;
import bibliothek.gui.dock.themes.basic.MinimalDecorator;
import bibliothek.gui.dock.themes.basic.TabDecorator;
import bibliothek.gui.dock.themes.basic.TabDisplayerCombinerTarget;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.title.ActionsDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class BasicDockableDisplayer
extends ConfiguredBackgroundPanel
implements DockableDisplayer {
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private DockStation station;
    private DockController controller;
    private Hints hints = new Hints();
    private boolean respectBorderHint = false;
    private boolean defaultBorderHint = true;
    private boolean singleTabShowInnerBorder = true;
    private boolean singleTabShowOuterBorder = true;
    private boolean tabInside = false;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private Background background = new Background();
    private DisplayerBorder baseBorder;
    private DisplayerBorder contentBorder;
    private SingleTabDeciderListener singleTabListener = new SingleTabDeciderListener(){

        @Override
        public void showSingleTabChanged(SingleTabDecider source, Dockable dockable) {
            if (dockable == BasicDockableDisplayer.this.dockable) {
                BasicDockableDisplayer.this.updateDecorator();
            }
        }
    };
    private PropertyValue<SingleTabDecider> decider = new PropertyValue<SingleTabDecider>(SingleTabDecider.SINGLE_TAB_DECIDER){

        @Override
        protected void valueChanged(SingleTabDecider oldValue, SingleTabDecider newValue) {
            if (oldValue != null) {
                oldValue.removeSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            if (newValue != null) {
                newValue.addSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            BasicDockableDisplayer.this.updateDecorator();
        }
    };
    private BasicDockableDisplayerDecorator decorator;
    private BasicDockableDisplayerDecoratorListener decoratorListener = new BasicDockableDisplayerDecoratorListener(){

        @Override
        public void moveableElementChanged(BasicDockableDisplayerDecorator decorator) {
            BasicDockableDisplayer.this.fireMoveableElementChanged();
        }
    };
    private boolean singleTabShowing;
    private boolean pendingForcedUpdateDecorator = false;
    private boolean stacked = false;
    private DisplayerContentPane content;
    private DockComponentRootHandler rootHandler;

    public BasicDockableDisplayer(DockStation station) {
        this(station, null, null);
    }

    public BasicDockableDisplayer(DockStation station, Dockable dockable, DockTitle title) {
        this(station, dockable, title, DockableDisplayer.Location.TOP);
    }

    public BasicDockableDisplayer(DockStation station, Dockable dockable, DockTitle title, DockableDisplayer.Location location) {
        super((LayoutManager)new GridLayout(1, 1), Transparency.DEFAULT);
        this.init(station, dockable, title, location);
    }

    protected BasicDockableDisplayer(DockStation station, boolean initialize) {
        super((LayoutManager)new GridLayout(1, 1), Transparency.DEFAULT);
        if (initialize) {
            this.init(station, null, null, DockableDisplayer.Location.TOP);
        }
    }

    protected void init(DockStation station, Dockable dockable, DockTitle title, DockableDisplayer.Location location) {
        this.content = this.createContentPane();
        this.content.setBackground(this.background);
        this.setDecorator(new MinimalDecorator());
        this.setBackground(this.background);
        this.setTitleLocation(location);
        this.setStation(station);
        this.setDockable(dockable);
        this.setTitle(title);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new DisplayerFocusTraversalPolicy(this), true));
        this.baseBorder = new DisplayerBorder(this, "basic.base");
        this.contentBorder = new DisplayerBorder(this.content, "basic.content");
        this.rootHandler = this.createRootHandler();
        this.rootHandler.addRoot(this.getComponent());
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                DockTitle title = BasicDockableDisplayer.this.getTitle();
                if (title != null && title.getComponent() == component) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE;
                }
                Dockable dockable = BasicDockableDisplayer.this.getDockable();
                if (dockable != null && dockable.getComponent() == component) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    protected DisplayerContentPane createContentPane() {
        return new DisplayerContentPane();
    }

    protected void setDecorator(BasicDockableDisplayerDecorator decorator) {
        if (decorator == null) {
            throw new IllegalArgumentException("decorator must not be null");
        }
        if (this.decorator != null) {
            this.decorator.setDockable(null, null);
            this.decorator.setController(null);
            this.decorator.removeDecoratorListener(this.decoratorListener);
        }
        this.decorator = decorator;
        this.decorator.addDecoratorListener(this.decoratorListener);
        this.decorator.setController(this.controller);
        this.resetDecorator();
        if (this.title != null) {
            this.title.changed(new ActionsDockTitleEvent(this.dockable, decorator.getActionSuggestion()));
        }
        this.fireMoveableElementChanged();
        this.revalidate();
        this.repaint();
    }

    protected void updateDecorator() {
        this.updateDecorator(false);
    }

    protected void updateDecorator(boolean force) {
        if (force) {
            this.pendingForcedUpdateDecorator = true;
        }
        if (this.dockable != null && this.station != null) {
            boolean decision = this.decider.getValue().showSingleTab(this.station, this.dockable);
            if (this.pendingForcedUpdateDecorator || decision != this.singleTabShowing) {
                this.pendingForcedUpdateDecorator = false;
                this.singleTabShowing = decision;
                if (this.singleTabShowing) {
                    this.setDecorator(this.createTabDecorator());
                } else if (this.isStacked()) {
                    this.setDecorator(this.createStackedDecorator());
                } else {
                    this.setDecorator(this.createMinimalDecorator());
                }
            }
            this.updateBorder();
        }
    }

    public boolean isSingleTabShowing() {
        return this.singleTabShowing;
    }

    public void setStacked(boolean stacked) {
        if (this.stacked != stacked) {
            this.stacked = stacked;
            this.updateDecorator(true);
        }
    }

    public boolean isStacked() {
        return this.stacked;
    }

    protected BasicDockableDisplayerDecorator createMinimalDecorator() {
        return new MinimalDecorator();
    }

    protected BasicDockableDisplayerDecorator createStackedDecorator() {
        return this.createMinimalDecorator();
    }

    protected BasicDockableDisplayerDecorator createStackedDecorator(final PropertyKey<DockActionDistributor> distributor) {
        return new MinimalDecorator(){
            private DockActionDistributorSource source;
            {
                this.source = new DockActionDistributorSource(DockActionDistributor.Target.TITLE, distributor);
            }

            @Override
            public void setDockable(Component content, Dockable dockable) {
                super.setDockable(content, dockable);
                this.source.setDockable(dockable);
            }

            @Override
            public DockActionSource getActionSuggestion() {
                return this.source;
            }
        };
    }

    protected BasicDockableDisplayerDecorator createTabDecorator() {
        return new TabDecorator(this.station, null);
    }

    @Override
    public void setController(DockController controller) {
        this.rootHandler.setController(null);
        this.controller = controller;
        this.decider.setProperties(controller);
        this.decorator.setController(controller);
        this.background.setController(controller);
        this.baseBorder.setController(controller);
        this.contentBorder.setController(controller);
        this.resetDecorator();
        this.rootHandler.setController(controller);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration configuration) {
        this.rootHandler.setConfiguration(configuration);
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.rootHandler.getConfiguration();
    }

    @Override
    public void addDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.remove(listener);
    }

    protected DockableDisplayerListener[] listeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    protected void fireMoveableElementChanged() {
        for (DockableDisplayerListener listener : this.listeners()) {
            listener.moveableElementChanged(this);
        }
    }

    @Override
    public void setStation(DockStation station) {
        this.station = station;
        this.updateDecorator();
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.configureDisplayerHints(null);
        }
        this.hints.setShowBorderHint(null);
        this.dockable = dockable;
        this.updateDecorator();
        this.resetDecorator();
        if (dockable != null) {
            this.dockable.configureDisplayerHints(this.hints);
        }
        this.revalidate();
    }

    protected void resetDecorator() {
        this.removeAll();
        if (this.tabInside) {
            if (this.dockable == null) {
                this.content.setDockable(null);
                this.decorator.setDockable(null, null);
            } else {
                this.content.setDockable(null);
                this.decorator.setDockable(this.getComponent(this.dockable), this.dockable);
                this.content.setDockable(this.decorator.getComponent());
            }
            this.add(this.content);
        } else {
            if (this.dockable == null) {
                this.content.setDockable(null);
            } else {
                this.content.setDockable(this.getComponent(this.dockable));
            }
            this.decorator.setDockable(this.content, this.dockable);
            Component newComponent = this.decorator.getComponent();
            if (newComponent != null) {
                this.add(newComponent);
            }
        }
    }

    @Override
    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    @Override
    public void setTitleLocation(DockableDisplayer.Location location) {
        if (location == null) {
            location = DockableDisplayer.Location.TOP;
        }
        this.location = location;
        this.content.setTitleLocation(location);
        if (this.title != null) {
            this.title.setOrientation(this.orientation(location));
        }
        this.revalidate();
    }

    protected DockTitle.Orientation orientation(DockableDisplayer.Location location) {
        switch (location) {
            case TOP: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case BOTTOM: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case LEFT: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case RIGHT: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    @Override
    public DockTitle getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(DockTitle title) {
        this.title = title;
        if (title == null) {
            this.content.setTitle(null);
        } else {
            this.content.setTitle(this.getComponent(title));
        }
        if (title != null) {
            title.setOrientation(this.orientation(this.location));
            if (this.decorator != null) {
                title.changed(new ActionsDockTitleEvent(this.dockable, this.decorator.getActionSuggestion()));
            }
        }
        this.fireMoveableElementChanged();
        this.revalidate();
    }

    @Override
    public DockElementRepresentative getMoveableElement() {
        DockElementRepresentative result;
        if (this.title != null) {
            return this.title;
        }
        if (this.decorator != null && (result = this.decorator.getMoveableElement()) != null) {
            return result;
        }
        return this.getDockable();
    }

    @Override
    public Point getTitleCenter() {
        DockElementRepresentative moveable = this.getMoveableElement();
        if (moveable == null) {
            return null;
        }
        Component component = moveable.getComponent();
        if (!SwingUtilities.isDescendingFrom(component, this.getComponent())) {
            return null;
        }
        Point topLeft = new Point(0, 0);
        topLeft = SwingUtilities.convertPoint(component, topLeft, this.getComponent());
        Dimension size = component.getSize();
        return new Point(topLeft.x + size.width / 2, topLeft.y + size.height / 2);
    }

    protected Component getComponent(Dockable dockable) {
        return dockable.getComponent();
    }

    protected Component getComponent(DockTitle title) {
        return title.getComponent();
    }

    @Override
    public boolean titleContains(int x, int y) {
        DockTitle title = this.getTitle();
        if (title == null) {
            return false;
        }
        Component component = this.getComponent(title);
        Point point = new Point(x, y);
        point = SwingUtilities.convertPoint(this, point, component);
        point.x -= component.getX();
        point.y -= component.getY();
        return component.contains(point);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets decorator = this.decorator.getDockableInsets();
        insets.left += decorator.left;
        insets.right += decorator.right;
        insets.top += decorator.top;
        insets.bottom += decorator.bottom;
        if (this.title == null && this.dockable == null) {
            return insets;
        }
        if (this.title == null) {
            return insets;
        }
        if (this.dockable != null) {
            Dimension preferred = this.getComponent(this.title).getPreferredSize();
            if (this.location == DockableDisplayer.Location.LEFT) {
                insets.left += preferred.width;
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                insets.right += preferred.width;
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                insets.bottom += preferred.height;
            } else {
                insets.top += preferred.height;
            }
        }
        return insets;
    }

    protected Hints getHints() {
        return this.hints;
    }

    public void setRespectBorderHint(boolean respectBorderHint) {
        if (this.respectBorderHint != respectBorderHint) {
            this.respectBorderHint = respectBorderHint;
            this.updateBorder();
        }
    }

    public boolean isRespectBorderHint() {
        return this.respectBorderHint;
    }

    public void setDefaultBorderHint(boolean defaultBorderHint) {
        if (this.defaultBorderHint != defaultBorderHint) {
            this.defaultBorderHint = defaultBorderHint;
            this.updateBorder();
        }
    }

    public boolean getDefaultBorderHint() {
        return this.defaultBorderHint;
    }

    public void setSingleTabShowInnerBorder(boolean singleTabShowInnerBorder) {
        this.singleTabShowInnerBorder = singleTabShowInnerBorder;
        this.updateBorder();
    }

    public boolean isSingleTabShowInnerBorder() {
        return this.singleTabShowInnerBorder;
    }

    public void setSingleTabShowOuterBorder(boolean singleTabShowOuterBorder) {
        this.singleTabShowOuterBorder = singleTabShowOuterBorder;
        this.updateBorder();
    }

    public boolean isSingleTabShowOuterBorder() {
        return this.singleTabShowOuterBorder;
    }

    public boolean isTabInside() {
        return this.tabInside;
    }

    public void setTabInside(boolean tabInside) {
        this.tabInside = tabInside;
        this.resetDecorator();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBorder();
    }

    protected void updateBorder() {
        if (this.singleTabShowing) {
            if (this.singleTabShowInnerBorder) {
                this.setContentBorder(this.getDefaultBorder());
            } else {
                this.setContentBorder(null);
            }
            if (this.singleTabShowOuterBorder) {
                this.setBaseBorder(this.getDefaultBorder());
            } else {
                this.setBaseBorder(null);
            }
        } else {
            this.setContentBorder(null);
            if (this.respectBorderHint) {
                boolean show = this.hints.getShowBorderHint();
                if (show) {
                    this.setBaseBorder(this.getDefaultBorder());
                } else {
                    this.setBaseBorder(null);
                }
            } else if (this.defaultBorderHint) {
                this.setBaseBorder(this.getDefaultBorder());
            } else {
                this.setBaseBorder(null);
            }
        }
    }

    public void setBaseBorder(Border border) {
        if (this.baseBorder != null) {
            this.baseBorder.setBorder(border);
        }
    }

    public void setContentBorder(Border border) {
        if (this.contentBorder != null) {
            this.contentBorder.setBorder(border);
        }
    }

    @Override
    public DisplayerCombinerTarget prepareCombination(CombinerSource source, Enforcement force) {
        TabDisplayerCombinerTarget target;
        if (this.decorator instanceof TabDecorator && (target = new TabDisplayerCombinerTarget(this, ((TabDecorator)this.decorator).getStackComponent(), source, force)).isValid()) {
            return target;
        }
        return null;
    }

    protected Border getDefaultBorder() {
        return BorderFactory.createBevelBorder(0);
    }

    protected class Hints
    implements DockableDisplayerHints {
        private Boolean border;

        protected Hints() {
        }

        @Override
        public DockStation getStation() {
            return BasicDockableDisplayer.this.station;
        }

        @Override
        public void setShowBorderHint(Boolean border) {
            if (this.border != border) {
                this.border = border;
                BasicDockableDisplayer.this.updateBorder();
            }
        }

        public boolean getShowBorderHint() {
            if (this.border != null) {
                return this.border;
            }
            return BasicDockableDisplayer.this.defaultBorderHint;
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements DisplayerBackgroundComponent {
        public Background() {
            super(DisplayerBackgroundComponent.KIND, "dock.background.displayer");
        }

        @Override
        public Component getComponent() {
            return BasicDockableDisplayer.this;
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return BasicDockableDisplayer.this;
        }
    }

    protected class DisplayerBorder
    extends BorderForwarder
    implements DisplayerDockBorder {
        public DisplayerBorder(JComponent target, String idSuffix) {
            super(DisplayerDockBorder.KIND, "dock.border.displayer." + idSuffix, target);
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return BasicDockableDisplayer.this;
        }
    }
}

