/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.DockActionImportanceOrder;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Dockable dockable;
    private DockActionSource source;
    private Listener listener = new Listener();
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private DefaultDockActionSource menuSource;
    private BasicTitleViewItem<JComponent> menuItem;
    private SimpleMenuAction menuAction;
    private DockActionIcon menuIcon;
    private int visibleActions = -1;
    private PropertyValue<DockActionImportanceOrder> actionOrder = new PropertyValue<DockActionImportanceOrder>(DockActionImportanceOrder.ORDER){

        @Override
        protected void valueChanged(DockActionImportanceOrder oldValue, DockActionImportanceOrder newValue) {
            ButtonPanel.this.resetVisibleActions();
        }
    };

    public ButtonPanel(boolean menu) {
        this.setLayout(null);
        this.setOpaque(false);
        if (menu) {
            this.menuSource = new DefaultDockActionSource(new DockAction[0]);
            this.menuAction = new SimpleMenuAction(this.menuSource);
            this.menuIcon = new DockActionIcon("overflow.menu", this.menuAction){

                @Override
                protected void changed(Icon oldValue, Icon newValue) {
                    ButtonPanel.this.menuAction.setIcon(newValue);
                }
            };
        }
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(action, ViewTarget.TITLE, dockable);
    }

    public int getItemCount() {
        int count = 0;
        for (ActionItem entry : this.actions) {
            if (entry.item == null) continue;
            ++count;
        }
        return count;
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            if (this.menuItem != null) {
                this.menuItem.setOrientation(orientation);
            }
            for (ActionItem item : this.actions) {
                if (item.item == null) continue;
                item.item.setOrientation(orientation);
            }
            this.revalidate();
        }
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void set(Dockable dockable) {
        if (dockable == null) {
            this.set(null, null);
        } else {
            this.set(dockable, dockable.getGlobalActionOffers());
        }
    }

    public DockActionSource getSource() {
        return this.source;
    }

    public boolean hasActions() {
        return this.actions.size() > 0;
    }

    public void setController(DockController controller) {
        this.actionOrder.setProperties(controller);
    }

    private void set() {
        this.set(this.dockable, this.source, true);
    }

    public void set(Dockable dockable, DockActionSource source) {
        this.set(dockable, source, false);
    }

    public void set(Dockable dockable, DockActionSource source, boolean force) {
        if (source == null != (dockable == null)) {
            throw new IllegalArgumentException("Either both arguments are null, or none");
        }
        if (force || this.source != source || this.dockable != dockable) {
            if (this.source != null) {
                this.removeAll();
                for (ActionItem item : this.actions) {
                    if (item.item == null) continue;
                    item.item.unbind();
                    item.action.unbind(this.dockable);
                }
                if (this.menuAction != null) {
                    if (this.menuItem != null) {
                        this.menuItem.unbind();
                        this.menuItem = null;
                    }
                    this.menuAction.unbind(this.dockable);
                    this.menuSource.removeAll();
                }
                this.actions.clear();
                this.source.removeDockActionSourceListener(this.listener);
            }
            this.source = source;
            this.dockable = dockable;
            this.listener.setDockable(dockable);
            if (source != null) {
                if (this.menuAction != null) {
                    this.menuAction.bind(dockable);
                    if (dockable.getController() != null) {
                        this.menuItem = this.createItemFor(this.menuAction, dockable);
                        if (this.menuItem != null) {
                            this.menuItem.setOrientation(this.orientation);
                            this.menuItem.setForeground(this.getForeground());
                            this.menuItem.setBackground(this.getBackground());
                            this.menuItem.bind();
                        }
                    }
                }
                source.addDockActionSourceListener(this.listener);
                for (DockAction action : source) {
                    BasicTitleViewItem<JComponent> item;
                    ActionItem actionItem = new ActionItem();
                    actionItem.action = action;
                    this.actions.add(actionItem);
                    if (dockable.getController() == null || (item = this.createItemFor(action, dockable)) == null) continue;
                    action.bind(dockable);
                    item.bind();
                    actionItem.item = item;
                    item.setOrientation(this.orientation);
                    item.setForeground(this.getForeground());
                    item.setBackground(this.getBackground());
                }
            }
            this.visibleActions = this.actions.size();
            this.resetVisibleActions();
            this.revalidate();
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.menuItem != null) {
            this.menuItem.setForeground(fg);
        }
        if (this.actions != null) {
            for (ActionItem item : this.actions) {
                if (item.item == null) continue;
                item.item.setForeground(fg);
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.menuItem != null) {
            this.menuItem.setBackground(bg);
        }
        if (this.actions != null) {
            for (ActionItem item : this.actions) {
                if (item.item == null) continue;
                item.item.setBackground(bg);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ButtonPanel.this.setForeground(ButtonPanel.this.getForeground());
                ButtonPanel.this.setBackground(ButtonPanel.this.getBackground());
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.actions.isEmpty()) {
            return new Dimension(0, 0);
        }
        if (this.menuItem == null) {
            return this.getPreferredSize();
        }
        return ((JComponent)this.menuItem.getItem()).getMinimumSize();
    }

    private ActionItem[] getItemsOrdered() {
        DockAction[] actions = new DockAction[this.actions.size()];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = this.actions.get((int)i).action;
        }
        this.actionOrder.getValue().order(actions);
        int index = 0;
        int next = 0;
        int length = actions.length;
        ActionItem[] result = new ActionItem[length];
        boolean[] used = new boolean[length];
        block1: for (DockAction action : actions) {
            ActionItem item;
            int i;
            for (i = next; i < length; ++i) {
                if (used[i]) continue;
                item = this.actions.get(i);
                if (item.action != action) continue;
                used[i] = true;
                result[index++] = item;
                next = i + 1;
                continue block1;
            }
            for (i = 0; i < next; ++i) {
                if (used[i]) continue;
                item = this.actions.get(i);
                if (item.action != action) continue;
                used[i] = true;
                result[index++] = item;
                next = i + 1;
                continue block1;
            }
        }
        return result;
    }

    public Dimension[] getPreferredSizes() {
        if (this.actions.isEmpty()) {
            return new Dimension[]{new Dimension(0, 0)};
        }
        if (this.menuAction == null) {
            return new Dimension[]{this.getPreferredSize()};
        }
        Dimension current = new Dimension(0, 0);
        Dimension menuPreferred = this.menuItem == null ? new Dimension(0, 0) : ((JComponent)this.menuItem.getItem()).getPreferredSize();
        Dimension[] results = new Dimension[this.actions.size() + 1];
        results[0] = new Dimension(menuPreferred);
        ActionItem[] actions = this.getItemsOrdered();
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            BasicTitleViewItem<JComponent> item = actions[i].item;
            if (item != null) {
                Dimension preferred = ((JComponent)item.getItem()).getPreferredSize();
                if (this.orientation.isHorizontal()) {
                    current.width += preferred.width;
                    current.height = Math.max(current.height, preferred.height);
                } else {
                    current.width = Math.max(current.width, preferred.width);
                    current.height += preferred.height;
                }
            }
            Dimension result = new Dimension(current);
            if (i + 1 < n) {
                if (this.orientation.isHorizontal()) {
                    result.width += menuPreferred.width;
                    result.height = Math.max(result.height, menuPreferred.height);
                } else {
                    result.width = Math.max(result.width, menuPreferred.width);
                    result.height += menuPreferred.height;
                }
            }
            results[i + 1] = result;
        }
        Insets insets = this.getInsets();
        for (Dimension dimension : results) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        return results;
    }

    public Dimension getCurrentPreferredSize() {
        int i;
        int width = 0;
        int height = 0;
        if (this.orientation.isHorizontal()) {
            int n = this.getComponentCount();
            for (i = 0; i < n; ++i) {
                Dimension preferred = this.getComponent(i).getPreferredSize();
                width += preferred.width;
                height = Math.max(height, preferred.height);
            }
        } else {
            int n = this.getComponentCount();
            for (i = 0; i < n; ++i) {
                Dimension preferred = this.getComponent(i).getPreferredSize();
                width = Math.max(width, preferred.width);
                height += preferred.height;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        if (this.orientation.isHorizontal()) {
            for (ActionItem entry : this.actions) {
                if (entry.item == null) continue;
                Dimension preferred = ((JComponent)entry.item.getItem()).getPreferredSize();
                width += preferred.width;
                height = Math.max(height, preferred.height);
            }
        } else {
            for (ActionItem entry : this.actions) {
                if (entry.item == null) continue;
                Dimension preferred = ((JComponent)entry.item.getItem()).getPreferredSize();
                width = Math.max(width, preferred.width);
                height += preferred.height;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    public void setVisibleActions(int count) {
        if (this.visibleActions != count) {
            this.visibleActions = count;
            this.resetVisibleActions();
        }
    }

    private void resetVisibleActions() {
        this.removeAll();
        if (this.menuItem == null) {
            for (ActionItem entry : this.actions) {
                if (entry.item == null) continue;
                this.add((Component)entry.item.getItem());
            }
        } else {
            this.menuSource.removeAll();
            int set = 0;
            int index = 0;
            int max = this.actions.size();
            int length = this.actions.size();
            ActionItem[] order = this.getItemsOrdered();
            HashSet<ActionItem> visibleOrdered = new HashSet<ActionItem>();
            while (set < this.visibleActions && index < length) {
                ActionItem item = order[index++];
                if (item.item == null) {
                    --max;
                    continue;
                }
                ++set;
                visibleOrdered.add(item);
            }
            for (ActionItem item : this.actions) {
                if (visibleOrdered.contains(item)) {
                    this.add((Component)item.item.getItem());
                    continue;
                }
                this.menuSource.add(item.action);
            }
            if (set < max) {
                this.add((Component)this.menuItem.getItem());
            }
        }
    }

    @Override
    public void doLayout() {
        Dimension current = this.getCurrentPreferredSize();
        Insets insets = this.getInsets();
        current.width -= insets.left + insets.right;
        current.height -= insets.top + insets.bottom;
        if (this.orientation.isHorizontal()) {
            if (current.width <= 0) {
                return;
            }
            int x = insets.left;
            int y = insets.top;
            int height = this.getHeight() - insets.top - insets.bottom;
            int width = this.getWidth() - insets.left - insets.right;
            if (width > current.width) {
                x += width - current.width;
                width = current.width;
            }
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.getComponent(i);
                Dimension preferred = c.getPreferredSize();
                if (current.width <= 0) {
                    if (width <= 0) {
                        width = 1;
                    }
                    current.width = width;
                }
                if (width == current.width) {
                    c.setBounds(x, y, preferred.width, height);
                } else {
                    double factor = (double)width / (double)current.width;
                    c.setBounds(x, y, (int)(factor * (double)preferred.width), height);
                }
                current.width -= preferred.width;
                width -= c.getWidth();
                x += c.getWidth();
            }
        } else {
            if (current.width <= 0) {
                return;
            }
            int x = insets.left;
            int y = insets.top;
            int height = this.getHeight() - insets.top - insets.bottom;
            int width = this.getWidth() - insets.left - insets.bottom;
            if (height > current.height) {
                y += height - current.height;
                height = current.height;
            }
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.getComponent(i);
                Dimension preferred = c.getPreferredSize();
                if (current.height <= 0) {
                    if (height <= 0) {
                        height = 1;
                    }
                    current.height = height;
                }
                if (height == current.height) {
                    c.setBounds(x, y, width, preferred.height);
                } else {
                    double factor = (double)height / (double)current.height;
                    c.setBounds(x, y, width, (int)(factor * (double)preferred.height));
                }
                current.height -= preferred.height;
                height -= c.getHeight();
                y += c.getHeight();
            }
        }
    }

    private class Listener
    implements DockActionSourceListener,
    DockHierarchyListener {
        private Dockable dockable;

        private Listener() {
        }

        public void setDockable(Dockable dockable) {
            if (this.dockable != null) {
                this.dockable.removeDockHierarchyListener(this);
                this.dockable = null;
            }
            this.dockable = dockable;
            DockController controller = null;
            if (dockable != null) {
                dockable.addDockHierarchyListener(this);
                controller = dockable.getController();
            }
            if (ButtonPanel.this.menuIcon != null) {
                if (controller == null) {
                    ButtonPanel.this.menuIcon.setManager(null);
                } else {
                    ButtonPanel.this.menuIcon.setManager(controller.getIcons());
                }
            }
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            DockController controller = null;
            if (this.dockable != null) {
                controller = this.dockable.getController();
            }
            if (ButtonPanel.this.menuIcon != null) {
                if (controller == null) {
                    ButtonPanel.this.menuIcon.setManager(null);
                } else {
                    ButtonPanel.this.menuIcon.setManager(controller.getIcons());
                }
            }
            ButtonPanel.this.set();
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                DockAction action = source.getDockAction(i);
                ActionItem entry = new ActionItem();
                entry.action = action;
                if (this.dockable.getController() != null) {
                    BasicTitleViewItem<JComponent> item = ButtonPanel.this.createItemFor(action, this.dockable);
                    entry.item = item;
                    if (item != null) {
                        action.bind(this.dockable);
                        item.bind();
                        item.setOrientation(ButtonPanel.this.orientation);
                        item.setForeground(ButtonPanel.this.getForeground());
                        item.setBackground(ButtonPanel.this.getBackground());
                    }
                }
                ButtonPanel.this.actions.add(i, entry);
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            for (int i = lastIndex; i >= firstIndex; --i) {
                ActionItem entry = ButtonPanel.this.actions.remove(i);
                if (entry.item == null) continue;
                entry.item.unbind();
                entry.action.unbind(this.dockable);
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }
    }

    private static class ActionItem {
        public DockAction action;
        public BasicTitleViewItem<JComponent> item;

        private ActionItem() {
        }
    }
}

