/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

public class DropDownMiniButton
extends MiniButton<BasicDropDownButtonModel> {
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private BasicDropDownButtonHandler handler;

    public DropDownMiniButton(BasicDropDownButtonHandler handler) {
        super(null);
        this.handler = handler;
        BasicDropDownButtonModel model = new BasicDropDownButtonModel(this, handler, handler){

            @Override
            public void changed() {
                DropDownMiniButton.this.updateBorder();
                DropDownMiniButton.this.repaint();
            }

            @Override
            protected boolean inDropDownArea(int x, int y) {
                return DropDownMiniButton.this.isOverDropIcon(x, y);
            }
        };
        this.setModel(model);
        this.dropIcon = handler.getDropDownIcon();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getMaxBorderInsets();
        Dimension icon = this.getContent().getPreferredSize();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int width = insets.left + 2 * insets.right + icon.width;
            int height = this.dropIcon.getIconHeight();
            height = Math.max(height, icon.height);
            return new Dimension(width += this.dropIcon.getIconWidth(), height += insets.top + insets.bottom);
        }
        int height = insets.top + 2 * insets.bottom + icon.height;
        int width = this.dropIcon.getIconWidth();
        width = Math.max(width, icon.width);
        return new Dimension(width += insets.left + insets.right, height += this.dropIcon.getIconHeight());
    }

    @Override
    public void updateUI() {
        if (this.handler != null) {
            this.handler.updateUI();
        }
        super.updateUI();
    }

    @Override
    public void paint(Graphics g) {
        BasicDropDownButtonModel model = (BasicDropDownButtonModel)this.getModel();
        BackgroundPaint paint = model.getBackground();
        BackgroundComponent component = model.getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            @Override
            protected void background(Graphics g) {
            }

            @Override
            protected void foreground(Graphics g) {
                DropDownMiniButton.this.doPaintForeground(g);
            }

            @Override
            protected void border(Graphics g) {
                DropDownMiniButton.this.doPaintBorder(g);
            }

            @Override
            protected void children(Graphics g) {
            }

            @Override
            protected void overlay(Graphics g) {
            }

            @Override
            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        paintable.paint(g);
    }

    @Override
    public void doLayout() {
        MiniButtonContent content = this.getContent();
        Insets insets = this.getMaxBorderInsets();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int dropWidth = this.dropIcon.getIconWidth();
            content.setBounds(insets.left + 1, insets.top, this.getWidth() - insets.left - 2 * insets.right - 1 - dropWidth, this.getHeight() - insets.top - insets.bottom);
        } else {
            int dropHeight = this.dropIcon.getIconHeight();
            content.setBounds(insets.left, insets.top + 1, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - 2 * insets.bottom - 1 - dropHeight);
        }
    }

    private void doPaintForeground(Graphics g) {
        this.paintContent(g);
        Insets insets = this.getMaxBorderInsets();
        MiniButtonContent content = this.getContent();
        Icon drop = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = this.handler.getDisabledDropDownIcon();
            }
            drop = this.disabledDropIcon;
        }
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int iconWidth = content.getWidth();
            int dropWidth = this.dropIcon.getIconWidth();
            double sum = insets.left + iconWidth + insets.right + dropWidth + insets.right;
            double factor = (double)this.getWidth() / sum;
            drop.paintIcon(this, g, (int)(factor * (double)(insets.left + insets.right + iconWidth + dropWidth / 2) - (double)(dropWidth / 2)), insets.top + (this.getHeight() - insets.top - insets.bottom - this.dropIcon.getIconHeight()) / 2);
        } else {
            int iconHeight = content.getHeight();
            int dropHeight = this.dropIcon.getIconHeight();
            double sum = insets.top + iconHeight + insets.bottom + dropHeight + insets.bottom;
            double factor = (double)this.getHeight() / sum;
            drop.paintIcon(this, g, insets.left + (this.getWidth() - insets.left - insets.right - this.dropIcon.getIconWidth()) / 2, (int)(factor * (double)(insets.top + insets.bottom + iconHeight + dropHeight / 2) - (double)(dropHeight / 2)));
        }
        if (this.isFocusOwner() && this.isFocusable() && this.isEnabled()) {
            this.paintFocus(g);
        }
    }

    private void doPaintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = this.getMaxBorderInsets();
            if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
                int iconWidth = this.getContent().getWidth();
                int dropWidth = this.dropIcon.getIconWidth();
                double sum = insets.left + iconWidth + insets.right + dropWidth + insets.right;
                double factor = (double)this.getWidth() / sum;
                border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, g, 0, 0, (int)(factor * (double)(insets.left + insets.right + iconWidth)), this.getHeight());
                }
            } else {
                int iconHeight = this.getContent().getHeight();
                int dropHeight = this.dropIcon.getIconHeight();
                double sum = insets.top + iconHeight + insets.bottom + dropHeight + insets.bottom;
                double factor = (double)this.getHeight() / sum;
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, g, 0, 0, this.getWidth(), (int)(factor * (double)(insets.top + insets.bottom + iconHeight)));
                }
            }
        }
    }

    public boolean isOverDropIcon(int x, int y) {
        if (!this.contains(x, y)) {
            return false;
        }
        Insets insets = this.getMaxBorderInsets();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int iconWidth = this.getContent().getWidth();
            int dropWidth = this.dropIcon.getIconWidth();
            double sum = insets.left + iconWidth + insets.right + dropWidth + insets.right;
            double factor = (double)this.getWidth() / sum;
            int barrier = (int)(factor * (double)(insets.left + insets.right + iconWidth)) - insets.right;
            return x > barrier;
        }
        int iconHeight = this.getContent().getHeight();
        int dropHeight = this.dropIcon.getIconHeight();
        double sum = insets.top + iconHeight + insets.bottom + dropHeight + insets.bottom;
        double factor = (double)this.getHeight() / sum;
        int barrier = (int)(factor * (double)(insets.top + insets.bottom + iconHeight)) - insets.bottom;
        return y > barrier;
    }
}

