/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.color;

import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.color.AbstractColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultColorScheme
extends AbstractColorScheme {
    private Map<String, Color> colors = new HashMap<String, Color>();
    private Map<Path, ColorBridgeFactory> bridges = new HashMap<Path, ColorBridgeFactory>();

    @Override
    public ColorBridge getBridge(Path name, UIProperties<Color, DockColor, ColorBridge> properties) {
        ColorBridgeFactory factory = this.getBridgeFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.create((ColorManager)properties);
    }

    @Override
    protected void updateUI() {
    }

    public void setBridgeFactory(final Path kind, ColorBridgeFactory bridge) {
        if (bridge == null) {
            this.bridges.remove(kind);
        } else {
            this.bridges.put(kind, bridge);
        }
        UISchemeEvent<Color, DockColor, ColorBridge> event = new UISchemeEvent<Color, DockColor, ColorBridge>(){

            @Override
            public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                return DefaultColorScheme.this;
            }

            @Override
            public Collection<String> changedResources(Set<String> names) {
                return Collections.emptySet();
            }

            @Override
            public Collection<Path> changedBridges(Set<Path> names) {
                ArrayList<Path> result = new ArrayList<Path>();
                for (Path name : names) {
                    if (!name.startsWith(kind)) continue;
                    result.add(name);
                }
                return result;
            }
        };
        this.fire(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(String id, Color color) {
        Map<String, Color> map = this.colors;
        synchronized (map) {
            if (color == null) {
                this.colors.remove(id);
            } else {
                this.colors.put(id, color);
            }
        }
        this.fire(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNullColor(String id) {
        Map<String, Color> map = this.colors;
        synchronized (map) {
            this.colors.put(id, null);
        }
        this.fire(id);
    }

    private void fire(final String id) {
        UISchemeEvent<Color, DockColor, ColorBridge> event = new UISchemeEvent<Color, DockColor, ColorBridge>(){

            @Override
            public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                return DefaultColorScheme.this;
            }

            @Override
            public Collection<String> changedResources(Set<String> names) {
                if (names == null) {
                    return null;
                }
                ArrayList<String> result = new ArrayList<String>();
                for (String name : names) {
                    if (!name.startsWith(id)) continue;
                    result.add(id);
                }
                return result;
            }

            @Override
            public Collection<Path> changedBridges(Set<Path> names) {
                return Collections.emptySet();
            }
        };
        this.fire(event);
    }

    @Override
    public Color getResource(String name, UIProperties<Color, DockColor, ColorBridge> properties) {
        return this.getColor(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(String id) {
        Color color;
        Map<String, Color> map = this.colors;
        synchronized (map) {
            color = this.colors.get(id);
            if (color != null || this.colors.containsKey(id)) {
                return color;
            }
            int best = -1;
            for (Map.Entry<String, Color> entry : this.colors.entrySet()) {
                if (!id.startsWith(entry.getKey()) || entry.getKey().length() <= best) continue;
                best = entry.getKey().length();
                color = entry.getValue();
            }
        }
        return color;
    }

    public ColorBridgeFactory getBridgeFactory(Path kind) {
        while (kind != null) {
            ColorBridgeFactory factory = this.bridges.get(kind);
            if (factory != null) {
                return factory;
            }
            kind = kind.getParent();
        }
        return null;
    }
}

