/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.NullPriorityValue;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DockProperties {
    private Map<PropertyKey<?>, Entry<?>> map = new HashMap();
    private DockController controller;

    public DockProperties(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public <A> void set(PropertyKey<A> key, A value) {
        this.set(key, value, Priority.CLIENT);
    }

    public <A> void set(PropertyKey<A> key, A value, Priority priority) {
        Entry<A> entry = this.getEntry(key, true);
        entry.setValue(value, priority);
        this.check(entry);
    }

    public <A> void finalize(PropertyKey<A> key) {
        Entry<A> entry = this.getEntry(key, true);
        entry.lock();
    }

    public <A> void setOrRemove(PropertyKey<A> key, A value, Priority priority) {
        if (value == null) {
            this.unset(key, priority);
        } else {
            this.set(key, value, priority);
        }
    }

    public void unset(PropertyKey<?> key) {
        this.unset(key, Priority.CLIENT);
    }

    public void unset(PropertyKey<?> key, Priority priority) {
        Entry<?> entry = this.getEntry(key, true);
        entry.unsetValue(priority);
        this.check(entry);
    }

    public <A> A get(PropertyKey<A> key) {
        Entry<A> entry = this.getEntry(key, true);
        return entry.getValue();
    }

    public <A> A get(PropertyKey<A> key, Priority priority) {
        Entry<A> entry = this.getEntry(key, false);
        if (entry == null) {
            return null;
        }
        return entry.getValue(priority);
    }

    public <A> boolean isSet(PropertyKey<A> key, Priority priority) {
        Entry<A> entry = this.getEntry(key, false);
        if (entry == null) {
            return false;
        }
        return entry.value.isSet(priority);
    }

    public <A> boolean isSet(PropertyKey<A> key) {
        Entry<A> entry = this.getEntry(key, false);
        if (entry == null) {
            return false;
        }
        return entry.value.isSomethingSet();
    }

    public <A> void addListener(PropertyKey<A> key, DockPropertyListener<A> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.getEntry(key, true).addListener(listener);
    }

    public <A> void removeListener(PropertyKey<A> key, DockPropertyListener<A> listener) {
        Entry<A> entry = this.getEntry(key, false);
        if (entry != null) {
            entry.removeListener(listener);
            this.check(entry);
        }
    }

    private <A> Entry<A> getEntry(PropertyKey<A> key, boolean createIfNull) {
        Entry<Object> entry = this.map.get(key);
        if (entry == null && createIfNull) {
            entry = new Entry<A>(key);
            this.map.put(key, entry);
        }
        return entry;
    }

    private void check(Entry<?> entry) {
        if (entry.removeable()) {
            this.map.remove(entry.getKey());
        }
    }

    private class Entry<A> {
        private PropertyKey<A> key;
        private List<DockPropertyListener<A>> listeners = new ArrayList<DockPropertyListener<A>>();
        private NullPriorityValue<A> value = new NullPriorityValue();
        private A defaultValue;
        private boolean defaultValueSet = false;
        private boolean locked = false;

        public Entry(PropertyKey<A> key) {
            this.key = key;
        }

        public void lock() {
            this.locked = true;
        }

        public void setValue(A value, Priority priority) {
            if (this.locked) {
                throw new IllegalStateException("this entry is immutable");
            }
            A oldValue = this.getValue();
            this.value.set(priority, value);
            A newValue = this.getValue();
            if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
                for (DockPropertyListener listener : this.listeners.toArray(new DockPropertyListener[this.listeners.size()])) {
                    listener.propertyChanged(DockProperties.this, this.key, oldValue, newValue);
                }
            }
        }

        public void unsetValue(Priority priority) {
            if (this.locked) {
                throw new IllegalStateException("this entry is immutable");
            }
            A oldValue = this.getValue();
            this.value.unset(priority);
            A newValue = this.getValue();
            if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
                for (DockPropertyListener listener : this.listeners.toArray(new DockPropertyListener[this.listeners.size()])) {
                    listener.propertyChanged(DockProperties.this, this.key, oldValue, newValue);
                }
            }
        }

        public A getValue() {
            A value = this.value.get();
            if (value == null && (!this.value.isSomethingSet() || this.key.isNullValueReplacedByDefault())) {
                return this.getDefault();
            }
            return value;
        }

        public A getValue(Priority priority) {
            return this.value.get(priority);
        }

        public A getDefault() {
            if (!this.defaultValueSet) {
                this.defaultValue = this.key.getDefault(DockProperties.this);
                this.defaultValueSet = true;
            }
            return this.defaultValue;
        }

        public PropertyKey<A> getKey() {
            return this.key;
        }

        public void addListener(DockPropertyListener<A> listener) {
            this.listeners.add(listener);
        }

        public void removeListener(DockPropertyListener<A> listener) {
            this.listeners.remove(listener);
        }

        public boolean removeable() {
            if (this.locked) {
                return false;
            }
            if (!this.listeners.isEmpty()) {
                return false;
            }
            return !this.defaultValueSet && !this.value.isSomethingSet();
        }
    }
}

