/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Map;

public class TypedUIProperties {
    private UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> properties;
    private Map<String, Type<?>> types = new HashMap();
    private Map<UIBridge<?, ?>, ThemeBridge<?>> bridges = new HashMap();

    public TypedUIProperties(DockController controller) {
        this.properties = new UIProperties(controller);
    }

    public <T> void registerType(Type<T> type) {
        if (this.types.get(type.getKey()) != null) {
            throw new IllegalArgumentException("the key '" + type.getKey() + "' is already in use");
        }
        this.types.put(type.getKey(), type);
    }

    private <T> void check(Type<T> type) {
        if (this.types.get(type.getKey()) != type) {
            throw new IllegalArgumentException("type '" + type.getKey() + "=" + type + " is not registered");
        }
    }

    public void setScheme(Priority priority, UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> scheme) {
        this.properties.setScheme(priority, scheme);
    }

    public UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> getScheme(Priority priority) {
        return this.properties.getScheme(priority);
    }

    public <V> void add(String id, Path kind, Type<V> type, UIValue<V> value) {
        this.check(type);
        this.properties.add(type.getKey(id), type.getKind(kind), value);
    }

    public void remove(UIValue<?> value) {
        this.properties.remove(value);
    }

    public <V> void publish(Priority priority, Path kind, Type<V> type, UIBridge<V, UIValue<V>> bridge) {
        this.check(type);
        kind = type.getKind(kind);
        ThemeBridge<Object> theme = this.bridges.get(bridge);
        if (theme == null) {
            theme = new ThemeBridge<V>(type.getKey().length() + 1, bridge);
            this.bridges.put(bridge, theme);
        }
        this.properties.publish(priority, kind, theme);
    }

    public <V> void unpublish(Priority priority, Path kind, Type<V> type) {
        this.check(type);
        kind = type.getKind(kind);
        UIBridge<Object, UIValue<Object>> bridge = this.properties.getBridge(priority, kind);
        if (bridge != null) {
            this.properties.unpublish(priority, kind);
            ThemeBridge<?> theme = this.bridges.get(bridge);
            if (theme != null) {
                this.checkUsed(theme);
            }
        }
    }

    public <V> void unpublish(Priority priority, UIBridge<V, UIValue<V>> bridge) {
        ThemeBridge<?> theme = this.bridges.get(bridge);
        if (theme != null) {
            this.properties.unpublish(priority, theme);
            this.checkUsed(theme);
        }
    }

    private void checkUsed(ThemeBridge<?> bridge) {
        if (!this.properties.isStored(bridge)) {
            this.bridges.remove(bridge.getDelegate());
        }
    }

    public <V> void put(Priority priority, String id, Type<V> type, V value) {
        this.check(type);
        id = type.getKey(id);
        this.properties.put(priority, id, value);
    }

    public <V> V get(String id, Type<V> type) {
        this.check(type);
        id = type.getKey(id);
        return (V)this.properties.get(id);
    }

    public void clear(Priority priority) {
        this.properties.clear(priority);
    }

    public static class Type<T> {
        private final String key;

        public Type(String key) {
            if (key == null) {
                throw new IllegalArgumentException("key must not be null");
            }
            if (key.length() == 0) {
                throw new IllegalArgumentException("key must contain at least one character");
            }
            if (key.contains(".")) {
                throw new IllegalArgumentException("key must not contain the character '.'");
            }
            if (!Path.isValidPath(key)) {
                throw new IllegalArgumentException("key not a valid path");
            }
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getKey(String id) {
            return this.key + "." + id;
        }

        public Path getKind(Path kind) {
            return new Path(this.key).append(kind);
        }
    }

    private static class ThemeBridge<V>
    implements UIBridge<V, UIValue<V>> {
        private int offset;
        private UIBridge<V, UIValue<V>> delegate;

        public ThemeBridge(int offset, UIBridge<V, UIValue<V>> delegate) {
            this.offset = offset;
            this.delegate = delegate;
        }

        public UIBridge<V, UIValue<V>> getDelegate() {
            return this.delegate;
        }

        @Override
        public void add(String id, UIValue<V> uiValue) {
            this.delegate.add(id.substring(this.offset), uiValue);
        }

        @Override
        public void remove(String id, UIValue<V> uiValue) {
            this.delegate.remove(id.substring(this.offset), uiValue);
        }

        @Override
        public void set(String id, V value, UIValue<V> uiValue) {
            this.delegate.set(id.substring(this.offset), value, uiValue);
        }
    }
}

