/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PriorityValue;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIPriorityValue;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class UIProperties<V, U extends UIValue<V>, B extends UIBridge<V, U>> {
    private Map<Path, UIPriorityValue<B>> bridges = new HashMap<Path, UIPriorityValue<B>>();
    private Map<Path, Integer> bridgesAccess = new HashMap<Path, Integer>();
    private Map<String, UIPriorityValue<V>> resources = new HashMap<String, UIPriorityValue<V>>();
    private Map<String, Integer> resourcesAccess = new HashMap<String, Integer>();
    private PriorityValue<UIScheme<V, U, B>> schemes = new PriorityValue();
    private PriorityValue<UISchemeListener<V, U, B>> schemeListeners = new PriorityValue();
    private List<Observer> observers = new LinkedList<Observer>();
    private int updateLock = 0;
    private DockController controller;

    public UIProperties(DockController controller) {
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public void lockUpdate() {
        ++this.updateLock;
    }

    public void unlockUpdate() {
        --this.updateLock;
        if (this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetAll();
            }
        }
    }

    public UIScheme<V, U, B> getScheme(Priority priority) {
        return this.schemes.get(priority);
    }

    public void setScheme(final Priority priority, UIScheme<V, U, B> scheme) {
        UIScheme<V, U, B> old = this.schemes.get(priority);
        this.schemes.set(priority, scheme);
        if (old != scheme) {
            int count;
            if (old != null) {
                old.removeListener(this.schemeListeners.get(priority));
                count = 0;
                for (Priority p : Priority.values()) {
                    if (this.schemes.get(p) != old) continue;
                    ++count;
                }
                if (count == 0) {
                    old.uninstall(this);
                }
            }
            if (scheme != null) {
                count = 0;
                for (Priority p : Priority.values()) {
                    if (this.schemes.get(p) != scheme) continue;
                    ++count;
                }
                if (count == 1) {
                    scheme.install(this);
                }
                if (this.schemeListeners.get(priority) == null) {
                    this.schemeListeners.set(priority, new UISchemeListener<V, U, B>(){

                        @Override
                        public void changed(UISchemeEvent<V, U, B> event) {
                            UIProperties.this.schemeUpdate(priority, event);
                        }
                    });
                }
                scheme.addListener(this.schemeListeners.get(priority));
            }
            this.fullSchemeUpdate(priority);
        }
    }

    private void fullSchemeUpdate(Priority priority) {
        this.schemeUpdate(priority, new UISchemeEvent<V, U, B>(){

            @Override
            public Collection<Path> changedBridges(Set<Path> names) {
                return null;
            }

            @Override
            public Collection<String> changedResources(Set<String> names) {
                return null;
            }

            @Override
            public UIScheme<V, U, B> getScheme() {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schemeUpdate(Priority priority, UISchemeEvent<V, U, B> event) {
        try {
            Object replacement;
            UIPriorityValue<Object> value;
            Set<Path> usedBridges;
            Collection<Path> changedBridges;
            this.lockUpdate();
            Set<String> usedResources = this.getAllUsedResources();
            Collection<String> changedResources = event.changedResources(usedResources);
            if (changedResources == null) {
                changedResources = usedResources;
            }
            if ((changedBridges = event.changedBridges(usedBridges = this.getAllUsedBridges())) == null) {
                changedBridges = usedBridges;
            }
            UIScheme<V, U, B> scheme = this.schemes.get(priority);
            for (String string : changedResources) {
                value = this.resources.get(string);
                replacement = null;
                if (scheme != null) {
                    replacement = scheme.getResource(string, this);
                }
                if (value == null) {
                    if (replacement == null) continue;
                    value = new UIPriorityValue();
                    value.set(priority, replacement, scheme);
                    if (this.isRemoveable(string, value)) continue;
                    this.resources.put(string, value);
                    continue;
                }
                if (value.getScheme(priority) == null) {
                    if (value.get(priority) == null) {
                        value.set(priority, replacement, scheme);
                    }
                } else {
                    value.set(priority, replacement, scheme);
                }
                if (!this.isRemoveable(string, value)) continue;
                this.resources.remove(string);
            }
            for (Path path : changedBridges) {
                value = this.bridges.get(path);
                replacement = null;
                if (scheme != null) {
                    replacement = scheme.getBridge(path, this);
                }
                if (value == null) {
                    if (replacement == null) continue;
                    value = new UIPriorityValue();
                    value.set(priority, replacement, scheme);
                    if (this.isRemoveable(path, value)) continue;
                    this.bridges.put(path, value);
                    continue;
                }
                if (value.getScheme(priority) == null) {
                    if (value.get(priority) == null) {
                        value.set(priority, replacement, scheme);
                    }
                } else {
                    value.set(priority, replacement, scheme);
                }
                if (!this.isRemoveable(path, value)) continue;
                this.bridges.remove(path);
            }
        }
        finally {
            this.unlockUpdate();
        }
    }

    private Set<String> getAllUsedResources() {
        HashSet<String> result = new HashSet<String>();
        for (Observer observer : this.observers) {
            result.add(observer.id);
        }
        return result;
    }

    private Set<Path> getAllUsedBridges() {
        HashSet<Path> result = new HashSet<Path>();
        for (Observer observer : this.observers) {
            result.add(observer.path);
        }
        return result;
    }

    public void publish(Priority priority, Path path, B bridge) {
        if (priority == null) {
            throw new IllegalArgumentException("priority must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (bridge == null) {
            throw new IllegalArgumentException("bridge must not be null");
        }
        UIPriorityValue<B> value = this.bridges.get(path);
        if (value == null) {
            value = this.createBridge(path);
            this.bridges.put(path, value);
        }
        if (value.set(priority, bridge, null) && this.updateLock == 0) {
            for (Observer check : this.observers) {
                check.resetBridge();
            }
        }
    }

    public void unpublish(Priority priority, Path path) {
        UIPriorityValue<B> value = this.bridges.get(path);
        if (value != null && value.getScheme(priority) == null) {
            UIScheme<V, U, B> scheme = this.schemes.get(priority);
            Object bridge = null;
            if (scheme != null) {
                bridge = scheme.getBridge(path, this);
            }
            boolean change = value.set(priority, bridge, scheme);
            if (this.isRemoveable(path, value)) {
                this.bridges.remove(path);
            }
            if (change && this.updateLock == 0) {
                for (Observer check : this.observers) {
                    check.resetBridge();
                }
            }
        }
    }

    public void unpublish(Priority priority, B bridge) {
        Iterator<Map.Entry<Path, UIPriorityValue<B>>> iterator = this.bridges.entrySet().iterator();
        boolean change = false;
        UIScheme<V, U, B> scheme = this.schemes.get(priority);
        while (iterator.hasNext()) {
            Map.Entry<Path, UIPriorityValue<B>> entry = iterator.next();
            UIPriorityValue<B> next = entry.getValue();
            if (next.get(priority) != bridge || next.getScheme(priority) != null) continue;
            Object replacement = null;
            if (scheme != null) {
                replacement = scheme.getBridge(entry.getKey(), this);
            }
            boolean bl = change = next.set(priority, replacement, scheme) || change;
            if (!this.isRemoveable(entry.getKey(), next)) continue;
            iterator.remove();
        }
        if (change && this.updateLock == 0) {
            for (Observer check : this.observers) {
                check.resetBridge();
            }
        }
    }

    public B getBridge(Priority priority, Path path) {
        UIPriorityValue.Value value;
        UIPriorityValue<B> bridge = this.bridges.get(path);
        if (bridge == null && !this.isRemoveable(path, bridge = this.createBridge(path))) {
            this.bridges.put(path, bridge);
        }
        if (bridge != null && (value = (UIPriorityValue.Value)bridge.get(priority)) != null) {
            return (B)((UIBridge)value.getValue());
        }
        return null;
    }

    public boolean isStored(B bridge) {
        for (UIPriorityValue<B> value : this.bridges.values()) {
            for (Priority priority : Priority.values()) {
                if (value.getValue(priority) != bridge) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isObserved(Path path) {
        return this.bridgesAccess.containsKey(path);
    }

    private boolean isRemoveable(Path path, UIPriorityValue<B> value) {
        if (value.getValue() == null) {
            return true;
        }
        return value.isAllScheme() && !this.isObserved(path);
    }

    private void checkRemove(Path path) {
        UIPriorityValue<B> value = this.bridges.get(path);
        if (value != null && this.isRemoveable(path, value)) {
            this.bridges.remove(path);
        }
    }

    public void add(String id, Path path, U value) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        Observer combination = new Observer(this, id, path, value);
        this.observers.add(combination);
        combination.resetAll();
    }

    public void remove(U value) {
        ListIterator<Observer> list = this.observers.listIterator();
        while (list.hasNext()) {
            Observer next = list.next();
            if (next.getValue() != value) continue;
            list.remove();
            next.destroy();
            return;
        }
    }

    public boolean isObserved(String id) {
        return this.resourcesAccess.containsKey(id);
    }

    private boolean isRemoveable(String id, UIPriorityValue<V> value) {
        if (value.getValue() == null) {
            return true;
        }
        return value.isAllScheme() && !this.isObserved(id);
    }

    private void checkRemove(String id) {
        UIPriorityValue<V> value = this.resources.get(id);
        if (value != null && this.isRemoveable(id, value)) {
            this.resources.remove(id);
        }
    }

    protected B getBridgeFor(Path path) {
        while (path != null) {
            UIBridge result;
            UIPriorityValue<B> bridge = this.bridges.get(path);
            if (bridge == null && !this.isRemoveable(path, bridge = this.createBridge(path))) {
                this.bridges.put(path, bridge);
            }
            if (bridge != null && (result = (UIBridge)bridge.getValue()) != null) {
                return (B)result;
            }
            path = path.getParent();
        }
        return null;
    }

    public void put(Priority priority, String id, V resource) {
        UIPriorityValue<V> value = this.resources.get(id);
        if (value == null && resource != null) {
            value = this.createResource(id);
            this.resources.put(id, value);
        }
        if (value != null) {
            UIScheme<V, U, B> scheme = null;
            if (resource == null && (scheme = this.schemes.get(priority)) != null) {
                resource = scheme.getResource(id, this);
            }
            if (value.set(priority, resource, scheme) && this.updateLock == 0) {
                for (Observer observer : this.observers) {
                    if (!observer.id.equals(id)) continue;
                    observer.update(resource);
                }
            }
            if (this.isRemoveable(id, value)) {
                this.resources.remove(id);
            }
        }
    }

    public V get(String id) {
        UIPriorityValue<V> value = this.resources.get(id);
        if (value == null && !this.isRemoveable(id, value = this.createResource(id))) {
            this.resources.put(id, value);
        }
        return value == null ? null : (V)value.getValue();
    }

    public void get(String id, Path kind, U key) {
        V base = this.get(id);
        B bridge = this.getBridgeFor(kind);
        if (bridge != null) {
            bridge.set(id, base, key);
        } else {
            key.set(base);
        }
    }

    public void clear(Priority priority) {
        UIScheme<V, U, B> scheme = this.schemes.get(priority);
        Iterator<Map.Entry<String, UIPriorityValue<V>>> resources = this.resources.entrySet().iterator();
        while (resources.hasNext()) {
            Map.Entry<String, UIPriorityValue<V>> entry = resources.next();
            UIPriorityValue<V> value = entry.getValue();
            if (value.getScheme(priority) != null) continue;
            Object replacement = null;
            if (scheme != null) {
                replacement = scheme.getResource(entry.getKey(), this);
            }
            value.set(priority, replacement, scheme);
            if (!this.isRemoveable(entry.getKey(), value)) continue;
            resources.remove();
        }
        Iterator<Map.Entry<Path, UIPriorityValue<B>>> bridges = this.bridges.entrySet().iterator();
        while (bridges.hasNext()) {
            Map.Entry<Path, UIPriorityValue<B>> entry = bridges.next();
            UIPriorityValue<B> value = entry.getValue();
            if (value.getScheme(priority) != null) continue;
            Object replacement = null;
            if (scheme != null) {
                replacement = scheme.getBridge(entry.getKey(), this);
            }
            value.set(priority, replacement, scheme);
            if (!this.isRemoveable(entry.getKey(), value)) continue;
            bridges.remove();
        }
        if (this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetAll();
            }
        }
    }

    private UIPriorityValue<B> createBridge(Path path) {
        UIPriorityValue<B> result = new UIPriorityValue<B>();
        for (Priority priority : Priority.values()) {
            B value;
            UIScheme<V, U, B> scheme = this.schemes.get(priority);
            if (scheme == null || (value = scheme.getBridge(path, this)) == null) continue;
            result.set(priority, value, scheme);
        }
        return result;
    }

    private UIPriorityValue<V> createResource(String name) {
        UIPriorityValue<V> result = new UIPriorityValue<V>();
        for (Priority priority : Priority.values()) {
            V value;
            UIScheme<V, U, B> scheme = this.schemes.get(priority);
            if (scheme == null || (value = scheme.getResource(name, this)) == null) continue;
            result.set(priority, value, scheme);
        }
        return result;
    }

    private static class Observer {
        private String id;
        private Path path;
        private U value;
        private B bridge;
        final /* synthetic */ UIProperties this$0;

        public Observer(String id, Path path, U value) {
            this.this$0 = var1_1;
            this.id = id;
            this.path = path;
            this.value = value;
            Integer count = var1_1.bridgesAccess.get(path);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            var1_1.bridgesAccess.put(path, count);
            count = var1_1.resourcesAccess.get(id);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            var1_1.resourcesAccess.put(id, count);
        }

        public void destroy() {
            this.setBridge(null, false);
            Integer count = this.this$0.bridgesAccess.get(this.path);
            if (count == 1) {
                this.this$0.bridgesAccess.remove(this.path);
                this.this$0.checkRemove(this.path);
            } else {
                this.this$0.bridgesAccess.put(this.path, count - 1);
            }
            count = this.this$0.resourcesAccess.get(this.id);
            if (count == 1) {
                this.this$0.resourcesAccess.remove(this.id);
                this.this$0.checkRemove(this.id);
            } else {
                this.this$0.resourcesAccess.put(this.id, count - 1);
            }
        }

        public U getValue() {
            return this.value;
        }

        public void resetAll() {
            Object bridge = this.this$0.getBridgeFor(this.path);
            if (bridge == null) {
                this.update(this.this$0.get(this.id));
            } else {
                this.setBridge(bridge, true);
            }
        }

        public void resetBridge() {
            this.setBridge(this.this$0.getBridgeFor(this.path), false);
        }

        public void setBridge(B bridge, boolean force) {
            if (this.bridge != bridge) {
                if (this.bridge != null) {
                    this.bridge.remove(this.id, this.value);
                }
                this.bridge = bridge;
                if (this.bridge != null) {
                    this.bridge.add(this.id, this.value);
                }
                this.update(this.this$0.get(this.id));
            } else if (force) {
                this.update(this.this$0.get(this.id));
            }
        }

        public void update(V value) {
            if (this.bridge == null) {
                this.value.set(value);
            } else {
                this.bridge.set(this.id, value, this.value);
            }
        }
    }
}

