/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.laf;

import bibliothek.gui.dock.util.laf.AbstractLookAndFeelColors;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public class DefaultLookAndFeelColors
extends AbstractLookAndFeelColors {
    private Map<String, String> translations = new HashMap<String, String>();
    private Listener listener = new Listener();

    public DefaultLookAndFeelColors() {
        this.translations.put("dock.title.background", "MenuItem.background");
        this.translations.put("dock.title.foreground", "MenuItem.foreground");
        this.translations.put("dock.title.selection.background", "MenuItem.selectionBackground");
        this.translations.put("dock.title.selection.foreground", "MenuItem.selectionForeground");
        this.translations.put("dock.selection.background", "TextField.selectionBackground");
        this.translations.put("dock.background", "Panel.background");
        this.translations.put("dock.foreground", "Panel.foreground");
        this.translations.put("dock.control.shadow", "controlDkShadow");
        this.translations.put("dock.window.border", "windowBorder");
    }

    @Override
    public Color getColor(String key) {
        if ((key = this.translations.get(key)) == null) {
            return null;
        }
        return UIManager.getColor(key);
    }

    @Override
    public void bind() {
        UIManager.addPropertyChangeListener(this.listener);
    }

    @Override
    public void unbind() {
        UIManager.removePropertyChangeListener(this.listener);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("lookAndFeel".equals(name)) {
                DefaultLookAndFeelColors.this.fireColorsChanged();
            } else {
                String key = null;
                for (Map.Entry<String, String> entry : DefaultLookAndFeelColors.this.translations.entrySet()) {
                    if (!entry.getValue().equals(name)) continue;
                    if (key == null) {
                        key = entry.getKey();
                        continue;
                    }
                    DefaultLookAndFeelColors.this.fireColorsChanged();
                    return;
                }
                if (key != null) {
                    DefaultLookAndFeelColors.this.fireColorChanged(key);
                }
            }
        }
    }
}

